! **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Simulator         :  STANDARD                                *
!      Department        :  61 - flight                             *
!      Module name       :  flt_update_plot                         *
!      Module description:  This module creates plots for the first *
!                           36 variables in the acd file
!      Originator        :  M. Saladin                              *
!      Date              :   2/22/99                                *
!                                                                   *
!                                                                   *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems Division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of FlightSafety International Simulation        *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!            FlightSafety International                             *
!            Simulation Systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012, U.S.A.                  *
!            (918) 251-0500    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **

      subroutine flt_update_plots(ftype)
      implicit none

!--> REVISION BEGIN

!                            Revision History

! $Id: flt_update_plots.f,v 1.3 2000/03/13 22:21:13 saladinm Exp $
! $Log: flt_update_plots.f,v $
! Revision 1.3  2000/03/13 22:21:13  saladinm
! Changes to autoscaling of plot scales.

! Revision 1.2  1999/03/05 16:38:30  saladinm
! Limited number of grids output to tdf to 36.

! Revision 1.1  1999/03/02 20:55:14  saladinm
! Initial revision

! Revision 1.2  1999/02/25 16:08:47  saladinm
! Modified format of output of plot data.

! Revision 1.1  1999/02/24 19:32:59  saladinm
! Initial revision


!--> REVISION END

      CHARACTER*80  RCSID & 
           /"$Id: flt_update_plots.f,v 1.3 2000/03/13 22:21:13 saladinm Exp $"/

! * Argument list

	character*4		ftype			!File suffix .acd or .pom

! * Locals

      integer*4     i,j,k
      integer*4     lu19   /19/      !Unit for output file
      integer*4     lu18   /18/      !Unit for input file
      integer*4     ist              !IOSTAT flag
      integer*4     nacd             !NUmber of variables in ACD file
      integer*4     lf               !Length of tdf file name
      integer*4     ie               !Index of end
      integer*4     is               !Index of start
      integer*4     ip               !Index of plot
      integer*4     imx              !Length of longest y variable

      character*256 message          !String for system calls
      character*256 line             !Input string read from file
      character*256 lowline          !Lower case version of line 
      character*132 dfile            !Data file name  *.acd or *.pom
      character*132 tdffile          !TDF file name
      character*64  acdvar(200)      !Acd variable list

      real*4        acdmn(200)       !Minimum value in acd data
      real*4        acdmx(200)       !Maximum value in acd data
      real*4        plotmax          !scale max
      real*4        plotmin          !scale min
      real*4        rate             !recording rate

      logical*4     aerr             !Return error flag from flt_var_data
	  logical*4     ferr             !Error renaming files
      logical*4     start            !Start of ics found
      logical*4     lend             !End of ics found


!     External functions
      integer*4      lrbl 
      integer*4      lran
      integer*4      rlan


      include "flt_plot.inc"


! * Set up file paths

      call pathfile(dfile,fpath,ftestname(:lrbl(ftestname))//ftype)
	  call pathfile(tdffile,fpath,ftestname(:lrbl(ftestname))//'.tdf')

! * Get all varibles from data file
      call flt_var_data(dfile,acdvar,nacd,acdmn,acdmx,aerr)      

! * Open tdf file to write out information

      lf = lrbl(tdffile)
	  call rename_file(tdffile(:lf),tdffile(:lf)//'.old',ferr)

      open(lu19,FILE=tdffile,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*)  'UNABLE TO OPEN '// tdffile(:lf)
         write(*,*) 'No changes made'
	     call rename_file(tdffile(:lf)//'.old',tdffile(:lf),ferr)
         return
      endif

      open(lu18,FILE=tdffile(:lf)//'.old',IOSTAT=i) 
      if ( i .ne. 0 ) then
         write(*,*) 'UNABLE TO OPEN '//tdffile(:lf)//'.old'
         write(*,*) 'No changes made'
         return
      endif

      start = .false.
      lend  = .false.

      imx = 0

! * Limit to 36 grids
      if ( nacd .gt. 37 ) nacd = 37


      do i=1,nacd
         j = lrbl(acdvar(i))
         if ( j .gt. imx ) imx = j
      enddo


! * Read existing file and write out non plot lines of information
      read(lu18,10,IOSTAT=ist) line
      do while ( ist .eq. 0 )
         lowline=line
         call lower(lowline,256)
         is = index(lowline,'start')
         ie = index(lowline,'end')
         ip = index(lowline,'plot')
         if ( is .gt. 0 .and. ip .gt. is .and. .not. start) then
            start = .true.
         elseif( ie .gt. 0 .and. ip .gt. ie .and. start ) then
            start = .false.
            lend  = .true.
         endif

         if ( .not. start .and. .not. lend) then !write out data
            write(lu19,10,IOSTAT=ist) line(:rlan(line))
         elseif( lend ) then    !write new plot definition
            write(lu19,10) 'Start Plot'
            call get_new_scale(acdmn(1),acdmx(1),plotmin,plotmax)
            rate = 200. / (plotmax - plotmin)
            if ( rate .lt. 1 ) rate = 1.
            write(lu19,20,IOSTAT=ist) acdvar(1)(:imx), & 
                 plotmin,plotmax,rate
            do i=2,nacd
               call get_new_scale(acdmn(i),acdmx(i),plotmin,plotmax)
               write(lu19,30,IOSTAT=ist) acdvar(i)(:imx), & 
                    plotmin,plotmax
            enddo
            write(lu19,10,IOSTAT=ist) line(:rlan(line))
            lend = .false.
         endif

           read(lu18,10,IOSTAT=ist) line

      enddo

      close(lu18)
      close(lu19)


      return
 10   format(a)
 20   format(3x,'X = ',a,6x,'Scale = ',f12.3,' to ',f12.3, & 
           ' Rate = ',f5.1)
 30   format('       Y = ',a,'  Scale = ',f12.3,' to ',f12.3)
      end




      subroutine get_new_scale(min,max,scale1,scale2)
      implicit none

! * Argument list

      real*4     min          !Input minimum
      real*4     max            !Input maximum
      real*4     scale1         !Output min scale
      real*4     scale2         !Output max scale


! * Locals

      real*4     scmin        !Scaled minimum +/- 1%
      real*4     scmax          !Scaled maximum +/- 1%

      real*4     admn           !Adjust value for min
      real*4     admx           !Adjust value for max
      real*4     delta          !Max - min
      real*4     delscl         !Power scaled delta


      integer*4  p              !Power
      integer*4  i              !Counter
      integer*4  iscale         !index into scale array
      integer*4  nscale         !Dimension of scale array
      parameter(nscale=4)

      real*4     scale(nscale) /1.,2.,4.,5./

      admn = 1.01
      admx = .99

      if ( min .lt. 0 ) admn= .99
      if ( max .lt. 0 ) admx = 1.01

      if ( max * admx .gt. min * admn ) then
         scmin = min * admn
         scmax = max * admx
      else
         scmin = min
         scmax = max
      endif

      delta = scmax - scmin

      if ( delta .eq. 0. ) then
         if ( scmax .eq. 0 ) then
            p = 1
         else
            p = alog10(abs(scmax))
         endif
         delta = 2.* 10.**(p-1)
         scmin = scmin - delta / 2.0
         scmax = scmax + delta / 2.0
      elseif( abs(delta/scmax ) .lt. 0.01 ) then
         delta = delta * 100.
      endif

      p = alog10(delta)
      delscl = delta / 10.**p

      i = 1
      iscale = 1
      do while( i .le. nscale .and. scale(i) .lt. delscl )
         iscale = i
         i = i + 1
      enddo

      if ( iscale .ne. 1 ) iscale = iscale + 1
      if ( iscale .eq. 5 ) then
         iscale = 1
         p = p + 1
      endif


      scale1 = aint(scmin/10.**p) * 10.**p

      do while ( scale1 .gt. scmin ) 
         scale1 = scale1 - 10.**p
      enddo      

      scale2 = scale1 + scale(iscale)*10.**p

      do while ( scale2 .lt. scmax ) 
         iscale = iscale + 1
         if ( iscale .gt. nscale ) then
            iscale = 1
            p = p + 1
         endif
           scale2 = scale1 + scale(iscale)*10.**p
      enddo


      if ( scale1 .gt. 0. .and. scale1 .lt. 10 .and. scale2 .lt. 10 ) then
         scale1 = 0.
         scale2 = 10.
      endif

! *   Attempt to make symmetric about zero

      if ( scale1 .lt. 0. .and. scale2 .gt. 0. ) then
         admn = 0. - .5 * scale(iscale)*10.**p
         admx = 0. + .5 * scale(iscale)*10.**p
         if ( admn .le. scmin .and. admx .ge. scmax ) then
            scale1 = admn
            scale2 = admx
         endif
      endif

      if ( scale1 .eq. 0.0 .and. scale2 .eq. 0 ) then
         scale1 = 1.0
         scale2 = -1.0
      endif

      return
      end
















