!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Department        :  61 - flight                             *
!      Module name       :  flt_tgprint                             *
!      Module description:  test guide print utility                *
!      Rate              :  n/a                                     *
!      Issue             :  n/a                                     *
!      Originator        :  matthew f. kneisler                     *
!      Date              :  april 22, 1991                          *
!      Engineer          :  matthew f. kneisler                     *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of the FlightSafety International Simulation    *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y  I N T E R N A T I O N A L         *
!            Simulation systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012                          *
!            (918) 251-0500    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!--> REVISION BEGIN

!                            Revision History

! $Id: flt_tgprint.f,v 1.9 2000/03/13 22:19:11 saladinm Exp $
! $Log: flt_tgprint.f,v $
! Revision 1.9  2000/03/13 22:19:11  saladinm
! Many changes to code.  Modified whole menu selection/options
! for printing and updating the page numbers.

! Revision 1.8  2000/02/14 16:49:12  saladinm
! Updated call to flt_output.f.  Just a variable order change.

! Revision 1.7  2000/02/14 16:17:46  saladinm
! DR/MACAR:     None
! Problem:      Changes made to flt_output.f no longer require configuration
!               flags to be sent to this module.
! Conclusion:   True,
! Resolution:   Removed these labels from call to flt_output.f
! Dependencies: flt_output.f
! Engineer:     Mike Saladin

! Revision 1.6  1999/12/22 17:55:22  mattk
! flt_tgprint.f Initial release from automated zeb process

! Revision 1.5  1999/03/15 13:29:21  saladinm
! Update from 717.

! Revision 1.10  1999/03/11 15:23:14  saladinm
! Changed a couple of compiler errors that the Harris didn't pick up.

! Revision 1.9  1999/03/08 16:01:50  saladinm
! Modified call to flt_output.  Deleted fcplotac and added fmantxtfl.

! Revision 1.8  1999/03/01 12:16:56  saladinm
! Got print_all routine working with new system.

! Revision 1.7  1999/02/08 17:11:42  saladinm
! Added routine to repaginate the TOC.

! Revision 1.6  1999/02/03 22:06:46  saladinm
! New release of Autotest SW. Version 2.0

! Revision 1.1  1998/12/16 21:29:25  saladinm
! Initial revision


!--> REVISION END
      subroutine tgprint
      implicit none

      character*80  RCSID & 
      /"$Id: flt_tgprint.f,v 1.9 2000/03/13 22:19:11 saladinm Exp $"/

!--> local begin
      character*132 filename         !Full path file name
      character*40  testname(1000)   !testnames
      character*40  name             !Input test name
      character*80  line             !read line
      character*40  cfilea(300)      !filename array
      character*1   ans
      character*3   data(4)          !data sets to be included
      character*3   answ(4)          !answer status
      logical*4     fplotacd         !plot aircraft data flag
      logical*4     fplotpom         !plot proof-of-match data flag
      logical*4     fplotsim         !plot simulator data flag
      logical*4     fplotman         !Plot Manual data
      logical*4     fcppomok         !fcp fat pom plot data ok

      logical*4     fctxtdisp        !display text file
      logical*4     fctxtplot        !print text file

      logical*4     batch            !batch flag
      logical*4     lexist           !file exist flag
      logical*4     last  /.true./   !last print in batch file
      logical*4     all              !
      logical*4     cont             !Loop flag
      logical*4     setup            !Loop flag
      logical*4     printall         !Loop flag
      logical*4     prompt           !temp argument
      logical*4     temp             !Loop flag
      logical*4     pageup           !Update page numbers flag
      logical*4     titleup          !Update test titles flag

      integer*4     cmd              !console command
      integer*4     i,j,ierr         !counters
      integer*4     icnt             !Number of tests in ftpages.dat
      integer*4     imax             !maximum file count
      integer*4     ist              !IOSTAT flag
      integer*4     itype            !type of input ie name or number
      integer*4     lu4   /4/        !batch file lu
      integer*4     lu60  /60/       !text file lu
      integer*4     num              !test number
      integer*4     numa(300)        !Test number array to go with cfilea
      integer*4     numt             !number of tests
      integer*4     opt              !desired option
      integer*4     page(500,5)      !Page data 1=sec 2=test 3=# text 
      integer*4     sect             !sect number for pages
      integer*4     testnum(1000)    !test numbers


! * local end

! * External Functions
      integer*4     lrbl             !Returns index of first blank form left

      include "flt_plot.inc"

      fctxtdisp = .true.        !display text file
      fctxtplot = .false.
      answ(1) = 'yes'
      answ(2) = 'no'
      answ(3) = 'no'
      answ(4) = 'no'

      call read_index(numt,testname,testnum)

      cont = .true. 
      do while ( cont )


         write(*,*)' '
         write(*,*)' '
         write(*,*)'        Test Guide Print Options'
         write(*,*)' '
         write(*,*)'        1.  Print/Display Text Pages'
         write(*,*)'        2.  Print Text/IC/Plot Pages'
         write(*,*)'        3.  Repaginate Part of Test Guide'
         write(*,*)'        4.  Repaginate All of Test Guide '// & 
                                '(Option to Update TOC)'
         write(*,*)'        5.  Exit'

         read (*,20,IOSTAT=ist) opt  
         if (opt .le. 0 .or. opt .ge.5 .or. ist .ne. 0) & 
                         cont = .false.


         if ( opt .eq. 1 ) then      
            setup = .true.           
            do while ( setup )       
               write (*,*) ' '       
               write (*,*) ' '       
               write (*,*) ' '       
               write (*,*) ' '       
               write (*,*) '        Test Guide Print Set-up'
               write (*,*) ' '       
               write (*,*) '        1.  Enable screen display.    ',answ(1)
               write (*,*) '        2.  Enable print out.         ',answ(2)
               write (*,*) '        3.  Reset.                    ',answ(3)
               write (*,*) '        4.  Continue.'     
               write (*,*) ' '       
               read (*,20,IOSTAT=ist)cmd
               if (cmd .le. 0 .or. cmd .ge. 4 .or. ist .ne. 0) & 
                    setup = .false.  

               if (cmd.eq.1) then    
                  fctxtdisp=.not.fctxtdisp
                  if (fctxtdisp) then
                     answ(1) = 'yes' 
                  else               
                     answ(1) = 'no ' 
                  endif              
                  answ(3) = 'no '    
               elseif (cmd.eq.2) then
                  fctxtplot= .not.fctxtplot
                  if (fctxtplot) then
                     answ(2) = 'yes' 
                  else               
                     answ(2) = 'no ' 
                  endif              
                  answ(3) = 'no '    
               elseif (cmd.eq.3) then
                  fctxtdisp = .false.
                  fctxtplot = .true. 
                  answ(1) = 'no'     
                  answ(2) = 'yes'    
                  answ(3) = 'no '    
                  answ(4) = 'no'     
               endif                 
            enddo                    
         elseif ( opt .eq. 2 ) then  
            fplotacd = .true.        
            fplotpom = .false.       
            fplotsim = .true.        
            fplotman = .false.       

            data(1) = 'no'           
            data(2) = 'no'           
            data(3) = 'no'           
            data(4) = 'no'           
            if(fplotacd) data(1) = 'yes'
            if(fplotpom) data(2) = 'yes'
            if(fplotsim) data(3) = 'yes'
            if(fplotman) data(4) = 'yes'

            temp = .true.            
            do while ( temp )        
               write(*,*) '  '       
               write(*,*) '        Select data sets to be included: '
               write(*,*) '  '       
               write(*,*) '        1.  Include ACD data.    ',data(1)
               write(*,*) '        2.  Include POM data.    ',data(2)
               write(*,*) '        3.  Include SIM data.    ',data(3)
               write(*,*) '        4.  Include MAN data.    ',data(4)
               write(*,*) '        5.  Continue. '
               read (*,20,IOSTAT=ist)cmd

               if (cmd.eq.1) then    
                  fplotacd = .not. fplotacd
               elseif(cmd.eq.2) then 
                  fplotpom = .not. fplotpom
               elseif(cmd.eq.3) then 
                  fplotsim = .not. fplotsim
               elseif(cmd.eq.4) then 
                  fplotman = .not. fplotman
               else                  
                  temp = .false.     
               endif                 
            enddo                    
            fctxtdisp = .false.      
            fctxtplot = .true.       
         else                        
            fctxtdisp = .false.      
            fctxtplot = .true.       
         endif                       

         if ( opt .eq. 1 .or. opt .eq. 2 ) then

            if ( opt .eq. 1 ) then   
               write (*,*) ' '       
               write (*,*) ' '       
               write (*,*) ' '       
               write (*,*) '          Test Guide Print Text Utility.'
               write (*,*) ' '       
               if (fctxtdisp)         & 
                    WRITE (*,*) '       Screen Display Activated'
               if (fctxtplot)         & 
                    WRITE (*,*) '       Text Print Out Activated'
               write (*,*) ' '       
               write (*,*) '          1.  Display/Print Single File.'
               write (*,*) '          2.  Display/Print Several Files.'
               write (*,*) '          3.  Display/Print Files From'// & 
                                          ' Batch File.'
               write (*,*) '          4.  Redo setup'
               write (*,*) '          5.  Exit'
               read (*,20,IOSTAT=ist)cmd
               if (cmd .le. 0 .or. cmd .ge. 5 .or. ist .ne. 0) & 
                    cont = .false.   

            else                     
               write(*,*)' '         
               write(*,*)' '         
               write(*,*)' '         
               write(*,*)'           Test Guide Print Tests Utility.'
               write(*,*)' '         
               if (fctxtdisp)         & 
                    WRITE (*,*) '       Screen Display Activated'
               if (fctxtplot)         & 
                    WRITE (*,*) '       Text Print Out Activated'
               write(*,*)' '         
               write(*,*)'           1.  Print Single Test.'
               write(*,*)'           2.  Print Several Tests.'
               write(*,*)'           3.  Print Tests From Batch File'
               write(*,*)'           4.  Print Files From Section.'
               write(*,*)'           5.  Print Complete Test Guide'
               write(*,*)'           6.  Exit'
               read (*,20,IOSTAT=ist) cmd
               if (cmd .le. 0 .or. cmd .ge. 6 .or. ist .ne. 0) & 
                    cont = .false.   

            endif                    



            if ( cmd .eq. 1 ) then !Single File print out
               write (*,*) ' '       
               write (*,*) ' Enter the file name/number:'
               read (*,10,IOSTAT=ist) name
               if ( ist .eq. 0 ) then
                  call lower(name,40)
                  call findname(name,num,itype,testname,testnum,numt)
                  if ( itype .gt. 2 ) then
                     write(*,*) 'Test  '//name
                     write(*,*) 'Not found in test_index.dat'
                     name = name(:lrbl(name))//'.txt'
                     call pathfile(filename,fpath, name)
                     inquire(FILE=filename,EXIST=lexist)
                     if ( lexist ) then
                        write(*,*) ' '
                        write(*,*) 'File :',filename(:lrbl(filename))
                        write(*,*)'Exists.  Do you want to print it? (Y,n)'
                        read(*,10,IOSTAT=ist) ans
                        if ( ist .eq. 0 & 
                             .and. (ans .ne. 'n' .or. ans .ne. 'N')) then
                           itype = 0 
                        endif        
                     else            
                        write(*,*) 'Hit <CR> to Continue'
                        read(*,10,IOSTAT=ist) name
                     endif           
                  endif              
                  if ( itype .lt. 2) Then
                     batch=.false.   
                     last =.true.    
                     sect = 99        
                     call print_all(name,num,opt,sect,batch,last,fplotacd, & 
                          fplotpom,fplotsim,fplotman,fctxtdisp,fctxtplot)
!#                 call flt_print (name,num,batch,last,
!#    >                 fctxtdisp,fctxtplot)
                     write (*,*) 'Single print finished.'
                  endif              
               endif                 

            elseif ( cmd .eq. 2 .or. cmd .eq. 3 ) then !Multi file print

               write (*,*) ' '       
               write (*,*) ' '       
               i = 1                 
               imax = 0              
               if ( cmd .eq. 2 ) then !input numbers by hand
                  write (*,*) 'Enter all tests to be printed,'
                  write (*,*) 'and to finish hit <CR>.'
                  do while ( ist .eq. 0 ) 
                     read (*,10,IOSTAT=ist) cfilea(i)
                     if ( cfilea(i) .eq. ' ' ) then
                        ist = 1      
                     else            
                        call findname(cfilea(i),numa(i),itype, & 
                             testname,testnum,numt)
                        if ( itype .gt. 2 ) then
                           write(*,*)'Test: '//cfilea(i)
                           write(*,*)'Not found in test_index.dat'
                           name = cfilea(i)(:lrbl(cfilea(i)))//'.txt'
                           call pathfile(filename,fpath, name)
                           inquire(FILE=filename,EXIST=lexist)
                           if ( lexist ) then
                              write(*,*) ' '
                              write(*,*) 'File :',filename(:lrbl(filename))
                              write(*,*)'Exists.  Do you want to print it? (Y,n)'
                              read(*,10,IOSTAT=ist) ans
                              if ( ist .eq. 0 .and. (ans .ne. 'n' & 
                                   .or. ans .ne. 'N')) then
                                 imax = i
                                 cfilea(i) = name
                                 i = i + 1
                              endif  
                           endif     
                        else         
                           imax = i  
                           i = i + 1 
                        endif        
                     endif           
                  enddo              
               else             !cmd  3 batch mode 
                  write(*,*) 'Enter batch file name (assume in DATA dir)'
                  read(*,10,IOSTAT=ist) name
                  if ( ist .ne. 0 ) then
                     write(*,*) 'Invalid input'
                     write(*,*) 'Hit <CR> to Continue'
                     read(*,10,IOSTAT=ist) name
                  else          !input valid
                     call pathfile(filename,fpath,name)
                     inquire (FILE=filename,EXIST=lexist)
                     if ( .not. lexist ) then
                        write(*,*) 'Batch file does not exist'
                        write(*,*) 'File: '//filename(:lrbl(filename))
                        write(*,*) 'Hit <CR> to Continue'
                        read(*,10,IOSTAT=ist) name
                     else       !batch file exists
                        open(lu4,FILE=filename,IOSTAT=ist)
                        if ( ist .ne. 0 ) then
                           write(*,*)'Error opening batch file'
                           write(*,*)'File: '//filename(:lrbl(filename))
                           write(*,*)'Hit <CR> to Continue'
                           read(*,10,IOSTAT=ist) name
                        else         
                           ist = 0   
                           do while (ist .eq. 0 )
                              read(lu4,10,IOSTAT=ist) cfilea(i)
!                              if ( cfilea(i) .eq. ' ' ) then
!                                 ist = 0
!                              elseif( ist .eq. 0 ) then
                              if( ist .eq. 0 ) then
                                 call findname(cfilea(i),numa(i),itype, & 
                                      testname,testnum,numt)
                                 if ( itype .gt. 2 ) then
                                    write(*,*) 'Test: '//cfilea(i)
                                    write(*,*) 'Not found in test_index.dat'
                                    name = cfilea(i)(:lrbl(cfilea(i))) & 
                                        //'.txt'
                                    call pathfile(filename,fpath, name)
                                    inquire(FILE=filename,EXIST=lexist)
                                    if ( lexist ) then
                                      write(*,*) 'Will print ', & 
                                           filename(:lrbl(filename))
                                      imax = i
                                      cfilea(i) = name
                                      i = i + 1
                                    endif
                                 else
                                    imax = i
                                    i = i + 1
                                 endif

                              endif  
                           enddo     
                           close(lu4)
                        endif        
                     endif           
                  endif              
               endif  !Input list or Batch file
               sect = 99
               do j=1,imax           
                  if ( opt .eq. 1 ) then
                     if (j.eq.imax) then
                        last=.true.  
                     else            
                        last=.false. 
                     endif           
                     batch = .true.  
                  else               
                     batch = .false. 
                     last  = .true.  
                  endif              
                  call print_all(cfilea(j),numa(j),opt,sect,batch,last, & 
                       fplotacd,fplotpom,fplotsim,fplotman, & 
                       fctxtdisp,fctxtplot)
!#               call flt_print (cfilea(j),numa(j),
!#     >                         batch,last,fctxtdisp,fctxtplot)
               enddo                 
               if ( imax .gt. 0 ) write (*,*) 'Multiple print finished.'
            elseif ( cmd .eq. 4 .and. opt .eq. 2 ) then !Print Section
               write(*,*)' '         
               write(*,*)' '         
               printall = .true.     
               do while ( printall ) 
                  write(*,*)'Enter Section Number to Print (RTN=Exit):'
                  read(*,10) line    

                  read(line,*,IOSTAT=ierr) sect
                  if ( ierr .ne. 0 ) then
                     printall = .false.
                  else               
                     write(*,*)' '   
                     write(*,*)' It is highly recommended to repage'// & 
                          ' this secton before printing'
                     write(*,*)' Do you want to repage this section?'// & 
                               ' (y/N)'
                     read(*,10,IOSTAT=ierr) line
                     call lower(line,10)
                     if ( index(line,'y') .and. ierr .eq. 0 ) then
                        write(*,*)' Repaginating section: ',sect
                        prompt = .false.
                        call pages(prompt,sect,page,icnt)
                     endif           

                     batch = .false. 
                     last  = .true.  
                     call print_all(name,num,opt,sect,batch,last, & 
                          fplotacd,fplotpom,fplotsim,fplotman, & 
                          fctxtdisp,fctxtplot)
                  endif              
               enddo                 

            elseif ( cmd .eq. 5 .and. opt .eq. 2 ) then !Print test guide
               write(*,*)' It is highly recommended to repage'// & 
                    ' the QTG before printing'
               write(*,*)' Do you want to repage the QTG?'// & 
                    ' (y/N)'         
               read(*,10,IOSTAT=ierr) line
               call lower(line,10)   
               if ( index(line,'y') .and. ierr .eq. 0 ) then
                  write(*,*)' Repaginating the QTG: '
                  prompt = .false.   
                  sect = 0   !Do all Sections
                  call pages(prompt,sect,page,icnt)
               endif                 

               batch = .false.       
               last  = .true.        
               sect  = 0
               call print_all(name,num,opt,sect,batch,last, & 
                    fplotacd,fplotpom,fplotsim,fplotman, & 
                    fctxtdisp,fctxtplot)
            endif               !Cmd 1

         elseif ( opt .eq. 3 ) then !Repage part of test guide
            write(*,*)' '            
            write(*,*)' '            
            printall = .true.        
            do while ( printall )    
               write(*,*)'Enter Section Number to Re-page (RTN=Exit):'
               read(*,10) line       

               read(line,*,IOSTAT=ierr) sect
               if ( ierr .ne. 0 ) then
                  printall = .false. 
               else                  
                  write(*,*)' Repaginating section: ',sect
                  prompt = .false.   
                  call pages(prompt,sect,page,icnt)
               endif                 
            enddo                    


         elseif ( opt .eq. 4 ) then !Repage test guide and table of contents
            pageup = .true.          
            titleup = .false.        

            temp = .true.            
            do while (temp)          
               data(1) = 'no'        
               data(2) = 'no'        
               if(pageup)  data(1) = 'yes'
               if(titleup) data(2) = 'yes'
               write(*,*)' '         
               write(*,*)' '         
               write(*,*)'    Re-page Options for Table of Contents'// & 
                              ' in front.txt'
               write(*,*)'  '        
               write(*,*)' 1.  Update page numbers: '//data(1)
               write(*,*)' 2.  Update test titles:  '//data(2)
               write(*,*)' 3.  Continue'
               read (*,20,IOSTAT=ist) cmd

               if (cmd.eq.1) then    
                  pageup = .not. pageup
                  if ( titleup ) pageup = .true.
               elseif(cmd.eq.2) then 
                  titleup = .not. titleup
                  if ( titleup ) pageup = .true.
               else                  
                  temp = .false.     
               endif                 
            enddo                    

            call repage (pageup,titleup)

         endif  !if Opt = 1          

      enddo                          


      return                         
 10   format(A)                      
 20   format (i1)                    
      end                            
!                                    
!                                    

!                                    
!     This subroutine prints all of the Qtg in order (text,ic,plot) as 
!     specified in ftpages.dat       
!                                    
      subroutine print_all(name,num,opt,sect,batch,last, & 
                          fplotacd,fplotpom,fplotsim,fplotman, & 
                          fctxtdisp,fctxtplot)

      implicit none                  

! * Arguments             
      character*40  name            !Test name

      integer*4     num             !test Number
      integer*4     opt             !print option number
      integer*4     sect            !Section to print 0=all
      integer*4     ftpage(500,5)   !Page data 1=sec 2=test 3=# text 
                                    !         4=No pages 5=start
      logical*4     batch           !Batch mode 
      logical*4     last            !Last file in batch or only file
      logical*4     fplotacd        !Plot aircraft data flag
      logical*4     fplotpom        !Plot proof-of-match data flag
      logical*4     fplotman        !Plot manual data from .man file
      logical*4     fplotsim        !Plot simulator data flag
      logical*4     fctxtdisp       !Display text file
      logical*4     fctxtplot       !Print text file


! * Local Variables                  
      integer*4     icnt            !Number of data points in ftpage
      integer*4     i,j,k,ij         
      integer*4     temp            !Temp int
      integer*4     itype           !Return flag fro findname
      integer*4     numt            !Number of tests
      integer*4     testnum(1000)   !Test numbers
      integer*4     tnum            !Individual test number
      integer*4     fininrt         !Return flag from flt_read.inc

      logical*4     prompt  /.false./         

      character*40  testname(1000)  !Testnames


      integer*4  fattest          !ref fat test ip code number
      integer*4  fsimruns /1/     !ref 113 number of sim runs to plot
      logical*4  fcplot           !ref display plots
      logical*4  fcpmess  /.true./!ref 113 6-grid message enable flag
      logical*4  fcprtplot        !ref crt print current plots
      logical*4  fcptolf /.false./!ref fcp tolerance flag

! * Varaibles to support flt_init_plo.inc


      logical*4   cont            !loop variable
      logical*4   ch              !changed
      logical*4   terr            !temp error flag in flt_plot_init.inc

      integer*4   ficoutype(100)   !ICount vars type in flt_plot_init.inc
      integer*4   fictype(100)     !ICvar  type in flt_plot_init.inc
      integer*4   frectype(42)    !rec 991nrt type of rec variables
      integer*4   frecstart       !start recording value
      integer*4   runway          !temp integer for runway in ic in
      integer*4   airport         !temp integer for airport in ic in
      integer*4   fairdmd         !ref 113 autotest dmd airport 
      integer*4   frundmd         !ref 113 autotest dmd runway 
      integer*4   l               !Counter

      character*4   crun               !
      character*4   cair               !
      equivalence(runway,crun)       
      equivalence(airport,cair)      


      include "flt_plot.inc"         
      include "flt_read_vars.inc"  !variable defs for flt_read.inc


      call read_index(numt,testname,testnum)

      if ( sect .eq. 99 ) then  !single file print
         ftestname = name
         fattest   = num
         call flt_print (name,fattest,  & !Print text
              batch,last,fctxtdisp,fctxtplot)
         if ( opt .eq. 2 ) then
            fcprtplot   = .true.
            fcplot      = .false.
            call flt_plottest(fattest,fcplot,fcprtplot,fcpmess, & 
                              fplotacd,fplotpom,fplotsim,fplotman, & 
                              fsimruns,fcptolf)
         endif
      else
         call pages(prompt,sect,ftpage,icnt)
         do ij=1,icnt                   
            if ( ftpage(ij,1) .eq. sect .or. sect .eq. 0 ) then
               temp = ftpage(ij,2)      
               call itoc(temp,ftestname)
               call findname(ftestname,tnum,itype, & 
                    testname,testnum,numt)

            if ( itype .gt. 2 ) then 
               write(*,*) 'Test not found :',ftpage(ij,2), & 
                          ' will not Print out'
            else                     
               batch       = .false.
               last        = .true.
               fcprtplot   = .true.
               fcplot      = .false.
               fattest     = ftpage(ij,2)
               write(*,*) 'Printing test: ',ftpage(ij,2)
               call flt_print (ftestname,fattest,  & !Print text
                       batch,last,fctxtdisp,fctxtplot)
               call flt_plottest(fattest,fcplot,fcprtplot,fcpmess, & 
                               fplotacd,fplotpom,fplotsim,fplotman, & 
                               fsimruns,fcptolf)

               endif                    
            endif                       
         enddo          
      endif

      return                         
      end                            


      subroutine repage (pageup,titleup)
      implicit none                  

! * Argument list                    
      logical*4     pageup            !Update page numbers in TOC
      logical*4     titleup           !Update test titles in TOC


! * Locals
      character*132 frntfile          !Filename of front.txt
      character*132 scrfile           !Full file name of scratch file
      character*132 temp1
      character*50  dots
      character*40  ctnum             !test number in characters
      character*80  temp2
      character*80  temp3
      character*80  temp4
      character*40  name              !temp test name
      character*40  testname(1000)   !testnames
      character*4   sec               !Character string of section number
      character*4   pg                !Character String of page number

      integer*4     ftpage(500,5)   !Page data 1=sec 2=test 3=# text 
                                     !          4=No pages 5=start
      integer*4     icnt            !Number of data points in ftpage
      integer*4     isect
      integer*4     date(3)              !date
      integer*4     et                   !test number end
      integer*4     i,i1,i2,i3,i4,i5,i6,i7,i8,i9,i0 !counters
      integer*4     ierr                 !iostat error
      integer*4     ist                  !IOSTAT flag
      integer*4     j,k                  !counter
      integer*4     nline                !line pointer
      integer*4     lu61  /61/           !front.txt file
      integer*4     lu62  /62/           !new front.txt file
      integer*4     num                  !Found test number
      integer*4     numt                 !number of tests
      integer*4     testnum(1000)        !test numbers
      integer*4     itype                !Type of input
      integer*4     page  /1/            !page counter
      integer*4     pg_doc               !page number
      integer*4     sec_doc              !section number 
      integer*4     time(3)              !time
      integer*4     fininrt              !flag used by in read of tdf file
      integer*4     fattest              !Autotest number
      integer*4     ntext                !Number of text pages

      logical*4     end                  !end of file flag
      logical*4     first  /.true./      !first pass
      logical*4     lexist               !file exist flag
      logical*4     new                  !new part of front.txt
      logical*4     tgtext               !page is front or back of tg
	  logical*4     ferr                 !Rename file error flag

! * Include files

      include "flt_plot.inc"
      include "flt_read_vars.inc"

      call read_index(numt,testname,testnum)


      isect = 0                  !Repaginate whole test guide
      call pages(.false.,isect,ftpage,icnt)

      if ( icnt .lt. 0 ) then
         write(*,*) 'Error reading ftpages exiting print'
         return
      elseif ( icnt .eq. 0 ) then
         write(*,*) 'ftpages.dat is empty; exiting print'
         return
      endif

      if ( .not. pageup .and. .not. titleup ) return



      call pathfile(frntfile,fpath,'front.txt')
      inquire(FILE=frntfile,EXIST=lexist)
      if (.not.lexist) then
         write(*,*) ' File: front.txt does not exist.'
         write(*,*) ' Cannot create an index.'
         return
      endif

      open (lu61,FILE=frntfile,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*) ' Unable to open file: front.txt'
         write(*,*) ' Cannot create an index.'
         return
      endif

      k = lrbl(cpid)
      call pathfile(scrfile,fpath,'scratch_'//cpid(:k))
      open (lu62,FILE=scrfile,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*) ' Unable to open scratch file:'// & 
              scrfile(:lrbl(scrfile))
         write(*,*) ' Cannot create an index.'
         return
      endif

      i3 = 0
      new = .false.


      write(dots,90)            !set up dot array
 90   format(50('.'))

! *   Use data from call to pages (read ftpages.dat) to build table of contents

      if ( titleup ) then  !Rewrite whole TOC

         do j=1,icnt            !total # of tests
            if (ftpage(j,1).ne.i3) then !check for new section
               if (ftpage(j,1).ne.1) write(lu62,*) ' ' !need this line
               call itoc(ftpage(j,1),temp3(1:3)) !store as char
               temp3 = temp3(:rlan(temp3(1:2))) // '...' !add the rest
               i2 = 0             
               ist = 0          !reset pointer
               do while (i2 .eq. 0 .and. ist .eq. 0 ) !loop
                  read(lu61,10,IOSTAT=ist) temp2 !read original
                  i2 = index(temp2,temp3(:4)) !test
                  if (.not.new .or. i2.gt.0)  & !old stuff
                       write(lu62,10) temp2(:rlan(temp2)) !build new file
                  new = new .or. i2.gt.0 !do top part only
               enddo
               write(lu62,*) ' '
            endif
            i3 = ftpage(j,1)    !save last pass



            i1 = ftpage(j,2)
            call itoc(i1,name)
            call findname(name,num,itype,testname,testnum,numt)

            if ( itype .gt. 2 ) then
               write(*,*) 'Test: '//name(:lrbl(name))// & 
                    ' Not in test_index.dat'
               title='TEST NOT DEFINED'
            else                ! Read test definition file to get title
               call pathfile(temp1,fpath,name(:lrbl(name))//'.tdf')
               inquire(FILE=temp1,EXIST=lexist)
               if ( lexist ) then
                  fattest = num
                  ftestname = name
                  include "flt_read.inc"
               else
                  title = 'NO TEST DEFINITION FILE'
               endif
            endif

            write(sec,30) ftpage(j,1)
            write(pg,30)  ftpage(j,5)
            write(lu62,110) ftpage(j,2),title(:rlan(title)), & 
                 dots(:50-rlan(title)),sec(lran(sec):),pg(lran(pg):)
         enddo

!        Read through old TOC to start of last def'd section in ftpages.dat
!        i2 = 0
!        call itoc(ftpage(icnt,1),temp3(1:3))   !Read to last section def'd
!        temp3 = temp3(:rlan(temp3(1:2))) // '...' !add the rest
!        ist = 0
!        do while (i2 .eq. 0 .and. ist .eq. 0 ) !loop
!           read(lu61,10,IOSTAT=ist) temp2 !read original
!           write(*,*) temp2(:lrbl(temp2))
!           i2 = index(temp2,temp3(:4)) !test
!        enddo

!        Read through last section in TOC 
         i2 = 0
         ist = 0
         do while (i2 .eq. 0 .and. ist .eq. 0 ) !loop
            read(lu61,10,IOSTAT=ist) temp2 !read original
            if ( temp2 .ne. ' ' ) then
               temp4 = temp2(lran(temp2):)
               temp4 = temp4(:lrbl(temp4)) !isolate test number
               call ctoi(temp4,num)
               call get_pgno(num,pg_doc,sec_doc,ntext)
               if ( sec_doc .ne. ftpage(icnt,1) ) i2 = 1
            endif
         enddo
         write(lu62,*) ' '
         write(lu62,10) temp2(:rlan(temp2)) !write this line

      else  !only update page numbers
         temp3 = '1...'
         ist   = 0
         i2    = 0
         isect = 1
!         Read through the file until section 1 found "1...."
         do while ( ist .eq. 0 .and. i2 .eq. 0 ) 
            read(lu61,10,IOSTAT=ist) temp2 !read original
            i2 = index(temp2,temp3(:4)) !test
            if ( ist .eq. 0 )  & !Echo Old stuff to output file
                 write(lu62,10) temp2(:rlan(temp2)) !build new file
         enddo

         isect = isect + 1
         call itoc(isect,temp3(1:3)) !goto next section
         temp3 = temp3(:rlan(temp3(1:2))) // '...' !add the rest

         do while ( isect .le. ftpage(icnt,1)+1 ) !Last section def'd in ftpages
            read(lu61,10,IOSTAT=ist) temp2 !read original
            if ( ist .ne. 0 ) then
               write(*,*)' Error reading :'//frntfile(:lrbl(frntfile))
               write(*,*)' Nothing Done'
               close(lu61)
               close(lu62)
			   call del_file(scrfile)
               return
            else
               i2 = index(temp2,temp3(:4)) !test for next section
               if ( i2 .gt. 0 ) then
                  isect = isect + 1
                  call itoc(isect,temp3(1:3)) !goto next section
                  temp3 = temp3(:rlan(temp3(1:2))) // '...' !add the rest
               elseif ( temp2 .ne. ' ' ) then !Assume a number
                  temp4 = temp2(lran(temp2):)
                  temp4 = temp4(:lrbl(temp4)) !isolate test number
                  call ctoi(temp4,num)
                  call get_pgno(num,pg_doc,sec_doc,ntext)
                  if ( sec_doc .ne. isect - 1 ) then !test in wrong section?

                     if ( isect .eq. ftpage(icnt,1)+1 ) then
                        isect = isect + 1   !Reached end of tests define 
                                            !in ftpages.dat so exit here
                     else
                        write(*,*)' Error in front.txt'
                        write(*,*)' Appears that test ',num, & 
                             ' is in wrong section'
                        write(*,*)' ftpages.dat says section ',sec_doc, & 
                             ' and front.txt says section ',isect-1
                        write(*,*)' Nothing Done'
                        close(lu61)
                        close(lu62)
		         	    call del_file(scrfile)
                        return
                     endif
                  else

                     write(sec,30) sec_doc
                     write(pg,30)  pg_doc
                     temp2 = temp2(:63) !remove old page number
                     write(temp4,120,IOSTAT=ist) sec(lran(sec):), & 
                          pg(lran(pg):)
                     temp2 = temp2(:62)//temp4(:lrbl(temp4))
                  endif
               endif

               write(lu62,10) temp2(:rlan(temp2))
            endif
         enddo

      endif
      ist = 0
      do while (ist .eq. 0 )    !loop
         read(lu61,10,IOSTAT=ist) temp2 !read remaining original
         write(lu62,10) temp2(:rlan(temp2)) !build new file
      enddo
      write (*,*) 'Tgprint Repagination and TOC Update Complete.'
      close(lu61)
      close(lu62)
	  call rename_file(scrfile,frntfile,ferr)

	  if ( ferr ) then
		 write(*,*) 'Unable to rename :'//scrfile(:lrbl(scrfile))
		 write(*,*) 'To new file name :'//frntfile(:lrbl(frntfile))
		 write(*,*) 'PLease make cnage outside of this program to incorporate changes.'
	  endif

      return
 10   format(A)
 30   format(i4)
 110  format(t2,i4,t12,a,a,t63,a,'-',a)
 120  format(a,'-',a)
      end




      subroutine ftn_logmess_info(module,message)

      implicit none

      character*(*) module
      character*(*) message

      integer*4 rlan     !Returns index of last nom blank

      write(*,*) message(:rlan(message))
      return
      end
