!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      SIMULATOR         :  Boeing 717-200
!      JOB NUMBER        :  8700                                    *
!      DEPARTMENT        :  61 - Flight                             *
!      MODULE NAME       :  TGPLOT                                  *
!      MODULE DESCRIPTION:  TG plot utility                         *
!      RATE              :  N/A                                     *
!      ISSUE             :  N/A                                     *
!      ORIGINATOR        :  Matthew F. Kneisler                     *
!      DATE              :  April 22, 1991                          *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FLIGHTSAFETY INTERNATIONAL Simulation Systems Division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of the FLIGHTSAFETY INTERNATIONAL Simulation    *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y  I N T E R N A T I O N A L         *
!            Simulation Systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012                          *
!            (918) 251-0500    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!--> REVISION BEGIN

! $Id: flt_tgplot.f,v 1.10 2000/03/13 22:17:58 saladinm Exp $
! $Log: flt_tgplot.f,v $
! Revision 1.10  2000/03/13 22:17:58  saladinm
! DR/MACAR:     None
! Problem:      Had to update all three calls to flt_output.f anytime that
!               module was changed.
! Conclusion:   True.
! Resolution:   Created a subroutine that calls flt_output.f therefore requiring
!               the changes to be made in one spot.  ALso all of the labels
!               no longer have to be defined in this module.
! Dependencies: flt_plottest.f
! Engineer:     Mike Saladin

! Revision 1.9  2000/02/14 16:48:42  saladinm
! Updated call to flt_output.f.  Just a variable order change.

! Revision 1.8  2000/02/14 16:17:05  saladinm
! DR/MACAR:     None
! Problem:      Changes made to flt_output.f no longer require configuration
!               flags to be sent to this module.
! Conclusion:   True,
! Resolution:   Removed these labels from call to flt_output.f
! Dependencies: flt_output.f
! Engineer:     Mike Saladin

! Revision 1.7  1999/12/22 17:55:21  mattk
! flt_tgplot.f Initial release from automated zeb process

! Revision 1.6  1999/04/08 19:43:54  saladinm
! Fixed error with batch file.

! Revision 1.16  1999/03/18 14:05:54  saladinm
! Fixed batch file mode.

! Revision 1.15  1999/03/11 15:22:26  saladinm
! Changs variable for do loop from L to LL since L is used in flt_init_plot.inc.

! Revision 1.14  1999/03/08 16:01:10  saladinm
! Modified call to flt_output.  Deleted fcplotac and added fmantxtfl.

! Revision 1.13  1999/03/01 12:16:06  saladinm
! Removed fsimin and changed call to flt_output.

! Revision 1.12  1999/02/24 19:31:15  saladinm
! Removed fsimin from menu and replaced with fcptolf - plot tolerance flag.

! Revision 1.11  1999/02/18 14:06:10  saladinm
! Added fplotman code.

! Revision 1.10  1999/02/12 16:01:00  saladinm
! Added fxplotshft to flt_output calls.

! Revision 1.9  1999/02/11 15:27:59  saladinm
! Updated call to flt_output which supports not re-reading sim file in real time.

! Revision 1.8  1999/02/10 16:39:54  saladinm
! Changed call to flt_output for x/y target slope vairables.

! Revision 1.7  1999/02/08 17:11:00  saladinm
! Modified call to flt_output.

! Revision 1.6  1999/02/05 23:02:52  saladinm
! Added naptdmd stuff mainly so it will compile.

! Revision 1.5  1999/02/03 22:06:29  saladinm
! New release of Autotest SW. Version 2.0

! Revision 1.3  1999/01/08 17:25:24  saladinm
! Updated array size of test index to 1000 from 400.

! Revision 1.2  1998/12/16 23:18:21  saladinm
! *** empty log message ***

! Revision 1.1  1998/12/16 21:29:24  saladinm
! Initial revision

! Revision 1.4  1998/09/08 20:43:35  vdemeter
! Updated from 8420

! Revision 1.10  1998/08/28 17:29:12  vdemeter
! Fixed problem with testnumber

! Revision 1.9  1998/08/21 20:14:06  vdemeter
! Added multiple sim runs plotting

! Revision 1.8  1998/08/21 15:19:35  vdemeter
! Changed *.sim file type to *.acd file type.

! Revision 1.7  1998/08/06 19:47:21  flt
! Reverted to one sim plot version.

! Revision 1.5  1998/02/04 17:18:36  vdemeter
! Added display 1st plot when multiple plots are generated.

! Revision 1.4  1998/01/27 17:44:38  vdemeter
! Updated from 7504

! Revision 1.4  1997/12/02 20:30:39  vdemeter
! Canged default to pom=false

! Revision 1.3  1997/11/03 17:33:32  scottc
! added fatprint for batchs without printouts

! Revision 1.2  1997/09/05 16:48:19  vdemeter
! Changed default options.

! Revision 1.1  1997/06/27 16:18:05  vdemeter
! Initial revision

! Revision 1.4  1997/06/04 15:36:17  vdemeter
! Changed fmm990 to flt_990 and fmmplt to flt_plt

! Revision 1.3  1997/06/04 13:46:40  vdemeter
! Changed default print options.

! Revision 1.2  1997/05/21 12:37:06  vdemeter
! flt_tgplot.f Initial release from automated d61master process

! Revision 1.3  1997/01/09 00:14:01  ssmith
! Added proof of match plotting capability.  The user can now
! decide which combination or all data sets to plot: acd, pom,
! and/or sim.

! Revision 1.2  1996/12/09  20:46:58  mattk
! flt_tgplot.f Initial release from automated zeb process

! Revision 1.1  1996/11/01  15:56:07  mattk
! Initial revision

! Revision 1.1  1996/10/11  21:17:27  mattk
! Initial revision


! Revision 1.12  1996/07/25  20:39:59  mattk
! undo 1.11

! Revision 1.11  1996/05/29  18:15:58  msaladin
! Added dms plotting stuff.

! Revision 1.10  1996/05/09  21:52:40  msaladin
! Added frecrate to call to 990.

! Revision 1.9  1996/02/27  18:06:24  mattk
! ms latest

! Revision 1.8  1996/02/26  21:05:51  mattk
! ms latest

! Revision 1.6  1996/02/01  21:04:10  mattk
! flt_tgplot.f Initial release from automated d61master process

! Revision 1.5  1996/01/30  16:00:28  mattk
! mike saladin latest

! Revision 1.4  1996/01/26  19:02:07  mattk
! allow toggle of set up

! Revision 1.3  1996/01/24  18:10:13  mattk
! added ghostscript capability

! Revision 1.2  1996/01/23  19:42:38  mattk
! flt_tgplot.f add FAX number from automated change process

! Revision 1.1  1996/01/19  22:13:22  mattk
! Initial revision

!--> REVISION END

      subroutine tgplot()
      IMPLICIT NONE

      character*80  rcsid & 
      /"$Id: flt_tgplot.f,v 1.10 2000/03/13 22:17:58 saladinm Exp $"/

!--> GLOBAL BEGIN

      include "flt_plot.inc" 

!--> GLOBAL END

! * Variables for call to flt_output   
      integer*4  fbetavar         !ref 113 Y index for peak analysis beta
      integer*4  fphivar          !ref 113 Y index for peak analysis phi
      integer*4  fpowervar        !ref 113 Y index for accel analysis N1
      integer*4  fplavar          !ref 113 Y index for accel analysis
      integer*4  fcfdvar          !ref 113 Y index for accel analysis
      integer*4  fytarvar(10)     !ref 113 Y target plot index
      integer*4  fxtarvar(10)     !ref 113 X target plot index
      integer*4  fnxtar           !ref 113 Number of x targets
      integer*4  fnytar           !ref 113 Number of y targets
      integer*4  ficinnum         !ref 113 Number of vars input as init's
      integer*4  ficotnum         !ref 113 Number of vars to output as ic
      integer*4  ficord(100)       !ref 113 Numerical order of ic variables
      integer*4  ficinop(100)      !ref 113 I/O status for ic input vars
      integer*4  frecframe        !ref rec number of frames recorded
      integer*4  frecnumb         !ref 113 Number of variables recorded
      integer*4  fnumgrid(36)     !ref 113 Number of grids to use for each y
      integer*4  fymaptox(36)     !ref 113 For each Y which X to use
      integer*4  fxvarnum         !ref 113 Number of x variables for plots
      integer*4  fyvarnum         !ref 113 Number of y variables plotted
      integer*4  fdampvar         !ref 113 Which Y var to use for damp ratio
      integer*4  fairdmd          !ref 113 autotest dmd airport 
      integer*4  frundmd          !ref 113 autotest dmd runway 
      integer*4  fxtarm(10)       !ref 113 Slope to find x target on
      integer*4  fytarm(10)       !ref 113 Slope to find y target on

      logical*4  facdline         !ref 113 Put line w/ snapshot pts ACD/POM
      logical*4  fatman           !ref 113 Manual test selected for test
      logical*4  fsimline         !ref 113 Put line w/ snapshot pts SIM
      logical*4  fhilite(36)      !ref 113 Highlight these variables
      logical*4  ftstover         !ref 113 Test over flag

      real*4     fytarval(10)     !ref 113Y target value for high lighting
      real*4     fxtarval(10)     !ref 113 X target value for high lighting
      real*4     fdampst          !ref 113 Start time for damp ratio analysis
      real*4     ficinval(100)     !ref 113 Sim input ic data array
      real*4     frecbuff(100000) !ref 991 temp data storage arry
      real*4     fxsng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fysng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fxscale(2,6)     !ref 113 X axis scales (1) min (2) max
      real*4     fyscale(2,36)    !ref 113 Y axis scales (1) min (2) max
      real*4     ftola(36)        !ref 113 Absolute tolerance value
      real*4     ftolp(36)        !ref 113 Percent tolerance value
      real*4     fbetast          !ref 113 Start time for peak analysis beta
      real*4     fphist           !ref 113 Start time for peak analysis phi
      real*4     fcfdst           !ref 113 Start time for peak analysis phi
      real*4     fxplotshft       !ref 113 time shift for manual data

      logical*4  fatbrun          !ref crt batch tests running flag
      logical*4  fatenabl         !ref fat test ip enable
      logical*4  fsnapacd(36)     !ref 113 Snap shot flag by variable ACD
      logical*4  fsnappom(36)     !ref 113 Snap shot flag by variable POM
      logical*4  fsnaplot         !ref 113 whole plot snap shot
      logical*4  fylimit(36)      !ref 113 Limit plot data to y axis

      integer*4  fattask          !ref 113 fat task controller
      integer*4  fattest          !ref fat test ip code number
      integer*4  fsimruns         !ref 113 number of sim runs to plot

      integer*4  fcpbctr          !ref 113 fat batch plot control ctr
      logical*4  fcplot           !def display plots
      logical*4  fplotacd         !ref 113 plot aircraft data flag
      logical*4  fplotman         !ref 113 plot manual data flag
      logical*4  fplotpom         !ref 113 plot prrof-of-match data flag
      logical*4  fplotsim         !ref 113 plot simulator data flag
      logical*4  fcpmess          !ref 990 6-grid message enable flag
      logical*4  fatprint         !def 990 batch printer control flag
      logical*4  fcprtplot        !def crt print current plots
      logical*4  fcptolf          !ref fcp tolerance flag
      integer*4  frecval          !ref 991 program pointer
      logical*4  fcpcopy          !def 990 copy output flag
      logical*4  ftgplot          !def 990 tgplot active flag
      logical*4  fmantxtfl        !ref 113 display man test txt page when ran
      real*4     frecrate         !ref 991nrt actual autoteset recording rate


      real*4     iconst     /1/   !Frame time variable

! * local begin

      character*132 btfile          !full batch file name
      character*40  testname(1000)   !testnames
      character*40  name            !temp testname
      integer*4     testnum(1000)    !test numbers
      integer*4     numt            !number of tests
      integer*4     itype           !Type of test input name=1 num=0

      character*8   cfilea(300)       !filename array

      character*80  mess1


      logical*4   lexist               !file exist flag
      logical*4   firstpass /.true./   !firstpass flag
      logical*4   temp_fcprtplot       !save value of fcprtplot
      logical*4   temp_fcplot          !save value of fcplot
      logical*4   master               !master loop variable
      logical*4   cont                 !loop variable
      logical*4   ch                   !changed
      logical*4   terr                 !temp error flag in flt_plot_init.inc

      integer*4   ficoutype(100)        !IC out vars type in flt_plot_init.inc
      integer*4   fictype(100)          !IC var type in flt_plot_init.inc
      integer*4   fininrt              !flag for error in test read
      integer*4   frectype(42)         !ref 991nrt type of rec variables
      integer*4   frecstart            !start recording value
      integer*4   cmd                  !console command
      integer*4   i,j,k,l,ll           !counters
      integer*4   ist                  !IO status flag    
      integer*4   imax                 !maximum file count
      integer*4   lu4   /4/            !batch file lu
      integer*4   runway               !temp integer for runway in ic in
      integer*4   airport              !temp integer for airport in ic in

      character*4   crun                !
      character*4   cair                !
      equivalence(runway,crun)
      equivalence(airport,cair)

      character*3 ans(10)               !answer status

!--> LOCAL END
      include "flt_read_vars.inc"  !variable defs for flt_read.inc

! Initialize certain parameters.

      ftgplot = .true.
      frecrate = 0.
      fcplot   = .true.
      fcprtplot= .false.
      fcpmess  = .false.
      fplotacd = .true.
      fplotpom = .false.
      fplotsim = .true.
      fplotman = .false.
      fcptolf   = .false.
      fmantxtfl = .false.

      fsimruns  = 1
      ans(1) = 'yes'
      ans(2) = 'no'
      ans(3) = 'no'
      ans(4) = 'yes'
      ans(5) = 'no'
      ans(6) = 'yes'
      ans(7) = 'no'
      ans(8) = ' 1'
      ans(9) = 'no '
      ans(10) = 'yes'


! * Read test name number index
      call read_index(numt,testname,testnum)

      master = .true.
      do while ( master ) 
      cont = .true.
      do while ( cont )
         write (*,*) ' '
         write (*,*) ' '
         write (*,*) ' '
         write (*,*) ' '
         write (*,*) '           TG Plot Utility.'
         write (*,*) '                Set Up'
         write (*,*) ' '
         write (*,*) '           1.  Enable screen display.    ',ans(1)
         write (*,*) '           2.  Enable print out.         ',ans(2)
         write (*,*) '           3.  Enable messages.          ',ans(3)
         write (*,*) '           4.  Include acd data.         ',ans(4)
         write (*,*) '           5.  Include pom data.         ',ans(5)
         write (*,*) '           6.  Include sim data.         ',ans(6)
         write (*,*) '           7.  Include man data.         ',ans(7)
         write (*,*) '           8.  No of sim runs to plot:   ',ans(8)
         write (*,*) '           9.  Show Tolerances           ',ans(9)
         write (*,*) '           10. Reset.                    ',ans(10)
         write(*,*) 'Enter choice -> '
         read (*,150,IOSTAT=ist) cmd

         if ( ist .ne. 0 ) then
            cont = .false.
            cmd = 99
         endif

         if (cmd.eq.1) then
            fcplot=.not.fcplot
            if (fcplot) then
               ans(1) = 'yes'
            else
               ans(1) = 'no '
            endif
            ans(10) = 'no '
         elseif (cmd.eq.2) then
            fcprtplot= .not.fcprtplot
            if (fcprtplot) then
               ans(2) = 'yes'
            else
               ans(2) = 'no '
            endif
            ans(10) = 'no '
         elseif (cmd.eq.3) then
            fcpmess = .not.fcpmess
            if (fcpmess) then
               ans(3) = 'yes'
            else
               ans(3) = 'no '
            endif
            ans(10) = 'no '
         elseif (cmd.eq.4) then
            fplotacd = .not.fplotacd
            if (fplotacd) then
               ans(4) = 'yes'
            else
               ans(4) = 'no '
            endif
            ans(10) = 'no '
         elseif (cmd.eq.5) then
            fplotpom = .not.fplotpom
            if (fplotpom) then
               ans(5) = 'yes'
            else
               ans(5) = 'no '
            endif
            ans(10) = 'no ' 
         elseif (cmd.eq.6) then
            fplotsim = .not.fplotsim
            if (fplotsim) then
               ans(6) = 'yes'
            else
               ans(6) = 'no '
            endif
            ans(10) = 'no '
         elseif (cmd .eq. 7) then
            fplotman = .not.fplotman
            if (fplotman) then
               ans(7) = 'yes'
            else
               ans(7) = 'no '
            endif
            ans(10) = 'no ' 
         elseif (cmd .eq. 8) then
            if (fsimruns .eq. 1) then
               ans(8) = ' 2'
               fsimruns = 2
            elseif (fsimruns .eq. 2) then
               ans(8) = ' 3'
               fsimruns = 3
            else
               ans(8) = ' 1'
               fsimruns = 1
            endif
         elseif (cmd .eq. 9) then
            fcptolf   = .not. fcptolf 
            if (fcptolf) then
               ans(9) = 'yes'
            else
               ans(9) = 'no '
            endif
            ans(10) = 'no '
         elseif (cmd .eq. 10) then
            fcplot    = .true.
            fcprtplot = .false.
            fcpmess   = .false.
            fplotacd  = .true.
            fplotpom  = .false.
            fplotsim  = .true.
            fplotman  = .false.
            fsimruns  = 1
            fcptolf   = .false.
            ans(1) = 'yes'
            ans(2) = 'no'
            ans(3) = 'no '
            ans(4) = 'yes'
            ans(5) = 'no'
            ans(6) = 'yes'            
            ans(7) = 'no'
            ans(8) = ' 1'
            ans(9) = 'no '
            ans(10) = 'yes'
         elseif ( cmd .eq. 0 .or. cmd .gt. 10 )then
            cont = .false.
         endif
      enddo


      cont = .true.
      do while ( cont ) 
         write (*,*) ' '
         write (*,*) ' '
         write (*,*) ' '
         write (*,*) ' '
         write (*,*) '           TG Plot Utility.'
         write (*,*) '              Main Menu'
         if (.not. fcplot) & 
              write (*,*) '        Screen Display Inhibited'
         if (.not. fcprtplot) & 
              write (*,*) '        Plot Print Out Inhibited'
         if (fcpmess) & 
              write (*,*) '            Messages Enabled'
         if (.not. fplotacd)   & 
              write (*,*) '      ACD Data will NOT be Included'
         if (.not. fplotpom)   & 
         write (*,*) '      POM Data will NOT be Included'
         if (.not. fplotsim)   & 
              write (*,*) '      SIM Data will NOT be Included'
         if ( fplotman ) & 
              write (*,*) '      Man Data will Be Included'
         write (*,*) ' '
         write (*,*) '           1.  Plot single test.'
         write (*,*) '           2.  Plot several tests.'
         write (*,*) '           3.  Plot tests from batch list.'
         write (*,*) '           4.  Exit.'
         write(*,*) 'Enter choice -> '
         read (*,150,IOSTAT=ist) cmd
 150     format (i2)

         if ( ist .ne. 0 ) return

         if (cmd .le. 0 .or. cmd .ge. 4) return

         if ( cmd .eq. 1 ) then
! * single file print out
            write (*,*) ' '
            write(*,*) ' Enter Test Name or Number'
            read(*,10,IOSTAT=ist) name
            if ( name(1:1) .ne. ' ' ) then
               ftestname = name
               call findname(ftestname,fattest,itype, & 
                             testname,testnum,numt)
            else
               itype = 99
            endif
            if ( itype .lt. 2 ) then !Test found 
               temp_fcprtplot = fcprtplot
               temp_fcplot    = fcplot
               call flt_plottest(fattest,fcplot,fcprtplot,fcpmess, & 
                                 fplotacd,fplotpom,fplotsim,fplotman, & 
                                 fsimruns,fcptolf)
               fcprtplot = temp_fcprtplot !these get reset 
               fcplot    = temp_fcplot
               call tmessage
               write (*,*) ' TGPLOT single plot finished.'
            endif

         elseif ( cmd .eq. 2 .or. cmd .eq. 3 ) then

            write (*,*) ' '
            temp_fcprtplot = fcprtplot
            temp_fcplot    = fcplot
            i = 1
            imax = 0
            if ( cmd .eq. 2 ) then !read from screen
               write (*,*) ' '
               write (*,*) ' Enter all tests to be plotted,'
               write (*,*) ' and to finish type a * or hit return.'
               read (*,'(a8)',IOSTAT=ist) cfilea(i)
               do while ( ist .eq. 0 .and. cfilea(i)(1:1) .ne. ' ' & 
                                     .and. index(cfilea(i),'*') .eq. 0 ) 
                  imax = i
                  i = i + 1
                  read (*,'(a8)',IOSTAT=ist) cfilea(i)
               enddo
!               write(*,*) 'imax = ',imax
            else
               call pathfile(btfile,fpath,'tgplot.bat')
               inquire (FILE=btfile,EXIST=lexist)
               if (.not.lexist) then
                  write (*,*) ' '
                  write (*,*) ' '
                  write (*,*) ' File tgplot.bat is not found.'
                  write (*,*) ' '
                  write (*,*) ' To use the batch feature execute the'
                  write (*,*) ' following in the DATA directory:'
                  write (*,*) ' '
                  write (*,*) '   1. emacs tgplot.bat'
                  write (*,*) '   2. Add all tests to be plotted.'
                  write (*,*) '   3. On the last line type a *.'
                  write (*,*) '   4. Re-run tgplot.'
                  write (*,*) ' '
               else
                  open (lu4,FILE=btfile,IOSTAT=ist)
                  if ( ist .ne. 0 ) then
                     write(*,*) 'Error read tgplot.bat'
                     write(*,*) 'No able to run batch mode'
                     imax = 0
                  else
                     i = 1
                     read (lu4,'(a)',IOSTAT=ist) cfilea(i)
                     do while ( ist .eq. 0  & 
                                 .and. index(cfilea(i),'*') .eq. 0 ) 
                        imax = i
                        i = i + 1
                        read (lu4,'(a)',IOSTAT=ist) cfilea(i)
                     enddo
                     close(lu4)
                  endif
               endif
            endif
! *       Batch data read in from either tgplot or from command line
            do  ll=1,imax
!               if ( ll .eq. 1 .and. temp_fcplot) then
               if ( temp_fcplot) then
                  fcplot = .true. !displays first plot
               else
                  fcplot = .false.
               endif
               ftestname = cfilea(ll)
               call findname(ftestname,fattest,itype,testname,testnum,numt)
               if ( itype .lt. 2 ) then !Test found
                  write(*,*) 'Working with test ',fattest,ftestname
                  temp_fcprtplot = fcprtplot
                  temp_fcplot    = fcplot
                  if ( fcprtplot ) then
                     write(*,*) 'Creating plot file and'// & 
                          ' sending to printer'
                  else
                     write(*,*) 'Creating plot file will NOT print'
                  endif
                  call flt_plottest(fattest,fcplot,fcprtplot,fcpmess, & 
                                    fplotacd,fplotpom,fplotsim,fplotman, & 
                                    fsimruns,fcptolf)

                  fcprtplot = temp_fcprtplot !these get reset 
                  fcplot    = temp_fcplot
               endif
            enddo
            write (*,*) ' TGPLOT multiple plot finished.'
         endif
      enddo  ! single multiple tests
      enddo  ! master loop

 10   format(a)
 11   format(A,I5,A,A)
 12   format(A,A)
      return
      END


      subroutine tmessage

      USE DFPORT

      integer*4    bell

      data           bell     /Z'20202007'/

      integer*4   i_date(3)             !date
      integer*4   i_time(3)             !time

      integer*4   lrbl                !returns first blank from left

      INCLUDE "flt_plot.inc" 

      call idate(i_date)
      call itime(i_time)
      write(*,600) ftestname(:lrbl(ftestname)),i_time(1),i_time(2),i_time(3), & 
                     i_date(2),i_date(1),i_date(3),bell
  600   format(' ', & 
        ' TEST ',A,' FINISHED AT ',I2,':',I2,':',I2, & 
        '   ',I2,'/',I2,'/',I4,'  ',A4)

      return
      end
