! **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Simulator         :  STANDARD                                *
!      Department        :  61 - flight                             *
!      Module name       :  flt_reduction                           *
!      Module description:  Reads flight test data in               *
!                           and creates .acd files from the         *
!                           data.                                   *
!      Originator        :  M. Saladin                              *
!      Date              :  12/21/98                                *
!                                                                   *
!                                                                   *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems Division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of FlightSafety International Simulation        *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!            FlightSafety International                             *
!            Simulation Systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012, U.S.A.                  *
!            (918) 251-0500    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **

      subroutine flt_reduction
      implicit none

!--> REVISION BEGIN

!                            Revision History

! $Id: flt_reduction.f,v 1.5 1999/06/01 19:36:06 saladinm Exp saladinm $
! $Log: flt_reduction.f,v $
! Revision 1.5  1999/06/01 19:36:06  saladinm
! Fixed a number of problems.  Shift data to zero.

! Revision 1.4  1999/03/08 13:30:20  saladinm
! Fixed output of trimpts.  Finished manual input data.  Cleaned up code.

! Revision 1.3  1999/03/05 16:42:26  saladinm
! Fixed error in findsym when a variable not found in flt_symbols.dat.
! Removed create_extras and more_data routines which are now in reduc_boeing.f

! Revision 1.2  1999/02/25 16:09:26  saladinm
! Modified for | delimited flt_batch.dat file.

! Revision 1.1  1999/02/24 19:35:17  saladinm
! Initial revision
!--> REVISION END

      CHARACTER*80  RCSID & 
      /"$Id: flt_reduction.f,v 1.5 1999/06/01 19:36:06 saladinm Exp saladinm $"/

      integer*4     lu3    /3/       !Output file unit
      integer*4     lu20   /20/      !Data file unit
      integer*4     lu40   /40/      !.acd header file unit
      integer*4     lu43   /43/      !.tdf file unit
      integer*4     lu82   /82/      !flt_batch file unit
      integer*4     icmd             !Command type
      integer*4     typeans          !Type of test command
      integer*4     i,j,k            !Counters
      integer*4     itrimpt          !Array start/end indices for clipping
      integer*4     ist              !IOSTAT error flag
      integer*4     ist2             !IOSTAT error flag
      integer*4     ist3             !IOSTAT error flag
      integer*4     numt             !Number of tests defined in test_index.dat
      integer*4     lt               !Length of ftestname
      integer*4     num              !Test number from test_index.dat
      integer*4     itype            !return code from look for test in index
      integer*4     dtype            !Data type to convert
      integer*4     decomp           !Decompress data flag
      integer*4     retstat          !Return status flag
!      integer*4     tt(3)            !Time array hours,minutes,seconds
!      integer*4     td(3)            !Date array day,month,year
      integer*4     zip_flag/0/      !zip file status flag
      integer*4     ftestnum         !test number
      integer*4     fattest          !Auto test number
      integer*4     fininrt          !Error flag
      integer*4     testnum(1000)    !test numbers
      integer*4     icat             !Category of test



      integer*4     NUMPTS           !Max allowed number of pts per variable
      parameter     (NUMPTS = 10000)

      logical*4     lexist /.false./ !File exists 
      logical*4     bexist /.false./ !Symbols file exists 
      logical*4     fopen  /.false./ !Batch  file open 
      logical*4     bopen  /.false./ !Symbols file open 
      logical*4     badbatch/.false./!Error reading batch file
      logical*4     tclip            !Time clip the data
      logical*4     trimpt           !Create a trim point
	  logical*4     ferr             !Error flag for renaming a file
      logical*4     end_flag/.false./!end of batch file flag
      logical*4     cont             !Master loop continue flag
	  logical*4		c_up			 !Comment updated from title
      logical*4     totop            !return to the top of the loop
      logical*4     firstpass        !Firstpass flag - choose data type
      logical*4     tdfup            !Update tdf file with ic's and plots
      logical*4     newfile          !New file/dir specified

      character*132 cin1             !Input first line
      character*132 filein           !Unzipped input data file original
      character*132 filein1          !Unzipped input data file modified name
      character*132 batchfile /'flt_batch.dat'/ 
      character*132 fileout          !Output file name (.acd/.pom)
      character*132 figure           !Desired figure number 
      character*80  input(17)        !Input read from batch file
      character*40  testname(1000)   !testnames
      character*132 new_title        !test title (32 chars)
      character*132 new_comment      !test comment (32 chars)

!      character*28  tim              !Current time string
!      character*20  uname            !Users login name
      character*17  clock            !Clock first time hack
      character*20  ans              !Answer
      character*40  temp             !Temporary testname
      character*40  temp1            !Temporary testname
      character*40  clip1            !Start clip value
      character*40  clip2            !End   clip value
      character*4   testtype         !Type of test to create (acd or pom)
      character*4   version /'A1.2'/ !Version of flt_read.f file
      character     cat              !Category of test

      real*4        rate             !Recording rate



! * Have access to character string commons ( fpath )
      include "flt_plot.inc"
      include "flt_read_vars.inc"

!MRS 3/27/00 No need for .temp files on PC since data storage no longer a problem
!      message='/bin/rm -f .temp_*'
!      call system(message)

      newfile = .false.
	  end_flag = .false.

!     check on symbols file

      call pathfile(filename,fpath,'flt_symbols.dat')
      inquire(FILE=filename,EXIST=bexist)
      if ( bexist) then
         open(lu80,FILE=filename,IOSTAT=ist)
         if ( ist .eq. 0 ) then
            bopen = .true.
         else
            write(*,*) 'Unable to open flt_symbols.dat'
            write(*,*) 'Symbols and Titles defaulted'
         endif
      else
         write(*,*) 'Symbol file flt_symbols.dat not found'
         write(*,*) 'Symbols and Titles defaulted'
         write(*,*) ' '
      endif

! * Read test number and name index
      call read_index(numt,testname,testnum)

      firstpass = .true.


	dtype = 3
	decomp = 1
    cont = .true.
    icmd = 0
      do while ( cont )

         if ( icmd .ne. 1 ) then
            write(*,*) '  '
            write(*,*) '     Flight Test Data Converter'
            write(*,*) '  '
            write(*,*) '     1) Batch data reduction'
            write(*,*) '     2) Single data reduction'
            write(*,*) '     3) Exit'
            write(*,*) '  '
            write(*,*) 'Enter Command:'
            read(*,20,IOSTAT=ist) icmd

            if ( icmd .lt. 1 .or. icmd .gt. 2 .or. ist .ne. 0 ) then
               cont = .false.

            else

               write(*,*) '  '
               write(*,*) '    What type of file do you wish to create?'
               write(*,*) '  '
               write(*,*) '    1) Aircraft Data  .ACD (Default)'
               write(*,*) '    2) Proof of Match .POM'
               write(*,*) '  '
               read(*,20,IOSTAT=ist) typeans
               if ( typeans .lt. 1 .or. typeans .gt. 2 & 
                   .or. ist .ne. 0) then
                  typeans = 1
               endif
               tdfup = .false.
               write(*,*) 'Do You want to update tdf file (y,N)'
               read(*,10,IOSTAT=ist) ans
               if ( ist .eq. 0 .and. ( index(ans,'y') .ge. 1 .or. & 
                        index(ans,'Y') .ge. 1 )) tdfup = .true.
               if ( typeans .eq. 1) then
                  testtype = '.acd'
               else
                  testtype = '.pom'
               endif
            endif
         endif ! icmd != 1

         totop = .false.

         if ( icmd .eq. 1 .and. .not. fopen .and. cont) then !only first time

            lexist = .false.
            call pathfile(batchfile,fpath,'flt_batch.dat')
            do while( .not. lexist .and. .not. totop)
               inquire(FILE=batchfile,EXIST=lexist)
               if ( .not. lexist ) then
                  write(*,*) ' Enter batch file name: '
                  read(*,10,IOSTAT=ist) cin1
                  if (cin1(1:1) .eq. ' ' .or. ist .ne. 0 ) then
                     totop = .true.
                     icmd  = 0
                  else
                     cin1 = cin1(lran(cin1):)
                     call pathfile(batchfile,fpath,cin1(:lrbl(cin1)))
                     inquire(FILE=batchfile,EXIST=lexist)
                     if ( .not. lexist ) then
                        write(*,*) 'File: ',batchfile(:lrbl(batchfile)), & 
                             ' does not exist.'
                        write(*,*) 'Please try again'
                     endif
                  endif
               else
                  write (*,*) 'Using batch file: ', & 
                       batchfile(:lrbl(batchfile))
                  open(lu82,FILE=batchfile,IOSTAT=ist)
                  if ( ist .ne. 0 ) then
                     write(*,*) 'Error opening batch file.'
                     icmd = 0
                     totop = .true.
                  else
                     fopen = .true.
                  endif
               endif
            enddo               !.not. lexist
		rewind(lu82)
         endif                  !if icmd = 1 & not fopen

		
! **********************************************************************
!     Get figure and output file names
! **********************************************************************

         if ( icmd .eq. 1 .and. cont .and. .not. totop ) then !execute every loop

            cin1='.'
            ftestnum = 0
            ist = 0
! *         Ignore comments
            do while (cin1(1:1).gt.' ' .and. cin1(1:1).lt.'/' .and. & 
                      ist .eq. 0 )
               read (lu82,10,IOSTAT=ist) cin1
            enddo

            do i=1,17  
               input(i) =  ' '  !Clear input fields every pass
            enddo

! *        Parse input line from batch file
            if ( ist .ne. 0 ) then
               end_flag = .true.
            else
               is = index(cin1,'|')
               i = 1
               do while ( is .gt. 0 ) 
                  if ( is .gt. 1 ) then
                     input(i) = cin1(:is-1)
!                     call isolate(input(i),ist)
                  endif
                  cin1 =cin1(is+1:)  !Delete part of line read
                  is   = index(cin1,'|')
                  i    = i + 1 !update counter
               enddo
               input(i) = cin1

! *           Check for input file or directory
               if ( input(1) .ne. ' ' ) then
                  call isolate(input(1),ist)
                  filein = input(1)(:lrbl(input(1)))
                  newfile = .true.
               endif

! *           Check to see if ID exists if not return to top
               if ( input(2) .ne. ' ' ) then
                  call isolate(input(2),ist)
                  figure = input(2)(:lrbl(input(2)))
               else
                  figure = ' '
                  totop = .true.
               endif

! *           Check to see if test name exists if not return to top
               if ( input(3) .ne. ' ' ) then
                  call isolate(input(3),ist)
                  ftestname = input(3)(:lrbl(input(3)))
                  call lower(ftestname,lrbl(ftestname))
               else
                  totop = .true.
               endif

! *           Check to see if test number exists if not return to top
               if ( input(4) .ne. ' ' ) then
                  call isolate(input(4),ist)
                  read(input(4),*,IOSTAT=ist) ftestnum
                  if ( ist .ne. 0 ) totop = .true.
               else
                  totop = .true.
               endif

! *           Check to see if category exists if not set to blank
               if ( input(5) .ne. ' ' ) then
                  call isolate(input(5),ist)
                  cat   = input(5)(1:1)
               else
                  cat = ' '
               endif

! *           Check to see if rate exists if not set to -1
               if ( input(6) .ne. ' ' ) then
                  call lower(input(6),10)
                  call isolate(input(6),ist)
                  if ( index(input(6),'all') .gt. 0 ) then
                     rate = 10000.
                  else
                     read(input(6),*,IOSTAT=ist) rate
                     if ( ist .ne. 0 ) rate = -1
                  endif
               else
                  rate = -1
               endif

! *           Check to see if title exists
               c_up = .false.
               if ( input(7) .ne. ' ' ) then
				  i = index(input(7),'?')
				  if ( i .gt. 0 ) then
                     new_title   = input(7)(:i-1)
                     new_comment = input(7)(i+1:rlan(input(7)))
					 c_up = .true.
				  else
                     new_title = input(7)(:rlan(input(7)))
                  endif
               else
                  new_title = ftestname
               endif

! *           Check to see if key words set
               tclip  = .false.
               trimpt = .false.
               if ( input(8) .ne. ' ' ) then
                  call lower(input(8),30)
                  i = index(input(8),'clip')
                  j = rlan(input(8))
                  if (  i  .gt. 0 ) then
                     clip1 = input(8)(i+5:)
                     call isolate(clip1,ist)
                     if ( ist .eq. 0 ) tclip = .true.
                     j = lrbl(clip1)
                     i = index(clip1(:j),input(8)(i+5:)) + j + i + 5
                     clip2 = input(8)(i:)
                     call isolate(clip2,ist)
                     if ( ist .ne. 0 ) tclip = .false.
                     if ( tclip .and. .not. c_up ) then
                        new_comment = figure(:lrbl(figure))//' ' & 
                          //clip1(:lrbl(clip1))//' '// & 
                            clip2(:lrbl(clip2))//' sec'
                     elseif( .not. c_up ) then
                        new_comment = figure(:lrbl(figure))
                     endif
                  elseif ( .not. c_up ) then
                     new_comment = figure(:lrbl(figure))
                  endif

                  i = index(input(8),'trimpt')
                  if ( i .gt. 0 ) then
                     read(input(8)(i+6:),*,IOSTAT=ist) itrimpt
                     if ( ist .eq. 0 ) trimpt = .true.
                  endif

               elseif ( .not. c_up ) then
                  new_comment = figure(:lrbl(figure))
               endif


            endif

            if (newfile .or. end_flag ) then !time for new file or exit

! If previous file was unzipped, return to original state.
!     
               newfile = .false.
                 !reset flag

               if (end_flag) goto 9999

               if ( input(2) .eq. ' ' ) totop = .true. 


            endif


! * Input by hand
         elseif (icmd .eq. 2 .and. cont) then
            lexist = .false.
            do while (.not. lexist .and. .not. totop ) 
               write(*,*) 'Enter flight test data file name including extension:<CR> to exit'
               read(*,10,IOSTAT=ist)  filein1

               if (filein1(1:1) .eq. ' ' .or. ist .ne. 0 ) then
                  totop = .true.
                  icmd = 0
               else
                  call lower(filein1,132)
                  call pathfile(filein,fpath,filein1)
                  inquire(FILE=filein,EXIST=lexist)

                  if (lexist) then
                     open(lu20,FILE=filein,IOSTAT=ist)
                     if ( ist .ne. 0 ) then
                        write(*,*)'Unable to open file:'// & 
                             filein(:lrbl(filein))
                        write(*,*) 'Please try again.'
                     endif
                  else
                     write(*,*) 'FILE: ',filein(:lrbl(filein)), & 
                          ' does not exist.'
                     write(*,*) 'Please try again.'
                  endif
               endif
            enddo           !.not. lexist

            if ( .not. totop ) then

               write(*,*) 'Enter data directory (XXX) where the data file above resides'
               write(*,*) '(must be a subdirectory of DATA dir /.../.../data/XXX/...)'
               read(*,10,IOSTAT=ist) filein
               if ( ist .eq. 0 ) then
                  newfile = .true.
               else
                  totop = .true.
               endif

               if ( .not. totop ) then
                  write(*,*) 'Enter test file name (same as above but without extension)'
                  read(*,10,IOSTAT=ist) figure
                  if ( ist .ne. 0 ) then
                     totop = .true.
                     write(*,*) 'Error reading input figure/test ID'
                  endif
               endif

               if ( .not. totop ) then
                  write(*,*) 'Enter name or number for the output files (without extensions):'
                  read(*,10,IOSTAT=ist) ftestname
                  if ( ist .ne. 0 ) then
                     totop = .true.
                     write(*,*) 'Error reading input test name'
                  endif
               endif


               if ( .not. totop ) then
                  write(*,*) 'test category per flt_symbols.dat (test type):'
                  read(*,10,IOSTAT=ist) cat
                  if ( ist .ne. 0 ) then
                     totop = .true.
                     write(*,*) 'Error reading input category'
                  endif
               endif

               if ( .not. totop ) then
                  write(*,*) 'Enter title for test (used only as comment in TDF file):'
                  read(*,10,IOSTAT=ist) new_title
                  if ( ist .ne. 0 ) then
                     new_title = ftestname
                  endif
               endif

               if ( .not. totop ) then
                  write(*,*)'Enter rate to store data at (all,'// & 
                            '<rtn>=default)'
                  read(*,10,IOSTAT=ist) temp
                  if ( index(temp,'all') .gt. 0 ) then
                     rate = 10000.
                  else
                     read(temp,*,IOSTAT=ist) rate
                     if ( ist .ne. 0 .or. rate .eq. 0 ) rate = -1
                  endif
               endif

               if ( .not. totop ) then
                  tclip = .false.
                  write(*,*)'Do you want to clip the data? (N/y)'
                  read(*,10,IOSTAT=ist) ans
                  if ( index(ans,'y') .gt. 0 .and. ist .eq. 0 ) then
                     write(*,*) 'Input start time'
                     read(*,10,IOSTAT=i) clip1
                     read(*,10,IOSTAT=ist) clip2
                     if ( i .eq. 0 .and. ist .eq. 0 ) then
                        tclip = .true.
                        new_comment = figure(:lrbl(figure))//' '// & 
                             clip1(:lrbl(clip1))//' '// & 
                             clip2(:lrbl(clip2))//' secs' 
                     endif
                  endif
                  if ( .not. tclip ) new_comment = figure(:lrbl(figure))
               endif   

               if ( .not. totop ) then
                  trimpt = .false.
                  write(*,*)'Is data a trim point? (N/y)'
                  read(*,10,IOSTAT=ist) ans
                  if ( index(ans,'y') .gt. 0 .and. ist .eq. 0 ) then
                     write(*,*) 'Input index of point to extract'
                     read(*,*,IOSTAT=ist) itrimpt
                     if ( ist .eq. 0 .and. itrimpt .gt. 0 ) then
                        trimpt  = .true.
                     else
                        itrimpt = 1
                     endif
                  endif
               endif

            endif

         endif                  !if icmd .eq. 1 and cont


! Next data set delimiter to the screen.
         write(*,*) ' '
         write(*,*) '/\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ '
         write(*,*) '\/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ '
         write(*,*) ' '


!     create output file name and delete previous versions and open
!     
         if ( cont .and. .not. totop ) then
            lt = lrbl(ftestname)
            call pathfile(fileout,fpath,ftestname(:lt)//testtype)

! *       See if output file exists and backup if it does
            inquire(FILE=fileout,EXIST=fexist,IOSTAT=ist)
            if ( fexist ) then  !Output file currently exists
			   i = lrbl(fileout)
			   call rename_file(fileout(:i),fileout(:i)//'.old',ferr)
            endif


! *       See if test exists in test_index.dat file               
            call findname(ftestname,num,itype,testname,testnum,numt)
            if ( icmd .eq. 1 ) then !batch mode testname and number specified
               if ( itype .gt. 2 ) then !testname not found in index
                  numt = numt + 1      !Update index
                  testname(numt) = ftestname
                  testnum(numt)  = ftestnum
                  call write_index(numt,testname,testnum)
               else  !test name & number specified verify matches batch file
                  if ( ftestnum .ne. num ) then
                     write(*,*)'Test number specified in batch file'// & 
                          'does not match that in test_index.dat'
                     write(*,*)'Updating test_index.dat to reflect this'
                     do i=1,numt
                        if ( ftestname .eq. testname(i) ) then
                           testnum(i) = ftestnum
                        endif
                     enddo
                     call write_index(numt,testname,testnum)
                     write(*,*) 'Test_index.dat file updated.'
                  endif
               endif

            elseif ( icmd .eq. 2 ) then !interactive mode
               if ( itype .gt. 2 ) then  !test name not found in test_index.dat
                  ftestnum = 0
                  do while ( .not. totop .and. ftestnum .eq. 0 )
                     write(*,*) 'Test : ',ftestname,' does not exist.'
                     if ( itype .eq. 89 ) then !input was a name
                        write(*,*) 'Please enter new test number:'
                        read(*,*,IOSTAT=ist) temp

                        if ( ist .ne. 0 .or. temp .eq. ' ') then
                           totop = .true.
                        else
                           temp1=temp

                           call findname(temp1,i,itype,testname, & 
                                testnum,numt)
                           if ( itype .lt. 2 ) then !test found
                              write(*,*) 'Test number ',temp, & 
                                    ' already exists.'
                              ftestnum = 0
                           else
                              call ctoi(temp,ftestnum)
                              numt = numt + 1
                              testname(numt) = ftestname
                              testnum(numt)  = ftestnum
                              call write_index(numt,testname,testnum)
                              write(*,*) 'Test_index.dat file updated.'

                           endif
                        endif
                     else  !input was a number = num
                        ftestnum = num
                        write(*,*) 'Please enter new test name:'
                        read(*,*,IOSTAT=ist) temp
                        if ( temp(1:1) .eq. ' ' .or. ist .ne. 0 ) then
                           totop = .true.
                        else
                           call findname(temp,i,itype,testname, & 
                                testnum,numt)
                           ftestname = temp
                           if ( itype .lt. 2 ) then !name already exists
                              if ( i .ne. num ) then
                                 write(*,*)'Input test number does'// & 
                                      ' not match existing number.'
                                 write(*,*)'Will update test_index.dat'
                                 do i=1,numt
                                    if (ftestname .eq. testname(i)) then
                                       testnum(i) = ftestnum
                                    endif
                                 enddo
                                 call write_index(numt,testname,testnum)
                                 write(*,*) 'Test_index.dat file updated.'
                              endif
                           else
                              numt = numt + 1 
                              testname(numt) = ftestname
                              testnum(numt)  = ftestnum
                              call write_index(numt,testname,testnum)
                              write(*,*) 'Test_index.dat file updated.'
                           endif
                        endif
                     endif
                  enddo
               endif
            endif

         endif                  !if cont and not totop exit to reassess totop and cont

         if ( cont .and. .not. totop ) then !continue with reduction

! * Open final output file - written to in write_conv_data
			call del_file(fileout)
            open(lu3,FILE=fileout,IOSTAT=ist)

            if ( ist .ne. 0 ) then
               write(*,*)'Unable to open file '//fileout(:lrbl(fileout))
               totop = .true.
            else

! *         Deal with data file compression/decompression
               if ( decomp .eq. 2 ) then
                  filein1 = filein
               else  
          !        if ( zip_flag .eq. 0 ) then
          !           if ( index(filein,'.zip') .gt. 0 ) then
          !              zip_flag = 1
          !              write(*,*) 'Unzipping file'
          !              call system('unzip '//filein)
          !              filein1 = filein(:index(filein,'.zip')-1)
          !           elseif ( index(filein,'.z') .gt. 0 ) then
          !              zip_flag = 2
          !              write(*,*) 'Uncompressing file'
          !              call system('uncompress '//filein)
          !              filein1 = filein(:index(filein,'.z')-1)
          !           elseif ( index(filein,'.gz') .gt. 0 ) then
          !              inquire(FILE=filein,EXIST=lexist)
          !              if ( .not. lexist ) then
          !                 filein1 = filein
          !                 call pathfile(filein,fpath,filein1)
          !                 inquire(FILE=filein,EXIST=lexist)
          !              endif
          !              if ( lexist ) then
          !                 zip_flag = 3
          !                 write(*,*) 'Gunzipping file'//filein
          !                 call system('gunzip '//filein)
          !              else
           !                write(*,*) 'Unable to find file'//filein
           !             endif
           !             filein1 = filein(:index(filein,'.gz')-1)
           !          else
                        filein1 = filein
            !         endif
            !      endif
               endif
               i=lrbl(filein1)

! * Call routines to actually read the data from the input files               

               if ( dtype .eq. 1 ) then !Boeing file format 

!                  call flt_reduc_boeing(filein1,figure,cat,rate,trimpt, & 
!                     itrimpt,clip1,clip2,tclip,decomp,bopen,firstpass, & 
!                     retstat)

               elseif ( dtype .eq. 2 ) then !DPD file format

                  !call flt_reduc_dpd(filein1,figure,cat,rate,trimpt, & 
                   !    itrimpt,clip1,clip2,tclip,input,bopen, & 
                    !   firstpass,retstat)

                  if ( retstat .eq. 4 ) then  !don't process any more data
                     cont = .false.
                     totop = .true.
                  endif
               elseif ( dtype .eq. 3 ) then
			     call flt_reduc_jpats(filein1,figure,cat,rate,trimpt, & 
                      itrimpt,clip1,clip2,tclip,input,bopen,firstpass,retstat)
!     call flt_reduc_generic()
               endif

! * Write Finishing touches to files and piece then together 
               if ( retstat .eq. 0 ) then
                  write(lu3,10) 'End Data'
                  write(lu40,10) 'End IC'
                  write(lu40,10) '#'

!                  close(lu40)   !.bred_head
!                  close(lu3)    !.acd/.pom file
                  close(lu20)   !.temp_data

				  rewind(lu3)

				  ist = 0
				  do while ( ist .eq. 0 ) 
				     read(lu3,10,IOSTAT=ist) cin1
					 if ( ist .eq. 0 ) write(lu40,10) cin1(:rlan(cin1))
				  enddo

				  close(lu3)
				  close(lu40)
!                  message='cat '//fileout(:lrbl(fileout))//'>>' & 
!                       //filename(:lrbl(filename)) !Note filename = .bred_head
!                  call system(message)
!                  message='mv '//filename(:lrbl(filename))//' '// & 
!                       fileout(:lrbl(fileout))
!                  call system(message)
                   call pathfile(filename,fpath,'.bred_head')
                   call rename_file(filename,fileout,ferr)
	

! * Clean up ( get rid of duplicate ic's in the acd file)


                  call cleanics(fileout,err)

! *       See if test definition file exists and backup if it does
                  call pathfile(filename,fpath,ftestname(:lt)//'.tdf')
                  inquire(FILE=filename,EXIST=fexist,IOSTAT=ist)

!MRS 3/27/00  THis section commented out since the .old file is created for each function below
!                  if ( fexist ) then !Test definition file currently exists
!                     message = 'cp '//filename(:lrbl(filename))//' '// & 
!                          filename(:lrbl(filename))//'.old'
!                     call system(message)
!                  endif

! * Open tdf file for upgrades
                  if ( .not. fexist ) then
                     open(UNIT=lu43,FILE=filename,IOSTAT=ist)
                     if ( ist .ne. 0 ) then
                        write(*,*)'Unable to open: '// & 
                             filename(:lrbl(filename))
                     else
                        !call getlog(uname)

                        !call fsi_idate(td)
                        !call fsi_itime(tt)

						call get_date

!                        write(tim,60) td(2),td(1),td(3),tt(1),tt(2),tt(3)
                        write(lu43,10) '#'

                        write(lu43,10) '# '//ftestname(:lrbl(ftestname))
                        write(lu43,10) '# This file written from'// & 
                             ' flt_reduction'
                        write(lu43,10) '# By: '//username(:lrbl(username))// & 
                             ' On: '//chdate//' At: '//chtime
                        write(lu43,10) '#'
                        write(lu43,10) 'Title   = '// & 
                             new_title(:rlan(new_title))
                        write(lu43,10) 'Comment = '// & 
                             new_comment(:rlan(new_comment))
                        write(lu43,10) '#'
                        write(lu43,10) 'Start IC'
                        write(lu43,10) 'End IC'
                        write(lu43,10) '#'
!                        write(lu43,10) 'Start Task 3'
!                        write(lu43,10) '   flylevel = true'
!                        write(lu43,10) 'End task 3'
                        write(lu43,10) '#'
                        write(lu43,10) 'Start Task 5'
                        write(lu43,10) '   define ftsttime > 0.'
!                        write(lu43,10) '      fsetpla = true'
                        write(lu43,10) 'End task 5'
                        write(lu43,10) '#'
                        write(lu43,10) 'Start Plot'
                        write(lu43,10) 'End Plot'
                        close(lu43)
                     endif
                  endif
                  fattest = ftestnum
                  include "flt_read.inc"
                  if ( nic .lt. 1 .or. tdfup ) then !update ic's
                     call flt_updateic_file(testtype,nic,icval,icvar,2)
                     do i=1,nic
                        icout(i) = 1 !Input/output flag
                     enddo
                     call pathfile(filename,fpath, & 
                          ftestname(:lt)//'.tdf')
                     call flt_write_ics(filename,icvar,icval, & 
                          icout,nic,.true.,err)

                  endif

                  if ( nplot .lt. 1 .or. tdfup ) then !Update plots
!                     call flt_update_plots(testtype)
                     call flt_update_plots_jpats(testtype,filein1,figure)
                  endif

                  write(*,*) 'Aircraft data file: ',fileout(:lrbl(fileout)), & 
                       ' completed'
                  write(*,*) ' '
               else
                  write(*,*)' There was an error trying to '// & 
                       'reduce this data'
               endif
            endif
         endif
      enddo                     ! Master while loop


 9999 continue



      if (fopen) then           !batch file open
         fopen=.false.
         close(lu82)
      endif
      if (bopen) then !flt_symbols.dat file open so close
         bopen=.false.
         close(lu80)
      endif



      if (badbatch) then
         write(*,*) 'Error reading batch file.'
         write(*,*) 'PLease see header of flt_batch.dat file for'
         write(*,*) 'explaination of proper file format.'
      endif

      return

 10   format(A)
 20   format(I1)
 30   format(6(G11.5,1x))
 40   format(4x,a,' ',f13.4)
! 60   format(i2,'/',i2,'/',i4,' ',i2,':',i2,':',i2)

      end
