

!  This file contains numerous routines used in the data reduction software
!  and in other parts of the FLT utility.



!    Searches through the flt_symbols.dat file and attempts to find
!    the flight test mnemonic (insym) and replaces it with the FSI
!    mnemonic (outsym). 


      subroutine findsym(insym,outsym,cat,isuse,ic)
      implicit none

! * Argument List      
      character     cat             !Category for this test
      character*40  insym           !Input Symbol to look for
      character*40  outsym          !FSI symbol for this variable

      logical*4     isuse           !Use this variable 
      logical*4     ic              !Is variable an IC variable

! * Locals

      character*40  fsivar(400)     !FSI variable names
      character*40  manvar(400)     !Manufacturer names
      character*20  categ(400)      !Category field for variable
      character*20  temp            !IC order number character string
      character*132 line            !Input line 

      integer*4     icord(400)      !Ic order number
      integer*4     i,j             !Counters
      integer*4     lu80  /80/      !Unit for flt_symbols.dat open in bred
      integer*4     ist             !IOSTAT error flag         
      integer*4     ist2            !IOSTAT error flag         
      integer*4     nvar            !Number of variables read from .dat file

      logical*4     first /.true./ 
      logical*4     isic(400)       !Specified IC number
      logical*4     fnd             !Variable found in flt_symbols

! * External Functions
      integer*4     lrbl            !Finds first blank from left


! * Initialize output to input
      outsym   = insym(:lrbl(insym))

      if ( first ) then
         rewind(lu80)           !flt_symbols.dat
         first = .false.
         ist   = 0
         nvar  = 0 
         do while ( ist .eq. 0 .and. nvar .lt. 400 )
            read(lu80,10,IOSTAT=ist) line
            if ( ist .eq. 0 .and. line(1:1) .gt. '0' ) then
               i = index(line,'|')
               if ( i .gt. 0 ) then !Found a |
                  call lower(line,132)
                  nvar = nvar + 1
                  manvar(nvar) = line(:i-1)
                  call isolate(manvar(nvar),ist)
                  j = index(line(i+1:),'|') + i
                  if ( j .le. i .or. ist .ne. 0 ) then ! Nothing found
                     ist = 0  !read next line
                     write(*,*)'Error reading flt_symbols.dat at line'
                     write(*,*) line
                     nvar = nvar - 1
                  else
                     fsivar(nvar) = line(i+1:j-1)
                     call isolate(fsivar(nvar),ist)
                     i = index(line(j+1:),'|') + j
                     if ( i .le. j .or. ist .ne. 0 ) then ! Nothing found
                        ist = 0  !read next line
                        write(*,*)'Error reading flt_symbols.dat'
                        write(*,*)'Unable to FSI variable name at line:'
                        write(*,*) line
                        nvar = nvar - 1
                     else
                        categ(nvar) = line(j+1:i-1)
                        j = index(line(i+1:),'|') + i
                        if ( j .le. i .or. ist .ne. 0 ) then ! Nothing found
                           ist = 0 !read next line
                           write(*,*)'Error reading flt_symbols.dat'
                           write(*,*)'Unable to read category at line:'
                           write(*,*) line
                           nvar = nvar - 1
                        else !get ic order number
                           temp = line(i+1:j-1)
                           call isolate(temp,ist2)
                           read(temp,*,IOSTAT=ist2) i
                           if ( ist2 .eq. 0 ) then
                              isic(nvar)  = .true.
                              icord(nvar) = i
                           else
                              isic(nvar) = .false.
                           endif
                        endif  !number
                     endif !categeory
                  endif !FSI var
               endif !man var
            endif !if comment
         enddo
      endif ! if first

! * Search for insym in database of variables
      isuse = .false.
      ic  = .false.

      fnd = .false.
      j   = 1
      i = lrbl(insym)
      do while ( .not. fnd .and. j .le. nvar )
!         write(*,*) insym(:i),manvar(j)(:lrbl(manvar(j)))
         if ( insym(:i) .eq. manvar(j)(:lrbl(manvar(j))) ) then
            fnd = .true.
!            write(*,*) 'FND = .true.'
         endif
         j = j + 1
      enddo

      if ( fnd ) then  !variable found
         j = j - 1
!      write(*,*) cat,categ(j)
         i = index(categ(j),cat) !is the variable used for this cat of test

         if ( i .gt. 0 ) isuse = .true.
         if ( isic(j) ) then    !contains ic number
            isuse=.true.
            ic=.true.
         endif

         if ( j .le. nvar ) outsym   = fsivar(j)(:lrbl(fsivar(j)))
      endif


      return

 10   format(a)
      end


      subroutine isolate(line, ierr)
      implicit none

! * Argument List      
      character*(*) line   !input line
      integer*4     ierr   !Error flag

! * Locals
      integer*4     i      !counter

! * Enternal Functions
      integer*4     lrbl   !Returns first blank from left
      integer*4     lran   !Returns first character form left

      line = line(lran(line):)
      i    = lrbl(line)
      if ( i .gt. 0 ) then
         line = line(:i)
      else
         line = ' '
         ierr = 1
      endif

      return
      end


      subroutine write_conv_data(tdata,rdata,tmdata,iparm,tclip,tclip1, & 
           tclip2,trimpt,itrimpt,rate,dmax,used,fsisymbol,icl,numpts)

      implicit none

! * Argument list
      character*40  fsisymbol(200)   !FSI variable names

      integer*4     dmax             !Number of valid points
      integer*4     numpts           !Dimension of arrays
      integer*4     iparm            !Index of current parameter
      integer*4     itrimpt          !Index of data point to be used as trim

      real*4        tdata(numpts)    !Time data
      real*4        rdata(numpts)    !Y Data
      real*4        tmdata(numpts)   !Time data shifted temp array
      real*4        tclip1           !Start of time clip
      real*4        tclip2           !End of time clip
      real*4        rate             !rate in Hz to output data

      logical*4     tclip            !Clip data flag
      logical*4     used             !Is data used flag
      logical*4     trimpt           !Is data atrim point
      logical*4     icl(200)         !Is parameter an IC variable only


! * Locals
      character*132 filename         !temp file name

      logical*4     lexist           !File exists flag

      integer*4     i,j,k            !Counters
      integer*4     istrt            !Start counter for clipping
      integer*4     iend             !End counter for clipping
      integer*4     np               !Number of data points to skip in output
      integer*4     ist              !IOSTAT error flag
      integer*4     lu3    /3/       !Output file unit opened in reduction
      integer*4     lu40   /40/      !.acd header file unit

      real*4        dt               !Delta time of data
      real*4        xshift           !Data shift increment default
      real*4        yshift           !Data shift increment default
      real*4        xgan             !Data gain default
      real*4        ygan             !Data gain default

! *   External functions

      integer*4      lrbl 
      integer*4      lran
      integer*4      rlan

! * Get things like fpath
      include "flt_plot.inc"


!     Update the current date
      call get_date()



!              write the data to the output file


      if ( tclip ) then
         if ( iparm .eq. 1 ) then
            i = 1
            do while (tdata(i) .lt. tclip1  & 
                 .and. i.lt.dmax)
               i = i + 1
            enddo

            if ( i .ge. dmax ) then 
               tclip =.false.   !error don't clip
               write(*,*)  & 
                 'ERROR - finding clip time start. Will not clip data.'
            else
               istrt = i
               i = i + 1
               do while (tdata(i).lt.tclip2 & 
                    .and. i.lt.dmax)
                  i = i + 1 
               enddo
               iend = i
               write(*,*) 'Data will be clipped'
               write(*,*) 'Start time = ',tclip1, & 
                    'Point No. = ',istrt
               write(*,*) 'End time   = ',tclip2, & 
                    'Point No. = ',iend,' of ',dmax

               dmax = iend - istrt + 1
            endif

         else
            dmax = iend - istrt + 1
         endif
      elseif( iparm .eq. 1 ) then
         istrt = 1
         iend = dmax
      endif

      if ( trimpt ) then
!         dmax = 2
      elseif ( iparm .eq. 1) then
         if ( tdata(istrt+3) .ne. tdata(istrt+2) ) then
            dt = 1.0 / (tdata(istrt+3) - tdata(istrt+2))
         else
            dt = 1.
         endif
         if ( rate .ge. dt ) then
            np = 1
         elseif ( rate .le. 0 ) then !default to 1000 pts
            j = int(float(dmax) / 1000.)
            if ( mod(dmax,1000) .ne. 0 ) then
               np = j + 1
            else
               np = j
            endif
         elseif ( rate .ne. 0 ) then
            np = int( 0.5 + dt/rate)
         else
            np = 1
         endif
      endif
!      write(*,*) 'rate = ',rate,' dt = ',dt,' np = ',np


      if ( iparm .eq. 1 ) then  
         call pathfile(filename,fpath,'.bred_head')
         inquire(FILE=filename,EXIST=lexist)
         if (lexist) then
			call del_file(filename(:lrbl(filename)))
         endif
         open(lu40,FILE=filename,IOSTAT=ist)
         write(lu40,10) '# '//ftestname(:lrbl(ftestname))
         write(lu40,10) '# This file created by'// & 
              ' flt_reduction'
         write(lu40,10) '# By: '//username(:lrbl(username))// & 
                 ' On: '//chdate//' '//chtime
         write(lu40,10) '#'
         write(lu40,10) 'Start IC'

         if ( trimpt ) then
            xshift = 0.0        !since time data will be created
         else
            xshift = -tdata(istrt)
         endif
         yshift = 0.0
         xgan  = 1.0
         ygan  = 1.0
      else
         if ( icl(iparm) ) then !write ic data to acd file
            if ( trimpt ) then
               write(lu40,40) & 
                 fsisymbol(iparm)(:lrbl(fsisymbol(iparm))), & 
                 rdata(itrimpt)
            else
               write(lu40,40) & 
                 fsisymbol(iparm)(:lrbl(fsisymbol(iparm))), & 
                 rdata(istrt)
            endif
         endif
      endif

      if ( trimpt ) then
         if ( iparm .eq. 1 ) then
            if ( itrimpt .gt. dmax ) itrimpt = dmax  !limit to data read in
            rdata(1) = tdata(itrimpt)
            rdata(2) = rdata(1)
            tdata(1) = 0.0
            tdata(2) = 10.0
            fsisymbol(2) = fsisymbol(1)
            fsisymbol(1) = 'ftsttime'
            iparm        = 2
            write(lu3,*) 'Start Data'
            write(lu3,*) fsisymbol(1)(:lrbl(fsisymbol(1))),2
            write(lu3,30,IOSTAT=ist) (tdata(i),i=1,2)
            write(lu3,*) fsisymbol(2)(:lrbl(fsisymbol(2)))
            write(lu3,30,IOSTAT=ist) (rdata(i),i=1,2)
            write(lu40,40) 'fmaxtime',tdata(2)  !Add fmaxtime

         else

            rdata(1) = rdata(itrimpt)
            rdata(2) = rdata(1)
            write(lu3,*) fsisymbol(iparm)(:lrbl(fsisymbol(iparm)))
            write(lu3,30,IOSTAT=ist) (rdata(i),i=1,2)
         endif
      else

         if (iparm .eq. 1) then
            j = np              !get the first point
            k = 0
            do i=istrt,iend
               if ( j .ge. np ) then
                  k = k + 1
                  tmdata(k) = tdata(i) + xshift
                  j = 0
               endif
               j = j + 1
            enddo
            write(lu3,*) 'Start Data'
            write(lu3,*) fsisymbol(1)(:lrbl(fsisymbol(1))),k
            write(lu3,30,IOSTAT=ist) (tmdata(i),i=1,k)
            write(lu40,40) 'fmaxtime',tmdata(k)
         else 
            j = np              !get the first point
            k = 0
            do i=istrt,iend
               if ( j .ge. np ) then
                  k = k + 1
                  tmdata(k) = rdata(i)
                  j = 0
               endif
               j = j + 1
            enddo
            write(lu3,*) fsisymbol(iparm)(:lrbl(fsisymbol(iparm)))
            write(lu3,30,IOSTAT=ist) (tmdata(i),i=1,k)
         endif                  ! i != 1
      endif


      return
 10   format(A)
 20   format(I1)
 30   format(6(G11.5,1x))
 40   format(4x,a,' ',f13.4)
 60   format(i2,'/',i2,'/',i4,' ',i2,':',i2,':',i2)
      end



      subroutine cleanics(file,err)
      implicit none

! * Argument list

      character*132 file             !ACD file name

      logical*4     err              !Return error flag


! * Locals  

      character*64  vararr(200)       !Variables to search for
      character*80  cicval(200)       !Character string of ic values

      integer*4     i,j,k
      integer*4     num              !Number of variables to search for
      integer*4     icout(100)        !Icout flag not important here
      integer*4     l1,l2            !Length of names

	logical*4		cont			!Continue flag
      logical*4     mantest          !Manual test flag
      logical*4     getall           !Return all data in file


      real*4        icdata(200)       !Value of data found
      real*4        time       /-1.0/ !Flag for write_ics_all

!     External functions
      integer*4      lrbl 

! * Read IC information
      err = .false.

      call flt_read_ic_all(file,num,vararr,icdata,err)
      if ( err ) then
         write(*,*) 'Error reading IC information in cleanics'
         return
      endif

! * Remove duplicates -
	i = 1
	do while ( i .lt. num )
		j = i + 1
		cont = .true.
		do while ( j .le. num .and. cont ) 
			l1 = lrbl(vararr(i))
			l2 = lrbl(vararr(j))
			if ( vararr(i)(:l1) .eq.  vararr(j)(:l2) .and. & 
				l1 .eq. l2 ) then
				do k=j,num-1 !k=j to keep first or k=i to keep second
					vararr(k) = vararr(k+1)
					icdata(k) = icdata(k+1)
				enddo
				num = num -1
				cont = .false.
			endif
			j = j + 1
		enddo
		if ( cont ) i = i + 1
	enddo

      call write_ics_all(file,vararr,icdata,num,time,err)

      if ( err ) then
         write(*,*) 'Error trying to re-write ics. '
      endif

      return
      end


      subroutine flt_read_ic(ffile,num,vararr,icdata,mantest,err)

      implicit none

      character*132   ffile      !Data file
      character*64    vararr(100) !Variables to search for

      integer*4       num        !Number of variables to search for

      logical*4       mantest    !Manual test flag
      logical*4       err        !Err reading data flag

      real*4          icdata(100) !Value of data found

      include "flt_plot.inc"
!     Locals      

      logical*4       exist      !logical flag
      logical*4       start      !Look for start of ic data

      integer*4       i,j        !Counters
      integer*4       ist        !Status flag
      integer*4       lu40 /40/  !Logical Unit for data file
      integer*4       nl         !Number of lines read
      integer*4       nfnd       !Number of variables found

      character*132 message      !Output error message string
      character*132 line         !Output error message string
      character*64  vari         !temp variable name

      real*4        val          !temp value

!>    external functions
      integer*4     lrbl         !returns loc of 1st blank from left in string
      integer*4     rlan         !returns loc of last character in string

      err = .false.

!>    Attempt to open file



      inquire(FILE=ffile,EXIST=exist)
      if ( .not. exist ) then
         message='Data file does not exist '//ffile(:lrbl(ffile))
         call ftn_logmsg_err("flt_read_ic",message(:rlan(message)))
         err = .true.
         return
      endif

      open(lu40,FILE=ffile,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         message= 'UNABLE TO OPEN '//ffile(:lrbl(ffile))
         call ftn_logmsg_err("flt_read_ic",message(:rlan(message)))
         err = .true.
         return
      endif

!     Reset the data array - value of -999999. will not show on page
      do i=1,num
         icdata(i) = -999999.0
      enddo

      nl   = 0
      nfnd = 0
      start = .true.

      do while ( ist .eq. 0 )
         read(lu40,'(a)',IOSTAT=ist) line
         nl = nl + 1

         if ( line(1:1) .eq. '#' ) then
            if ( index(line,'DATE:') .gt. 0 ) then
               i = index(line,'DATE:')               
               read(line(i+6:),'(a)') chdate
            elseif ( index(line,'TIME:') .gt. 0 ) then
               i = index(line,'TIME:')
               read(line(i+6:),'(a)') chtime
            elseif( index(line,'Manual') .gt. 0 ) then
               mantest = .true.
            endif
         else
            call lower(line,132)

!>          Read until "start data" is found
            if ( start ) then
               i = index(line,'start')
               j = index(line,'ic')
               if ( i .gt. 0 .and. j .gt. i ) then
                  start = .false.
               endif
               if( index(line,'manual') .gt. 0 ) then
                  mantest = .true.
               endif

            else  !data is found
               i = index(line,'end ')
               j = index(line,'ic')

               if ( i .gt. 0 .and. j .gt. i ) then !if end of ic section return
                  close(lu40)
                  return
               endif

               read(line,*,IOSTAT=ist) vari,val
               if ( ist .eq. 0 ) then
                  do i=1,num
                     if ( vari(:lrbl(vari)) .eq. & 
                          vararr(i)(:lrbl(vararr(i))) ) then
                        icdata(i) = val
                        nfnd = nfnd + 1 !increment number of found variables
                     endif
                  enddo
               endif

               if ( nfnd .eq. num ) then ! Return if all vairables found
                  close(lu40)
                  return
               endif

            endif ! If start
         endif ! if  comment
      enddo  ! while ist = 0

      close(lu40)
      return

      end



      subroutine flt_read_ic_all(ffile,num,vararr,icdata,err)

      implicit none

      character*132   ffile      !Data file
      character*64    vararr(200) !Variables to search for

      integer*4       num        !Number of variables to search for

      logical*4       err        !Err reading data flag

      real*4          icdata(200) !Value of data found

      include "flt_plot.inc"
!     Locals      

      logical*4       exist      !logical flag
      logical*4       start      !Look for start of ic data

      integer*4       i,j        !Counters
      integer*4       ist        !Status flag
      integer*4       lu40 /40/  !Logical Unit for data file
      integer*4       nl         !Number of lines read
      integer*4       nfnd       !Number of variables found

      character*132 message      !Output error message string
      character*132 line         !Output error message string
      character*64  vari         !temp variable name

      real*4        val          !temp value

!>    external functions
      integer*4     lrbl         !returns loc of 1st blank from left in string
      integer*4     rlan         !returns loc of last character in string

      err = .false.

!>    Attempt to open file


      inquire(FILE=ffile,EXIST=exist)
      if ( .not. exist ) then
         message='Data file does not exist '//ffile(:lrbl(ffile))
         call ftn_logmsg_err("flt_read_ic",message(:rlan(message)))
         err = .true.
         return
      endif

      open(lu40,FILE=ffile,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         message= 'UNABLE TO OPEN '//ffile(:lrbl(ffile))
         call ftn_logmsg_err("flt_read_ic",message(:rlan(message)))
         err = .true.
         return
      endif

!     Reset the data array - value of -999999. will not show on page
      do i=1,200
         icdata(i) = -999999.0
      enddo

      nl   = 0
      nfnd = 0
      start = .true.
      num = 0

      do while ( ist .eq. 0 )
         read(lu40,'(a)',IOSTAT=ist) line
         nl = nl + 1

         if ( line(1:1) .ne. '#' ) then
            call lower(line,132)

!>          Read until "start data" is found
            if ( start ) then
               i = index(line,'start')
               j = index(line,'ic')
               if ( i .gt. 0 .and. j .gt. i ) then
                  start = .false.
               endif

            else  !data is found
               i = index(line,'end ')
               j = index(line,'ic')

               if ( i .gt. 0 .and. j .gt. i ) then !if end of ic section return
                  close(lu40)
                  return
               endif

               read(line,*,IOSTAT=ist) vari,val
               if ( ist .eq. 0 ) then
                  num = num + 1
                  vararr(num) = vari
                  icdata(num) = val
               endif

            endif ! If start
         endif ! if  comment
      enddo  ! while ist = 0

      close(lu40)
      return

      end
