! **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Simulator         :  Raytheon                                *
!      Department        :  61 - flight                             *
!      Module name       :  flt_reduc_raytheon                      *
!      Module description:  This module reads Raytheon data         *
!      Originator        :  M. Saladin                              *
!      Date              :   2/19/99                                *
!                                                                   *
!                                                                   *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems Division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of FlightSafety International Simulation        *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!            FlightSafety International                             *
!            Simulation Systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012, U.S.A.                  *
!            (918) 259-4000    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **

      subroutine flt_reduc_jpats(filein,figure,cat,rate,trimpt, & 
           itrimpt,clip1,clip2,tclip,input,bopen,firstpass,retstat)
      implicit none

!--> REVISION BEGIN

!                            Revision History

! $Id: flt_reduc_premier.f,v 1.6 2000/03/27 17:01:23 leongw Exp $
! $Log: flt_reduc_premier.f,v $
! Revision 1.6  2000/03/27 17:01:23  leongw
! Update Simulator and Job descriptions.

! Revision 1.5  2000/03/24 21:45:55  leongw
! Added capability to read in ic file.
! Incorporate shipment 2 gear position sign convention.
! Zip up a/c data file after reducing it.

! Revision 1.4  1999/11/23 17:37:08  leongw
! changed data type to .txt.
! increased junk read to a2660 characters.

! Revision 1.3  1999/10/20 20:40:59  leongw
! cleaned up code.

! Revision 1.2  1999/09/24 18:25:17  leongw
! updated code to read Premier I FTD and output to FSI standard formet.

! Revision 1.1  1999/09/23 18:21:33  leongw
! Initial revision


!--> REVISION END

      CHARACTER*80  RCSID & 
      /"$Id: flt_reduc_jpats.f90,v 1.6 2000/03/27 17:01:23 leongw Exp $"/

! * Argument list
      character*132 filein           !Input data file or directory
      character*132 figure           !Desired figure number 
      character*80  input(17)        !Input fields
      character*40  clip1            !Start clip value
      character*40  clip2            !End   clip value
      character     cat              !Category of test

      logical*4     firstpass        !First pass flag for data conversion
      logical*4     tclip            !Time clip the data
      logical*4     bopen            !flt_symbols.dat open flag
      logical*4     trimpt           !Create a trim point

      integer*4     itrimpt          !Index of point to be used as trim point
      integer*4     retstat          !Return status flag

      real*4        rate             !Recording rate

! * Locals


      integer*4     lu               !Logical unit for data
      integer*4     numics           !Number of IC values found in file
      integer*4     dmax             !Number of flight test data points 
      integer*4     icmax            !Number of ic data points 
      integer*4     i,j,k            !Loop counters
      integer*4     lu20   /20/      !Data file unit
	integer*4     lu40   /40/			!Unit to write ICs to opened in write_conv_data
      integer*4     lu41   /41/      !IC file unit
      integer*4     ncol             !Number of columns data is written in
      integer*4     ist              !IOSTAT flag
      integer*4     ist2             !IOSTAT flag
      integer*4     end              !IOSTAT flag
      integer*4     finish           !IOSTAT flag
      integer*4     ended            !IOSTAT flag
      integer*4     idtype           !Type of file to find Sim - flight test
      integer*4     iparm            !Total parameter count
      integer*4     dataparm         !Parameter count from flight test data file

      integer*4     NUMPTS           !Max allowed number of pts per variable
      parameter     (NUMPTS = 10000)

      integer*4     NUMVARS          !Max number of variables
      parameter     (NUMVARS=200)

      character*2660 biggie          !Temporary line
      character*132 datadir          !Directory of input data
      character*132 ifile            !Complete input data file name
      character*132 icfile           !Name of icheader file .lta file
      character*132 licfile          !Name of last ic file input 
      character*500 biggieic         !Temporary line 
      character*80  line             !line
      character*40  fsisymbol(NUMVARS)   !FSI variable names
      character*40  fsisym           !FSI variable names
      character*40  parma(NUMVARS)   !Input variable names
      character*40  icvars(400)      !IC variables DPD Names
      character*20  junk             !junk
      character*20  pfmsg            !Warning message
      character*20  ans              !Answer         
      character*4   cdtype(2) /'.csv','.sim'/

      logical*4     icl(NUMVARS)     !Is parameter an IC variable only
	logical*4		err					!Error flag
      logical*4     figfound         !Found the figure in the data file
	logical*4		fnd					!found flag
	logical*4		isic				!Is variable an ic variable
      logical*4     lexist /.false./ !File exists 
      logical*4     used             !Use this data to output
      logical*4     dupe             !Is this parameter duplicated
      logical*4     data_done /.false./!done with data reading
      logical*4     ic_done   /.false./!done with ic data reading
      logical*4     ic_found  /.false./!found ic input in testic.txt

      real*4        data(NUMPTS,NUMVARS) !data storage
      real*4        clocktime        !beginning of data
      real*4        lclocktime /99./ !save beginning of data
      real*4        tdata(NUMPTS)    !Time data
      real*4        rdata(NUMPTS)    !Y Data
      real*4        tmdata(NUMPTS)   !Time data shifted temp array
      real*4        tclip1           !Start time of clip
      real*4        tclip2           !End time of clip
	real*4			x				!Temp real variable

	real*4			icvals(400)		!Values for above variables

!     External functions
      integer*4      lrbl 
      integer*4      lran
      integer*4      rlan

! * Have access to character string commons ( fpath )
      include "flt_plot.inc"

      ncol    = 10     !Number of columns of data in numeric section

      write (*,*) ' '
      write (*,*) 'Begin Conversion Process.'
      retstat = 0 

      if (.not.tclip) then      !always send data
         tclip1 = -9e30
         tclip2 = +9e30
      else
         read(clip1,*,IOSTAT=ist) tclip1
         read(clip2,*,IOSTAT=i)   tclip2
         if ( ist .ne. 0 .or. i .ne. 0 ) then
            tclip = .false.
            tclip1 = -9e30
            tclip2 = +9e30
         endif
      endif


      if (firstpass) then
         firstpass = .false.            
		 idtype = 0
         do while ( idtype .lt. 1 .or. idtype .gt. 2 )
            write (*,*) ' '
            write (*,*) ' Select the data source you want:'
            write (*,*) ' '
            write (*,*) ' 1. Flight Test Data  .csv'
            write (*,*) ' 2. Simulation Data   .sim'
            write (*,*) ' '
            read (*,'(i1)',IOSTAT=ist) idtype
         enddo
         datadir =  ' '
      endif

      ifile = ' '

      call lower(figure,lrbl(figure))

! * Determine of file in a file name or directory
! * Since this version of FORTRAN does not error on opening a directory name
! * will have to assume that directory ends in a "/" or does not contain a "."
      j = lrbl(filein)
      if ( j .gt. 1 ) then
         if ( filein(j:j) .eq. '/' .or. filein(j:j) .eq. '\' .or. & 
              index(filein(:j),'.') .eq. 0 ) then  !assume a directory
            if ( filein(j:j) .eq. '/' .or. filein(j:j) .eq. '\' ) then
               !datadir = filein(:j-1)  !delete the / will be added in pathfile
			   call pathfile(datadir,fpath,filein(:j-1))
            else
			   call pathfile(datadir,fpath,filein(:j))
               !datadir = filein(:j)
            endif
            ifile   = ' '
         else
            inquire(FILE=filein(:j),EXIST=lexist) !see if file exis            
            if ( lexist ) then
               ifile = filein
            else                !See if file exists in DATA directory
               call pathfile(ifile,fpath,filein(:lrbl(filein)))
               inquire(FILE=ifile(:lrbl(ifile)),EXIST=lexist) !see if file exists
               if ( .not. lexist ) then 
                  ifile =  ' '
               endif
            endif
         endif
      endif

      if ( ifile .eq. ' ' ) then
         if ( datadir .eq. ' ' ) then
            call pathfile(ifile,fpath,figure(:lrbl(figure))// & 
                 cdtype(idtype))
         else
            call pathfile(ifile,datadir,figure(:lrbl(figure))// & 
                 cdtype(idtype))
         endif
      endif

      inquire(FILE=ifile(:lrbl(ifile)),EXIST=lexist)
      if (.not. lexist) then    !does input data file exist
         write(*,*) 'Input data file: ',ifile(:lrbl(ifile)), & 
              ' does not exist'
         retstat = 1
         return
      endif


      open(lu20,FILE=ifile(:lrbl(ifile)),IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*) 'Error opening file: ',ifile(:lrbl(ifile))
         write(*,*) 'Exiting'
         retstat = 2
         return
      endif


! **********************************************************************
!     If the figure is found get the parameters and the data
! **********************************************************************

!      write(*,*) 'Found Figure: ',figure

!     
!     read parameters from flight test data file 
!     

	used = .true.
	ist = 0

	if ( idtype .eq. 2 ) then     !Sim data has big header - read through it for now

		do while ( used .and. ist .eq. 0 ) 
			read(lu20,10,IOSTAT=ist) biggie
			if ( index(biggie,',') .gt. 0  .and. &
				 index(biggie,'initial') .lt. 1  .and. &
				 index(biggie,':') .lt. 1                ) then
				call sub_char(biggie,',',' ')
				call lower(biggie,2660)
		
				i = lran(biggie)
				if ( ichar(biggie(i:i)) .ge. 98 .and. ichar(biggie(i:i)) .le. 123  ) then
					used = .false.
				endif
			endif	
		enddo

		read (biggie,*,IOSTAT=end) (parma(iparm),iparm=1,NUMVARS) !read each parma name 
		dataparm = iparm - 1 !return is always one too many


	else  !Flight test data has no header
		do i=1,3
			read(lu20,10,IOSTAT=ist) biggie  !Header line
		enddo
		call lower(biggie,2660)
		call sub_char(biggie,'^','_')
		call sub_char(biggie,',',' ')
		i = lrbl(biggie)
		biggie = biggie(i+1:)  !Remove first occurance of time called time

		read (biggie,*,IOSTAT=end) (parma(iparm),iparm=1,NUMVARS) !read each parma name 

		dataparm = iparm - 1 !return is always one too many

	endif




!	Remove "_" at the end of a paramter name
	do i=1,dataparm
		j = lrbl(parma(i))
		if ( parma(i)(j:j) .eq. '_' ) parma(i)(j:j) = ' '
	enddo

!   Read units line directly following Parameter list
	read (lu20,10,iostat=ist) biggie !read data long line 
	if ( ist .ne. 0 ) then
		write(*,*)'Error reading data file below list of variables'
		retstat = 2
		close(lu20)
		return
	endif

!	Sim data has a blank line between units and real data
	if ( idtype .eq. 2 ) then
		read (lu20,10,iostat=ist) biggie !read data long line 
		if ( ist .ne. 0 ) then
			write(*,*)'Error reading data file below list of variables'
			retstat = 2
			close(lu20)
			return
		endif
	endif



!	read in data from data file

	write(*,*) 'Looping through test data file',ifile(:lrbl(ifile))
	dmax = 0                  !reset dmax  
	icmax = 0
	data_done = .false.       !reset done data 
	lclocktime = -9999.

	do while (.not. data_done)
		dmax = dmax + 1
		if ( idtype .eq. 1 ) then !Flight test data has expanded time in first column
			read (lu20,'(a12,a2660)',iostat=finish) junk, biggie !read data long line 
		else
			read (lu20,10,iostat=ist) biggie !read data long line 
		endif	
		call sub_char(biggie,',',' ')
		read (biggie,*,iostat=finish) (data(dmax,j),j=1,dataparm) !read each data 
		clocktime = data(dmax,1)
		if (clocktime .eq. lclocktime) then !read last line
			data_done = .true.
			dmax = dmax - 1     !I have read one more line, so back up
		endif
		lclocktime = clocktime
	enddo                     !complete one parameter

	write(*,*) 'Done reading Data File'





!     loop through all the data points with one parameter at a time


	do iparm = 1,dataparm
		call lower(parma(iparm),40)                 

		do i = 1,dmax
			if (iparm .eq. 1) then 
				tdata(i) = data(i,1) - data(1,1)
			else            
				rdata(i) = data(i,iparm)      
			endif       
		enddo      

		if ( bopen ) then
			call findsym(parma(iparm),fsisymbol(iparm),cat,used,icl(iparm))
			dupe = .false.
			if (iparm .gt. 1 .and. used ) then
				do k = 1,iparm-1
					if (parma(k)(:lrbl(parma(k))) .eq. & 
						parma(iparm)(:lrbl(parma(iparm))) .or. & 
						fsisymbol(k)(:lrbl(fsisymbol(k))) .eq. & 
						fsisymbol(iparm)(:lrbl(fsisymbol(iparm))) ) then
						dupe = .true.
					endif
				enddo
			endif

			if ( dupe ) then
				used = .false.
				pfmsg = ' DUPLICATE'
			elseif ( used .and. icl(iparm)  ) then
				call write_var(fsisymbol(iparm),1) !add variables.dat as ic
				call write_var(fsisymbol(iparm),4) !to variables.dat as plot
				pfmsg = ' PLOT/IC VARIABLE'
			elseif (used .and. .not. icl(iparm)) then
				call write_var(fsisymbol(iparm),4) !to variables.dat as plot
				pfmsg = ' PLOT VARIALBLE'
			elseif ( icl(iparm) ) then
				call write_var(fsisymbol(iparm),1) !to variables.dat as ic
				pfmsg = ' IC VARAIBLE'
			else
				pfmsg = ' NOT USED'
			endif
		else
			fsisymbol(iparm) = parma(iparm)
			pfmsg            = 'NO SUB DATA'
			used = .true.       ! Use all parameters if no flt_symbols
		endif

		if ( used ) then
			write(*,95) 'Working with parameter # ', & 
									iparm,parma(iparm)(:lrbl(parma(iparm))), & 
							'  (',fsisymbol(iparm)(:lrbl(fsisymbol(iparm))), & 
								') ',pfmsg
		else
			write(*,*) 'Parameter '// & 
				parma(iparm)(:lrbl(parma(iparm)))//pfmsg
		endif


		if (iparm.eq.1) then 
			write (*,*) 'Data Available: ',dmax,' points.'
		endif
!     
!     write the data to the output file
!     
	
		if ( dmax .le. NUMPTS .and. used) then ! write the data

	!			if ( icl(iparm) .and. (fsisymbol(iparm) .eq. icsymbol1) ) !ic for gears
	!			   if (filein .eq. '/8418/SCS/DATA/AERO/FTDATA/SHIP2') then 
	!				  if (rdata(1) .gt. 50.0) then	   !Shipment 2 gear 0-100 (Up-Dn)
	!					 rdata(1) = 1.0
	!				  else
	!					 rdata(1) = 0.0
	!				  endif
	!			   else
	!				  if (rdata(1) .gt. 50.0) then	   !Shipment 1 gear 0-100 (Dn-Up)
	!					 rdata(1) = 0.0
	!				  else
	!					 rdata(1) = 1.0
	!				  endif
	!			   endif
	!			endif

	!            if ( icl(iparm) .and. (fsisymbol(iparm) .eq. icsymbol2)) then  !ic for maxtime
	!               rdata(1) = tdata(dmax)
	!            endif

			call write_conv_data(tdata,rdata,tmdata,iparm, & 
								tclip,tclip1,tclip2,trimpt,itrimpt,rate,dmax,used, & 
								fsisymbol,icl,numpts)

		elseif ( dmax .gt. NUMPTS) then ! more than allowed data points
			write(*,*) 'Figure ',figure
			write(*,*) 'Has over',NUMPTS,' data points.'
			write(*,*) 'The data will not be written.'
		else                   ! parameter not used
			if (parma(iparm) .eq. 'title') then
				write(*,*) 'Skipping TITLE BLOCK - ', & 
					'Scanning for next ARRAYS...'
			elseif (parma(iparm) .eq. 'run') then
				write(*,*) 'Skipping NON-EOF RUN - ', & 
					'Scanning for next ARRAYS...'
			elseif (dupe) then
				write(*,*) 'Duplicate: ', & 
					parma(iparm)(:lrbl(parma(iparm))), & 
					' not written to output file.'
			else
				write(*,*) 'Parameter: ', & 
					parma(iparm)(:lrbl(parma(iparm))), & 
					' not written to output file.'
			endif
		endif                  ! dmax .le. NUMPTS

	enddo                     ! complete all parma



! *   Close the input file
	close(lu20)  


!	Extract more ic information from the .sim file

	i = index(ifile,'.sim') 
	if ( i .gt. 0 ) then
!		icfile = ifile(:i)//'dat'
		icfile = ifile(:i)//'sim'
		inquire(FILE=icfile,EXIST=lexist)
		if ( lexist ) then
			open(UNIT=lu41,FILE=icfile(:lrbl(icfile)),IOSTAT=ist)
			if ( ist .ne. 0 ) then
				write(*,*) 'Unable to open IC File: '//icfile(:lrbl(icfile))
				write(*,*) 'IC information only from plot data'
				return
			endif
			!call read_dat(lu41,icvars,icvals,numics,fnd,err)
			call read_sim_header(lu41,icvars,icvals,numics,fnd,err)
			close(lu41)      !close .dat file
			if ( err .or. .not. fnd ) then
				write(*,*) 'Error reading IC File: '//icfile(:lrbl(icfile))
				write(*,*) 'IC information only from plot data'
				return
			endif

!			read test_type into IC stream for host...
			numics = numics + 1
			read(cat,'(G12.4)') icvals(numics)
			icvals(numics) = icvals(numics) * 10000.
			icvars(numics) = 'test_type'
!			read default for trim_num into IC stream for host...			
			numics = numics + 1
			if(icvals(numics - 1).lt.0.5) then
			   icvals(numics) = 0.
			else
			   icvals(numics) = 1.
			end if
			icvars(numics) = 'trim_num'

			do i=1,numics
				call findsym(icvars(i),fsisym,cat,used,isic)

!write(*,*) icvars(i),fsisym,cat,used,isic
			!if ( icvars(i)(:5) .eq. 'cgmac' ) then
			!	icvals(i) = icvals(i) * 100
			!endif
				if ( isic ) then
					fnd = .false.
					do j=1,iparm
						if ( fsisymbol(j)(:lrbl(fsisymbol(j))) .eq. &
		                       fsisym(:lrbl(fsisym)) ) fnd = .true.
					enddo
					!Don't include data from header if in time history
					if ( .not. fnd) write(lu40,40,IOSTAT=ist) fsisym(:lrbl(fsisym)),icvals(i)
				endif
			enddo
		else
			write(*,*) 'Unable to find IC File: '//icfile(:lrbl(icfile))
			write(*,*) 'IC information only from plot data'
		endif
	else
		write(*,*) 'Unable to determine name of IC file'
		write(*,*) 'IC information only from plot data'
	endif

	close(lu41)

	return

 10	format(A)
 20	format(I1)
 30	format(6(G11.5,1x))
 40	format(4x,a,' ',f13.4)
 60	format(i2,'/',i2,'/',i4,' ',i2,':',i2,':',i2)
 95	format(A,I3,1X,A,A,A,A,T60,A)

	end


	subroutine  sub_char(line,old,new)

	implicit none

	character*(*)	line		!Input line
	character*1		old			!Character to replace
	character*1		new			!Character to change to

!	Locals
	integer*4		i			!Loop Counter
	integer*4		ln			!End of line

!	Externals
	integer*4		rlan		!Last non-blank on line


	ln = rlan(line)


	do i=1,ln
		if ( line(i:i) .eq. old ) line(i:i) = new
	enddo

	return

	end



	subroutine read_dat(lu,icvars,icvals,numics,fnd,err)
	implicit none


!	*** Argument List
	character*40	icvars(400)		!IC variables DPD Names

	real*4			icvals(400)		!Values for above variables

	integer*4		lu				!Logical unit for data
	integer*4		numics			!Number of IC values found in file

	logical*4		err				!Error flag

!	*** Locals      

	integer*4		i,j,k			!Counters
	integer*4		ie				!Location of equals "="
	integer*4		is				!Location of end of last variable
	integer*4		isect			!Start of valid section
	integer*4		ist				!IOSTAT flag

	character*132	line			!INput read line from data file
	character*40	cicval			!Character string of ic value

	logical*4		fnd				!Found ic block
	logical*4		cont			!continue

!	*** Externals
	integer*4     lrbl				!Returns first blank from left

	err  = .false.
	fnd  = .false.
	cont = .true.

	numics = 0

	do i=1,400
	 	icvars(i) = ' '
		icvals(i) = -999999.
	enddo

	read(lu,10,IOSTAT=ist) line
	do while ( ist .eq. 0 ) 
		call lower(line,132)
		isect = index(line,'mass_properties') + &
		    index(line,'aircraft_configuration')  + &
			index(line,'initial_conditions') 
		
		if ( isect .gt. 0 ) then
			cont = .true.
			do while ( cont ) 
				read(lu,10,IOSTAT=ist) line

				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				call lower(line,132)

				if ( line(1:1) .eq. ' ' ) then !Data is not in first column

					numics = numics + 1
				
					read(line,*,IOSTAT=ist) icvals(numics),icvars(numics)
!					write(*,*) numics,icvals(numics),icvars(numics), 'from .dat'
!					pause
					if ( ist .ne. 0 ) then
						write(*,*) 'Error parsing line:'
						write(*,*) line
						err = .true.
						return
					endif
					fnd = .true.
				else  !Got a new section of data
					cont = .false.  
				endif
			enddo
		else
			read(lu,10,IOSTAT=ist) line	
		endif
	enddo

	return
10	format(a)
	end


	subroutine read_sim_header(lu,icvars,icvals,numics,fnd,err)
	implicit none


!	*** Argument List
	character*40	icvars(400)		!IC variables DPD Names

	real*4			icvals(400)		!Values for above variables

	integer*4		lu				!Logical unit for data
	integer*4		numics			!Number of IC values found in file

	logical*4		err				!Error flag

!	*** Locals      

	integer*4		i,j,k			!Counters
	integer*4		i1,i2,i3,i4,i5,i6  !Section holders
	integer*4		ie				!Location of equals "="
	integer*4		is				!Location of end of last variable
	integer*4		isect			!Start of valid section
	integer*4		ist				!IOSTAT flag

	character*132	line			!INput read line from data file
	character*40	cicval			!Character string of ic value
	character*40    environ(5) /'wind_spd','wind_dir','field_hp','runway_slope','runway_cond'/
	character*40	engine(3)  /'engine_bleed','acc_load','ac_load'/
	character*40	accel(6)   /'vkcasdot','alphadot','betadot','pdot','qdot','rdot'/

	logical*4		fnd				!Found ic block
	logical*4		cont			!continue

!	*** Externals
	integer*4     lrbl				!Returns first blank from left

	err  = .false.
	fnd  = .false.
	cont = .true.

	numics = 0

	do i=1,400
	 	icvars(i) = ' '
		icvals(i) = -999999.
	enddo

	read(lu,10,IOSTAT=ist) line
	do while ( ist .eq. 0 ) 
		call lower(line,132)
		i1 = index(line,'mass properties') 
		i2 = index(line,'miscellaneous') 
		i3 = index(line,'environment and ambient conditions') 
		i4 = index(line,'engine loads and losses')
		i5 = index(line,'accelerations and rates of change at trim')
		i6 = index(line,'control mode selections by axis')

!write(*,*) i1,i2,i3,i4,i5,i6,line(:45)

		if ( i1 .gt. 0 ) then !Mass properties  value,var,descrption.....
!		    write(*,*) 'reading mass properties'
!			pause
			do i=1,8  !Hard coded format
				read(lu,10,IOSTAT=ist) line
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				call lower(line,132)
				call sub_char(line,',','  ')
				numics = numics + 1
 				read(line,*,IOSTAT=ist) icvals(numics),icvars(numics)
				if ( ist .ne. 0 ) then
					write(*,*) 'Error parsing line:'
					write(*,*) line
					err = .true.
					return
				endif
!				write(*,*) numics,icvars(numics),icvals(numics)
!				pause
			enddo
			fnd = .true.
		elseif ( i2 .gt. 0 ) then !Miscellaneous value,,description only extract ship
!		    write(*,*) 'reading miscellaneous'
!			pause
			do i=1,4  !Ignore the first 3 lines of data
				read(lu,10,IOSTAT=ist) line
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
			enddo

			i = index(line,',')
			line = line(:i-1)
			numics = numics + 1
			read(line,*,IOSTAT=ist) icvals(numics)
			if ( ist .ne. 0 ) then
				write(*,*) 'Error reading ship off of line:'
				write(*,*) line
				err = .true.
				return
			endif
			icvars(numics) = 'ship'
			fnd = .true.

		elseif ( i3 .gt. 0 ) then !Environmental parameters
!		    write(*,*) 'environment and ambient conditions'
!			pause
			do i=1,5
				read(lu,10,IOSTAT=ist) line
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				numics = numics + 1
				read(line,*,IOSTAT=ist) icvals(numics)
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				icvars(numics) = environ(i)
!				write(*,*) numics,icvars(numics),icvals(numics)
!				pause
!				if ( icvals(numics) .ne. 0.0 .and. i .lt. 5 ) then
!					icvars(numics) = environ(i)
!					fnd = .true.
!				elseif( icvals(numics) .ne. 1.0 .and. i .eq. 5 ) then
!					icvars(numics) = environ(i)
!					fnd = .true.
!				else !If not interesting info delete
!					numics = numics - 1
!				endif
					
			enddo
		elseif( i4 .gt. 0 ) then !Engine loads				
!		    write(*,*) 'engine loads and losses'
!			pause
			do i=1,3  !Don't worry about 3rd  which is AC
				read(lu,10,IOSTAT=ist) line
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				numics = numics + 1
				read(line,*,IOSTAT=ist) icvals(numics)
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				icvars(numics) = engine(i)
!				write(*,*) numics,icvars(numics),icvals(numics)
!				pause
				fnd = .true.
				
			enddo

		elseif ( i5 .gt. 0 ) then !Accelerations and rates
!		    write(*,*) 'accelerations and rates of change at trim'
!			pause
			do i=1,6  
				read(lu,10,IOSTAT=ist) line
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				numics = numics + 1
				read(line,*,IOSTAT=ist) icvals(numics)
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
				icvars(numics) = accel(i)				
!				write(*,*) numics,icvars(numics),icvals(numics)
!				pause
				fnd = .true.
			enddo
		elseif ( i6 .gt. 0 ) then
!		    write(*,*) 'control mode selections by axis'
!			pause
			do i=1,5 !Read to the proper line containing power,constant
				read(lu,10,IOSTAT=ist) line
				if ( ist .ne. 0 ) then
					write(*,*) 'Error reading line:'
					write(*,*) line
					err = .true.
					return
				endif
			enddo
			numics = numics + 1
			read(line,*,IOSTAT=ist) icvals(numics)
			if ( ist .ne. 0 ) then
				write(*,*) 'Error reading line:'
				write(*,*) line
				err = .true.
				return
			endif
			fnd = .true.
!           reset RAC pla_mode settings to settings as used by host...
            if(icvals(numics).eq.3.) then		! rac torque driver setting
			   icvals(numics) = 2.				! host torque driver setting
			else 
			   icvals(numics) = 1.				! host pcl driver setting
			end if
			icvars(numics) = 'pla_mode'
!			write(*,*) numics,icvars(numics),icvals(numics)
!			pause
!           Hardcode default values into IC stream for driver modes, gain settings and switch times...
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'pitchmode1'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'pitchmode2'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'kpitch1'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'kpitch2'
			numics = numics + 1
			icvals(numics) = 999.0
   		    icvars(numics) = 'pitch_time'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'rollmode1'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'rollmode2'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'kroll1'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'kroll2'
			numics = numics + 1
			icvals(numics) = 999.0
   		    icvars(numics) = 'roll_time'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'yawmode1'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'yawmode2'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'kyaw1'
			numics = numics + 1
			icvals(numics) = 1.0
   		    icvars(numics) = 'kyaw2'
			numics = numics + 1
			icvals(numics) = 999.0
   		    icvars(numics) = 'yaw_time'
!*** Move this if more data needed			
			return
		else !Read next line
			read(lu,10,IOSTAT=ist) line
		endif

	enddo

	return
10	format(a)
	end



      subroutine flt_update_plots_jpats(ftype,filein,figure)
      implicit none

! * Argument list

	character*132   filein          !RAC file prefix
	character*132   figure          !Figure
	character*4		ftype			!File suffix .acd or .pom

! * Locals

      integer*4     i,j,k
      integer*4     lu19   /19/      !Unit for output file
      integer*4     lu18   /18/      !Unit for input file
      integer*4     lu17   /17/      !Unit for plot_vars.dat file
      integer*4     lu16   /16/      !Unit for .plt file
      integer*4     ist              !IOSTAT flag
      integer*4     lf               !Length of tdf file name
      integer*4     ie               !Index of end
      integer*4     is               !Index of start
      integer*4     ip               !Index of plot
      integer*4     imx              !Length of longest y variable
	  integer*4     nplot            !Number of labels in plot_vars.dat
	  integer*4     nvar             !Number of plot variables in .plt file

      character*256 message          !String for system calls
      character*256 line             !Input string read from file
      character*256 lowline          !Lower case version of line 
	  character*132 datadir          !Data directory if different from fpath
      character*132 dfile            !Data file name  *.acd or *.pom
      character*132 tdffile          !TDF file name
      character*132 pltfile          !PLT file name
	  character*40  desc(400)        !description of variable
	  character*40  var(400)         !Variable name for plotting
	  character*40  vplot(37)        !Variables to plot 1=independent
	  character*40  ydesc            !temp y description
	  character*40  xdesc            !temp x description
	  character*12  cnum             !Character of number

      real*4        xmax             !X scale max
      real*4        xmin             !X scale min
      real*4        ymax(36)         !Y scale max
      real*4        ymin(36)         !Y scale min
	  real*4        ymn              !temp ymin 
	  real*4        ymx              !temp ymax 
	  real*4        xmn              !temp xmin 
	  real*4        xmx              !temp xmax 
      real*4        rate             !recording rate

      logical*4     aerr             !Return error flag from flt_var_data
	  logical*4     fexist           !File exist flag
	  logical*4     ferr             !Error renaming files
	  logical*4     fnd              !Found flag
	  logical*4     firstpass /.true./!Firstpass flag
      logical*4     start            !Start of ics found
      logical*4     lend             !End of ics found


!     External functions
      integer*4      lrbl 
      integer*4      lran
      integer*4      rlan


      include "flt_plot.inc"

	ferr = .false.

	do i=1,37
		vplot(i) = ' '
	enddo

	datadir = ' '

	j = lrbl(filein)
	if ( j .gt. 1 ) then
        if ( filein(j:j) .eq. '/' .or. filein(j:j) .eq. '\' .or. & 
              index(filein(:j),'.') .eq. 0 ) then  !assume a directory
            if ( filein(j:j) .eq. '/' .or. filein(j:j) .eq. '\' ) then
			   call pathfile(datadir,fpath,filein(:j-1))
            else
			   call pathfile(datadir,fpath,filein(:j))
            endif
			pltfile   = ' '
		else
			inquire(FILE=filein(:j),EXIST=fexist) !see if file exis            
			if ( fexist ) then
				pltfile = filein
			else                !See if file exists in DATA directory
				call pathfile(pltfile,fpath,filein(:lrbl(filein)))
				inquire(FILE=pltfile(:lrbl(pltfile)),EXIST=fexist) !see if file exists
				if ( .not. fexist ) then 
					pltfile =  ' '
				endif
			endif
		endif
	endif


	k = lrbl(pltfile)
	if ( k .lt. 1  ) then
		if ( datadir(1:1) .eq. ' ' ) then
			call pathfile(pltfile,fpath,figure(:lrbl(figure))//'.plt')
		else
			call pathfile(pltfile,datadir,figure(:lrbl(figure))//'.plt')
		endif	
	endif


! * Set up file paths

	call pathfile(tdffile,fpath,ftestname(:lrbl(ftestname))//'.tdf')
	call pathfile(dfile,fpath,'plot_vars.dat')

!	See if plot_vars.dat exists
	inquire(FILE=dfile,EXIST=fexist)
	if ( .not. fexist ) then
		ferr = .true.
		write(*,*)'File does not exist: '//dfile(:lrbl(dfile))
	endif

!	See if .plt file exists
	inquire(FILE=pltfile,EXIST=fexist)
	if ( .not. fexist ) then
		ferr = .true.
		write(*,*)'File does not exist: '//pltfile(:lrbl(pltfile))
	endif

	if ( .not. ferr ) then
		if ( firstpass ) then
			firstpass = .false.
			
			open(lu17,FILE=dfile,STATUS='OLD',IOSTAT=ist)
			if ( ist .ne. 0 ) then
				write(*,*)  'UNABLE TO OPEN '// dfile(:lf)
				ferr = .true.
			else
				read(lu17,10,IOSTAT=ist) line
				nplot = 1
				do while ( ist .eq. 0 ) 
					if ( .not. (line(1:1) .gt. ' ' .and. line(1:1) .lt. '/') ) then !ignore comments
						call lower(line,132)
						k= index(line,'|')
						desc(nplot) = line(:k-1)
						var(nplot)  = line(k+1:)
						nplot = nplot + 1
					endif
					read(lu17,10,IOSTAT=ist) line
				enddo
				nplot = nplot - 1
				close(lu17)
				if ( nplot .le. 1 ) then
					write(*,*)'Error reading '//dfile(:lrbl(dfile))
					write(*,*)'No information found'
					ferr = .true.
				endif
			endif
		endif

		if ( .not. ferr ) then
			open(lu16,FILE=pltfile,IOSTAT=ist)
			if ( ist .ne. 0 ) then
				write(*,*)  'UNABLE TO OPEN '// dfile(:lf)
				ferr = .true.
			else
				read(lu16,10,IOSTAT=ist) line  !test name line
				read(lu16,10,IOSTAT=ist) line  !First line of data
				nvar = 2
				do while ( ist .eq. 0 ) 

					call lower(line,132)

					k = index(line,',')
					ydesc = line(:k-1)
					line=line(k+1:)

					k = index(line,',')
					cnum = line(:k-1)
					read(cnum,*,IOSTAT=j) ymn
					line=line(k+1:)

					k = index(line,',')
					cnum = line(:k-1)
					read(cnum,*,IOSTAT=ist) ymx
					line=line(k+1:)

					ist = ist + j
					if ( ist .ne.  0 ) then
						write(*,*) 'Unable to extract ymin or ymax from line:'
						ferr = .true.
					endif
					i = 1
					fnd = .false.
					do while ( i .le. nplot .and. .not. fnd .and. nvar .le. 37)
						k = rlan(desc(i))
						if ( desc(i)(:k) .eq. ydesc(:k) ) then !description found
							vplot(nvar) = var(i)
							ymin(nvar)  = ymn
							ymax(nvar)  = ymx
								
							!Find X if first	
							if ( nvar .eq. 2 ) then						
								i = 1
								k = index(line,',')
								xdesc = line(:k-1)
								line=line(k+1:)

								k = index(line,',')
								cnum = line(:k-1)
								read(cnum,*,IOSTAT=j) xmn
								line=line(k+1:)

								!k = index(line,',')
								!cnum = line(:k-1)
								read(line,*,IOSTAT=ist) xmx
								!line=line(k+1:)

								ist = ist + j
								if ( ist .ne.  0 ) then
									write(*,*) 'Unable to extract xmin or xmax'
									ferr = .true.
								endif
								do while ( i .le. nplot .and. .not. fnd )
									k = rlan(desc(i))
									if ( desc(i)(:k) .eq. xdesc(:k) ) then !description found
										vplot(1) = var(i)
										xmin     = xmn
										xmax     = xmx
									    fnd = .true.
									endif
									i = i + 1
								enddo
							endif
							nvar = nvar + 1
							fnd = .true.
						endif
						i = i + 1
					enddo
					read(lu16,10,IOSTAT=ist) line  !First line of data
				enddo
				close(lu16)
				if ( nvar .eq. 2 ) then
					write(*,*)'Unable to extract any plot information from .plt file'
					ferr = .true.
				endif
				if ( vplot(1) .eq. ' ' ) then
					vplot(1) = 'ftsttime'
					xmin = 0.0
					xmax = 40.0
				endif
			endif
		endif
	endif

	if ( .not. ferr ) then  ! Write plot data to .tdf file

! * Open tdf file to write out information

		lf = lrbl(tdffile)
		call rename_file(tdffile(:lf),tdffile(:lf)//'.old',ferr)

		open(lu19,FILE=tdffile,IOSTAT=ist)
			if ( ist .ne. 0 ) then
			write(*,*)  'UNABLE TO OPEN '// tdffile(:lf)
			write(*,*) 'No changes made'
			call rename_file(tdffile(:lf)//'.old',tdffile(:lf),ferr)
			ferr = .true.
		endif

		open(lu18,FILE=tdffile(:lf)//'.old',IOSTAT=i) 
		if ( i .ne. 0 ) then
			write(*,*) 'UNABLE TO OPEN '//tdffile(:lf)//'.old'
			write(*,*) 'No changes made'
			ferr = .true.
		endif

	
		if ( .not. ferr ) then
			start = .false.
			lend  = .false.

			imx = 0


			do i=1,nvar
				j = lrbl(vplot(i))
				if ( j .gt. imx ) imx = j
			enddo


			! * Read existing file and write out non plot lines of information
			read(lu18,10,IOSTAT=ist) line
			do while ( ist .eq. 0 )
				lowline=line
				call lower(lowline,256)
				is = index(lowline,'start')
				ie = index(lowline,'end')
				ip = index(lowline,'plot')
				if ( is .gt. 0 .and. ip .gt. is .and. .not. start) then
					start = .true.
				elseif( ie .gt. 0 .and. ip .gt. ie .and. start ) then
					start = .false.
					lend  = .true.
				endif

				if ( .not. start .and. .not. lend) then !write out data
					write(lu19,10,IOSTAT=ist) line(:rlan(line))
				elseif( lend ) then    !write new plot definition
					write(lu19,10) 'Start Plot'
					rate = 400. / (xmax - xmin)
					if ( rate .lt. 1 ) rate = 1.
					write(lu19,20,IOSTAT=ist) vplot(1)(:imx),xmin,xmax,rate
					do i=2,nvar	
						write(lu19,30,IOSTAT=ist) vplot(i)(:imx),ymin(i),ymax(i)
					enddo
					write(lu19,10,IOSTAT=ist) line(:rlan(line))
					lend = .false.
				endif

				read(lu18,10,IOSTAT=ist) line

			enddo
		endif
		close(lu18)
		close(lu19)

	endif

	if ( ferr ) then  !Error somewhere
		write(*,*)'Plot information will come from list of variables in data file'
		call flt_update_plots(ftype)
	endif

	return
10	format(a)
20	format(3x,'X = ',a,6x,'Scale = ',f12.3,' to ',f12.3,' Rate = ',f5.1)
30	format('       Y = ',a,'  Scale = ',f12.3,' to ',f12.3)
40	format(a,'|',a)
50	format(a,',',g,',',g,',',a,',',g,',',g)
	end

