!  ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : Generic
!    JOB             : Generic
!    DEPARTMENT      : D61 Flight Dynamics
!    MODULE NAME     : flt_read_data.f
!    DESCRIPTION     : Read data file
!    PACKAGE         : flt_utl.a library
!    RATE            : N/A
!    ORIGINATOR      : Mike Saladin
!    DATE            : 12/7//98
!    ENGINEER        : N/A
!    SYSTEM          : Generic 

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 1998 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               Phone: (918) 259-4000
!               Fax:   (918) 251-5597
! 
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

! ****************************************************************************
!--> REVISION BEGIN
!                            Revision History

! $Id: flt_read_data.f,v 1.5 1999/06/01 19:33:33 saladinm Exp saladinm $
! $Log: flt_read_data.f,v $
! Revision 1.5  1999/06/01 19:33:33  saladinm
! fixed error on reading X-y data where x is a desired y.

! Revision 1.4  1999/03/08 16:02:58  saladinm
! Made x y data start at ptr = 2 so as not to confuse with x y y y data.

! Revision 1.3  1999/02/18 14:13:39  saladinm
! Modified so no longer returns error flag= true if a variable not found.

! Revision 1.2  1999/02/10 16:39:12  saladinm
! Increased the dimension of the local data arrays.

! Revision 1.1  1999/02/03 22:03:28  saladinm
! Initial revision

! Revision 1.2  1999/01/05 17:15:40  saladinm
! Added dummy subroutine at the header to fool mscan.  Otherwise this
! module will not compile.

! Revision 1.1  1998/12/16 21:29:23  saladinm
! Initial revision


! Revision 1.1  1992/09/02  20:58:13  saladinm
! Initial revision

!--> REVISION END
! ****************************************************************************

! ****************************************************************************
!.mp  .TH flt_read_data.f l FSI
!.mp  .SH NAME
!.mp    flt_read_data.f  This module reads the test definition files.
!.mp
!.mp  .SH LIBRARY
!.mp
!.mp  FSI D61FLT Library flt_utl.a
!.mp
!.mp  .SH DESCRIPTION
!.mp
!.mp  This module reads a data file and extracts the specified variables
!.mp  and stores them in the single data array
!.mp
!.mp  The main inputs are the file name and variables to extract
!.mp
!.mp  The outputs would be the data read in from the file.
!.mp
!.mp  .SH RELATED INFORMATION
!.mp
!.mp
! ****************************************************************************

! *****************************************************************************

!  This dummy routine is here to fool mscan when compiling.

!  DO NOT REMOVE OR AUTOTEST WILL NOT WORK

      subroutine dummy_data(iconst)

      real iconst

      return
      end

! ****************************************************************************

      subroutine flt_read_data(ffile,var,nvar,idx,xsng,sng,dim,xdx,ydx, & 
                               ptr,outarr,psnap,isman,err)
      implicit none

! * Argument list

      character*132 ffile          !file name to read includes path
      character*64  var(42)        !array of variables to find


      integer*4     nvar           !number of variables in vars
      integer*4     idx(40)        !index to correlate to fatdnum
      integer*4     dim(40)        !Number of data points per variable
      integer*4     xdx(40)        !Location of xpointer for the atdvar
      integer*4     ydx(40)        !Location of ypointer for the atdvar
      integer*4     psnap          !Location of fsnap


      integer*4     ptr            !Number of data points filled in outarr


      real*4        outarr(100000) !Data storage array
      real*4        sng(2,40)      !Y Shift and gains (1,#)=shift (2,#)=gain
      real*4        xsng(2,40)     !X Shift and gains (1,#)=shift (2,#)=gain

      logical*4     isman          !Manual test flag
      logical*4     err            !error flag 


      character*80  rcsid & 
      /"$Id: flt_read_data.f,v 1.5 1999/06/01 19:33:33 saladinm Exp saladinm $"/

! * Locals

      character*132 message      !Output error message string
      character*132 message1     !Output error message string
      character*132 line         !Input line read
      character*132 blk /' '/!Blank line
      character*64  v1           !temp variable name from file
      character*64  v2           !temp variable name from file
      character*13  module /'flt_read_data'/

      integer*4     i,j,k,p      !Indices
      integer*4     ifd          !Variable found index
      integer*4     istat        !IO status flag
      integer*4     istatus      !IO status flag for master read loop
      integer*4     lu40 /40/    !Logical unit of data file for read
      integer*4     ldim         !Local temp number of variables
      integer*4     nl           !Number of lines read
      integer*4     nv           !Number of points for this file
      integer*4     type         !Type of data format x in group or x y
      integer*4     xtype        !Type of pointer that was read
      integer*4     xptr1        !Temp location of x data points in outarr
      integer*4     xptr2        !Temp location of x data points in outarr
      integer*4     odim /100000/!Dimension of outdata array
      integer*4     ddim
	  parameter(ddim=20000)

      logical*4     first        !First variable found flag 
      logical*4     fnd          !Y data loaded for this X in interp
      logical*4     goodx        !Current x array is same as in outvar
      logical*4     start        !Look for start of data in file
      logical*4     varfnd(40)   !Found this variable
      logical*4     exist        !Input files exists flag
      logical*4     fend         !file end flag

      real*4        xd(ddim)      !Local x array values
      real*4        yd(ddim)      !Local y array values
      real*4        y             !Temp y calculated

!>    external functions
      integer*4     lrbl         !returns loc of 1st blank from left in string
      integer*4     rlan         !returns loc of last character in string


      err = .false.
!     do i=1,nvar
!        write(*,*) 'var(',i,') = ',var(i)
!        write(*,*) 'yshft = ',sng(1,idx(i))
!        write(*,*) 'ygn = ',sng(2,idx(i))
!     enddo

!>    Attempt to open file

      inquire(FILE=ffile,EXIST=exist)
      if ( .not. exist ) then
         message='Data file does not exist '//ffile(:lrbl(ffile))
         call ftn_logmsg_err(module,message(:rlan(message)))
         err = .true.
         return
      endif

      open(lu40,FILE=ffile,IOSTAT=istat)
      if ( istat .ne. 0 ) then
         message= 'UNABLE TO OPEN '//ffile(:lrbl(ffile))
         call ftn_logmsg_err(module,message(:rlan(message)))
         err = .true.
         return
      endif

!>    Attempt to read desired variables from file and store in outarr array
      istat = 0
      istatus = 0
      nl = 0
      psnap = 0
      isman = .false.
      start = .true. 
      first = .true.
      type  = 0
      j     = 1
      do i=1,nvar
         varfnd(i) = .false.
      enddo

      fend = .false. 

      do while ( istatus .eq. 0 .and. .not. fend )
         read(lu40,'(a)',IOSTAT=istatus) line
!         write(*,*) line(:rlan(line))
         nl = nl + 1
         ifd = 0
         if ( istatus .eq. 0 .and. line(1:1) .ne. '#' & 
                             .and. line .ne. blk ) then
            call lower(line,132) ! make input line lower case
!            if ( line(1:3) .eq. 'end' .and. .not. start ) fend = .true.
            if ( index(line,'end') .gt. 0 .and. & 
                 index(line,'data') .gt. 0 .and. & 
                 .not. start ) fend = .true.

!>          Read until "start data" is found
            if ( start ) then
               i = index(line,'start')
               j = index(line,'data')
               if ( i .gt. 0 .and. j .gt. 0 ) then !found start of data
                  start = .false.
               endif
               j = index(line,'manual test')
               if ( j .gt. 0 ) isman = .true.
            elseif( fend ) then
               type = 0

!>          Looking for new variable 
            elseif ( type .eq. 0 ) then ! looking for new variable
               read(line,*,IOSTAT=istat) v1,v2,nv


!>             No Error reading this format ( x y numpts )
               if ( istat .eq. 0 ) then 
                  type = 2
!>             Should be in form y or x numpts
               else !See if in format "var" or "var numpts"
                  if ( first ) then     ! First var has # after it
                     read(line,*,IOSTAT=istat) v1,nv
                  else
                     read(line,*,IOSTAT=istat) v1
                  endif

                  if ( istat .ne. 0 ) then  !error in data
                     message='UNABLE to read variable name'
                     call write_mess(message,line,nl,ffile)
                     err = .true.
                     close(lu40)
                     return
                  endif

                  type = 1
               endif
            endif

            if ( nv .gt. ddim ) then !too many points
               message='Too many points for a single parameter'
               call write_mess(message,line,nl,ffile)
               err = .true.
               close(lu40)
               return
            endif

            if( type .eq. 1 .and. .not. fend ) then ! read group of single variable
               read(lu40,*,IOSTAT=istat) (yd(i), i=1,nv)
               if ( istat .gt. 0 ) then
                  message='Error reading data for: '//v1
                  call write_mess(message,line,nl,ffile)
                  err =  .true.
               endif
               nl = nl + (nv-1)/6 + 1

               ifd = 0
               if ( first ) then  ! First variable found (independent)
                  first = .false.
!>                Keep the independent variable 
                  ldim = nv      !set the local dim variable
                  xptr1 = ptr     !For this set of data set the x ptr
                  ifd = 0

! *             See if this variable is desired as well
                  j = 1
                  do while( j .le. nvar .and. ifd .eq. 0 ) 
                     if ( var(j)(:lrbl(var(j))) .eq. v1(:lrbl(v1)) ) then
                        varfnd(j) = .true.
                        xdx(idx(j)) = xptr1
                        ydx(idx(j)) = ptr
                        dim(idx(j)) = ldim
                        ifd = j
                        xtype = 1
                     endif
                     j = j + 1
                  enddo

                  if ( ifd .eq. 1 ) ifd = 0

!>                Load independent into output array
                  do j=1,ldim
                     outarr(j+ptr-1) = (yd(j)+xsng(1,1)) * xsng(2,1)
                  enddo
                  ptr = ptr + ldim   ! Update ptr for values just written
               else             ! See if variable desired
                  ifd = 0
                  j   = 1
                  do while ( j .le. nvar .and. ifd .eq. 0 )
!                     write(*,*) v1(:lrbl(v1)),' ',var(j)(:lrbl(var(j)))
                     if (v1(:lrbl(v1)) .eq. var(j)(:lrbl(var(j)))) then
                        ifd = j
                        varfnd(ifd) = .true.
                        xtype = 1
                     endif
                     j = j + 1
                  enddo
               endif

               type = 0         !look for next variable

!>          Data is in x y format 
            elseif ( type .eq. 2 .and. .not. fend ) then
!>             Search to see if Y variable is desired 
               ifd = 0
               j = 1
               do while ( j .le. nvar .and. ifd .eq. 0 ) 
!                  write(*,*) v2(:lrbl(v2)),var(j)(:lrbl(var(j)))
                  if (v2(:lrbl(v2)) .eq. var(j)(:lrbl(var(j)))) then
                     ifd = j
                     varfnd(ifd) = .true.
                  endif
                  j = j + 1
               enddo
               if ( ifd .ne. 0 ) then ! Y var is desired Read data
                  read(lu40,*,IOSTAT=istat) (xd(j),yd(j),j=1,nv)
                  nl = nl + nv

                  if ( istat .ne. 0 ) then !Error reading the data
                     message='UNABLE to read data in x y format'
                     call write_mess(message,line,nl,ffile)
                     err = .true.
                     close(lu40)
                     return
                  endif
!>                Put independent into output array
                  if ( ptr .eq. 1 ) ptr = 2  !Distinguish between type 1 & 2
                  xptr2 = ptr
                  xtype = 2
                  ldim = nv
                  if ( ldim + ptr .gt. odim ) then
                     message='Too many total points read in.'
                     call write_mess(message,line,nl,ffile)
                     err = .true.
                     close(lu40)
                     return
                  endif

                  do j=1,ldim
                     outarr(j+ptr-1) = (xd(j)+xsng(1,idx(ifd))) & 
                                       * xsng(2,idx(ifd))
                  enddo
                  ptr = ptr + ldim   ! Update ptr for values just written

               else   ! just read thru the data
                  do j=1,nv
                     read(lu40,'(a)',IOSTAT=istat) line
                     nl = nl + 1
                  enddo
               endif
               type = 0
            endif               ! if type = 1 

!>          If valid data found then put into output array 

            if ( ifd .gt. 0 ) then
               if ( xtype .eq. 1 ) then
                  xdx(idx(ifd)) = xptr1
               else
                  xdx(idx(ifd)) = xptr2
               endif                  

               ydx(idx(ifd)) = ptr
               dim(idx(ifd)) = ldim
               if ( ldim + ptr .gt. odim ) then
                  message='Too many total points read in.'
                  call write_mess(message,line,nl,ffile)
                  err = .true.
                  close(lu40)
                  return
               endif

!>             Write y data to outarr 
               do i=1,ldim
                  outarr(i+ptr-1) = & 
                    ( yd(i) + sng(1,idx(ifd))) * sng(2,idx(ifd))
               enddo

               ptr = ptr + ldim

            endif ! if data found
         endif ! if comment line

!>       Check to see if all desired variable found and exit
         j = 0
         do i=1,nvar
            if ( varfnd(i) ) then
               j = j + 1
               if ( var(i)(:lrbl(var(i))) .eq. 'fsnap' ) then
                  psnap = ydx(idx(i))
!                  write(*,*) 'psnap = ',psnap
               endif
            endif
            if ( j .ge. nvar ) then !If all variables are found return
               close(lu40)
               return
            endif
         enddo

      enddo                     !master loop

!>#   Check to make sure all variable found in file
      do i=1,nvar
         if ( .not. varfnd(i) .and.  & !Dont write message for fsnap - not in acd
              var(i)(:lrbl(var(i))) .ne. 'fsnap') then
            j = 1
            do while ( j .le. nvar ) !check to see if a variable is repeated
               if ( j .ne. i .and. var(i)(:lrbl(var(i))) .eq. & 
                    var(j)(:lrbl(var(j))) ) then
                  if ( varfnd(j) ) then       !if vars the same and data fnd
                     dim(idx(i)) = dim(idx(j))!Set the unfound to the found
                     xdx(idx(i)) = xdx(idx(j))!values
                     ydx(idx(i)) = ydx(idx(j))
                     varfnd(i) = .true.
                  endif
               endif
               j = j + 1
            enddo

! *         Variable still not found but don't write error if acd file   
         if ( .not. varfnd(i)  ) then
               dim(idx(i)) = 0
               if ( index(ffile,'.acd') .eq. 0 ) then
                  message='Did not find variable '// & 
                       var(i)(:lrbl(var(i)))
                  call ftn_logmsg_err(module,message)
                  message='In File: '//ffile
                  call ftn_logmsg_err(module,message(:rlan(message)))
               endif
!               err = .true.   MRS 2/17/99 No error if all not found
            endif
         endif
      enddo

      close(lu40)

      return
      end      


      subroutine flt_var_data(ffile,var,nvar,min,max,err)
      implicit none

      character*132 ffile          !file name to read includes path
      character*64  var(200)       !array of variables found

      real*4        min(200)       !Minimum of variable
      real*4        max(200)       !Maximum of variable

      integer*4     nvar           !number of variables in vars

      logical*4     err            !error flag 


      character*80  rcsid & 
      /"$Id: flt_read_data.f,v 1.5 1999/06/01 19:33:33 saladinm Exp saladinm $"/

      character*132 message      !Output error message string
      character*132 line         !Input line read
      character*132 blk /' '/!Blank line
      character*64  v1           !temp variable name from file
      character*64  v2           !temp variable name from file

      integer*4     i,j,k        !Indices
      integer*4     istat        !IO status flag
      integer*4     istatus      !IO status flag for master read loop
      integer*4     lu40 /40/    !Logical unit of data file for read
      integer*4     nl           !Number of lines read
      integer*4     nv           !Number of points for this file
      integer*4     type         !Type of data format x in group or x y
	  integer*4     ddim
      parameter(ddim=20000)

      logical*4     first        !First variable found flag 
      logical*4     start        !Look for start of data in file
      logical*4     exist        !Input files exists flag
      logical*4     fend         !file end flag

      real*4        yd(ddim)     !Local y array values
      real*4        x,y          !temp x & y values
      real*4        mn           !Temp minimum value
      real*4        mx           !Temp maximum value
      real*4        mn1          !Temp minimum value
      real*4        mx1          !Temp maximum value

!>    external functions
      integer*4     lrbl         !returns loc of 1st blank from left in string
      integer*4     rlan         !returns loc of last character in string


      err = .false.

!>    Attempt to open file

      inquire(FILE=ffile,EXIST=exist)
      if ( .not. exist ) then
         message='Data file does not exist '//ffile(:lrbl(ffile))
         call ftn_logmsg_err("flt_var_data",message(:rlan(message)))
         err = .true.
         return
      endif

      open(lu40,FILE=ffile,IOSTAT=istat)
      if ( istat .ne. 0 ) then
         message= 'UNABLE TO OPEN '//ffile(:lrbl(ffile))
         call ftn_logmsg_err("flt_var_data",message(:rlan(message)))
         err = .true.
         return
      endif

!>    Attempt to find all variables in file
      istat = 0
      istatus = 0
      nl = 0
      start = .true. 
      first = .true.
      type  = 0
      j     = 1

      fend = .false. 
      nvar = 0

      do while ( istatus .eq. 0 .and. .not. fend )
         read(lu40,'(a)',IOSTAT=istatus) line
         nl = nl + 1
         if ( istatus .eq. 0 .and. line(1:1) .ne. '#' & 
                             .and. line .ne. blk ) then
            call lower(line,132) ! make input line lower case
            if ( index(line,'end') .gt. 0 .and. & 
                 index(line,'data') .gt. 0 .and. & 
                 .not. start ) fend = .true.

!>          Read until "start data" is found
            if ( start ) then
               i = index(line,'start')
               j = index(line,'data')
               if ( i .gt. 0 .and. j .gt. 0 ) then !found start of data
                  start = .false.
               endif

            elseif( .not. fend ) then
!>          Looking for new variable 

               read(line,*,IOSTAT=istat) v1,v2,nv

!>             No Error reading this format ( x y numpts )
               if ( istat .eq. 0 ) then 
                  nvar = nvar + 1
                  var(nvar) = v1
                  nvar = nvar + 1
                  var(nvar) = v2
                  mn=9999999.
                  mx=-9999999.
                  mn1=9999999.
                  mx1=-9999999.
                  do j=1,nv
                     read(lu40,*,IOSTAT=istat) x,y
                     nl = nl + 1
                     if ( istat .ne. 0 ) then
                        message='Error reading data for: '//v1
                        call write_mess(message,line,nl,ffile)
                        err =  .true.
                        close(lu40)
                        return
                     endif
                     if ( x .gt. mx1 ) mx1 = x
                     if ( x .lt. mn1 ) mn1 = x
                     if ( y .gt. mx ) mx = y
                     if ( y .lt. mn ) mn = y

                  enddo
                  min(nvar-1) = mn1
                  max(nvar-1) = mx1
                  min(nvar) = mn
                  max(nvar) = mx
                  nl = nl + nv
                  type = 0
!>             Should be in form y or x numpts
               else !See if in format "var" or "var numpts"
                  if ( first ) then     ! First var has # after it
                     read(line,*,IOSTAT=istat) v1,nv
                     first = .false.
                     if ( nv .gt. ddim ) then
                        message='Too many points in data array'
                        call write_mess(message,line,nl,ffile)
                        err = .true.
                        close(lu40)
                        return
                     endif
                  else
                     read(line,*,IOSTAT=istat) v1
                  endif
                  nvar = nvar + 1
                  var(nvar) = v1

                  read(lu40,*,IOSTAT=istat) (yd(i), i=1,nv)
                  if ( istat .ne. 0 ) then
                     message='Error reading data for: '//v1
                     call write_mess(message,line,nl,ffile)
                     err =  .true.
                     close(lu40)
                     return
                  endif
                  mn=9999999.
                  mx=-9999999.

                  do i=1,nv
                     if ( yd(i) .gt. mx ) mx = yd(i)
                     if ( yd(i) .lt. mn ) mn = yd(i)
                  enddo

                  min(nvar) = mn
                  max(nvar) = mx

                  nl = nl + (nv-1)/6 + 1

               endif  !type of input x y # or x # &  y 

            endif  !if start/end

         endif                  ! if comment line
      enddo  !Master read loop

!>#   remove repeated variables
      do i=1,nvar-1
         do j=i+1,nvar
            if ( var(i)(:lrbl(var(i))) .eq. var(j)(:lrbl(var(j))) ) then
               do k=j,nvar-1
                  var(k) = var(k+1)
               enddo
               nvar = nvar - 1
            endif
         enddo
      enddo

      close(lu40)

      return
      end

