! ***************************************************************************
!>
!>    This INCLUDE file reads the test definition file and stores the 
!>    information from it in local arrays and flags.  Variable declarations
!>    for these arrays are included in the file flt_read_vars.inc
!>   

! ***************************************************************************





! * Verify if test definition file exists and open it for reading


      filename = ""

      filename = ftestname(:lrbl(ftestname))//'.tdf'
      call pathfile(testfile,fpath,filename(:lrbl(filename)))

      inquire(FILE=testfile,EXIST=exist)
      if ( .not. exist ) then
         message='Test file does not exist '//testfile(:lrbl(testfile))
         call ftn_logmsg_err("flt_read.inc",message(:rlan(message)))
         fininrt = 3
         return
      endif

      open(lu19,FILE=testfile,IOSTAT=istatus)
      if ( istatus .ne. 0 ) then
         message = 'UNABLE TO OPEN '//testfile(:lrbl(testfile))
         call ftn_logmsg_err("flt_read.inc",message)
         call perror(message1)
         write(message,'(A,I5,A,A)') 'Status #',istatus,':',message1
         call ftn_logmsg_err("flt_read.inc",message)
         fininrt = 3
         return
      endif


! * Initialize the storage variables to the defaults allowing file read to 
!   overwrite everything.

      comment = blank
      title   = blank
      type    = 'plot'

      acd   = .false.
      atd   = .false.
      defic = .false.
      drv   = .false.
      err   = .false.
      plot  = .false.
      pom   = .false.
      task3 = .false.
      task5 = .false.
      text  = .false.

      plavar    = 0
      powervar  = 0
      betavar   = 0
      dampvar   = 0
      ncond     = 0
      nic       = 0
      nplot     = 0
      ntask3    = 0
      ny        = 0
      phivar    = 0
      recrate   = 200.
      nyt       = 0
      nxt       = 0
      beta_st   = 0.
      damp_st   = 0.
      phi_st    = 0.
      cfd_st    = 0.
      totgrids  = 0

      do ii=1,10
         ytarval(ii) = 0.
         ytarvar(ii) = 0
         ytarm(ii)   = 0  !No specified slope
         xtarval(ii) = 0.
         xtarvar(ii) = 0
         xtarm(ii)   = 0  !No specified slope
      enddo           


      do ii=1,4
         ncnt(ii) = 0
         do is=1,maxgrid
            var(ii,is)  = blank(:80)
            ysh(ii,is)  = 0.0         !Default
            ygn(ii,is)  = 1.0         !Default
            xsh(ii,is)  = 0.0         !Default
            xgn(ii,is)  = 1.0         !Default
            if ( ii .eq. 1 ) then
               yvar(is)   = blank(:80)
               snap(is)   = blank(:8)
               ynplot(is) = 1
               ngrid(is)  = 1           !Default
               ymin(is)   = 0.
               ymax(is)   = 100.
               hilite(is) = .false.
               tol_a(is)  = 0.0
               tol_p(is)  = 0.0
               ylimit(is) = .false.
            endif
         enddo
      enddo

      do ii=1,6
         xmin(ii) = 0
         xmax(ii) = 100
      enddo

      do ii=1,ndimt5
         do is=1,ndimcon
            t5var(is,ii)    = blank(:80)
            t5val(is,ii)    = blank(:80)
            t5source(is,ii) = 'acd'       !Default location of drivers
            t5sync(is,ii)   = blank(:80)
            t5bias(is,ii)   = 0.0
            if ( ii .le. 2 ) then
               convar(ii,is)        = blank(:80)
               con(ii,is)           = '  '
               icvar(is+(ii-1)*30)  = blank(:80)
               icval(is+(ii-1)*30)  = blank(:20)
               if ( ii .eq. 1 ) then
                  ntask5(is) = 0
                  t3var(is) = blank(:80)
                  t3val(is) = blank(:80)
               endif
            endif
         enddo
      enddo


! * Start reading test definition file one line at a time      

      read(lu19,'(a)',IOSTAT=istatus) line
      nl = 1 
      do while ( istatus .eq. 0 )  
         ii = rlan(line)
         if ( line(1:1) .ne. '#' .and. ii .gt. 0) then   ! exclude comments
            lowline = line
            call lower(lowline,132)          ! make input line lower case
            it  = index(lowline,'title')
            ic  = index(lowline,'comment')
            is  = index(lowline,'start')
            ie  = index(lowline,'end')
            ieq = index(lowline,'=')

!            write(*,*) 'line = ',line(:70)

! *        Read title
            if ( it .gt. 0  .and. ieq .gt. it+5 ) then
               read(line(ieq+1:),'(a)',IOSTAT=istatus) title
               if ( istatus .ne. 0 ) then  ! Error reading this line
                  err = .true.
                  message='Unable to read title'
                  call write_mess(message,line,nl,testfile)
               endif
               title = title(lran(title):) !Remove leading blanks

! *        Read comment
            elseif ( ic .gt. 0  .and. ieq .ge. ic ) then
               read(line(ieq+1:),'(a)',IOSTAT=istatus) comment
               comment = comment(lran(comment):) !remove leading blanks
!               write(*,*) 'comment = ',comment(:rlan(comment))
               if ( istatus .ne. 0 ) then  ! Error reading this line
                  err = .true.
                  message='Unable to read comment'
                  call write_mess(message,line,nl,testfile)
               endif

! *        End of a section reached easiest to just reset all
            elseif ( ie .gt. 0  .and. ie .lt. 5 ) then       
               task3 = .false.
               task5 = .false.
               plot  = .false.
               acd   = .false.
               atd   = .false.
               pom   = .false.
               drv   = .false.
               text  = .false.
               defic = .false.

! *        Read Shifts and Gains
            elseif ( acd .or. atd .or. pom .or. drv ) then  
               ncnt(idnum) = ncnt(idnum) + 1
               ii = ncnt(idnum)
               read(lowline,*,IOSTAT=istatus) var(idnum,ii), & 
                                ysh(idnum,ii),ygn(idnum,ii), & 
                                xsh(idnum,ii), xgn(idnum,ii)
               if ( istatus .ne. 0 ) then  ! Error reading this line
                  err = .true.
                  message='Unable to read shift and gain line'
                  call write_mess(message,line,nl,testfile)
               endif

! *        Read Plot Information
            elseif ( plot ) then !look for x or y variable definition
               is = index(lowline,'x')
               it = index(lowline,'y')

! *           Read X = variable line including scales, type & rate
               if ( is .gt. 0 .and. ieq .gt. is ) then  
                  nplot = nplot + 1           ! Increment to next page
                  read(lowline(ieq+1:),*,IOSTAT=istatus) xvar(nplot)
                  if ( istatus .ne. 0 ) then  ! Error reading this line
                     err = .true.
                     message='Unable to read X variable'
                     call write_mess(message,line,nl,testfile)
                  endif
                  ln = lrbl(xvar(nplot))
                  ie = index(lowline,' '//xvar(nplot)(:ln)//' ') + ln

                  is = index(lowline(ie:),'scale') + ie
                  it = index(lowline(is+1:),'=') + is
                  read(lowline(it+1:),*,IOSTAT=istatus)  & 
                      xmin(nplot),to,xmax(nplot)
                  if ( istatus .ne. 0 ) then  ! Error reading this line
                     err = .true.
                     message='Unable to parse X scales'
                     call write_mess(message,line,nl,testfile)
                  endif

                  is = index(lowline(ie:),'type') 
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) type
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse plot type'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif

                  is  = index(lowline(ie:),'rate')
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) recrate
!                     write(*,*) 'recrate = ',recrate
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse plot rate'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif

! *           Find Y = variable line
               elseif( it  .gt. 0 .and. ieq .gt. it ) then !found Y = 
                  if ( ny + 1 .gt. maxgrid ) then
                     err = .true.
                     message='Too many plot variables defined'
                     call write_mess(message,line,nl,testfile)
                  else
                     ny = ny + 1
                  endif

                  ynplot(ny) = nplot
                  read(lowline(ieq+1:),*,IOSTAT=istatus) yvar(ny) ! read y variable
                  if ( istatus .ne. 0 ) then  ! Error reading this line
                     err = .true.
                     message='Unable to read Y variable'
                     call write_mess(message,line,nl,testfile)
                  endif

                  ln = lrbl(yvar(ny))
                  ie = index(lowline,' '//yvar(ny)(:ln)//' ') + ln

                  is = index(lowline(ie+1:),'scale') + ie
                  it = index(lowline(is:),'=') + is

                  read(lowline(it:),*,IOSTAT=istatus)  & 
                      ymin(ny),to,ymax(ny)       ! read scales
                  if ( istatus .ne. 0 ) then     ! Error reading this line
                     err = .true.
                     message='Unable to parse Y scales'
                     call write_mess(message,line,nl,testfile)
                  endif

                  is = index(lowline(ie:),'grid')
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) ngrid(ny)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to parse grids'
                     endif
                  endif

                  totgrids = totgrids + ngrid(ny)

                  if ( totgrids .gt. maxgrid ) then
                     err = .true.
                     message='Too many plot variables/grids defined'
                     call write_mess(message,line,nl,testfile)
                  endif


                  is  = index(lowline(ie:),'snap') 
                  if ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) snap(ny)
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse plot snap flag'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif


                  it  = ie
                  is  = index(lowline(it:),'ytarget')
                  do while ( is .gt. 0 .and. nyt .lt. 10 & 
                             .and. istatus .eq. 0)
                     ieq = index(lowline(is+it:),'=') + is + it
                     nyt = nyt + 1
                     read(lowline(ieq:),*,IOSTAT=istatus) ytarval(nyt)
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse ytarget'
                        call write_mess(message,line,nl,testfile)
                     endif
                     ytarvar(nyt) = ny

                     it  = ieq    !start looking for next ytarget after '='
                     is  = index(lowline(it:),'slope')
                     ii  = index(lowline(it:),'ytarget')
                     if ( ( is .gt. 0 ) .and.  & 
                          ( ii .eq. 0 .or. is .lt. ii) ) then !slope fnd
                        ieq = index(lowline(it+is:),'=') + is + it
                        read(lowline(ieq:),*,IOSTAT=istatus) ytarm(nyt)
                        if ( istatus .ne. 0 .or.  ytarm(nyt) .lt. 0 & 
                             .or. ytarm(nyt) .gt. 2 ) then ! Error reading this line
                           err = .true.
                           if  ( istatus .eq. 0 ) then
                              message='Invalid slope specified'
                           else
                              message='Unable to parse ytarget slope'
                           endif
                           call write_mess(message,line,nl,testfile)
                        endif      
                     endif
                     is  = index(lowline(it:),'ytarget')
                  enddo

                  it  = ie
                  is  = index(lowline(it:),'xtarget')
                  do while ( is .gt. 0 .and. nxt .lt. 10 & 
                             .and. istatus .eq. 0 )
                     ieq = index(lowline(is+it:),'=') + is + it
                     nxt = nxt + 1
                     read(lowline(ieq:),*,IOSTAT=istatus) xtarval(nxt)
                     if ( istatus .ne. 0 ) then ! Error reading this line
                        err = .true.
                        message='Unable to parse xtarget'
                        call write_mess(message,line,nl,testfile)
                     endif
                     xtarvar(nxt) = ny

                     it  = ieq    !start looking for next xtarget after '='
                     is  = index(lowline(it:),'slope')
                     ii  = index(lowline(it:),'xtarget')
                     if ( ( is .gt. 0 ) .and.  & 
                          ( ii .eq. 0 .or. is .lt. ii) ) then !slope fnd
                        ieq = index(lowline(it+is:),'=') + is + it
                        read(lowline(ieq:),*,IOSTAT=istatus) xtarm(nxt)
                        if ( istatus .ne. 0 .or.  xtarm(nxt) .lt. 0 & 
                             .or. xtarm(nxt) .gt. 2 ) then ! Error reading this line
                           if ( istatus .eq. 0 ) then
                              message = 'Invalid slope specified'
                           else
                              message='Unable to parse xtarget slope'
                           endif
                           err = .true.
                           call write_mess(message,line,nl,testfile)
                        endif      
                     endif
                     is  = index(lowline(it:),'xtarget')

                  enddo

                  is  = index(lowline(ie:),'hili') !hilight or hilite
                  if  ( is .gt. 0 ) then
                     hilite(ny) = .true.
                  endif

                  is  = index(lowline(ie:),'ylimit') !Limit data to y axis
                  if  ( is .gt. 0 ) then
                     ylimit(ny) = .true.
                  endif

                  is  = index(lowline(ie:),'power') !Power parameter
                  if  ( is .gt. 0 ) then
                     powervar = ny
                  endif

                  is  = index(lowline(ie:),'pla') !Pla parameter
                  if  ( is .gt. 0 ) then
                     plavar = ny
                  endif

                  is  = index(lowline(ie:),'cfd_st') !CFD start anlysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) cfd_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read cfd_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     cfdvar = ny
                  endif

                  is  = index(lowline(ie:),'damp_st') !Damp ratio anlysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) damp_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read damp_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     dampvar = ny
                  endif

                  is  = index(lowline(ie:),'beta_st') !Beta analysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) beta_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read beta_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     betavar = ny
                  endif

                  is  = index(lowline(ie:),'phi_st') !Phi analysis
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) phi_st
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read phi_st value'
                        call write_mess(message,line,nl,testfile)
                     endif
                     phivar = ny
                  endif

                  is  = index(lowline(ie:),'tol_a') !Absolute tolerance
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) tol_a(ny)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read absolute tolerance'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif

                  is  = index(lowline(ie:),'tol_p') !Percent tolernace
                  if  ( is .gt. 0 ) then
                     it = index(lowline(is+ie:),'=') + is + ie + 1
                     read(lowline(it:),*,IOSTAT=istatus) tol_p(ny)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read percent tolerance'
                        call write_mess(message,line,nl,testfile)
                     endif
                  endif
               endif   ! If Y = variable line

!>          Read ICs in the form var = Number     1
            elseif ( defic ) then
               nic = nic + 1
               read(lowline(:ieq-1),*,IOSTAT=istatus) icvar(nic)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read IC variable name for input'
                  call write_mess(message,line,nl,testfile)
               endif

               read(lowline(ieq+1:),'(a)',IOSTAT=istatus) icval(nic)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read ic variable value'
                  call write_mess(message,line,nl,testfile)
               endif
               icval(nic) = icval(nic)(lran(icval(nic)):)
               icval(nic) = icval(nic)(:lrbl(icval(nic)))

               ii = rlan(lowline)  ! Find occurance of last non blank
               read(lowline(ii-2:),*,IOSTAT=istatus) icout(nic)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read ic output flag'
                  call write_mess(message,line,nl,testfile)
               endif



!>          Read task 3 inputs               
            elseif ( task3 ) then
               ntask3 = ntask3 + 1
               read(lowline(:ieq-1),*,IOSTAT=istatus) t3var(ntask3)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read Task 3 variable'
                  call write_mess(message,line,nl,testfile)
               endif
               read(lowline(ieq+1:),'(a)',IOSTAT=istatus) t3val(ntask3)
               if ( istatus .ne. 0 ) then !Error reading this line
                  err = .true.
                  message='Unable to read Task 3 value'
                  call write_mess(message,line,nl,testfile)
               endif

!>#
!>#         Read Task 5 information
!>#
            elseif ( task5 ) then
               is = index(lowline,'define')
               if ( is .gt. 0 ) then ! New conditional
                  ncond = ncond + 1
                  it = index(lowline(is:),' ') + is
                  is = lran(lowline(it:)) + it - 1
                  ie = lrbl(lowline(is:)) + is
                  read(lowline(is:ie),*,IOSTAT=istatus) convar(1,ncond)
                  if ( istatus .ne. 0 ) then !Error reading this line
                     err = .true.
                     message='Unable to read first conditional variable'
                     call write_mess(message,line,nl,testfile)
                  endif
                  ie = lrbl(convar(1,ncond))
                  is = index(lowline,convar(1,ncond)(:ie)) + ie 
                  read(lowline(is:),*,IOSTAT=istatus) con(1,ncond)
                  if ( istatus .ne. 0 ) then !Error reading this line
                     err = .true.
                     message='Unable to read first conditional operator'
                     call write_mess(message,line,nl,testfile)
                  endif
                  ie = lrbl(con(1,ncond))
                  is = index(lowline,con(1,ncond)(:ie)) + ie 
                  read(lowline(is:),'(A)',IOSTAT=istatus) conval(1,ncond)
                  if ( istatus .ne. 0 ) then !Error reading this line
                     err = .true.
                     message='Unable to read first conditional value'
                     call write_mess(message,line,nl,testfile)
                  else
                     conval(1,ncond)=conval(1,ncond) & 
                                           (lran(conval(1,ncond)):)
                     conval(1,ncond)=conval(1,ncond) & 
                                           (:lrbl(conval(1,ncond)))
                  endif

!>                Search for second conditional statement
                  ic = index(lowline(is:),' and ') 
                  it = index(lowline(is:),' or ') 
                  conop(ncond) = 0   ! Reset   

                  if ( ic .gt. 0 .or. it .gt. 0 ) then
                     if ( ic .gt. 0 ) then
                        ii = ic + is + 4   !Offset by ' and '
                     else
                        ii = it + is + 3   !Offset by ' or '
                     endif
                     lowline = lowline(ii:)
                     is = lran(lowline) 
                     ie = lrbl(lowline(is:)) + is
                     read(lowline(is:ie),*,IOSTAT=istatus) convar(2,ncond)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read 2nd conditional variable'
                        call write_mess(message,line,nl,testfile)
                     endif

                     ie = lrbl(convar(2,ncond))
                     is = index(lowline,convar(2,ncond)(:ie)) + ie 
                     read(lowline(is:),*,IOSTAT=istatus) con(2,ncond)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read 2nd conditional operator'
                        call write_mess(message,line,nl,testfile)
                     endif

                     ie = lrbl(con(2,ncond))
                     is = index(lowline,con(2,ncond)(:ie)) + ie 
                     read(lowline(is:),'(A)',IOSTAT=istatus) conval(2,ncond)
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read 2nd conditional value'
                        call write_mess(message,line,nl,testfile)
                     else
                        conval(2,ncond) = conval(2,ncond) & 
                                          (lran(conval(2,ncond)):)
                        conval(2,ncond) = conval(2,ncond) & 
                                          (:lrbl(conval(2,ncond)))
                     endif

                     if ( ic .gt. 0 ) then
                        conop(ncond) = 1     ! and
                     else
                        conop(ncond) = 2     ! or 
                     endif
                  endif

!>             Task 5 read variables and values for previously define condition
               else  ! not define assume set variable line
                  if ( ncond .lt. 1 ) then  ! Something wrong and out of order
                     message='Error trying to set values before define'
                     call write_mess(message,line,nl,testfile)
                     err = .true.
                  else
!                    if more variables than max for array then create a new 
!                    conditional statement the same as the one before it.
                     if ( ntask5(ncond) + 1 .gt. ndimt5 ) then
                        is    = ncond
                        ncond = ncond + 1
                        ntask5(ncond) = 1
                        do ii=1,2
                           convar(ii,ncond) = convar(ii,is)
                           con(ii,ncond)    = con(ii,is)
                           conval(ii,ncond) = conval(ii,is)
                        enddo
                        conop(ncond) = conop(is)
                     else
                        ntask5(ncond) = ntask5(ncond) + 1
                     endif

!>                   Read vairable to set if condition true
                     read(lowline(:ieq-1),*,IOSTAT=istatus)  & 
                          t5var(ncond,ntask5(ncond))
                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read Task 5 variable'
                        call write_mess(message,line,nl,testfile)
                     else
                        t5var(ncond,ntask5(ncond)) = & 
                          t5var(ncond,ntask5(ncond)) & 
                          (:lrbl(t5var(ncond,ntask5(ncond))))
                     endif
!>                   Read value to set variable to if condition true
!>                   May be an atd variable name
                     read(lowline(ieq+1:),'(a)',IOSTAT=istatus)  & 
                          t5val(ncond,ntask5(ncond))

                     if ( istatus .ne. 0 ) then !Error reading this line
                        err = .true.
                        message='Unable to read Task 5 value'
                        call write_mess(message,line,nl,testfile)
                     else
                        t5val(ncond,ntask5(ncond)) = & 
                          t5val(ncond,ntask5(ncond)) & 
                          (lran(t5val(ncond,ntask5(ncond))):)
                        t5val(ncond,ntask5(ncond)) = & 
                          t5val(ncond,ntask5(ncond)) & 
                          (:lrbl(t5val(ncond,ntask5(ncond))))
                     endif

!>                   Read source value if it exists default=atd
                     is = index(lowline,'source')
                     if ( is .gt. 0 ) then
                        it = index(lowline(is:),'=') + is
                        read(lowline(it:),*,IOSTAT=istatus) & 
                             t5source(ncond,ntask5(ncond))

                        if ( istatus .ne. 0 ) then !Error reading this line
                           err = .true.
                           message='Unable to read Task 5 source'
                           call write_mess(message,line,nl,testfile)
                        endif
                     endif

!>                   Read sync variable if it exists
                     is = index(lowline,'sync')
                     if ( is .gt. 0 ) then
                        it = index(lowline(is:),'=') + is
                        read(lowline(it:),*,IOSTAT=istatus) & 
                             t5sync(ncond,ntask5(ncond))
                        if ( istatus .ne. 0 ) then !Error reading this line
                           err = .true.
                           message='Unable to read Task 5 sync'
                           call write_mess(message,line,nl,testfile)
                        endif
                     endif

!>                   Read bias value if it exists
                     is = index(lowline,'bias')
                     if ( is .gt. 0 ) then
                        it = index(lowline(is:),'=') + is
                        read(lowline(it:),*,IOSTAT=istatus) & 
                             t5bias(ncond,ntask5(ncond))
                        if ( istatus .ne. 0 ) then !Error reading this line
                           err = .true.
                           message='Unable to read Task 5 bias'
                           call write_mess(message,line,nl,testfile)
                        endif
                     endif



                  endif ! if ncond > 0
               endif    ! if define line
            elseif ( text ) then
               is = 0  !Not important just prevent text from triggering others
!>          This line has a START key word in it
            elseif ( is .gt. 0 ) then ! Line has start in it 

               if ( index(lowline,'task')  .gt. 0 ) then    ! Start drivers
                  if ( index(lowline,'3') .gt. 0 ) then
                     task3 = .true.          ! task 3 specified
                  else
                     task5 = .true.          ! Assume if not 3 then task 5
                  endif 
               endif

               if ( index(lowline,'plot') .gt. 0 ) then
                  plot = .true.
               endif

               if ( index(lowline,'acd') .gt. 0 ) then
                  acd = .true.
                  idnum = 1
               endif

               if ( index(lowline,'atd') .gt. 0 ) then
                  atd = .true.
                  idnum = 2
               endif

               if ( index(lowline,'pom') .gt. 0 ) then
                  pom = .true.
                  idnum = 3
               endif

               if ( index(lowline,'driver') .gt. 0 ) then
                  drv = .true.
                  idnum = 4
               endif


               if ( index(lowline,'ic') .gt. 0 ) then
                  defic = .true.
               endif

               if ( index(lowline,'text') .gt. 0 ) then
                  text = .true.
               endif

               if ( .not. ( task3 .or. task5 .or. plot & 
                       .or. acd   .or. atd   .or. pom .or. drv & 
                       .or. defic .or. text  )) then

                  message = 'No key word to match START keyword'
                  err = .true.
                  call write_mess(message,line,nl,testfile)
               endif

            endif

            if ( err ) then
               close(lu19)
               fininrt = 3
               return
            endif



         endif
         read(lu19,'(a)',IOSTAT=istatus) line
         nl = nl + 1
      enddo

      close(lu19)


      nl = 0


! * Get tolernaces from tolerance.dat file
      call pathfile(filename,fpath,'tolerance.dat')
      open(lu81,FILE=filename,IOSTAT=istatus)
      if ( istatus .gt. 0 ) then
         write(message,'(a,a)') 'UNABLE TO OPEN ',filename
         call ftn_logmsg_err("fat_readtest",message)
         write(message,'(A,I5)') 'Status #',istatus
         call ftn_logmsg_err("fat_readtest",message)
      else
         fnd = .false.
	   rewind(lu81)
         do while ( istatus .eq. 0 .and. .not. fnd ) 
            read(lu81,'(a)',IOSTAT=istatus) line
            if ( istatus .eq. 0 ) nl = nl + 1

            if ( line (1:1) .ne. '#' .and. istatus .eq. 0 ) then
               call lower(line,rlan(line))

               if ( index(line,'start') .gt. 0 ) then  !start of new section
                  if ( index(line,'tolerance')  .gt. 0 ) then
                     istol = .true.
                  elseif ( index(line,'tests')  .gt. 0 ) then
                     istest = .true.
                  endif

               elseif ( index(line,'end') .gt. 0 ) then !end of section
                  istol = .false.
                  istest = .false.

               elseif ( istol ) then
                  read(line,*,IOSTAT=istatus) ii,tolv(ii), & 
                                        tola(ii),tolp(ii)
                  if ( istatus .ne. 0 ) then
                     message= 'Unable to read tolerances from '// & 
                          ' tolerances.dat file'
                     call write_mess(message,line,nl,filename)
                  else
                     ntol = ii
!                     write(*,*) 'tolv(',ii,' = ',tolv(ii),'tola = ',tola(ii),
!     >                    'tolp = ',tolp(ii)
                  endif

               elseif ( istest ) then 
                  read(line,'(a)',IOSTAT=istatus) message
                  is = lran(message)
                  ie = lrbl(message(is:)) + is
                  read(message(is:ie),*,IOSTAT=it) ii
                  if ( istatus .ne. 0 .or. it .ne. 0 ) then
                     message= 'Unable to read test info from'// & 
                          'tolerances.dat file'
                     call write_mess(message,line,nl,filename)
                  elseif ( ii .eq. fattest ) then
                     fnd = .true.
                     message=message(ie+1:)
                  endif
               endif
            endif
         enddo
         close(lu81)

! * Find tolernaces for each plot variable don't overwrite those in test def
         if ( fnd ) then  !if test tolerances found
            line = message
!            write(*,*) 'line = ',line
            it  = 1
            istatus = 0
            do while( istatus .eq. 0 .and. it .lt. rlan(line) )
               ie = lran(line(it:)) + it - 1
               read(line(ie:),*,IOSTAT=istatus) jj
               fnd = .false.
!               write(*,*) 'jj = ',jj
               ii = 1
               do while ( ii .le. ny .and. .not. fnd )
!                  write(*,*) 'tolv(',jj,') = ',tolv(jj),
!     >                 'yvar(',ii,') =',yvar(ii)
                  if ( yvar(ii)(:lrbl(yvar(ii))) .eq. & 
                       tolv(jj)(:lrbl(tolv(jj)))) then
                     if ( tol_a(ii) .eq. 0. ) tol_a(ii) = tola(jj)
                     if ( tol_p(ii) .eq. 0. ) tol_p(ii) = tolp(jj)
                     fnd = .true.
                  endif
                  ii = ii + 1
               enddo
               write(cname,*) jj
               is = lran(cname)
               ii = rlan(cname)
               it =  ie + ii - is + 1
!               write(*,*) 'it = ',it,'cname = ',cname,'is = ',is
!               write(*,*) 'line = ',line
            enddo
         endif !if test found in tolerances.dat

      endif !If tolerances.dat opened


