! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L
!    SIMULATOR       : Generic
!    JOB             : All
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : flt_plotutl
!    DESCRIPTION     : Auto Test output controller.
!    PACKAGE         : SimTest
!    RATE            : offline
!    ORIGINATOR      : Flight Data Library
!    DATE            : 4/19/00
!    ENGINEER        : Mike Saladin
!    SYSTEM          : SimNT
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!    Copyright 2000 FlightSafety International
!
!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597
!
! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!
! This file contains the collection of plot analysis and postscript generation
! routines that  are called  from the flt_output module.
!
!

      subroutine get_pgno(testno,pgno,secno,txtno)

      implicit none

! * Argument List
      integer*4     testno        ! test number
      integer*4     pgno          ! page number start of test
      integer*4     secno         ! test section number
      integer*4     txtno         ! num of text pages

! * Locals
      integer*4     page(5)       !page number array data
      integer*4     ierr          !IOSTAT flag
      integer*4     lu81 /81/     !ftpages.dat

      character*256 message       !Message string
      character*132 filename      !File name for ftpages.dat
      character*80  line          !temporary text string
      character*80  blk           !Blank text string

      logical*4     fopen         !ftpages file open

      include "flt_plot.inc"


! * External functions
      integer*4     lrbl           !Index-1 of first blank on line
      
      pgno  = 0
      secno = 0
      txtno = 0
      ierr  = 0

      blk   = ' '
!     Open ftpages.dat
      call pathfile(filename,fpath,'ftpages.dat')
      inquire(lu81,OPENED=fopen,IOSTAT=ierr)
      
      if ( .not. fopen .or. ierr .ne. 0 ) then
         open(lu81,FILE=filename,IOSTAT=ierr) !Gets cloes at end of output
      endif

      if ( ierr .ne. 0) then
         write(message,*) 'get_pgno: Unable to open ',filename(:lrbl(filename))//''C
!         call logmsg("SimTest"C,LOG_INFO,message)
		call ftn_logmsg_info('get_pgno',message)
         return
      endif

      if ( testno .gt. 0 ) then !test found
         do while (ierr .eq. 0 .and. secno .eq. 0 ) 
            read(lu81,'(A)',IOSTAT=ierr) line
            if ( line(1:1) .ne. '*' .and. line .ne. blk  & 
                 .and. ierr .eq. 0) then
               read(line,*,IOSTAT=ierr) page(1),page(2),page(3), & 
                    page(4),page(5)
               if ( page(2) .eq. testno ) then
                  secno = page(1)
                  txtno = page(3)
                  pgno  = page(5)
               endif
            endif
         enddo
      endif

      close(lu81)
      return
      end



      subroutine doc_pg(pg,sec,docpg)

      integer*4    pg    ! page number
      integer*4    sec   ! section number
      character*7  docpg !document page number sec-pg
      character*7  temp1 !document page number sec-pg
      character*7  temp2 !document page number sec-pg

      integer*4    ist,ist2
      integer*4    rlan,lran 

      write(temp1,10,IOSTAT=ist) sec
      write(temp2,10,IOSTAT=ist2) pg
      if ( sec .ne. 0 .and. pg .ne. 0 .and. ist .eq. 0 .and. ist2 .eq. 0) then
         docpg=temp1(lran(temp1):rlan(temp1))//'-'// & 
              temp2(lran(temp2):rlan(temp2))
      else
         docpg = '       '
      endif
      
      return
 10   format(i6)
      end
      

      subroutine itoc(iin,cout)
      implicit none
      
      character*1 carray(10)/'0','1','2','3','4','5','6','7','8','9'/
      character*(*) cout
      integer*4 iin,i,j,k,inarray(100),jmax,a

      cout = ' '                        !clear buffer 

      do j=1,100
         a = int(iin/10**j)*10          !find one digit
         jmax = j                       !store max
         inarray(j)=int(iin/10**(j-1))-a!determine individual unit
         if (a.eq.0) goto 200           !no more numbers
      enddo
 200  continue

      do i=1,jmax
         k=jmax-i+1
         cout(i:i)=carray(inarray(k)+1)
      enddo
      return
      end


      subroutine getdpath(path,selection)
      implicit none

      character*(*) path
      character*80  out_array(6),output
      character*23  in_array(6) /'autotest_data_directory', & 
                                 'autotest_data_director2', & 
                                 'autotest_data_director3', & 
                                 'autotest_data_director4', & 
                                 'autotest_data_director5', & 
                                 'autotest_data_director6'/
      character*23  input
      integer       ftn_getcfg
      integer       rval(6)                    !path valid flag
      integer       selection                  !sim data path selection
      integer       i,imin,imax                !loop counters
      integer       lrbl                       !str len
      integer       isel                       !user selection
      integer       ival                       !valid path counter
	  integer*4		seekpos /0/				   ! for calls ro GetCfg

! This program will call ftn_getcfg and find all pertinent data
! paths for this project.  This is needed for simulators which
! contain multiple data sets and subsequently multiple data paths.

! If called by a utility, it will automatically select a path if
! only one is present or it will produce a menu otherwise.

! During the simulation, the label for simulator type will be passed
! to the 990 module which will select the appropriate data path.


 100  if (selection.le.0) then                 !utility active
         imin = 1
         imax = 6
      else                                     !simulation active
         imin = selection
         imax = selection
      endif

 !     ival = 0                                 !valid path counter
 !     do i=imin,imax                           !scan for paths 
 !        input        = in_array(i)
 !        rval(i)      = GetCfg("flt_output"C, "C:\\SIMnt\\Config\\sim.cfg"C,input,seekpos, "%s", output)
 !        if (rval(i).eq.0) ival = ival + 1
 !        out_array(i) = output
 !     enddo

 !     if (selection.le.0) then                 !utility
 !        if (ival.eq.1) then                   !auto select path
 !           do i=imin,imax
 !              if (rval(i).eq.0) isel = i
 !           enddo
 !        else                                  !produce menu
 
 !           write (*,*) ' '
 !           write (*,*) ' Select one of the following DATA paths:'
 !           write (*,*) ' '
 !           do i=imin,imax
 !              if (rval(i).eq.0) & 
 !               write (*,'(a,i2,2a)') ' ',i,'.  '// & 
 !                     out_array(i)(:lrbl(out_array(i)))
 !           enddo
 !           write (*,*) ' '
 !           read (*,*,err=100) isel
 !           if (isel.lt.1 .or. isel.gt.6) goto 100
 !           if (rval(isel).eq.-1) goto 100
 !        endif
 !     else                                     !autoload for sim
 !        isel = selection
 !     endif

 !     path = out_array(isel)
 !     selection = isel
!      path = 'C:\simnt\simtarget\data\aero'
      path = 'd:\700'
      selection = 1

      return
      end

      subroutine spinner(string)
      implicit none

      character*(*) string
      character*8   cspin /'-\|/-\|/'/
      integer*4     up    /Z'201b5b41'/
      integer*4     i     /0/
      integer*4     lrbl

      i = i + 1
      if (i.gt.8) i = 1
      write (*,'(3a)') string(:lrbl(string))//' ',cspin(i:i),up

      return
      end

      subroutine ps_do_top(lu,line,page_label,page_no,  &
                          pg_doc,sec_doc,testnum,paper_size)
      implicit none

      INCLUDE "flt_plot.inc" 

      integer*4 lu                      !logical unit to write to
      integer   line                    !line number
      character*(*) page_label          !page label
      integer   page_no                 !total page number
      integer   pg_doc                  !document page number
      integer   sec_doc                 !document section number
      integer*4 testnum                 !test number
      integer*4 paper_size              !demanded paper size

      character*132 cline               !init.conditions output line
      character*7 secpg                 !doc page number sec-page  
      character*6 testno                !character of test number
      logical     do_header             !header flag
      integer     rlan                  !str len


!           Set up post script file for output
      do_header = page_label(1:2).eq.'IC' .or.  & 
                  page_label(1:5).eq.'Ratio'.or.  & 
                  page_label(1:4).eq.'Peak'
      line = 3
      if ( paper_size .eq. 2  ) write(lu,10) 'set_paper_a4'
      if ( jobcode .ne. ' ') then
         write(lu,10)'/JOB ('//jobcode(:rlan(jobcode))//') def'
      endif
      write(cline,*) page_label,page_no
      write(lu,10) '%%Page: '//cline(:rlan(cline))
      write(lu,10) 'grestore'      !to make it compatible with IBM
      write(lu,10) '0 draw_border' !draw plotborder with time and date
      write(testno,'(i6)') testnum
      write(cline,1103) testnum,ftestname
      write(lu,10)  &
          '/TESTNO ('//cline(:rlan(cline))//') def do_testno'
 1103 format(i6,5x,a,a,i2)

      pg_doc = pg_doc + 1                     !bump page number
      call doc_pg(pg_doc,sec_doc,secpg)
      write(lu,10) '/PAGE    ('//secpg//') def do_page'
 1100 format(A,I5,A)

      cline = simname
      write(lu,10) & 
           '/SIM    ('//cline(:rlan(cline))//') def do_sim'

      cline=title(:32)
      write(lu,10) & 
           '/TITLE  ('//cline(:rlan(cline))//') def do_title'
         if (do_header) then
            write(lu,1100) 'fnt2b ',line,' TITLE shwtc'
            line = line + 1
         endif

      if (comment(1:1) .ne. ' ' )then
         cline=comment
         write(lu,10) '/COMMENT ('//cline(:rlan(cline))// & 
              ') def do_comment'
         if (do_header) then
            write(lu,1100) 'fnt2b ',line,' COMMENT shwtc'
            line = line + 1
         endif
      else
         write(lu,10) '/COMMENT () def'
      endif

      if (do_header) then
         write(lu,1100) 'fnt2b ',line,' ('//testno//') shwtc'
         line = line + 1
      endif

      if ( chtime(3:3) .ne. ':' .or. & 
           ( chdate(8:8) .ne. '1' .and. chdate(8:8) .ne. '2' ) ) then
         call get_date()
      endif

      
      write(lu,10) '/DATE  ('//chdate(1:12)//') def do_date'
      write(lu,10) '/TIME  ('//chtime(1:8)//')  def do_time'
      
      line = line + 4

 10   format(a)
      return
      end

      subroutine chk_spike (i,j,time,flag)
      implicit none

      logical flag
      integer i,j,k
      real    time(5,6)
      real    deltat(5),sum,ave


! This subprogram checks for spikes in the damping ratio analysis
! data.  If a data spike is found, it is flagged and subsequently 
! ignored.
! 
! Here's the logic to find spikes:
!   a) If this is first point : exit
!   b) If time diff is less than 0.7 sec : exit (changed : was 1.0)
!   c) If time diff is 50% less than average : exit

      flag = .false.
      if (i.eq.1) return

      sum = 0.
      do k=2,i
         deltat(k) = time(k,j)-time(k-1,j)
         if (deltat(k) .lt. 0.7) then
            flag = .true.
            return
         endif

         sum = sum + deltat(k)
         ave = sum/(k-1)
         if (deltat(k) .lt. ave*0.5) then
            flag = .true.
            return
         endif
      enddo

      return
      end


      subroutine spike_find (i,xi,diff,x,y,xlast,ylast, & 
                             min,max,timed,value,index)
      implicit none

      integer*4 i                              !point index
      integer*4 xi                             !No of spikes found
      integer*4 index                          !index for timed and value
      real*4 diff,x,y,xlast,ylast
      real*4 timed(5,6)
      real*4 value(5,6)
      real*4 n /0.000001/
      logical*4 min,max,spike

      if ( xi .lt. 6 ) then                    !only do six cycles
         if ( i .eq. 1 ) then                  !setup on firstpass
            diff = 0. 
         else
            diff = y - ylast
         endif
         if (diff.gt.n) then                   !increasing slope
            if (min) then                      !save last time min
               min = .false.                   !reset
               timed(xi,index)=xlast
               call chk_spike(xi,index,timed,spike)
               if (.not.spike) then
                  value(xi,index)=ylast
                  xi = xi+1                     !increase counter
               endif
            endif
            max = .true.                       !searching for max
         elseif (diff.lt.-n) then              !decreasing slope
            if (max) then                      !save last time max
               max = .false.                   !reset
               timed(xi,index)=xlast
               call chk_spike(xi,index,timed,spike)
               if (.not.spike) then
                  value(xi,index)=ylast
                  xi = xi+1                    !increase counter
               endif
            endif
            min = .true.                       !searching for min
         endif
      endif

      return
      end
      subroutine ps_ic_head(lu,line,iclab,icord,st,end)
      implicit none

      integer*4   lu         ! Logical unit to write to
      integer*4   line       ! Line number  in file
      integer*4   st         ! Start of labels to show
      integer*4   end        ! End of labels to show
      integer*4   icord(100)  ! Order of IC variables

      character*36 iclab(100) ! labels for variables
      character*36 labl       !Temp formated label
      character*36 unit      !Temp for units

      include "flt_plot.inc"

!     locals
      integer*4    i,j,k     ! Counter
      integer*4    nl        ! temp line counter
      integer*4    ll        ! Length of label
      integer*4    mvar      ! Longest label length
      integer*4    munit     ! Longest unit
      integer*4    cw        ! Column width

!     Externals
      integer*4    rlan      !Returns 1st char from right
      integer*4    lran      !Returns 1st char from left

! * Set up column widths based on amount of data
!      if ( simin ) then
!         write(lu,*) '1 set_col'
!      else
      write(lu,*) '0 set_col'
!      endif

      write(lu,12) 'fnt1b',line,'uline',line,1,'(Parameter) col_shw'
      write(lu,11) line,2, '(Aircraft Value) col_shw'
!      if ( simin ) then
!         write(lu,11) line,3, '(Simulation IC) col_shw'
!      endif
      write(lu,11) line,4, '(Simulator Value) col_shw'
      line = line + 2

      nl = line
      mvar = 12
      munit = 0
      do i=st,end
         j = index(iclab(icord(i)),'?')
         if ( j .gt. 0 ) then             !remove ? from label
            labl = iclab(icord(i))(1:j-1)
            labl(j:) = iclab(icord(i))(j+1:)
         else
            labl = iclab(icord(i))
         endif
         j = index(labl,':')
         if ( j .gt. 0 ) then  ! Units found move to far right
            unit = labl(j+1:)
            unit = unit(lran(unit):) !remove leading spaces
            ll   = rlan(unit)
            if ( ll .gt. munit ) munit = ll
            ll = rlan(labl(:j-1))
            if (ll .gt. mvar ) mvar = ll
         else
            j = lran(labl)
            if ( j .gt. mvar ) mvar = j
         endif
      enddo

      if ( mvar + munit + 3  .gt. 36 ) then
         cw = 36
      else
         cw = mvar + munit + 3
      endif
      do i=st,end
         j = index(iclab(icord(i)),'?')
         if ( j .gt. 0 ) then             !remove ? from label
            labl = iclab(icord(i))(1:j-1)
            labl(j:) = iclab(icord(i))(j+1:)
         else
            labl = iclab(icord(i))
         endif
         j = index(labl,':')
         ll = rlan(labl)
         if ( j .gt. 0 ) then  ! Units found move to far right
            unit = labl(j+1:)
            unit = unit(lran(unit):) !remove leading spaces
            ll   = rlan(unit)
            labl = labl(:j-1)
            do k=j,36
               labl(k:k) = ' '  !pad space between label and unit
            enddo
            labl(cw-ll:) = unit
         endif
         ll=rlan(labl)
         write(lu,11) nl,1,' ('//labl(:ll)//') col_shw'
         nl = nl + 1
      enddo
      
 11   format(i2,1x,i1,1x,a)   
 12   format(a,1x,i2,1x,a,1x,i2,1x,i1,1x,a)
      return
      end



      
 
      subroutine ps_write_ic(lu,icdata,start,end,col,iord,line)
     
      implicit none

      integer*4   lu         ! Open logical unit to write to 
      integer*4   start      ! Starting point in icdata array
      integer*4   end        ! Endding point in icdata array
      integer*4   col        ! Column to print data in
      integer*4   iord(100)   ! Order index for icdata
      integer*4   line       ! Line number

      real*4      icdata(100) ! Value of data to write

!     Locals
      
      integer*4   i          ! Counters
      integer*4   ln         ! Incremental line numbers

      ln = line
      do i=start,end
         if ( icdata(iord(i)) .ne. -999999.0 ) then
            write(lu,10) ln,col,' (',icdata(iord(i)),') col_shw'
         endif
         ln = ln + 1
      enddo

 10   format(i2,1x,i1,a,f13.4,a)

      return
      end

      subroutine ps_do_xaxis(lu,idx,xmax,xmin,idelx,nfile,ifile)
      implicit none

      integer*4 lu           !Open Logical unit to write to
      integer*4 idx          !Index in freclab array
      integer*4 idelx        !Number of divisions of x axis
      integer*4 ifile        !Data file number 
      integer*4 nfile        !Number of time through

      real*4    xmin         !X minimum scale
      real*4    xmax         !X maximum scale


!     locals
      character*36 labl      !Temp label
      character*132 line     !Temp character string
      character*22 line1     !Y title line1
      character*22 line2     !Y title line2
      character*22 line3     !Y title line3

      integer*4    offset    !offset of legend in 1/16th of x length
      integer*4    xform     !Format of x axis labels
      integer*4    i         !counter

      real*4       delx      !Differrence between xmax and xmin

!     externals
      integer*4 lrbl         !Returns index of first blank starting from left
      integer*4 lran         !Returns index of first char starting from left
      integer*4 rlan         !Returns index of first char starting from right


      include "flt_plot.inc"


      if ( ifile .eq. 1 ) then  ! acd data
         line = 'Aircraft'
         offset  = 1
      elseif ( ifile .eq. 2 ) then  ! sim data
         line = 'Simulator'
         offset  = 14
      elseif ( ifile .eq. 3 ) then  ! pom data
         line = 'MAN'
         offset  = 4
      elseif ( ifile .eq. 4 ) then  ! pom data
         line = 'POM'
         offset  = 4
      else
         line = ' '
         offset  = 0
      endif

      if ( line(1:1) .ne. ' ' ) then !Write legend information
         write(lu,19) offset,line(:lrbl(line))
      endif
 19   format(i3,' (',a,') legend')

      if ( nfile .ne. 1 ) return  !Only write scales once when nfile = 1

! * Get x axis label
      labl = freclab(idx)
      call break_label(labl,line1,line2,line3)

      line=line1(:rlan(line1))//'  '//line2(:rlan(line2))//'  '// & 
            line3(:rlan(line3))

      if ( (xmax .lt. 1. .and. xmax .gt. -1. ) .and. & 
           (xmin .lt. 1. .and. xmin .gt. -1. ) ) then
         write(line1,'(f10.3)') xmax  ! Allow for more decimal points
         write(line2,'(f10.3)') xmin
         xform = 3
      else  ! Standard 1 decimal point
         xform = 1
         write(line1,'(f10.1)') xmax
         write(line2,'(f10.1)') xmin
      endif


      write(lu,10) '/XTITLE ('//line(:rlan(line))// & 
                            ') def do_xtitle'

      write(lu,10) '/XMAX ('//line1(lran(line1):rlan(line1))// & 
                        ') def'
!     >                  ') def do_xmax'
      delx = (xmax - xmin) / idelx

      line = '/XLABELS [ '
      do i=1,idelx-1
         if ( xform .eq. 1 ) then
            write(line3,20) xmin+i*delx
         else
            write(line3,25) xmin+i*delx
         endif
         line=line(:rlan(line))//' ('// & 
              line3(lran(line3):rlan(line3))//')'
      enddo
      line = line(:rlan(line))//' ] def'
      write(lu,10) line(:rlan(line))

      write(lu,10) '/XMIN ('//line2(lran(line2):rlan(line2))// & 
                        ') def x_dolabels'
!     >                  ') def do_xmin'

 10   format(a)
 20   format(f10.1)
 25   format(f10.3)

      return
      end


      subroutine flt_plot(lu,data,npts,xp,yp, idx,ifile,nfile,  &
           grid,numgrids,ymin,ymax,xmin,xmax,idelx,             &
           snap,snapline,tola,tolp, xshft, xgain,ylim)
      implicit none

      real*4    data(100000) !data storage arry
      real*4    xmin         !X minimum scale
      real*4    xmax         !X maximum scale
      real*4    ymin         !Y minimum scale
      real*4    ymax         !Y maximum scale
      real*4    tola         !Absolute tolerance
      real*4    tolp         !Pertcent tolerance
      real*4    xshft        !Xshift value
      real*4    xgain        !Xgain value


      integer*4 ifile        !Data file number 
      integer*4 nfile        !Number of time through
      integer*4 lu           !Open Logical unit to write to
      integer*4 npts         !Number of points to plot
      integer*4 xp           !Start of x data in data array
      integer*4 yp           !Start of y data in data array
      integer*4 idx          !Index in frecnumb defined arrays used for label
      integer*4 numgrids     !Number of grids for this variable
      integer*4 grid         !grid for this plot
      integer*4 snap         !Snap shot flag
      integer*4 idelx        !Number of grid divisions along X axis
      integer*4 yform        !Format for y scales # of decimal points
      integer*4 ll           !length of line

      logical*4 snapline     !Draw line with snapshot symbols
      logical*4 ylim         !Limit Data to bounds of y axis


!     Locals
      integer*4 prplot       !display plot and axis labels
      integer*4 i,j,k        !loop counters
      integer*4 sympts       !Number of symbols to draw ger grid

      logical*4 start        !start flag


      character*132 bline    !output line
      character*40 dxline    !data part of line
      character*40 dyline    !data part of line
      character*36 labl      !Temp label
      character*20 line      !type of lines
      character*22 line1     !Y title line1
      character*22 line2     !Y title line2
      character*22 line3     !Y title line3
      character*20 sym       !type of symbols
      character*40 dcntl     !Data control of how each point is displayed
      character*2  lstyle    !line style
      character*2  sstyle    !symbol style


      real*4    x            !Temp x value
      real*4    y            !Temp y value
      real*4    xspc         !Xvalue between points
      real*4    nextx        !X value for next symbol
      real*4    delx         !Real number of grid divisions along X axis

      include "flt_plot.inc"

!     Externals 
      integer*4  rlan        !returns index of most right non-blank
      integer*4  lran        !returns index of most left  non-blank
      

      lstyle = '  '
      sstyle = '  '
      if     ( ifile .eq. 1 ) then !Acd data
         lstyle(2:2) = '1'
         sstyle(2:2) = '1'
         sympts = 0
      elseif ( ifile .eq. 2 ) then !Sim data
         lstyle(2:2) = '2'
         sstyle(2:2) = '2'
         sympts = 20
      elseif ( ifile .eq. 3 ) then !Man data
         lstyle(2:2) = '3'  !use pom style for now
         sstyle(2:2) = '3'
         sympts  = 25
      elseif ( ifile .eq. 4 ) then !Pom data
         lstyle(2:2) = '3'
         sstyle(2:2) = '3'
         sympts  = 15
      elseif ( ifile .eq. 5 ) then !Sim.1 data
         lstyle(2:2) = '4'
         sstyle(2:2) = '4'
         sympts = 20
      elseif ( ifile .eq. 6 ) then !Sim.2 data
         lstyle(2:2) = '5'
         sstyle(2:2) = '5'
         sympts = 20
      elseif ( ifile .eq. 7 ) then !Tolerance
         lstyle(2:2) = '6'
         sstyle(2:2) = '6'
         sympts = 0
      endif

      if ( snap .gt. 0 ) sstyle(1:1) = '1'       !Add 10 to style
      if ( snap .gt. 0 .and. .not. snapline ) then !Don't draw line 
         lstyle(2:2) = '7'
      elseif ( snap .gt. 0 ) then
         lstyle(1:1) = '1'       !Add 10 to style
      endif
      

      if ( sympts .gt. 0 ) then
         xspc = ( xmax - xmin )/ sympts
      else
         xspc = 0.
      endif

      if ( nfile .eq. 1 ) then
         prplot = 1
      else
         prplot = 0
      endif

! * Calculate number of vertical lines
      delx = xmax - xmin
      if ( delx .lt. 6 ) delx = delx * 10.
      do while ( delx .gt. 50 ) 
         delx = delx / 10.
      enddo
      idelx = int(delx)
      i = 10
      if ( idelx .eq. 15 .or. idelx .eq. 30 ) idelx = 6
      if ( idelx .eq. 20 .or. idelx .eq. 40 ) idelx = 8
      if ( idelx .eq. 25 ) idelx = 5

      do while ( mod(idelx,i) .ne. 0 )
         i = i - 1 
      enddo
      idelx = i

      write(lu,*) xmin,xmax,'xset ',idelx,' x_doscale'

      if ( prplot .eq. 1 ) then ! Draw the plot grid and y axis label
         write(lu,*) grid,numgrids,' 1 set_plot %grid #grid 1 draw plot'
         labl = freclab(idx)
         call break_label(labl,line1,line2,line3)

         write(lu,40) line1(:rlan(line1)),line2(:rlan(line2)), & 
                      line3(:rlan(line3)),numgrids  

         write(lu,*) ymin,ymax,' yset y_doscale'
         if ( (ymax .lt. 1. .and. ymax .gt. -1. ) .and. & 
              (ymin .lt. 1. .and. ymin .gt. -1. ) ) then
            yform = 3
         else
            yform = 1
         endif
         if ( yform .eq. 1 ) then
            write(lu,10) '/YMIN (',ymin,') def do_ymin'
         else
            write(lu,11) '/YMIN (',ymin,') def do_ymin'
         endif

         if ( numgrids .gt. 1 ) then !Write Y labels for intermediate grids
            x = (ymax - ymin ) / numgrids
            do i = 1,numgrids-1
               y = ymax - x * i
               if ( yform .eq. 1 ) then
                  write(lu,15) '/YINT (',y,') def ',i,' do_yint'
               else
                  write(lu,16) '/YINT (',y,') def ',i,' do_yint'
               endif
            enddo
         endif
         if ( yform .eq. 1 ) then
            write(lu,10) '/YMAX (',ymax,') def do_ymax'
         else
            write(lu,11) '/YMAX (',ymax,') def do_ymax'
         endif
      elseif ( npts .gt. 0 ) then
         write(lu,*) grid,numgrids,' 0 set_plot '
         write(lu,*) ymin,ymax,' yset y_doscale'
      endif


! * Write line and symbol style - even if no data - legend uses these settings
	  write(lu,*) 'gsave '//lstyle//' '//sstyle//' set_line'

      if ( npts .le. 0 ) then !If no data to plot exit gracefully
         write(lu,*) 'stroke grestore'
         return                 !return if no data to plot
      endif

      start = .false.
      nextx = data(xp)  ! plot first point with symbol

      tolp = tolp / 100. !Adjust to decimal from percent
      bline = ' '
      ll = 1
      do i=0,npts-1
         x = data(xp+i)
         y = data(yp+i)

! *    Adjust Y value by tolerance for tolerance lines
         if ( tola .ne. 0. .or. tolp .ne. 0. ) then
            if ( abs(y * tolp) .gt. abs(tola) ) then
               y = y + (tolp * y)*sign(1.,y)   !use percent tolerance
            else
               y = y + tola       !use absolute tolerance
            endif
         endif

!      Limit Y to bounds of plot if desired
         if ( ylim ) then

			if ( y .gt. ymax ) y = ymax

			if ( y .lt. ymin ) y = ymin
!            y = flimit(y,ymax,ymin)
         endif

!        Adjust x by shift and gain
         x = ( x + xshft ) * xgain

!        Only plot data that is between xmin and xmax

         if ( x .ge. xmin .and. x .le. xmax ) then

            if ( ((x .ge. nextx .or. i .eq. npts-1).and. sympts .gt. 0) & 
                 .or. snap .gt. 0 ) then
               dcntl = ' drawsym'  !display the current symbol
               nextx = nextx + xspc !Set X for next symbol
            else
               dcntl = ' '
            endif

            if ( .not. start ) then
               dcntl = ' strt '//dcntl
            else
               dcntl = ' extnd '//dcntl
            endif
! *       Print data if normal data or if fsnap != 0. 
            if ( snap .le. 1 .or.  & 
                 ( snap .gt. 1 .and. data(snap+i) .ne. 0.) ) then

               write(dxline,*) x
               write(dyline,*) y
               bline = bline(:ll)//' '// & 
                    dxline(lran(dxline):rlan(dxline))//' '// & 
                    dyline(lran(dyline):rlan(dyline))//' '// & 
                    dcntl(:rlan(dcntl))
!               write(lu,20) x,y,dcntl(:rlan(dcntl))
               ll = rlan(bline)
               if ( ll .gt. 85 ) then
                  write(lu,'(a)') bline(:ll)
                  bline =  ' '
                  ll = 1
               endif
               if ( .not. start ) start = .true.
            endif

         endif
      enddo
      if ( ll .gt. 0 ) write(lu,'(a)') bline(:ll)
         
      write(lu,*) 'stroke grestore'
      
 10   format(a,f10.1,a)
 11   format(a,f10.3,a)
 15   format(a,f10.1,a,i1,a)
 16   format(a,f10.3,a,i1,a)
 20   format(f12.4,1x,f12.4,a)
 30   format(a,a,a,1x,i1,1x,a)
 40   format('/YTITLE [(',a,') (',a,') (',a,') ] def ',i1,' do_ytitle')

      return
      end


      subroutine anal_damp(dataarr,npts,xptr,yptr,xstrt, & 
                           ifile,period,zeta,xd,pval,ptime)

      implicit none
      
      real*4     dataarr(100000)   !Data array
      real*4     period(2)         !Period of oscillation
      real*4     zeta(2)           !Damp ratio
      real*4     xstrt             !Starting point in x
      real*4     xd(2,2)           !Calc parameters used to define zeta
      real*4     pval(2,5)         !Peak values
      real*4     ptime(2,5)        !Time of peaks
      real*4     term              !Used in calc of damp ratio

      integer*4  ifile             !File index
      integer*4  npts              !Number of points
      integer*4  xptr              !X location in data array
      integer*4  yptr              !Y location in data array

! *   locals

      real*4     kzet /0.5 /       !Filter damping
      real*4     wn                !Filter frequency
      real*4     dt                !Time step
      real*4     s1,s2,s3,s4,s5,s6 !Filter parameters
      real*4     s7,s9             !""
      real*4     x(5000)           !Xdata
      real*4     y(5000)           !Ydata
      real*4     in                !Unfiltered y 
      real*4     slope             !Local slope of the data
      real*4     inter             !Y Intercept of line between peaks
      real*4     keps /0.000001/   !Small number

      integer*4  i,j,k             !Counters
      integer*4  np                !Number of valid points
      integer*4  npeaks            !Number of peaks found
      integer*4  idx               !Pointer into data arrays

      logical*4  min               !Flag to show if looking for a min peak
      logical*4  max               !Flag to show if looking for a max peak

      if ( npts .gt. 5000 ) then
         npts = 5000
      endif
      
      if( ifile .eq. 1 ) then
         idx = 1   !ACD data
      else
         idx = 2   !SIM or MAN data
      endif

      do i=1,5
         ptime(idx,i) = 0.
         pval(idx,i)  = 0.
      enddo

! * Extract desired data from data array
      np = 0
      do i=0,npts-1
         if ( dataarr(xptr+i) .gt. xstrt .and. np .eq. 0 ) then
            np = i+1
         endif
         x(i+1) = dataarr(xptr+i)
         y(i+1) = dataarr(yptr+i)
      enddo
      

! * Extract frame time
      dt = ( dataarr(npts+xptr-1) - dataarr(xptr) ) / (npts-1)

      wn = 1.0 / dt

      if ( dt .gt. 0.5 ) then
         kzet = 5.
      else
         kzet = .5
      endif
     
! * Calculate filter parameters

      s1 = wn * wn * dt * dt
      
      s2 = 1. / (4. + 4. * kzet  * wn * dt + s1)
      
      s7 = 4. - 4. * kzet * wn * dt + s1
      
      s9 = -8. + 2. * s1
         
! * Filter the  y data
      do i=1,npts
         if ( i .eq. 1) then
            y(i) = y(i)
            s5  = 0.
            s6  = 0.
            s4  = 0.
            s3  = y(i)
         else
            s6  = s5
            s5  = y(i-1)
            in  = y(i)

            y(i)   =   s2 * (s1 * ( in + 2.*s3 + s4 ) -   & 
                 s5 * s9 - s6 * s7 )

            s4 = s3
            s3 = in
         endif
      enddo

! * Find Peaks

      i = np + 1
      npeaks = 0
      min = .false.
      max = .false.

      do while ( i .le. npts .and. npeaks .lt. 5 )
         slope = y(i) - y(i-1)
         if ( slope .gt. keps ) then
            if ( min ) then
               min = .false.
               npeaks = npeaks + 1
               ptime(idx,npeaks) = x(i-1)
               pval(idx,npeaks)  = y(i-1)
            endif
            max = .true.
         elseif ( slope .lt. -keps ) then
            if ( max ) then
               max = .false.
               npeaks = npeaks + 1
               ptime(idx,npeaks) = x(i-1)
               pval(idx,npeaks)  = y(i-1)
            endif
            min = .true.
         endif
         i = i + 1
      enddo

      if ( npeaks .ge. 4 ) then  !Enough data
         slope = (pval(idx,3) - pval(idx,1)) / & 
                 (ptime(idx,3)-ptime(idx,1))
         inter = pval(idx,3) - slope*ptime(idx,3)
         xd(idx,1) = abs(pval(idx,2) - (slope*ptime(idx,2) + inter))

         if ( npeaks .lt. 5 ) then !1/2 cycle will bw used
            slope = (pval(idx,4) - pval(idx,2)) / & 
                    (ptime(idx,4)-ptime(idx,2))
            inter = pval(idx,4) - slope*ptime(idx,4)
            xd(idx,2) = abs(pval(idx,3) - (slope*ptime(idx,3) + inter))

            period(idx) = ptime(idx,3) - ptime(idx,1)
            
            term   = 1.
         else  !Use full cycle analysis
            slope = (pval(idx,5) - pval(idx,3)) / & 
                    (ptime(idx,5)-ptime(idx,3))
            inter = pval(idx,5) - slope*ptime(idx,5)
            xd(idx,2) = abs(pval(idx,4) - (slope*ptime(idx,4) + inter))

            period(idx) = (ptime(idx,5) - ptime(idx,1)) / 2.

            term = .5
         endif

         term = ( term * log(xd(idx,2)/xd(idx,1)) ) / (3.141593)
         zeta(idx) = -term/sqrt(1.+term**2)

      else !No analysis
         period(idx) = 0.
         zeta(idx)   = 0.
      endif

      return
      end
      
      subroutine do_table(luid,line,xlab,ylab,time,val)

      implicit none

      real*4     val(2,5)   !Peak values 
      real*4     time(2,5)  !Time values of peaks 

      integer*4  i          !Counter
      integer*4  luid       !Logical unit for writing to
      integer*4  line       !Current line number

      character*132 cline   !Output character string line
      character*36 xlab     !X label
      character*36 ylab     !Y label
     
      character*22 xline1   !Line 1 of x label
      character*22 xline2   !Line 2 of x label
      character*22 xline3   !Line 3 of x label
      character*22 yline1   !Line 1 of y label
      character*22 yline2   !Line 2 of y label
      character*22 yline3   !Line 3 of y label

! * Externals
      integer*4    rlan     !Returns index of last non-blank char in string

!begining table
      call break_label(xlab,xline1,xline2,xline3)
      call break_label(ylab,yline1,yline2,yline3)

      write(cline,14) !Dashes
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,15) !Spacer line
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

!     Write Labels

      write(cline,16) xline1(:rlan(xline1)),yline1(:rlan(yline1)), & 
                      xline1(:rlan(xline1)),yline1(:rlan(yline1))
      write(luid,111) line,cline(:rlan(cline))
      write(cline,15)       ! '|'
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      if ( xline2 .ne. ' ' .or. yline2 .ne. ' ' ) then
         write(cline,16) xline2(:rlan(xline2)),yline2(:rlan(yline2)), & 
                         xline2(:rlan(xline2)),yline2(:rlan(yline2))
         write(luid,111) line,cline(:rlan(cline))
         write(cline,15)    ! '|'
         write(luid,11) line,' ('//cline(:rlan(cline))//')'
         line = line + 1
      endif
      if ( xline3 .ne. ' ' .or. yline3 .ne. ' ' ) then
         write(cline,16) xline3(:rlan(xline3)),yline3(:rlan(yline3)), & 
                         xline3(:rlan(xline3)),yline3(:rlan(yline3))
         write(luid,111) line,cline(:rlan(cline))
         write(cline,15)    ! '|'
         write(luid,11) line,' ('//cline(:rlan(cline))//')'
         line = line + 1
      endif

      write(cline,15)       !Spacer line
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1
      
!     Write data      

      do i = 1,5
         if ( time(1,i) .gt. 0. .and. time(2,i) .gt. 0.) then
            write(cline,17) time(1,i),val(1,i),time(2,i),val(2,i)
            write(luid,11) line,' ('//cline(:rlan(cline))//')'
            line = line + 1
         elseif ( time(1,i) .gt. 0. ) then
            write(cline,17) time(1,i),val(1,i)
            write(luid,11) line,' ('//cline(:rlan(cline))//')'
            line = line + 1
         elseif ( time(2,i) .gt. 0. ) then
            write(cline,18) time(2,i),val(2,i)
            write(luid,11) line,' ('//cline(:rlan(cline))//')'
            line = line + 1
         endif
      enddo

 11   format('fnt1 ',I5,A,' shw')
 111  format('fnt1 ',I5,A,' shwtc4')
 14   format(T6,62('-'))
 15   format(T36,'|')
!dv 16   format(T6,A,T21,A,T36,'|',T40,A,T55,A)
 16   format(1x,'(',A,') (',A,') (',A,') (',A,')')
 17   format(t4,f10.2,t20,f10.2,t36,'|',t40,f10.2,t56,f10.2)
 18   format(t36,'|',t40,f10.2,t56,f10.2)
! end of table
      return
      end

      subroutine ps_write_peak(luid,xin,ryin,byin, & 
                               rval,rtime,bval,btime)

      implicit none

      real*4    rval(2,5)   !Peak values from roll/beta analysis
      real*4    bval(2,5)   !Peak values from roll/beta analysis
      real*4    rtime(2,5)  !Time values of peaks from roll/beta analysis
      real*4    btime(2,5)  !Time values of peaks from roll/beta analysis

      integer*4  luid       !Logical unit for writing to
      integer*4  xin        !roll X label index
      integer*4  ryin       !roll Y label index
      integer*4  byin       !beta Y label index

! * Locals
      logical*4 peak_tol    !peaks in tolerance
      integer*4 i,j
      integer*4 line        !Current line number

      character*132 cline   !Output character string line
      character*132 cline2  !Output character string line
      character*36 xlab     !roll X label
      character*36 ylab     !roll Y label
     
      real*4 dt_average(2)  !average delta time
      real*4 dt(2,5)        !delta time

! * Externals
      integer*4    rlan      !Returns index of last non-blank char in string

      include "flt_plot.inc"

! Do page title and roll table 

      xlab = freclab(xin)
      ylab = freclab(ryin)

      line = 9
      write(luid,10) line,' (Roll-Sideslip Peak Analysis)'
      line = line + 4 

      write(cline,12) !Working parameters
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 2

      write(cline,13) !Aircraft Simulator
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

! Write Table for Roll

      call do_table(luid,line,xlab,ylab,rtime,rval)

      write(cline,15) !Spacer line
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,15) !Spacer line
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1


! Write Table for Sideslip

      ylab = freclab(byin)

      call do_table(luid,line,xlab,ylab,btime,bval)

!     Calculate delta time between Beta and Roll
      do i = 1,2
         do j = 1,5
            dt(i,j) = btime(i,j) - rtime(i,j)
         enddo
      enddo

! Writes dt values
      line = line + 5
      write(cline,21) !final computed data
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 2


      write(cline,13) !Aircraft Simulator
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,14) !Dashes
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      dt_average = 0.0
      do i=1,5
         write(cline,26) dt(1,i),dt(2,i)
         write(luid,11) line,' ('//cline(:rlan(cline))//')'
         write(luid,111) line !delta symbol
         line = line + 1
         if (dt(1,i).ne.0.0) dt_average(1) = dt_average(1)+dt(1,i)
         if (dt(2,i).ne.0.0) dt_average(2) = dt_average(2)+dt(2,i)
      enddo

      
      write(cline,27) 
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1



      write(cline,28) dt_average(1)/(i-1), & 
           dt_average(2)/(i-1)
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      write(luid,111) line  !delta symbol
      write(cline,15)       !Spacer line
      write(luid,11) line,' ('//cline(:rlan(cline))//')'


      line = line + 4

      peak_tol=.true.
      do i=1,5
         if ((dt(1,i).ne.0.0).or.(dt(2,i).ne.0.0)) then
            if (abs(dt(1,i)-dt(2,i)).gt.1.0)  & !tolerance is 1.0 sec
                 peak_tol = .false.
         endif
      enddo

      cline=' '
      cline2=' '
      if (peak_tol) then
         cline(20:)='PEAKS ARE      TOLERANCE OF +/- 1.0 SEC.'
         cline2(30:) = '"IN"'
      else
         cline(23:)='PEAKS ARE          TOLERANCE.    '
         cline2(33:) = '"OUT OF"'
      endif
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      write(luid,24) line,' ('//cline2(:rlan(cline2))//')'


      return
 10   format('fnt3b ',I5,A,' shwtc')
 11   format('fnt1 ',I5,A,' shw')
 111  format('fnt1s ',I5,' (D) shws')
 12   format(T19,'Working Parameters for Calculations')
 13   format(T17,'AIRCRAFT',T47,'SIMULATOR')
 14   format(T6,62('-'))
 15   format(T36,'|')
 17   format(t4,f10.2,t20,f10.2,t36,'|',t40,f10.2,t56,f10.2)
 18   format(t36,'|',t40,f10.2,t56,f10.2)
 21   format(T26,'Final Computed Outputs')
 24   format('fnt1b ',I5,A,' shw')
 26   format(T13,' t =',F12.2,' sec',T36,'|',T41,' t =',F12.2,' sec')
 27   format(T13,21('-'),T36,'|',T41,21('-'))
 28   format(T4,'Average:  t =',F12.4,' sec',T41,' t =',F12.4,' sec')
      end
      

      subroutine ps_write_damp(luid,xin,yin,period,zeta, & 
                 xd,zval,ztime)

      implicit none

      real*4     period(2)             !Period for damp ratio analysis
      real*4     zeta(2)               !Damping ration from analysis
      real*4     xd(2,2)               !X1 and X2 parameters from damp analysis 
      real*4     zval(2,5)             !Peak values from damp analysis
      real*4     ztime(2,5)            !Time values of peaks from damp analysis

      integer*4  i                     !Counter
      integer*4  luid                  !Logical unit for writing to
      integer*4  xin                   !X label index
      integer*4  yin                   !X label index

! * Locals
      integer*4   line      !Current line number

      character*132 cline   !Output character string line
      character*132 cline2  !Output character string line
      character*36 xlab     !X label
      character*36 ylab     !Y label
     
! * Externals
      integer*4    rlan      !Returns index of last non-blank char in string

      include "flt_plot.inc"

! * If not anlaysis set values to print ****** on page
      do i=1,2
         if ( period(i) .eq. 0 ) then
            period(i) = 9999999999.
            zeta(i)   = 9999999999.
         endif
      enddo

      xlab = freclab(xin)
      ylab = freclab(yin)

      line = 9
      write(luid,10) line,' (Damping Ratio Analysis)'
      line = line + 4 

      write(cline,12) !Working parameters
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 2

      write(cline,13) !Aircraft Simulator
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      call do_table(luid,line,xlab,ylab,ztime,zval)

      write(cline,15) !Spacer line
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,15) !Spacer line
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

 10   format('fnt3b ',I5,A,' shwtc')
 11   format('fnt1 ',I5,A,' shw')
 12   format(T19,'Working Parameters for Calculations')
 13   format(T17,'AIRCRAFT',T47,'SIMULATOR')
 14   format(T6,62('-'))
 15   format(T36,'|')
 17   format(t4,f10.2,t20,f10.2,t36,'|',t40,f10.2,t56,f10.2)
 18   format(t36,'|',t40,f10.2,t56,f10.2)

      write(cline,19) xd(1,1),xd(2,1)
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,20) xd(1,2),xd(2,2)
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 5
      
      write(cline,21) !final computer data
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 2

      write(cline,13) !Aircraft Simulator
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,14) !Dashes
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,22) zeta(1),zeta(2) 
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      write(cline,23) period(1),period(2) 
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 5
      
 19   format(T13,'X1 =',F12.4,T36,'|',T41,'X1 =',F12.4)
 20   format(T13,'X2 =',F12.4,T36,'|',T41,'X2 =',F12.4)
 21   format(T26,'Final Computed Outputs')
 22   format(T6,'Damping Ratio  =',F12.4,T36,'|', & 
           T39,'Damping Ratio  =',F12.4)
 23   format(T6,'Period         =',F12.4,T36,'|', & 
           T39,'Period         =',F12.4)
      
      cline = ' '
      if ( period(1) .gt. 999. ) then
         cline='NOT ENOUGH AIRCRAFT DATA FOR ANALYSIS.'
         write(luid,11) line,' ('//cline(:rlan(cline))//')'
         line = line + 1
      endif
            
      if ( period(2) .gt. 999. ) then
         cline='NOT ENOUGH SIMULATOR DATA FOR ANALYSIS.'
         write(luid,11) line,' ('//cline(:rlan(cline))//')'
         line = line + 1
      endif

      cline= ' '
      cline2= ' '
      if ( period(1) .gt. 999. .or. period(2) .gt. 999.) then
         cline(14:)= & 
              'MISSING DATA FOR COMPARISON OF DAMPING RATIO.'
      elseif (abs(zeta(1)-zeta(2)).le.0.02) then
         cline(16:) = 'DAMPING RATIO IS      TOLERANCE OF +/- 0.02.'
         cline2(33:) = '"IN"'
      else
         cline(14:39)='DAMPING RATIO IS          '
         cline(40:66)='TOLERANCE OF +/- 0.02.    '
         cline2(31:) = '"OUT OF"'
      endif
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      write(luid,24) line,' ('//cline2(:rlan(cline2))//')'
      line = line + 1
      
               
      cline=' '
      cline2=' '
      if ( period(1) .gt. 999. .or. period(2) .gt. 999.) then
         cline(17:)='MISSING DATA FOR COMPARISON OF PERIOD.'
      elseif (abs(period(1)-period(2)).le.(0.1*period(1))) then
         cline(20:)='PERIOD IS      TOLERANCE OF +/- 10%.    '
         cline2(30:) = '"IN"'
      elseif (abs(period(1)-period(2)).le.0.5) then
         cline(20:)='PERIOD IS      TOLERANCE OF +/- 0.5 SEC.'
         cline2(30:) = '"IN"'
      else
         cline(21:)='PERIOD IS          TOLERANCE.'
         cline2(31:) = '"OUT OF"'
      endif
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      write(luid,24) line,' ('//cline2(:rlan(cline2))//')'
      line = line + 6

      
      cline = 'For further information with'// &
           ' respect to the working parameters or the results'
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      cline = 'from these calculations please refer to Appendix D of ' 
      write(luid,11) line,' ('//cline(:rlan(cline))//')'
      line = line + 1

      cline = 'the Qualification Test Guide.'
      write(luid,11) line,' ('//cline(:rlan(cline))//')'

 24   format('fnt1b ',I5,A,' shw')

      return
      end
      

      subroutine break_label(label,l1,l2,l3)

      implicit none

      character*36 label     !Input label
      character*22 l1        !Line 1 of output      
      character*22 l2        !Line 2 of output
      character*22 l3        !Line 3 of output

! * Locals
      character*36 labl      !copy of input label

      integer*4    i,j,k     !counters

! * Externals 
      integer*4    rlan      !Index of last non-blank character in string 
      integer*4    lran      !Index of first non-blank character in string 

      labl = label
      i=index(labl,'?')
      j=index(labl,':')
      if ( j .gt. 0 ) then
         l3 = labl(j+1:)
         l3 = l3(lran(l3):)
         l3 = '('//l3(:rlan(l3))//')'
         labl=labl(:j-1)        !remove everthing after :
      else
         l3 = ' '
      endif
      if ( i .gt. 0 ) then      !line split specified
         l2 = labl(i+1:rlan(labl))
         l1 = labl(:i-1)
      else                      !No line break specified
         i = rlan(label)
         if ( i .gt. 19 ) then  ! Manually split line
            j = 19
            k = 0
            do while ( k .eq. 0 .and. j .gt. 0 ) 
               if ( labl(j:j) .eq. ' ' ) k = j
               j = j - 1
            enddo
            
            j = 19
            i = 0
            do while ( j .le. 24 .and. i .eq. 0 ) !Allow for lines of 24
               if ( labl(j:j) .eq. ' ' ) i = j
               j = j + 1
            enddo
!     Unable to find a good space force break
            if ( k .eq. 0 .and. i .eq. 0) then !no space found force break
               k = 19 
            elseif( k .eq. 0 ) then  !Space found after 19
               k = i
            elseif( i .ne. 0 .and. k .ne. 0 ) then !Both found use later one
               k = i
            endif   !if k .ne. 0 and i .eq. 0   k = k
            
            if ( k .ge. rlan(labl) ) then
               l1 = labl(:k)
               l2 = ' '
            else
               l1 = labl(:k)
               l2 = labl(k:)
            endif
         else
            l1 = labl
            l2 = ' '
         endif
      endif
      l1 = l1(lran(l1):) !get rid of leading spaces
      l2 = l2(lran(l2):) !get rid of leading spaces
         
      if ( l2 .eq. ' ' ) then
         l2 = l3
         l3 = ' '
      endif

      return
      end



      subroutine anal_target(dataarr,npts,xptr,yptr,xval,yval, & 
                             ptoff,slope,type,tfnd,ptfnd,xshft,xgain,max,min)



	implicit none

      real*4     dataarr(100000)   !Data array
      real*4     xval              !X value at y target        
      real*4     yval              !Y target value

	  real*4     max               !Max value of data plotted

	  real*4     min               !Min value of data plotted

	  real*4     xshft             !X data shift

	  real*4     xgain             !X data gain

      logical*4  tfnd              !Found target value

      integer*4  npts              !Number of points
      integer*4  xptr              !X location in data array
      integer*4  yptr              !Y location in data array

	  integer*4  ptfnd             !Pointer offset to found point

	  integer*4  ptoff             !Pointer offset to start analysis

      integer*4  slope             !0=either 1=ascend 2=descend
      integer*4  type              !=1 find X val based on yval else find y

! * Locals
      integer*4  i,j,k             !Counters
      integer*4  ptrx              !Local Pointer to indep
      integer*4  ptry              !Local Pointer to depend

      real*4     x1,x2             !Temp consective x values
      real*4     y1,y2             !Temp y for the above x
      real*4     tval              !Target value
      real*4     rval              !Found value
      real*4     ref               !if < 0 tval between two data points
      real*4     m                 !slope of x1 and x2


      rval = -999999.


      if ( type .eq. 1 ) then
         ptrx = yptr
         ptry = xptr
         tval = yval
      else
         ptrx = xptr
         ptry = yptr
         tval = xval
      endif

      tfnd = .false.

! * Search for point where data bounds search value
      i = ptoff   ! data starts at ptr + 0

	do while ( i .le. npts-1  .and. rval .eq. -999999. )



		if ( type .eq. 1 ) then
			x1 = dataarr(ptrx+i-1)
			x2 = dataarr(ptrx+i)

		else
			x1 = (dataarr(ptrx+i-1)+xshft)*xgain

			x2 = (dataarr(ptrx+i)+xshft)*xgain

		endif





		m = x2 - x1
		if ( (slope .eq. 0 )               .or. & 
			(m .gt. 0 .and. slope .eq. 1) .or. & 
			(m.lt. 0 .and. slope .eq. 2) ) then
			ref = (tval-x1)*(tval-x2)
			if ( ref .le. 0.0 ) then !tval is between x1 and x2

				if ( type .eq. 1 ) then
					y1 = (dataarr(ptry+i-1)+xshft)*xgain
					y2 = (dataarr(ptry+i)+xshft)*xgain

				else

					y1 = dataarr(ptry+i-1)

					y2 = dataarr(ptry+i)

				endif
				if ( x2 .ne. x1 ) then

					if ( (type .ne. 1 .and. x1 .ge. min .and. x2 .le. max ) .or. &

						 (type .eq. 1 .and. y1 .ge. min .and. y2 .le. max ) ) then
						rval = ((y2-y1)/(x2-x1)) * (tval - x1) + y1
						tfnd = .true.

						ptfnd = i

					endif
				endif
			endif
		endif

		i = i + 1
	enddo

      if ( type .eq. 1 ) then
         xval = rval
      else
         yval = rval
      endif

      return
      end


      subroutine anal_pla(dataarr,npts,xptr,yptr,xmin, & 
                          pla_t0,accel,found)

      real*4     dataarr(100000)   !Data array
      real*4     xmin              !min for x axes
      real*4     pla_t0(2)         !start of pla movement(time,y)

      integer*4  npts              !Number of points
      integer*4  xptr              !X location in data array
      integer*4  yptr              !Y location in data array
      logical*4  accel             !eng acceleration flag
      logical*4  found

!     local labels
      
      real*4 y0,y,delta_pla
      real*4 pla_tol /1.0/
      integer*4 i

      found = .false.
      accel = .false.
      y0 = dataarr(yptr)
      i = 1
      do while (i.le.npts-1.and..not.found)
         if (dataarr(xptr+i-1).ge.xmin) then
            y = dataarr(yptr+i)
            delta_pla = y - y0
            if(abs(delta_pla).gt.pla_tol) then
               if (delta_pla.gt.0.0) accel = .true.
               pla_t0(1) = dataarr(xptr+i-1)
               pla_t0(2) = dataarr(yptr+i-1)
               found = .true.
            endif
         endif
         i = i+1
      enddo

      return
      end

      subroutine anal_power(dataarr,npts,xptr,yptr, & 
                            xmin,xmax,pla_t0, & 
                            n1_0,n1_f,n1_10,n1_90, & 
                            found,xshft,xgain)

      real*4     dataarr(100000)   !Data array
      real*4     xmin              !min for x axes
      real*4     xmax              !max for x axes
      real*4     pla_t0(2)         !start of pla movement(time,y)
      real*4     n1_0              !initial n1 (or power param)
      real*4     n1_f              !final n1 (or power param)
      real*4     n1_10(3)          !10% of n1 (or power param)
      real*4     n1_90(3)          !90% of n1 (or power param)
	  real*4     xshft             !X data shift

	  real*4     xgain             !X data gain


      integer*4  npts              !Number of points
      integer*4  xptr              !X location in data array
      integer*4  yptr              !Y location in data array
      logical*4  found

!     local labels
      
      integer*4 i
      logical*4  tfnd10
      logical*4  tfnd90

      found = .false.

      i = 1
      do while (i.le.(npts-1).and.dataarr(xptr+i).le.xmin)
         i = i+1
      enddo
      n1_0 = (dataarr(yptr+i)  & !Average the first three points
             +dataarr(yptr+i+1) & 
             +dataarr(yptr+i+2))/3.0

      i = i+3
      do while (i .le.(npts-1) .and. dataarr(xptr+i) .lt. xmax)
         i = i+1
      enddo
      n1_f = (dataarr(yptr+i-1)  & !Average the last three points
             +dataarr(yptr+i-2) & 
             +dataarr(yptr+i-3))/3.0

      n1_10(2) = n1_0 + (n1_f-n1_0)*0.1
      n1_90(2) = n1_0 + (n1_f-n1_0)*0.9

      call anal_target(dataarr,npts,xptr,yptr,      & !find ti
                       n1_10(1),n1_10(2),1,0,1,tfnd10,i,xshft,xgain,xmax,xmin)

      call anal_target(dataarr,npts,xptr,yptr,      & !find tt
                       n1_90(1),n1_90(2),1,0,1,tfnd90,i,xshft,xgain,xmax,xmin)

      found = tfnd10 .and. tfnd90

      n1_10(3) = (n1_10(1)-pla_t0(1))*0.1 !+/- 10% of ti
      n1_90(3) = (n1_90(1)-n1_10(1))*0.1 !+/- 10% of tt



      return
      end



      subroutine ps_draw_x(luid,grid,x,y,ifile)

      integer*4   luid     !Logical Unit for output
      integer*4   ifile    !Type of file data is from
      integer*4   grid     !Grid

      real*4      x        !X value of data
      real*4      y        !Y value of data

! * Locals

      character*3  text    !text label for data
      character*10 xtext   !value of x in text format
      character*10 ytext   !value of y in text format
      character*28 blk /'                            '/    !Blank text 

      integer*4   offset   !Y offset from data for label
      integer*4   lifile   !Last value of ifile
      integer*4   lgrid    !Last grid term
      integer*4   nxs      !Number of x's per plot

      integer*4   lx       !Length of x
      integer*4   ly       !Length of y

      xtext = '          '
      ytext = '          '

      if ( lifile .eq. ifile .and. grid .eq. lgrid ) then
         nxs = nxs - 25
      else
         nxs = 0
      endif

      if ( ifile .eq. 1 ) then
         text = 'A/C'
         offset = 7
      elseif ( ifile .eq. 2 ) then
         text = 'Sim'
         offset = -7
      elseif ( ifile .eq. 3 ) then
         text = 'MAN'
         offset = 0
      else
         text = 'POM'
         offset = 0
      endif

      offset = offset + nxs
      lifile = ifile
      lgrid  = grid

      if ( x .gt. 99999.0 .or. x .lt. -9999. ) then
         write(xtext,'(f10.0)') x
         lx = 10
      else
         write(xtext,'(f8.2)') x
         lx = 8
      endif
      
      if ( y .gt. 99999.0 .or. y .lt. -9999. ) then
         write(ytext,'(f10.0)') y
         ly = 10
      else
         write(ytext,'(f8.2)') y
         ly = 8
      endif

      write(luid,10) x,y,xtext(:lx),ytext(:ly),blk(:lx+ly+8),offset,text

 10   format(f12.4,1x,f12.4,1x,'((',A,',',A,'))',' (',A,') ', i3,' (',A,') markx')

      return
      end

      subroutine ps_draw_arrow(luid,x,y,tol,type)

      integer*4   luid     !Logical Unit for output
      integer*4   type     !Type of arrow: 1=horizontal, 2 vertical

      real*4      x        !X value of data
      real*4      y        !Y value of data
      real*4      tol      !tolerance

! * Locals

      character*7 text     !text label for data

      if ( type .eq. 1 ) then
         text = 'v_arrow'
      elseif ( type .eq. 2 ) then
         text = 'h_arrow'
      else
         return
      endif

      write(luid,10) x,y,tol,text

 10   format(f12.4,1x,f12.4,1x,f12.4,1x,A)

      return
      end

      subroutine ps_draw_eng(luid,x,y,accel,type)

      integer*4   luid     !Logical Unit for output
      integer*4   type     !Type of time: 1=ti, 2 tt
      logical*4   accel    !accel = .true.

      real*4      x        !X value of data
      real*4      y        !Y value of data


! * Locals

      character*7 text     !text label for data
      integer*4   side     !if accel = +1, else -1

      if ( type .eq. 1 ) then
         text = 'draw_ti'
      elseif ( type .eq. 2 ) then
         text = 'draw_tt'
      else
         return
      endif

      side = 1
      if (accel) side = -1
      

      write(luid,10) x,y,side,text

 10   format(f12.4,1x,f12.4,1x,i2,1x,A)

      return
      end

      subroutine ps_man_rate(luid,x1,x2,isman)
      implicit none

! * Argument List
      real*4    x1                 !First xpoint
      real*4    x2                 !second xpoint
      
      integer*4 luid               !Logical unit for writing to
      integer*4 xp                 !Start of x in data array

      logical*4 isman              !Is manual test flag

! * Locals
      character*4 cstr             !Character string
      real*4    rate               !Recording rate

! * Externals
      if ( isman ) write(luid,*) 'do_man'
      
      if ( x2 .ne. x1 ) then
         rate = 1. / ( x2 - x1 )
         write(cstr,'(f4.1)') rate
         write(luid,*) '/RATE ('//cstr//' Hz) def do_rate'
      endif

      return
      end




	subroutine do_cfd(luid,dataarr,npts,xptr,yptr,cfd_st,xshft,xgain,maxx,minx)

	implicit none



	real*4     dataarr(100000)   !Data array

	real*4     cfd_st            !Time start of analysis - Release

	real*4     maxx              !X axis maximum

	real*4     minx              !X axis minimum

	real*4     xshft             !X data shift

	real*4     xgain             !X data gain



	integer*4  luid              !Output file unit number

	integer*4  npts              !Number of points

	integer*4  xptr              !X location in data array

	integer*4  yptr              !Y location in data array



!   Locals

	integer*4  i,j,k             !Loop counter

	integer*4  cfd_cross         !Number of crossovers

	integer*4  grid    /1/       !Grid Number

	integer*4  npeaks            !Number of peaks found

	integer*4  ptoff             !Pointer offset ie where to start

	integer*4  ptfnd             !Pointer offset where found

	integer*4  side              !Flag for which side to plot tolerances

	integer*4  slope             !Slope flag for anal_target

	integer*4  type              !Type flag for anal_target

	integer*4  cfd_overshoots 

	parameter (cfd_overshoots=5)





	real*4     Ad                !Release value

	real*4     cfd_peak(cfd_overshoots,2)      !overshoot coordinates

	real*4     cfd_trim          !Steady state value

	real*4     keps  /0.000001/  !Very small number but not zero

	real*4     Pn(cfd_overshoots,2)            !Peak values

	real*4     mslope            !Slope flag for anal_target

	real*4     ta(cfd_overshoots)!Tolerance for Peaks

	real*4     tad               !Tolerance in Ad

	real*4     tPn(cfd_overshoots)!Tolerance in Pn

	real*4     x,y               !temp values



	logical*4  flgok             !All points founs successfully

	logical*4  tfnd              !Point found

	logical*4  min               !Minimum

	logical*4  max               !Maximum





	character*10  t1,t2,t3,t4

	character*132 cstr



!	Externals

	integer*4  rlan              !Function to return last non-blank in line





	flgok = .true.



	slope = 0  !Any slope

	type  = 0  !Find y based on x - cfd_st

	x     = cfd_st

	ptoff = 1  !Start at beginning of file



    call anal_target(dataarr,npts,xptr,yptr,x,y, & 

                     ptoff,slope,type,tfnd,ptfnd,xshft,xgain,maxx,minx)



	if ( .not. tfnd ) then

		flgok = .false.

	else

		ad = y

		cfd_trim = 0.0

		do i=1,3

			cfd_trim = cfd_trim + dataarr(yptr+npts-i)

		enddo	

		cfd_trim = cfd_trim / 3.0



		tad = abs(Ad - cfd_trim)*0.05 !Tolerance in Ad



!       Look for first cross over - point where = cfd_trim

		type = 1  !find x based on y = cfd_trim

		y = cfd_trim

		ptoff = ptfnd  !Start looking after release

		call anal_target(dataarr,npts,xptr,yptr,x,y, & 

                             ptoff,slope,type,tfnd,ptfnd,xshft,xgain,maxx,minx)



		if ( tfnd ) then

			Pn(1,1) = x

			Pn(1,2) = y

			tPn(1)  = abs(x-cfd_st)*0.1 !10% tol for P0

		else	

			flgok = .false.

		endif

		

		i = ptoff + 1

		npeaks = 0

		min = .false.

		max = .false.



		do while ( i .le. npts .and. npeaks .lt. cfd_overshoots )

			mslope = dataarr(yptr+i) - dataarr(yptr+i-1)

			if ( mslope .gt. keps ) then

				if ( min ) then

					min = .false.

					npeaks = npeaks + 1

					cfd_peak(npeaks,1) = (dataarr(xptr+i-1)+xshft)*xgain

					cfd_peak(npeaks,2) = dataarr(yptr+i-1)

				endif

				max = .true.

			elseif ( mslope .lt. -keps ) then

				if ( max ) then

					max = .false.

					npeaks = npeaks + 1

					cfd_peak(npeaks,1) = (dataarr(xptr+i-1)+xshft)*xgain

					cfd_peak(npeaks,2) = dataarr(yptr+i-1)

				endif

				min = .true.

			endif

			i = i + 1

		enddo



		tfnd = .false.

		i = 1

		do while ( .not. tfnd .and. i .le. npeaks )

			if ( abs(cfd_peak(i,2)-cfd_trim) .lt. tad) then

				npeaks = i - 1

				tfnd = .true.

			endif

			i = i + 1

		enddo





		do i=1,npeaks

			if ( i .eq. 1 ) then

				ta(i) = abs(cfd_peak(i,2)-cfd_trim)*0.1  !10% tolerance

			else

				ta(i) = abs(cfd_peak(i,2)-cfd_trim)*0.2  !20% tolerance

			endif

		enddo





					



		ptoff = ptfnd + 1

		if (npeaks .eq. 0) then  !Critically-damped step response

			Pn(1,2) = (Ad-cfd_trim)*0.1+cfd_trim

			slope = 0  !Any slope

			type  = 1  !Find x based on y

			y     = Pn(1,2)

			call anal_target(dataarr,npts,xptr,yptr,x,y, & 

                             ptoff,slope,type,tfnd,ptfnd,xshft,xgain,maxx,minx)



			if (tfnd) then

				Pn(1,1) = x

				tPn(1)  = abs(Pn(1,1)-cfd_st)*0.1 !10% tol in Po

				cfd_cross = 1 !count crossings

			else

				flgok = .false.

			endif

		else                !Under Damped Step Response

			cfd_cross = 1

			j = 2

!           Look for Pn



			do while ( cfd_cross .lt. npeaks .and. flgok ) 

				slope = 0  !Any slope

				type  = 1  !Find x based on y

				y     = cfd_trim

				call anal_target(dataarr,npts,xptr,yptr,x,y, & 

                             ptoff,slope,type,tfnd,ptfnd,xshft,xgain,maxx,minx)

				if ( tfnd ) then

					Pn(j,1) = x

					Pn(j,2) = y

					tPn(j)  = abs(Pn(j,1)-Pn(j-1,1))*0.1*(j) !10(n+1)% tol in Pn

					cfd_cross = j

					j = j + 1

					ptoff = ptfnd + 1

				else

					flgok = .false.

				endif



			enddo

		endif	

	endif !if tfnd



!   Write data to post script file

	if ( flgok ) then

		

 		grid = grid + 1

 		if ( grid .eq. 2 ) grid = 0

 		call ps_draw_x(luid,grid,cfd_st,ad,1)

		write(luid,10) 'grestore'

		write(luid,10) 'cfd_line'

		write(luid,20) minx ,Ad,' strt'

		write(luid,20) cfd_st,Ad,' extnd' !from Ad to release point

		write(luid,20) minx,cfd_trim + tad,' strt'

		write(luid,20) maxx,cfd_trim + tad,' extnd' !+T(Ad)

		write(luid,20) minx,cfd_trim - tad,' strt'

		write(luid,20) maxx,cfd_trim - tad,' extnd' !-T(Ad)

		write(luid,10) 'stroke'

		write(luid,10) 'cfd_line1'

		write(luid,20) cfd_st,cfd_trim,' strt' !steady state value

		write(luid,20) maxx,cfd_trim,' extnd'

		write(luid,10) 'stroke'

		write(luid,10) 'grestore'

		write(luid,30) Ad,' draw_ad'

		write(luid,40) cfd_st,cfd_trim,tad,' v_arrow'

		write(luid,20) cfd_st,cfd_trim + tad,' draw_tad'



		side = 1

		if ((Ad-cfd_trim).lt.0.0) side = -1



		if (npeaks.eq.0) then !Critically-damped step response

			write(luid,40) Pn(1,1),Pn(1,2),tPn(1),' h_arrow'

			write(luid,50) Pn(1,1) + tPn(1),Pn(1,2),0,side,' draw_tPn'

		else                     !Under Damped Step Response

			do i=1,cfd_cross

				write(luid,40) Pn(i,1),cfd_trim,tPn(i),' h_arrow'

				write(luid,50) Pn(i,1) + tPn(i),cfd_trim,i-1,side,' draw_tPn'

				side = side*(-1.0) !switch sides for every Pn

			enddo



			side = 1

			if ((Ad-cfd_trim).gt.0.0) side = -1

			do i=1,npeaks

				write(luid,40) cfd_peak(i,1),cfd_peak(i,2),ta(i),' v_arrow'

				if (side.gt.0) then      !draw T(An) on top

					write(luid,50) cfd_peak(i,1),cfd_peak(i,2)+ta(i),i,side,' draw_tAn'

				else                     !draw T(An) below

					write(luid,50) cfd_peak(i,1),cfd_peak(i,2)-ta(i),i,side,' draw_tAn'

				endif

				side = side*(-1)

			enddo

		endif



	endif



 10   format(A)

 20   format(f12.4,f12.4,a)

 30   format(f12.4,a)

 40   format(f12.4,f12.4,f12.4,a)

 50   format(f12.4,f12.4,1x,i1,1x,i2,a)

 60   format(F12.4,f12.4,F12.4,f12.4,'((',A,',',A,'))',1x,'((',A,',',A,'))')



	return

	end








