!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Department        :  61 - flight                             *
!      Module name       :  flt_plottest                            *
!      Module description:  Plot test data offline                  *
!      Rate              :  n/a                                     *
!      Issue             :  n/a                                     *
!      Originator        :  Mike Saladin                            *
!      Date              :  3/8/00                                  *
!      Engineer          :  Mike Saladin                            *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of the FlightSafety International Simulation    *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y  I N T E R N A T I O N A L         *
!            Simulation systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012                          *
!            (918) 259-4000    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!--> REVISION BEGIN

!                            Revision History

! $Id: flt_plottest.f,v 1.1 2000/03/13 22:01:05 saladinm Exp $
! $Log: flt_plottest.f,v $
! Revision 1.1  2000/03/13 22:01:05  saladinm
! Initial revision


!--> REVISION END
      subroutine flt_plottest(fattest,fcplot,fcprtplot,fcpmess,fplotacd, & 
        fplotpom,fplotsim,fplotman,fsimruns,fcptolf)

      implicit none

      character*80  RCSID & 
      /"$Id: flt_plottest.f,v 1.1 2000/03/13 22:01:05 saladinm Exp $"/

      include "flt_plot.inc" 

!--> GLOBAL END

! * Variables for call to flt_output   
      integer*4  fbetavar         !ref 113 Y index for peak analysis beta
      integer*4  fphivar          !ref 113 Y index for peak analysis phi
      integer*4  fpowervar        !ref 113 Y index for accel analysis N1
      integer*4  fplavar          !ref 113 Y index for accel analysis
      integer*4  fcfdvar          !ref 113 Y index for accel analysis
      integer*4  fytarvar(10)     !ref 113 Y target plot index
      integer*4  fxtarvar(10)     !ref 113 X target plot index
      integer*4  fnxtar           !ref 113 Number of x targets
      integer*4  fnytar           !ref 113 Number of y targets
      integer*4  ficinnum         !ref 113 Number of vars input as init's
      integer*4  ficotnum         !ref 113 Number of vars to output as ic
      integer*4  ficord(100)       !ref 113 Numerical order of ic variables
      integer*4  ficinop(100)      !ref 113 I/O status for ic input vars
      integer*4  frecframe        !ref rec number of frames recorded
      integer*4  frecnumb         !ref 113 Number of variables recorded
      integer*4  fnumgrid(36)     !ref 113 Number of grids to use for each y
      integer*4  fymaptox(36)     !ref 113 For each Y which X to use
      integer*4  fxvarnum         !ref 113 Number of x variables for plots
      integer*4  fyvarnum         !ref 113 Number of y variables plotted
      integer*4  fdampvar         !ref 113 Which Y var to use for damp ratio
      integer*4  fairdmd          !ref 113 autotest dmd airport 
      integer*4  frundmd          !ref 113 autotest dmd runway 
      integer*4  fxtarm(10)       !ref 113 Slope to find x target on
      integer*4  fytarm(10)       !ref 113 Slope to find y target on

      logical*4  facdline         !ref 113 Put line w/ snapshot pts ACD/POM
      logical*4  fatman           !ref 113 Manual test selected for test
      logical*4  fsimline         !ref 113 Put line w/ snapshot pts SIM
      logical*4  fhilite(36)      !ref 113 Highlight these variables
      logical*4  ftstover         !ref 113 Test over flag

      real*4     fytarval(10)     !ref 113Y target value for high lighting
      real*4     fxtarval(10)     !ref 113 X target value for high lighting
      real*4     fdampst          !ref 113 Start time for damp ratio analysis
      real*4     ficinval(100)     !ref 113 Sim input ic data array
      real*4     frecbuff(100000) !ref 991 temp data storage arry
      real*4     fxsng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fysng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fxscale(2,6)     !ref 113 X axis scales (1) min (2) max
      real*4     fyscale(2,36)    !ref 113 Y axis scales (1) min (2) max
      real*4     ftola(36)        !ref 113 Absolute tolerance value
      real*4     ftolp(36)        !ref 113 Percent tolerance value
      real*4     fbetast          !ref 113 Start time for peak analysis beta
      real*4     fphist           !ref 113 Start time for peak analysis phi
      real*4     fcfdst           !ref 113 Start time for peak analysis phi
      real*4     fxplotshft       !ref 113 time shift for manual data

      logical*4  fatbrun          !ref crt batch tests running flag
      logical*4  fatenabl         !ref fat test ip enable
      logical*4  fsnapacd(36)     !ref 113 Snap shot flag by variable ACD
      logical*4  fsnappom(36)     !ref 113 Snap shot flag by variable POM
      logical*4  fsnaplot         !ref 113 whole plot snap shot
      logical*4  fylimit(36)      !ref 113 Limit plot data to y axis

      integer*4  fattask          !ref 113 fat task controller
      integer*4  fattest          !ref fat test ip code number
      integer*4  fsimruns         !ref 113 number of sim runs to plot

      integer*4  fcpbctr          !ref 113 fat batch plot control ctr
      logical*4  fcplot           !def display plots
      logical*4  fplotacd         !ref 113 plot aircraft data flag
      logical*4  fplotman         !ref 113 plot manual data flag
      logical*4  fplotpom         !ref 113 plot prrof-of-match data flag
      logical*4  fplotsim         !ref 113 plot simulator data flag
      logical*4  fcpmess          !ref 990 6-grid message enable flag
      logical*4  fatprint         !def 990 batch printer control flag
      logical*4  fcprtplot        !def crt print current plots
      logical*4  fcptolf          !ref fcp tolerance flag
      integer*4  frecval          !ref 991 program pointer
      logical*4  fcpcopy          !def 990 copy output flag
      logical*4  ftgplot          !def 990 tgplot active flag
      logical*4  fmantxtfl        !ref 113 display man test txt page when ran
      real*4     frecrate         !ref 991nrt actual autoteset recording rate


      real*4     iconst     /1/   !Frame time variable

! *   Variables used in include files but not def'd in flt_ead_vars.inc

      logical*4   ch                   !changed
      logical*4   terr                 !temp error flag in flt_plot_init.inc

      integer*4   i,j,k                !counters
      integer*4   ficoutype(100)        !IC out vars type in flt_plot_init.inc
      integer*4   fictype(100)          !IC var type in flt_plot_init.inc
      integer*4   fininrt              !flag for error in test read
      integer*4   frectype(42)         !ref 991nrt type of rec variables
      integer*4   frecstart            !start recording value
      integer*4   runway               !temp integer for runway in ic in
      integer*4   airport              !temp integer for airport in ic in

      character*4   crun                !
      character*4   cair                !
      equivalence(runway,crun)
      equivalence(airport,cair)

! ******
!  Locals

      include "flt_read_vars.inc"  !variable defs for flt_read.inc


!     set "global" constants to get proper plotting results      
      fmantxtfl = .false.
      frecrate = 0.
      frecval = 3
      ftgplot     = .true. 
      fcpmess     = .false.
      fatbrun     = .true. 
      fmantxtfl   = .false.
      frecval     = 3           !So plots produced
      fcpbctr     = 1           !Batch flag

!     Read tdf file - ftestname needs to be defined in calling routine

      include "flt_read.inc"      !Read test information
      include "flt_init_plot.inc" !Load globals with plot info
      if ( fininrt .ne. 3 ) then


       call flt_output(iconst,     fattask,   fattest,    & 
        fbetavar,  fcfdvar,   fcpbctr,   fdampvar,  ficinnum,   & 
        ficinop,   ficord,    ficotnum,  fnumgrid,  fnxtar,     & 
        fnytar,    fphivar,   fplavar,   fpowervar, frecframe,  & 
        frecnumb,  frecval,   fsimruns,  fxtarm,    fxtarvar,   & 
        fxvarnum,  fymaptox,  fytarm,    fytarvar,  fyvarnum,   & 
        facdline,  fatbrun,   fatenabl,  fatman,    fatprint,   & 
        fcpcopy,   fcplot,    fcpmess,   fcprtplot, fcptolf,    & 
        fhilite,   fmantxtfl, fplotacd,  fplotman,  fplotpom,   & 
        fplotsim,  fsimline,  fsnapacd,  fsnaplot,  fsnappom,   & 
        ftgplot,   ftstover,  fylimit,   fbetast,   fcfdst,     & 
        fdampst,   ficinval,  fphist,    frecbuff,  frecrate,   & 
        ftola,     ftolp,     fxplotshft,fxscale,   fxsng,      & 
        fxtarval,  fyscale,   fysng,     fytarval)


       else
          write(*,*)' Error reading .tdf file for ', & 
               ftestname(:lrbl(ftestname))
          write(*,*)' No plot outpuot produced.'
       endif

       return
       end

