! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
! 
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : Boeing 717-200
!    JOB             : 8700          
!    DEPARTMENT      : 61 - Flight Dynamics 
!    MODULE NAME     : pages
!    DESCRIPTION     : Auto Test plot program.
!    PACKAGE         : flt
!    RATE            : offline
!    ORIGINATOR      : Flight Data Library
!    DATE            : 1/26/99
!    ENGINEER        : Mike Saladin
!    SYSTEM          : Unix

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 1999 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 251-0500  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
! *******************************************************************
!      PURPOSE:       To count number of pages in the atg for       *
!                     automatically repaginating the document.      *
!                                                                   *
! *******************************************************************
!--> REVISION BEGIN
! $Id: flt_pages.f,v 1.4 2000/03/13 21:58:25 saladinm Exp $
! $Log: flt_pages.f,v $
! Revision 1.4  2000/03/13 21:58:25  saladinm
! DR/MACAR:     None
! Problem:      Would not compile.
! Conclusion:   Changes to include files added a new label.
! Resolution:   Added the fylimit label.
! Dependencies: None
! Engineer:     Mike Saladin

! Revision 1.3  1999/03/15 13:28:33  saladinm
! Update from 717.

! Revision 1.7  1999/03/11 15:21:38  saladinm
! fixed minor error with ".

! " in an if statement.

! Revision 1.6  1999/02/18 14:12:16  saladinm
! Added parameters fxtarm and fytarm.

! Revision 1.5  1999/02/08 17:05:57  saladinm
! Modified to work with tdf files.

! Revision 1.4  1999/02/03 22:01:28  saladinm
! New release of Autotest SW. Version 2.0 - All Of this module does not work.

! Revision 1.1  1998/12/16 21:55:54  saladinm
! Initial revision

! Revision 1.3  1996/10/17  13:11:16  mattk
! 1 changed atg to tg
! 2 changed serch from filename to number.txt etc.
! 3 revised some outputs

! Revision 1.2  1996/05/15  22:04:08  msaladin
! Made minor mods to support printing of sections of the atg.

! Revision 1.1  1996/01/19  22:13:39  mattk
! Initial revision

!--> REVISION END
! *******************************************************************
      subroutine pages(prompt,sect,page,icnt)

      implicit none

      CHARACTER*80  RCSID & 
      /"$Id: flt_pages.f,v 1.4 2000/03/13 21:58:25 saladinm Exp $"/

! *******************************************************************

! * Argument List
      logical       prompt       !prompt user for requied sections
      integer*4     sect         !section to repaginate 0=all
! !Page data 1=sec 2=test 3=# text 4=No pages 5=start
! !          |<-input-->| |<--------output-------->|
      integer*4      page(500,5)
      integer*4      icnt         !Number of entries in ftpages.dat

! * Locals
      character*80  infile       !Input file ftpages.dat
      character*80  outfile      !Output file to become ftpages.dat
      character*80  line         !Generic text string for multiple uses
      character*80  path         !Path to data files
      character*80  blk          !Generic text string for multiple uses
      character*40  name         !Test name
      character*40  testname(1000)   !testnames
      integer*4     testnum(1000)    !test numbers
      integer*4     numt        !number of tests

      integer*4      totsec(20)   !Total pages for each section
      integer*4      pagetot      !Total pages for a test
      integer*4      pageplot     !Total plot pages for a test
      integer*4      pagetext     !Total text pages for a test
      integer*4      pageic       !Total ic   pages for a test
      integer*4      ierr         !read/write IOSTAT
      integer*4      lsec         !Last section counter
      integer*4      i,j,k        !Counters
      integer*4      lu78 /78/    !ftpages.dat
      integer*4      lu79 /79/    !Output file unit
      integer*4      temp         !temp int
      integer*4      lrbl         !str len
      integer*4      num          !Returned test number
      integer*4      type         !Returned test type

      logical        force(500)  !Force No pages to # in ftpages.dat
      logical        all          !Repaginate all sections
      logical        first        !First pass flag for subroutines
      logical        lexist
	  logical*4      ferr         !Rename file error flag
      logical*4      cont         !Continue flag

      character*80   cname


      include "flt_plot.inc"

!  Menu input

      first = .true.
      blk = ' '

! * Read test_index.dat file
      call read_index(numt,testname,testnum)

      cont = .true.
      do while (cont)
         if ( prompt ) then
            write(*,*)'Enter Section Number to repaginate (A=all)', & 
                 ' (RTN=Exit):'
            read(*,10) line
 10         format(A)

            read(line,*,IOSTAT=ierr) sect
            all=(index(line,'A') .gt. 0) .or. (index(line,'a') .gt. 0)
            if ( ierr .ne. 0 .and. .not. all ) goto 9999

            if ( all ) then
               write(*,*) 'Repaginating whole Test Guide' 
               sect = 0
            else
               write(*,*) 'Repaginating section: ',sect
            endif
         endif


		call read_ftpages(page,icnt,force,ferr)


         if (icnt.le.0 .or. ferr) then
            write(*,*) ' No entries for your selection.'
            return
         endif

! ***********************************************************************
!     create new  number of pages for each test
! ***********************************************************************

         do i=1,icnt
            if ( page(i,1) .eq. sect .or. sect .eq. 0 ) then
               pagetot = 0
               pagetext = 0
               if ( force(i) ) then
                  pagetot = page(i,4)
                  pagetext= page(i,3) 
               else
                  name = ' '
                  temp = page(i,2)
                  call itoc(temp,name)
                  j =-1
                  call findname(name,num,type,testname,testnum,numt)

                  if ( type .gt. 2 ) then
                     write(*,*) 'Test not found :',page(i,2),  & 
                                ' Unable to update number of pages'
                  else
                     write(*,*) 'Searching test: ',page(i,2), & 
                                'in section : ',page(i,1)
                     call getpages(name, pageplot, pagetext,pageic)
                     pagetot = pageplot +  pageic + pagetext
                  endif
               endif
               page(i,4) = pagetot
               page(i,3) = pagetext
            endif
         enddo

! ***********************************************************************
!     Create starting page numbers for each test
! ***********************************************************************
         do i = 1,20
            totsec(i) = 1
         enddo

         do i = 1,icnt
            if ( sect .eq. page(i,1) .or. sect .eq. 0 ) then
               page(i,5) = totsec(page(i,1))
               totsec(page(i,1)) = totsec(page(i,1)) + page(i,4)
            endif
         enddo

! ***********************************************************************
!     write page information back into ftpages.dat
! ***********************************************************************
         call pathfile(outfile,fpath,'.temp_pages')

		 call del_file(outfile)

         open(UNIT=lu79,FILE=outfile,IOSTAT=ierr,STATUS='new')

         if ( ierr .ne. 0 ) then
            write(*,*) 'Error opening temporary file. No update done'
            goto 9999
         endif

         write(lu79,10) '* Use "F" on line to force '// & 
                        'pages numbers for test'
         write(lu79,20) !Comments
 20      format('*Section   Test   #Text #Pages   Starting Page No.')

         lsec = page(1,1)

         do i = 1,icnt
            if (page(i,1) .ne. lsec ) write(lu79,20) ! comments
            if (force(i)) then
               write(lu79,30) (page(i,j),j=1,5)
            else
               write(lu79,40) (page(i,j),j=1,5)
            endif
            lsec = page(i,1)
         enddo


!        move the new file over the old

         close(lu78)
         close(lu79)

	     call rename_file(outfile(:lrbl(outfile)),infile(:lrbl(infile)),ferr)

!        Open ftpages.dat
         call pathfile(infile,fpath,'ftpages.dat')
         open(lu78,FILE=infile,IOSTAT=ierr)
         if ( ierr .ne. 0 ) then
            write(*,*) 'UNABLE TO OPEN ',infile
         endif

 30      format('F',3X,I2,5X,I6,3X,I2,4X,I2,7X,I3)
 40      format(    4X,I2,5X,I6,3X,I2,4X,I2,7X,I3)

!        exit if not prompting
         if ( .not. prompt ) cont = .false.

      enddo


 9999 continue
      return
      end


! *****************************************************************************

      subroutine getpages(name, pageplot, pagetext,pageic)

! *****************************************************************************
!  
!  This subroutine finds the number of pages for a given test.  

!  Originator:  M Saladin 9/28/95
!    Modified:  M Saladin 2/6/99  New TDF file format
! *****************************************************************************

      IMPLICIT NONE

! * Argument list
      character*40  name          !Test name
      integer*4     pageplot      !Number of plot pages including analysis
      integer*4     pagetext      !Number of pages of text
      integer*4     pageic        !Number of pages of IC

! * Locals
      integer*4     ierr          !I/O error flag
      integer*4     i,j,k,l       !Counters
      integer*4     lx            !last X value
      integer*4     fininrt       !Real time error flag

      logical*4     ch            !Changed logical
      logical*4     terr          !temp error flag
      logical*4     cont          !Continue

      character*132 ctext         !Read line

      character*4   crun          !Runway 4 character string
! *******************************************************************
! * Variables used in flt_init_plot.inc
      integer*4  airport          !Airport variable integer - local used in equ
      integer*4  runway           !runway  variable integer - local used in equ
      integer*4  fictype(100)      !IC var type in flt_plot_init.inc
      integer*4  ficoutype(100)    !Output IC var type in flt_plot_init.inc
      integer*4  frectype(42)     !Recording var type in flt_plot_init.inc

      real*4     frecstart        !Recording start time in flt_plot_init.inc

      integer*4  fbetavar         !ref 113 Y index for peak analysis beta
      integer*4  fphivar          !ref 113 Y index for peak analysis phi
      integer*4  fpowervar        !ref 113 Y index for accel analysis N1
      integer*4  fplavar          !ref 113 Y index for accel analysis
      integer*4  fcfdvar          !ref 113 Y index for accel analysis
      integer*4  fytarvar(10)     !ref 113 Y target plot index
      integer*4  fxtarvar(10)     !ref 113 X target plot index
      integer*4  fnxtar           !ref 113 Number of x targets
      integer*4  fnytar           !ref 113 Number of y targets
      integer*4  ficinnum         !ref 113 Number of vars input as init's
      integer*4  ficotnum         !ref 113 Number of vars to output as ic
      integer*4  ficord(100)       !ref 113 Numerical order of ic variables
      integer*4  ficinop(100)      !ref 113 I/O status for ic input vars
      integer*4  frecnumb         !ref 113 Number of variables recorded
      integer*4  fnumgrid(36)     !ref 113 Number of grids to use for each y
      integer*4  fymaptox(36)     !ref 113 For each Y which X to use
      integer*4  fxvarnum         !ref 113 Number of x variables for plots
      integer*4  fyvarnum         !ref 113 Number of y variables plotted
      integer*4  fdampvar         !ref 113 Which Y var to use for damp ratio
      integer*4  fairdmd          !ref 113 autotest dmd airport 
      integer*4  frundmd          !ref 113 autotest dmd runway 


      logical*4  fsimin           !ref 113 Put Sim init values on IC page HC
      logical*4  facdline         !ref 113 Put line w/ snapshot pts ACD/POM
      logical*4  fsimline         !ref 113 Put line w/ snapshot pts SIM
      logical*4  fhilite(36)      !ref 113 Highlight these variables

      real*4     fytarval(10)     !ref 113Y target value for high lighting
      real*4     fxtarval(10)     !ref 113 X target value for high lighting
      real*4     fdampst          !ref 113 Start time for damp ratio analysis
      real*4     ficinval(100)     !ref 113 Sim input ic data array
      real*4     frecbuff(100000) !ref rec temp data storage arry
      real*4     fxsng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fysng(2,2,42)    !ref 113 shift/gains for acd/pom data
      real*4     fxscale(2,6)     !ref 113 X axis scales (1) min (2) max
      real*4     fyscale(2,36)    !ref 113 Y axis scales (1) min (2) max
      real*4     ftola(36)        !ref 113 Absolute tolerance value
      real*4     ftolp(36)        !ref 113 Percent tolerance value
      real*4     fbetast          !ref 113 Start time for peak analysis beta
      real*4     fphist           !ref 113 Start time for peak analysis phi
      real*4     fcfdst           !ref 113 Start time for peak analysis phi

      logical*4  fatbrun          !ref crt batch tests running flag
      logical*4  fatenabl         !ref fat test ip enable
      logical*4  fsnapacd(36)     !ref 113 Snap shot flag by variable ACD
      logical*4  fsnappom(36)     !ref 113 Snap shot flag by variable POM
      logical*4  fsnaplot         !ref 113 whole plot snap shot
      logical*4  fylimit(36)      !ref 113 limit plot to y Axis

      integer*4  fattask          !ref 113 fat task controller
      integer*4  fattest          !ref fat test ip code number
      integer*4  fsimruns         !ref 113 number of sim runs to plot
      integer*4  fytarm(10)       !ref 113 Slope to find y target on
      integer*4  fxtarm(10)       !ref 113 Slope to find x target on

      integer*4  fcpbctr          !ref 113 fat batch plot control ctr
      logical*4  fcplot           !def display plots
      logical*4  fplotacd         !ref 113 plot aircraft data flag
      logical*4  fplotpom         !ref 113 plot prrof-of-match data flag
      logical*4  fplotsim         !ref 113 plot simulator data flag
      logical*4  fcplotac         !ref crt fat plot aircraft data
      logical*4  fcpmess          !ref 990 6-grid message enable flag
      logical*4  fatprint         !def 990 batch printer control flag
      logical*4  fcprtplot        !def crt print current plots
      logical*4  fcptolf          !ref fcp tolerance flag
      integer*4  frecval          !ref 991 program pointer
      logical*4  fcpcopy          !def 990 copy output flag
      logical*4  ftgplot          !def 990 tgplot active flag
      real*4     frecrate         !ref 991nrt actual autoteset recording rate
! ***************************************************************************
      character*4   cair          !used in flt_read.inc not important here

      include "flt_plot.inc"

      include "flt_read_vars.inc"

      ftestname = name
      fattest   = 999999 !not important - only for tolernaces not used here
      pagetext  = 0
      pageplot  = 0
      pageic    = 0

      include "flt_read.inc"
      include "flt_init_plot.inc"

      if ( fininrt .eq. 3 ) return  !Error reading tdf file

      if ( ficotnum .gt. nlic ) then
         pageic = 2
      elseif ( ficotnum .gt. 0 ) then
         pageic = 1
      endif



! * Calculate total plot pages including analysis - copied from flt_output

      k  = 0
      lx = -1
      pageplot   = 0          ! Start with 1 page
      do j=1,fyvarnum
         if ( fymaptox(j) .eq. lx ) then !Same x variable
            if ( k + fnumgrid(j) .gt. 6 ) then ! page full 
               pageplot = pageplot + 1               
               k = fnumgrid(j)
            else
               k = k + fnumgrid(j)
            endif
         else                   ! New x means new page
            pageplot = pageplot + 1
            k = fnumgrid(j)
            lx = fymaptox(j)
         endif
      enddo
      if (fdampvar .gt. 0 ) pageplot = pageplot + 1
      if (fphivar .gt. 0 .and. fbetavar .gt. 0) pageplot = pageplot + 1

! * Calculate number of Text pages
      open(lu19,FILE=testfile,IOSTAT=istatus)
      if ( istatus .ne. 0 ) then
         write(*,*) 'UNABLE TO OPEN '//testfile(:lrbl(testfile))
         return
      endif

! *   Read to start of text information
      istatus = 0
      do while ( istatus .eq. 0 .and. pagetext .eq. 0 ) 
         read(lu19,10,IOSTAT=istatus) ctext
         call lower(ctext,rlan(ctext))
         i = index(ctext,'start')
         j = index(ctext,'text')
         if ( i .gt. 0 .and. j .gt. 0 .and. j .gt. i ) then
            istatus = 1
            pagetext = 1
         endif
      enddo

      istatus = 0
      k = 6   !starting number of lines including titles and such
      if ( pagetext .eq. 1 ) then
         read(lu19,10,IOSTAT=istatus) ctext
         do while (istatus .eq. 0 ) 
            call lower(ctext,rlan(ctext))
            if ( index(ctext,'.pg') .or. k .gt. numline ) then
               pagetext = pagetext + 1
               k = 6
            endif
            read(lu19,10,IOSTAT=istatus) ctext
         enddo
      endif


 10   format(a)
 11   format(a,a)
 12   format(a,i)
      return
      end


	subroutine read_ftpages(page,icnt,force,error)

	implicit none

! !Page data 1=sec 2=test 3=# text 4=No pages 5=start
! !          |<-input-->| |<--------output-------->|
	integer*4      page(500,5)
	integer*4      icnt         !Number of entries in ftpages.dat

	logical*4      force(500)
	logical*4      error        !Error flag
!
!	locals
	character*132 infile       !Full file name
	character*80  line         !Generic text string for multiple uses

	integer*4      i,j          !Counter
	integer*4      ierr         !IOSTAT error flag
	integer*4      ierr2        !IOSTAT error flag
	integer*4      lu78 /78/    !Logical Unit for ftpages.dat

!     reset page and force arrays

	include "flt_plot.inc"

	do i=1,500
		page(i,1) = -99
		page(i,2) = -99
		page(i,3) = -99
		page(i,4) = -99
		page(i,5) = -99
		force(i)  = .false.
	enddo

! ***********************************************************************
!     read ftpages.dat
! ***********************************************************************
	icnt = -1
	ierr = 0
	i = 1
	error = .false.
	
	call pathfile(infile,fpath,'ftpages.dat')
	open (lu78,FILE=infile,IOSTAT=ierr)
	if ( ierr .ne. 0 ) then
		write(*,*) 'Unable to open ftpages.dat'
		error = .true.
		return
	endif

	do while ( ierr .eq. 0 ) 
		read(lu78,10,IOSTAT=ierr) line
		if (ierr.eq.0 .and. line(1:1).ne.'*' .and. line.ne.' ') then
			call lower(line,80)
			force(i) = (index(line,'f') .gt. 0)
			if ( force(i) ) then   !remove the F to read the line
				j = index(line,'f')
				line = line(:j-1)//line(j+1:)//' '
			endif

			read(line,*,IOSTAT=ierr2)  & 
			page(i,1),page(i,2),page(i,3),page(i,4),page(i,5)

			if ( ierr2 .ne. 0 ) then
				write(*,*) 'Error reading line ',i,'in ftpages.dat'
				write(*,*) 'Quitting'
				error = .true.
				close(lu78)
				return
			endif
	
			i = i + 1
		endif
	enddo

	icnt = i - 1
	
	close(lu78)

	return

10	format(a)

	end
