!  ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : Boeing 717-200
!    JOB             : 8700
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : flt_modtest
!    DESCRIPTION     : modifies test definition files
!    PACKAGE         : flt
!    RATE            : offline
!    ORIGINATOR      : Flight Data Library
!    DATE            : 12/1/98
!    ENGINEER        : Mike Saladin
!    SYSTEM          : Unix

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 1998 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 251-0500  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!--> REVISION BEGIN
! $Id: flt_modtest.f,v 1.8 2000/03/16 16:29:10 saladinm Exp $
! $Log: flt_modtest.f,v $
! Revision 1.8  2000/03/16 16:29:10  saladinm
! DR/MACAR:     None
! Problem:      If IC value was null and IO code = 0 the label would still
!               be printed.
! Conclusion:   Logic here would force this combination to have an IO code
!               of 2 thereby forcing it to be output which may no be the
!               desired operation.
! Resolution:   Modified logic to not force IO codes to 2 for all variables
!               with vlaues of null.
! Dependencies: flt_init_plot.inc
! Engineer:     Mike Saladin

! Revision 1.7  2000/03/13 21:46:45  saladinm
! DR/MACAR:     None
! Problem:      Added new function of IC output ooption of 2 for output only.
!               Added new task 5/6 fuction of bias.
! Conclusion:   Same
! Resolution:   Same
! Dependencies: fat_readtest.f,flt_read.inc
! Engineer:     Mike Saladin

! Revision 1.6  2000/02/14 16:53:04  saladinm
! Upped the dimension from 400 to 1000 for listing IC's. This
! brings it up to date with the standards.

! Revision 1.5  2000/02/14 16:07:33  saladinm
! DR/MACAR:     None
! Problem:      IC's not written to .tdf file in same order as they appear
!               on the printed IC page.
! Conclusion:   True.
! Resolution:   Added calls to routines to sort the ICs so that they will
!               be written out in the correct order.  Also fixed problem
!               with some changes in flt not showing up in display.
! Dependencies: None
! Engineer:     Mike Saladin

! Revision 1.3  1999/08/26 20:56:05  mattk
! added Master feature for ICs to updated from baseline ALL QTG tests

! Revision 1.2  1999/03/10 14:50:42  saladinm
! Updated from 717

! Revision 1.7  1999/03/10 14:48:43  saladinm
! Modified input of syncs for task 5.

! Revision 1.6  1999/02/24 19:27:07  saladinm
! Implemented update ICs from ACD file.

! Revision 1.5  1999/02/18 14:11:24  saladinm
! Modified for no IC output section. Removed routine mod_icout.
! ,

! Revision 1.4  1999/02/09 17:33:24  saladinm
! Modified task 5 logic concerning the second conditional.

! Revision 1.3  1999/02/08 17:04:24  saladinm
! Added RCS control stuff.

!--> REVISION END
! *******************************************************************


      subroutine flt_modtest()

      implicit none

      CHARACTER*80  RCSID & 
      /"$Id: flt_modtest.f,v 1.8 2000/03/16 16:29:10 saladinm Exp $"/

! * Locals
      character*64 input        !Input Line

      integer*4    cmd          !command input
      integer*4    ist          !IO status
      integer*4    irow         !Number of rows in window

      logical*4    end          !Loop controler

! * Externals      

! *   Get current window size
      call flt_window(irow)

      end = .false.

      do while ( .not. end )
         write(*,*)'     **********************************************'
         write(*,*)'     *                                            *'
         write(*,*)'     *                Command Menu                *'
         write(*,*)'     *                                            *'
         write(*,*)'     *  1 : Display/Edit test index.              *'
         write(*,*)'     *  2 : Display/Edit a test.                  *'
         write(*,*)'     *  3 : Modify IC/Axis Labels/IC Order        *'
         write(*,*)'     *  4 : Utilities                             *'
         write(*,*)'     *  5 : Exit                                  *'
         write(*,*)'     *                                            *'
         write(*,*)'     **********************************************'
         write(*,*) ' '
         write(*,*) ' Enter your choice->'
         read(*,10,IOSTAT=ist) cmd

         if ( ist .ne. 0 ) return

         if ( cmd .le. 0 .or. cmd .gt. 4 ) return

         if ( cmd .eq. 1 ) then
            call test_index(irow)
         elseif ( cmd .eq. 2 ) then
            call edit_test(irow)
         elseif ( cmd .eq. 3 ) then
            call list_ic(irow,input,0)
         elseif ( cmd .eq. 4 ) then
            cmd = 1
            do while ( cmd .gt. 0 .and. cmd .lt. 2 ) 
               write(*,*)'    *****************************************'
               write(*,*)'    *                                       *'
               write(*,*)'    *           Utilities                   *'
               write(*,*)'    *                                       *'
               write(*,*)'    *  1 : Search tests for a variable      *'
               write(*,*)'    *  2 : Exit                             *'
               write(*,*)'    *                                       *'
               write(*,*)'    *****************************************'
               write(*,*) ' '
               write(*,*) ' Enter your choice->'
               read(*,10,IOSTAT=ist) cmd

               if ( ist .ne. 0 ) cmd = 99

               if ( cmd .lt. 0 .or. cmd .gt. 1 ) cmd = 99

               if ( cmd .eq. 1 ) then
                  write(*,*) 'Enter variable to search for'
                  read(*,11,IOSTAT=ist) input
                  if ( ist .eq. 0 ) then
                     write(*,*) 'This function not yet implemented'
                  else
                     write(*,*) 'Invalid input.'
                  endif
               endif !Utilites command sorter
            enddo ! Utilities loop
         endif !Master command sorter
      enddo  !Master Loop

 10   format(i2)
 11   format(a)

      return
      end


      subroutine test_index(irow)
      implicit none

      integer*4     irow            !Number of rows on the screen

! * Locals
      character*256 message         !Message variable
      character*128 filename        !Full path name of test_index.dat
      character*40  testname(1000)   !testnames
      character*40  name            !temp testname
      character*40  ans             !tenp answer variable

      integer*4     testnum(1000)    !test numbers
      integer*4     idx(1000)        !sort cross reference of indices
      integer*4     i,j,k           !Counters
      integer*4     ist             !IO status
      integer*4     col             !Number of columns to display
      integer*4     cmd             !Command input               
      integer*4     nline           !Number of lines displayed
      integer*4     numt            !number of tests
      integer*4     num             !Test Number of found test
      integer*4     type            !Type of test input name=1 num=0

      logical*4     changed         !Does test_index.dat file need updating
      logical*4     cont            !Master while loop continue
      logical*4     sort            !Sort while loop continue


! * Externals
      integer*4     rlan            !Returns index of last non-blank
      integer*4     lran            !Returns index of first non-blank
      integer*4     lrbl            !Returns index of first blank from left

! * Allow for global character strings ( fpath )
      include "flt_plot.inc"

      call pathfile(filename,fpath,'test_index.dat')

      call read_index(numt,testname,testnum)

      do i=1,1000
         idx(i) = i
      enddo
      changed = .false. 

! * Find longest test name to determine # of columns
      j = 0

      do i=1,numt
         k = lrbl(testname(i))
         if ( k .gt. j ) j = k
      enddo


! * Set number of output columns
      if ( j .le. 8 ) then
         col = 4
      elseif ( j .le. 14 ) then
         col = 3
      elseif ( j .le. 26 ) then
         col = 2
      else
         col = 1
      endif

! * Master do loop
      cont = .true.

      do while ( cont )
         write(*,*) '                      Tests in test_index.dat   '
         write(*,*) ' '
         do j=1,numt/col
            if ( nline .gt. irow-6 ) then !full screen
               write (*,*) 'Hit <CR> to continue.'
               read (*,50) name
               nline = 0
            endif
            if ( col .eq. 4 ) then
               write(*,40)(testnum(idx(i)),testname(idx(i)),i=j*4-3,j*4)
            elseif ( col .eq. 3 ) then
               write(*,30)(testnum(idx(i)),testname(idx(i)),i=j*3-2,j*3)
            elseif ( col .eq. 2 ) then
               write(*,20)(testnum(idx(i)),testname(idx(i)),i=j*2-1,j*2)
            else
               write(*,10) testnum(idx(j)),testname(idx(j))
            endif
            nline = nline + 1   !incr line count
         enddo

         if ( mod(numt,col) .gt. 0 ) then !write the remainer
            if ( col .eq. 4 ) then
               write(*,40) (testnum(idx(j)),testname(idx(j)),j=i,numt)
            elseif ( col .eq. 3 ) then
               write(*,30) (testnum(idx(j)),testname(idx(j)),j=i,numt)
            elseif ( col .eq. 2 ) then
               write(*,20) (testnum(idx(j)),testname(idx(j)),j=i,numt)
            elseif ( col .eq. 1 ) then
               write(*,10) testnum(idx(i+1)),testname(idx(i+1))
            endif
            nline = nline + 1   !incr line count
         endif
         write(*,*) ' Enter 1=Add Test 2=Delete Test: 3=Alter Test Name:4=Sort by Name'
         write(*,*) '       5=Sort by Number :6=No Sort'
         read(*,60,IOSTAT=ist) cmd


         if ( cmd .lt. 1 .or. cmd .gt. 6 .or. ist .ne. 0 ) cmd = 9


         if ( cmd .le. 3 ) then
            write(*,*) 'Enter test name or number'
            read(*,50,IOSTAT=ist) name
            call findname(name,num,type,testname,testnum,numt)
            if     ( cmd .eq. 1 ) then  !Add test
               if ( type .gt. 2 ) then !no test of this name
                  if ( type .eq. 99 ) then !input was a number
                     write(*,*) 'Enter test name:'
                     read(*,50,IOSTAT=ist) name
                  else
                     write(*,*) 'Enter test number:'
                     read(*,60,IOSTAT=ist) num
                  endif
                  if ( ist .eq. 0 ) then
                     numt = numt + 1
                     testname(numt) = name
                     testnum(numt)  = num
                     changed = .true.
                  endif
				  call pathfile(ftestname,fpath,name(:lrbl(name))//'.tdf')
				  open(UNIT=99,FILE=ftestname,IOSTAT=i)   !create blank tdf file
				  close(99)
               else ! test name found
                  write(*,70) 'Test already found:', & 
                              num,name(:lrbl(name))
                  write(*,*) 'Unable to add test'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,50) name
                  nline = 0
               endif
            elseif ( cmd .eq. 2 ) then !Remove test
               if ( type .gt. 2 ) then !Specified test doesn't exist
                  write(*,*) 'Specified test does not exist in '// & 
                       'test_index.dat'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,50) name
               else
                  write(*,*) 'Do you want to remove', & 
                              num,name(:lrbl(name))
                  write(*,*) 'from the test_index.dat file? (y,N)'
                  read(*,50,IOSTAT=ist) ans
                  call lower(ans,20)
                  if ( index(ans,'y') .gt. 0 .and. ist .eq. 0 ) then
                     do i=1,numt
                        if ( num .eq. testnum(i) .and. & 
                             name .eq. testname(i) ) then
                           do j=i,numt-1
                              testname(j) = testname(j+1)
                              testnum(j)  = testnum(j+1)
                           enddo
                           numt = numt - 1
                        endif
                     enddo
                     changed = .true.
                     write(*,*) 'The test was removed', & 
                          num,name(:lrbl(name))
                  endif
               endif
               nline = 0
            elseif ( cmd .eq. 3 ) then !Alter test name/number
               if ( type .gt. 2 ) then !no test of this name
                  write(*,*) 'Specified test does not exist in '// & 
                       'test_index.dat'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,50) name
               else
                  ans = ' '
                  if ( type .eq. 0 ) then !input was a number
                     write(*,*) 'Enter new test name: '// & 
                               '(<CR> for new number)'
                     read(*,50,IOSTAT=ist) ans
                     if ( ans(1:1) .eq. ' ' .and. ist .eq. 0 ) then
                        type = 1
                     elseif ( ist .ne. 0 ) then
                        type = 99
                     endif
                  endif
                  if ( type .eq. 1 ) then
                     write(*,*) 'Enter new test number:'// & 
                               '(<CR> for new name)'
                     read(*,50,IOSTAT=ist) ans
                     if ( ans(1:1) .eq. ' ' .and. ist .eq. 0 ) then
                        type = 0
                        write(*,*) 'Enter new test name: '
                        read(*,50,IOSTAT=ist) ans
                     elseif ( ist .ne. 0 ) then
                        type = 99
                     endif
                  endif
                  if ( type .eq. 99 ) then
                     write(*,*) 'Error - Invalid input.'
                     write (*,*) 'Hit <CR> to continue.'
                     read (*,50) name
                  else
                     i = 1
                     k = 0
                     do while ( i .le. numt .and. k .eq. 0 )
                        if ( num .eq. testnum(i) .and. & 
                             name .eq. testname(i) ) then
                           k = i
                        endif
                        i = i + 1
                     enddo
                     if ( type .eq. 0 ) then !new test name
                        testname(k) = ans
                        changed = .true.
                     else
                        read(ans,60,IOSTAT=ist) num
                        if ( ist .eq. 0 ) then
                           testnum(k)  = num
                           changed = .true.
                        else
                           write(*,*) 'Error - Invalid input.'
                           write (*,*) 'Hit <CR> to continue.'
                           read (*,50) name
                        endif
                     endif
                  endif
               endif
               nline = 0
            endif
         elseif ( cmd .eq. 4 ) then !sort by name
            sort = .false.
            do while ( .not. sort )
               sort = .true.
               do i=1,numt-1
                  if ( testname(idx(i)) .gt. testname(idx(i+1)) ) then
                     sort = .false.
                     k = idx(i)
                     idx(i) = idx(i+1)
                     idx(i+1) = k
                  endif
               enddo
            enddo
            nline = 0
         elseif ( cmd .eq. 5 ) then
            sort = .false.
            do while ( .not. sort )
               sort = .true.
               do i=1,numt-1
                  if ( testnum(idx(i)) .gt. testnum(idx(i+1)) ) then
                     sort = .false.
                     k = idx(i)
                     idx(i) = idx(i+1)
                     idx(i+1) = k
                  endif
               enddo
            enddo
            nline = 0
         elseif ( cmd .eq. 6 ) then
            do i=1,1000
               idx(i) = i
            enddo
            nline = 0
         elseif ( cmd .gt. 6 ) then  !Exit
            if ( changed ) then
               call write_index(numt,testname,testnum)
               write(*,*) 'Test_index.dat file updated.'
            endif
            cont = .false.
         endif

      enddo

 10   format(10x,i6,' - ',a)
 20   format(2(2x,i6,'-',a26))
 30   format(3(2x,i6,'-',a14))
 40   format(4(2x,i6,'-',a8))
 50   format(a)
 60   format(i5)
 70   format(a,i6,'-',a)
      return
      end


      subroutine findname(name,num,itype,testname,testnum,numt)
      implicit none

! * globals
      character*40  name             !name to find
      character*40  testname(1000)    !Array of testnames

      integer*4     num              !Test number found/input
      integer*4     itype             !Input was name=1 number=0
      integer*4     testnum(1000)     !Array of test numbers
      integer*4     numt             !Number of valid points in arrays

! * Locals
      integer*4     i,j,k            !Counters
      integer*4     irow             !Number of rows in window
      integer*4     col              !Nuber of columns to display
      integer*4     nl               !Number of lines displayed
      integer*4     ist              !IOSTAT flag

! * Externals
      integer*4     lrbl             !Returns index of last non-blank from left

! * If name is blank then display list of names to choose from
      if ( name(1:1) .eq. ' ' ) then
         call flt_window(irow)
         j = 0

         do i=1,numt
            k = lrbl(testname(i))
            if ( k .gt. j ) j = k
         enddo


! * Set number of output columns
         if ( j .le. 8 ) then
            col = 4
         elseif ( j .le. 12 ) then
            col = 3
         elseif ( j .le. 24 ) then
            col = 2
         else
            col = 1
         endif

! * Master do loop
         nl = 0

         write(*,*) '                      Tests in test_index.dat   '
         write(*,*) ' '
         do j=1,numt/col
            if ( nl .gt. irow-6 ) then !full screen
               write (*,*) 'Hit <CR> to continue.'
               read (*,50) name
               nl = 0
            endif
            if ( col .eq. 4 ) then
               write(*,40) (i,testnum(i),testname(i),i=j*4-3,j*4)
            elseif ( col .eq. 3 ) then
               write(*,30) (i,testnum(i),testname(i),i=j*3-2,j*3)
            elseif ( col .eq. 2 ) then
               write(*,20) (i,testnum(i),testname(i),i=j*2-1,j*2)
            else
               write(*,10)  j,testnum(j),testname(j)
            endif
            nl = nl + 1         !incr line count
         enddo

         if ( mod(numt,col) .gt. 0 ) then !write the remainer
            if ( col .eq. 4 ) then
               write(*,40) (j,testnum(j),testname(j),j=i,numt)
            elseif ( col .eq. 3 ) then
               write(*,30) (j,testnum(j),testname(j),j=i,numt)
            elseif ( col .eq. 2 ) then
               write(*,20) (j,testnum(j),testname(j),j=i,numt)
            elseif ( col .eq. 1 ) then
               write(*,10) i+1,testnum(i+1),testname(i+1)
            endif
            nl = nl + 1         !incr line count
         endif
         write(*,*) ' Enter Line # or <cr> for none'

         read(*,100,IOSTAT=ist) i

         if ( ist .ne. 0 ) return

         num = testnum(i)
         name = testname(i)

         itype = 0

      else    !name input see if testname or testnum


! *   See if name exists in name array
         i = 1
         do while ( i .le. numt )
            if ( name(:lrbl(name)) .eq. & 
                 testname(i)(:lrbl(testname(i))) ) then
               num  = testnum(i)
               itype = 1
               return
            endif
            i = i + 1
         enddo

! *   Input was not a valid name
         read(name,*,IOSTAT=i) j
         if ( i .ne. 0 ) then   !Name must be characters and not a number
            itype = 89
            return
         endif

! *   See if number exists in number array
         i = 1
         do while ( i .le. numt )
            if ( j .eq. testnum(i) ) then
               num   = testnum(i)
               name  = testname(i)
               itype = 0
               return
            endif
            i = i + 1
         enddo

! *   If got to here no test found
         itype = 99              !Name was a number

         num = j
      endif

      return

 10   format(10x,'(',i3,')',i6,' - ',a)
 20   format(2('(',i3,')',2x,i6,'-',a24))
 30   format(3('(',i3,')',2x,i6,'-',a12))
 40   format(4('(',i3,')',2x,i6,'-',a8))
 50   format(a)
 100  format(i3)
      end

      subroutine write_index(numt,testname,testnum)
      implicit none

! * Arguments 
      integer*4     numt           !Number of tests
      integer*4     testnum(1000)   !Array of test numbers

      character*40  testname(1000)  !Array of test names

! * Locals
      character*132 filename       !Full file name 

      logical*4     ferr           !Error flag for rename file

      integer*4     i              !Counter
      integer*4     ist            !IO status
      integer*4     lu20  /20/     !Logical unit for test_index.dat

! * Externals
      integer*4     lrbl            !Returns index of first blank from left

! * Get globals mainly fpath
      include "flt_plot.inc"

      call pathfile(filename,fpath,'test_index.dat')


! * Move existing test_index.dat file to .old
	  i = lrbl(filename)
	  call rename_file(filename(:i),filename(:i)//'.old',ferr)

      open(UNIT=lu20,FILE=filename,IOSTAT=ist)
      if ( ist .ne. 0 ) then !Unable to open test_index.dat file 
         write(*,*) 'Unable to open the following file '
         write(*,*) 'File : ',filename(:lrbl(filename))
         write(*,*) 'Status = ',ist
         return
      endif

      do i=1,numt
         write(lu20,10) testnum(i),testname(i)(:lrbl(testname(i)))
      enddo

      close(lu20)  !close test_index.dat file for now
      return

 10   format(i6,1x,a)
      end


      subroutine edit_test(irow)
      implicit none

! * Arguments
      integer*4    irow        !Number of displayed rows

! * Locals
      character*40  testname(1000)   !testnames
      character*40  name            !temp input name
      character*20  ans             !Answer string

      integer*4     testnum(1000)    !test numbers
	  integer*4     i               !Loop counter
      integer*4     ist             !IO status
      integer*4     cmd             !Command input               
      integer*4     numt            !number of tests
      integer*4     num             !Test Number of found test
      integer*4     fininrt         !Real time error flag
      integer*4     fattest         !Test number
      integer*4     itype           !Type of test input name=1 num=0

      logical*4     cont            !continue loop
      logical*4     firstpass /.true./

! * Externals

! * Include files to define variables and the character array common
      include "flt_plot.inc"
      include "flt_read_vars.inc"

      if ( firstpass ) then
!         write(*,*) 'Do you want to do variable type checking (N/y)'
!         read(*,10,IOSTAT=ist) name
!         if ( index(name,'y') .gt. 0 .and. ist .eq. 0 ) then
!            write(*,*) 'Reading variable types data bases.'
!            write(*,*) 'Please be Patient it will take a few seconds.'
!            call gettype('firstpass',ist,cont)
!         endif
         firstpass = .false.
      endif

! * Read the current test index
      call read_index(numt,testname,testnum)


      cont = .true.
      do while ( cont )
         write(*,*) '      TEST MODIFICATION MAIN MENU'
         write(*,*) ' '
         write(*,*) 'Enter test name or number to work with:'
         read(*,10,IOSTAT=ist) name

         if ( name .eq. ' ' .or. ist .ne. 0 ) then
            cont = .false.
            ftestname = ' '
         else   
            call findname(name,num,itype,testname,testnum,numt)
            if ( itype .gt. 2 ) then ! test not found
               write(*,*) 'Test Not Found. Do you want to create it? (y/N)'
               read(*,10,IOSTAT=ist) ans
               call lower(ans,2)
               if ( ist .eq. 0 .and. ans(:1) .eq. 'y' ) then
                  if ( itype .eq. 99 ) then !input was a number
                     write(*,*) 'Enter test name:'
                     read(*,10,IOSTAT=ist) name
                  else
                     write(*,*) 'Enter test number:'
                     read(*,20,IOSTAT=ist) num
                  endif
                  if ( ist .eq. 0 ) then
                     numt = numt + 1
                     testname(numt) = name
                     testnum(numt)  = num
                     call write_index(numt,testname,testnum)
                     write(*,*) 'Test index updated'
                  endif
				  call pathfile(ftestname,fpath,name(:lrbl(name))//'.tdf')
				  open(UNIT=99,FILE=ftestname,IOSTAT=i)   !create blank tdf file
				  close(99)
               else
                  ftestname = ' '
                  cont = .false.
               endif
            else
               ftestname = name(:lrbl(name))
            endif               !test found
         endif
         if ( ftestname .ne. ' ' ) then 
            fattest = num
            include "flt_read.inc"   !read test definition file

            cmd = 1
            do while ( cmd .gt. 0 .and. cmd .lt. 8 )
               write(*,*) '********************************************'
               write(*,*) '*     TEST: '//ftestname
               write(*,*) '*      NUM: ',fattest
               write(*,*) '* '
               write(*,*) '*    TITLE: '//title(:rlan(title))
               write(*,*) '*  COMMENT: '//comment(:rlan(comment))
               write(*,*) '* '
               write(*,*) '*  1 : Display/Edit IC variables'  
               write(*,*) '*  3 : Display/Edit Task 3'
               write(*,*) '*  5 : Display/Edit Task 5'
               write(*,*) '*  6 : Display/Edit Plot Variables (Title'// & 
                                  '/Comment)'
               write(*,*) '*  7 : Display/Edit Shift and Gains'
               write(*,*) '*  8 : Exit'
               write(*,*) '*'
               write(*,*) '********************************************'
               write(*,*) ' '
               write(*,*) ' Enter your choice->'
               read(*,20,IOSTAT=ist) cmd               

               if ( ist .ne. 0 ) cmd = 99 !exit

               if ( cmd .eq. 1 ) then ! Ic input modification
                  call mod_ics(fattest,numt,testname,testnum,irow & 
                         ,nic,icvar,icval,icout)
               elseif ( cmd .eq. 3 ) then
                  call mod_task3(fattest,numt,testname,testnum,irow, & 
                         ntask3,t3var,t3val)
               elseif ( cmd .eq. 5 ) then
                  call mod_task5(fattest,numt,testname,testnum,irow, & 
                       ncond,ntask5,t5var,t5val,t5source,t5sync,t5bias, & 
                       convar,conval,con,conop)

               elseif ( cmd .eq. 6 ) then
                  call flt_modplot(fattest,numt,testname,testnum,irow)

               elseif ( cmd .eq. 7 ) then
                  call mod_sng(fattest,numt,testname,testnum,irow, & 
                         ncnt,var,ysh,ygn,xsh,xgn,ncond,ntask5,t5val)

               endif

            enddo !Command loop for a test
         endif  !valid testname
      enddo !master loop


 10   format(a)
 20   format(i2)

      return

      end

 
 
      subroutine mod_ics(fattest,numt,testname,testnum,irow & 
                         ,n_ic,ic_var,ic_val,out_ic)
      implicit none

      character*64  ic_var(100)          !Variables for IC input
      character*40  testname(1000)       !Testnames
      character*80  ic_val(100)          !Variables for IC input

      integer*4     testnum(1000)        !Test numbers
      integer*4     irow                !Number of rows on screen
      integer*4     n_ic                !Number of icvariables
      integer*4     out_ic(100)          !Output flag of ic variables
      integer*4     fattest             !test number
      integer*4     numt                !Number of define tests

! * Locals
      character*132 oldt                !old title
      character*132 oldc                !old comment
      character*132 bfile               !batch file
      character*64  tivar               !temp input var
      character*40  name                !temp input name
      character*40  ttestname           !temp storage for test name
      character*40  ctnum(1000)         !Test numbers from batch file
      character*80  val                 !Temp value
      character*80  ans                 !Answer string
      character*14  fout                !Display of IO flag for ic's
	  character*4	suffix(2) /'.acd','.pom'/
	  character*4	ftype               !File type
      character*1   a1                  !Answer string

      integer*4     imx                 !Largest char string
      integer*4     i,j,k,l             !Counters
      integer*4     iloop               !Counter
      integer*4     nline               !Number of lines displayed
      integer*4     il                  !Number of rows for showing ic's
      integer*4     ierr                !Error flag
      integer*4     ierr2               !Error flag
      integer*4     inum1               !Start of range of IC'sodify
      integer*4     inum2               !End of range of IC's to modify
      integer*4     cod                 !IC IO code 
      integer*4     lu18  /18/          !Logical unit for testdef.tdf.old
      integer*4     lu21  /21/          !Logical unit for batch file
      integer*4     fininrt             !Real time error flag
      integer*4     ist                 !IO status flag
      integer*4     itype               !Type of test input name=1 num=0

      logical*4     change              !Data changed need to rewrite file
      logical*4     find                !found condition flag
      logical*4     cont                !continue loop
      logical*4     lexist              !file exists flag
      logical*4     terr                !Error finding input type
      logical*4     isatd /.false./     !Flag for call to get_value

! *
      include "flt_plot.inc"
      include "flt_read_vars.inc"


      imx = 0
      do i=1,n_ic
         j = lrbl(ic_var(i))
         if ( j .gt. imx ) imx = j
      enddo
      nline = 0
      j = 1
      il = irow - 8
      cont   = .true.
      change = .false.

      do while ( cont )
         write(*,20)'    IC`s for ',fattest,ftestname
         write(*,*) '    ',title(:rlan(title))
         write(*,*) '    ',comment(:rlan(comment))
         write(*,*) '  '
         do while ( nline .lt. il .and. j .le. n_ic )
            if ( out_ic(j) .eq. 2 ) then
               fout = 'OUTPUT ONLY'
            elseif ( out_ic(j) .eq. 0 ) then
               if ( index(ic_val(j),'null') .gt. 0 ) then
                  fout = 'DO NOTHING'
               else
                  fout = 'INPUT ONLY'
               endif
            else
               fout = 'INPUT & OUTPUT'
            endif
            write(*,30) j,ic_var(j)(:imx),ic_val(j)(:20),fout
            nline = nline + 1
            j = j + 1
         enddo
         write(*,*) ' '
         write(*,*)'Enter item to alter (# or #-#):+=more ', & 
              '-_back  (U)pdate codes (# or #-#)'
         write(*,*)' (D)elete (# or #-#) (A)dd '// & 
              ' (C)opy test  u(P)date from file  (I)/O Code Update'

         read(*,10,IOSTAT=ist) ans

         a1 = ans(1:1)  
         call lower(a1,1)
         if (a1 .eq. '=' .or. a1 .eq. '+' )then
            nline = 0
            if ( j .ge. n_ic ) j = 1
         elseif (a1 .eq. '-' .or. a1 .eq. '_' ) then
            j = j - 2*il
            nline = 0
            if ( j .lt. 1 ) j = 1
         elseif ( a1 .eq. 'p') then !acd update
			write(*,*) ' 1) ACD File'
			write(*,*) ' 2) POM File'
			write(*,*) ' Choose Desired file to update from'
            read(*,*,IOSTAT=ist) i
            if ( ist .ne. 0 .or. i .gt. 2 .or. i .lt. 1 ) i = 1
			ftype = suffix(i)
            write(*,*) ' 1) Update Defined IC with '//ftype(2:)//' data '
            write(*,*) ' 2) Replace whole IC section with '//ftype(2:)//' data'
            write(*,*) ' Choose the desired option'
            read(*,*,IOSTAT=ist) i
            if ( ist .ne. 0 .or. i .gt. 2 .or. i .lt. 1 ) i = 1
            call flt_updateic_file(ftype,n_ic,ic_val,ic_var,i)
            change = .true.
            j = 1
            nline = 0
         elseif ( a1 .eq. 'i') then !i/o code update
            write(*,*) ' 1) Copy another tests I/O codes to this test'
            write(*,*) ' 2) Update multiple tests based on current test'
            write(*,*) ' Choose the desired option (<CR>=1)'
            read(*,*,IOSTAT=ist) i
            if ( ist .ne. 0 .or. i .gt. 2 .or. i .lt. 1 ) i = 1

            if ( i .eq. 1 ) then
               write(*,*) ' Enter Test Name or Number to COPY: <CR> = MENU'
               read(*,10,IOSTAT=ist) name
               call findname(name,i,itype,testname,testnum,numt)
               if ( itype .lt. 2 ) then
                  ttestname = ftestname
                  ftestname = name         
                  oldt      = title
                  oldc      = comment
                  filename = ftestname(:lrbl(ftestname))//'.tdf'
                  call pathfile(testfile,fpath, & 
                                filename(:lrbl(filename)))

                  inquire(FILE=testfile,EXIST=exist)
                  if ( .not. exist ) then
                     message='Test file does not exist '// & 
                              testfile(:lrbl(testfile))
                     write(*,*) message(:rlan(message))
                  else
                     include "flt_read.inc" !read new data from ftestname.tdf
                     do i = 1,nic !scan copy test labels
                        find = .false. !reset find flag
                        j = 1
                        do while ( .not. find .and. j .le. n_ic) !scan old label
                           if ( icvar(i) .eq. ic_var(j) ) then
                              out_ic(j) = icout(i)
                              find = .true.
                           endif
                           j = j + 1
                        enddo
                     enddo
                     change = .true.
                  endif
                  ftestname = ttestname !restore values to current test
                  title     = oldt
                  comment   = oldc
               else
                  write(*,*) 'Test ',name,' not found'
                  write(*,*) 'No changes made'
               endif
               j     = 1        !redisplay data from top
               nline = 0

            else
               write (*,*) ' Master file is ',ftestname

               write (*,*) ' Input batch file or RTN for all tests in'// & 
                           ' test_index.dat'

               read(*,10,IOSTAT=ist) ans

               if ( ist .ne. 0 ) then
                  inum1 = 0
               else
                  inum1 = 1
                  if ( ans(1:1) .ne. ' ' ) then
                     call pathfile(bfile,fpath,ans(:lrbl(ans)))
                  else
                     call pathfile(bfile,fpath,'test_index.dat')
                  endif

                  inquire (FILE=bfile,EXIST=lexist,IOSTAT=ist)
                  if (.not.lexist .or. ist .ne. 0 ) then
                     write(*,*) 'Unable to find file :'// & 
                          bfile(:lrbl(bfile))
                     inum1 = 0
                  endif


                  if ( inum1 .ne. 0 ) then 
                     open (UNIT=lu21,FILE=bfile,IOSTAT=ist)

                     if ( ist .ne. 0 ) then 
                        write(*,*) 'Unable to open file :'// & 
                             bfile(:lrbl(bfile))
                        inum1 = 0
                     endif
                  endif

                  if ( inum1 .ne. 0 ) then
                     i = 1
                     read (lu21,10,IOSTAT=ist) ans

                     do while ( ist .eq. 0 )
                        ans = ans(lran(ans):)
                        ctnum(i) = ans(:lrbl(ans))
                        inum1 = i
                        i = i + 1
                        read (lu21,10,IOSTAT=ist) ans
                     enddo

                     close(lu21)
                     if ( inum1 .lt. 1 ) then
                        write(*,*) 'No tests defined in '// & 
                                    bfile(:lrbl(bfile))
                     endif
                  endif

                  ttestname = ftestname
                  oldt      = title
                  oldc      = comment

                  if ( inum1 .ge. 1 ) then   
                     write (*,*) ' Will update ',inum1,' tests.'
                  endif
                  do l = 1,inum1
                     ftestname = ctnum(l)
                     call findname(ftestname,inum2,itype, & 
                                    testname,testnum,numt)
                     if ( itype .ge. 2 ) then !test Not found
                        write(*,*) 'Unable to find test '// & 
                                    ftestname(:lrbl(ftestname))
                     else  !test found
                        filename = ftestname(:lrbl(ftestname))//'.tdf'
                        call pathfile(testfile,fpath, & 
                             filename(:lrbl(filename)))

                        inquire(FILE=testfile,EXIST=exist)
                        if ( .not. exist ) then
                           message=' Test file does not exist '// & 
                                testfile(:lrbl(testfile))
                           write(*,*) message(:rlan(message))
                        else

                           write (*,*) ' Test # ',l,' is ',ftestname
                           include "flt_read.inc" !read new data from ftestname.tdf

                           do i = 1,nic !scan target new file
                              find = .false. !reset find flag
                              j = 1
                              do while ( j .le. n_ic .and. .not. find ) 
                                 if ( icvar(i) .eq. ic_var(j) ) then 
                                    find = .true.
                                    icout(i) = out_ic(j)
                                 endif
                                 j = j + 1
                              enddo
                           enddo

                           filename=ftestname(:lrbl(ftestname))//'.tdf'
                           write(*,*) 'Updating test definition file:', & 
                                filename(:lrbl(filename))
                           call pathfile(testfile,fpath, & 
                                filename(:lrbl(filename)))

                           call flt_write_ics(testfile,icvar,icval, & 
                                              icout,nic,.true.,err)


                        endif
                     endif
                  enddo

!                  change = .true.
                  ftestname = ttestname !restore values to current test
                  title     = oldt
                  comment   = oldc
               endif
            endif
            j = 1
            nline = 0
         elseif ( a1 .eq. 'd' ) then !Delete variable
            i=index(ans,'-')
            ierr  = 0 
            ierr2 = 0
            if ( i .gt. 1 ) then
               read(ans(2:i-1),*,IOSTAT=ierr) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans(2:),*,IOSTAT=ierr) inum1
               inum2 = inum1
            endif
            if ( ierr .ne. 0 .or. ierr2 .ne. 0 ) then
               write(*,*) 'Enter variable number to delete'
               read(*,10,IOSTAT=ist) ans
               read(ans,*,IOSTAT=ierr) inum1
               if ( ist .ne. 0 .or. ierr .ne. 0 ) then
                  write(*,*) 'Invalid input'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,10) tivar
                  j = 1 
                  nline = 0
               else
                  ierr2 = 0
                  inum2 = inum1
               endif
            endif
            if ( ierr .eq. 0 .and. ierr2 .eq. 0 ) then
               k = inum2 - inum1 + 1 !number of variables to delete
               do i=inum1,n_ic-k
                  ic_var(i) = ic_var(i+k)
                  ic_val(i) = ic_val(i+k)
                  out_ic(i) = out_ic(i+k)
               enddo
               n_ic = n_ic - k
               change = .true.
            endif
            j = 1
            nline = 0
         elseif ( a1 .eq. 'a' ) then !Add variable
            write(*,*) 'Enter variable name or (L)ist to see all '// & 
                        'variables previously used'
            read(*,10,IOSTAT=ist) tivar
            call lower(tivar,64)

            if ( tivar(1:1) .eq. 'l' .and. lrbl(tivar) .eq. 1 ) then
               call list_var(irow,tivar,1)
            endif

            if ( tivar(1:1) .ne. ' ' ) then
               terr = .false.
               do i = 1,n_ic
                  if ( tivar(:lrbl(tivar)) .eq. & 
                       ic_var(i)(:lrbl(ic_var(i))) ) terr = .true.
               enddo
               if ( terr ) then
                  write(*,*) 'Variable already exists.'// & 
                          '  Will not add it'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,10) tivar
                  j = 1 
                  nline = 0
               else
                  n_ic = n_ic + 1
                  ic_var(n_ic) = tivar
                  ic_val(n_ic) = 'null'
                  out_ic(n_ic) = 1
                  call get_value(ic_var(n_ic),ic_val(n_ic), & 
                                 ans,isatd,terr)
                  if ( .not. terr ) then
                     if ( ans(1:1) .ne. ' ' ) then
                        ic_val(n_ic) = ans
                        change = .true.
                        if ( index(ans,'null') .gt. 0 ) then
                           write(*,*) ' Variable will be output only'
                           write (*,*) 'Hit <CR> to continue.'
                           read (*,10) ans
                           out_ic(n_ic) = 2
                        else
                           call get_cod(cod)
                           if ( cod .ne. 99 ) then
                              out_ic(n_ic) = cod
                           endif
                        endif
                     elseif( index(ic_val(n_ic),'null') .gt. 0 ) then
                        write(*,*) ' Variable will be output only'
                        write (*,*) 'Hit <CR> to continue.'
                        read (*,10) ans
                        out_ic(n_ic) = 2
                        change = .true.
                     else
                        n_ic = n_ic - 1
                     endif
                  endif
                  call write_var(tivar,1) !Write varaible to variables.dat file
               endif
            endif
            nline = 0
            j = 1
         elseif( a1 .eq. 'c') then
            write(*,*) ' Enter Test Name or Number to COPY : <CR> = MENU'
            read(*,10,IOSTAT=ist) name
            call findname(name,i,itype,testname,testnum,numt)
            if ( itype .lt. 2 ) then
               ttestname = ftestname
               ftestname = name         
               oldt      = title
               oldc      = comment
               include "flt_read.inc" !read new data from ftestname.tdf
               do i=1,nic
                  out_ic(i) = icout(i)
                  ic_var(i) = icvar(i)
                  ic_val(i) = icval(i)
               enddo
               n_ic = nic
               change = .true.
               ftestname = ttestname !restore values to current test
               title     = oldt
               comment   = oldc
            else
               write(*,*) 'Test ',name,' not found'
               write(*,*) 'No changes made'
            endif
            j     = 1           !redisplay data from top
            nline = 0
         elseif ( a1 .eq. '0'  .or. a1 .eq. ' ') then !exit
            if ( change ) then !Rewrite test definition file
               write(*,*) 'Updating test definition file'
               filename = ftestname(:lrbl(ftestname))//'.tdf'
               call pathfile(testfile,fpath, & 
                    filename(:lrbl(filename)))

               call flt_write_ics(testfile,ic_var,ic_val,out_ic,n_ic, & 
                    .true.,err)
               if ( err ) return
! *   Re-read updated test definition file
               include "flt_read.inc" 
               write(*,*) 'Test definition file:',testfile(:rlan(testfile))
               write(*,*) 'Written to and re-read.'
               do i= 1,nic
                  ic_var(i) = icvar(i)
                  ic_val(i) = icval(i)
                  out_ic(i) = icout(i)
               enddo
            endif
            cont = .false.
         elseif ( a1 .eq. 'u' ) then !update output codes
            i=index(ans,'-')
            ierr  = 0 
            ierr2 = 0
            if ( i .gt. 1 ) then
               read(ans(2:i-1),*,IOSTAT=ierr) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans(2:),*,IOSTAT=ierr) inum1
               inum2 = inum1
            endif
            if ( ierr .eq. 0 .and. ierr2 .eq. 0 ) then
               call get_cod(cod)  !Promt for new cod
               if ( cod .ne. 99 ) then
                  do i=inum1,inum2
                     out_ic(i)=cod !Update with new code
                  enddo
                  change = .true. !altered
               endif            !If valid code
            endif
            j     = 1           !Re-display data from the top
            nline = 0
! *  Input must be modify number
         else                   ! command must be a number or #-#
            j     = 1           !Re-display data from the top
            nline = 0
            i=index(ans,'-')
            ierr  = 0 
            ierr2 = 0
            if ( i .gt. 1 ) then
               read(ans(:i-1),*,IOSTAT=ierr) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans,*,IOSTAT=ierr) inum1
               inum2 = inum1
            endif
            if ( ierr .ne. 0 .or. ierr2 .ne. 0 .or. & 
                 inum1 .lt. 1 .or. inum1 .gt. n_ic .or.  & 
                 inum2 .lt. 1 .or. inum2 .gt. n_ic ) then 
               write(*,*) 'Invalid index'
               write(*,*) 'Hit <CR> to Continue'
               read(*,*,IOSTAT=ist) ans
            else
               do i=inum1,inum2
                  call get_value(ic_var(i),ic_val(i),ans,isatd,terr)
                  if ( .not. terr ) then
                     if ( ans(1:1) .ne. ' ' ) then
                        ic_val(i) = ans
                        change = .true.
                     endif
                     if ( index(ic_val(i),'null') .gt. 0 ) then
                        write(*,*) ' Variable will be output only'
                        write (*,*) 'Hit <CR> to continue.'
                        read (*,10) ans
                        if ( out_ic(i) .ne. 2 ) then
                           out_ic(i) = 2
                           change = .true.
                        endif
                     else
                        call get_cod(cod)
                        if ( cod .ne. 99 ) then
                           out_ic(i)=cod !NEW CODE
                           change =.true. !altered
                        endif   ! invalid code
                     endif
                  endif         ! if .not. terr

               enddo            !modify loop
            endif               !if ierr = 0 and ierr2 = 0
!     
         endif                  ! Ic command conditionals
      enddo                     !IC command loop

      return
 10   format(a)
 20   format(a,1x,I7,2x,a)
 30   format(2x,i3,2x,a,' = ',a20,2x,a)
 50   format(3x,a,' = ',a20,4x,i1)



      end

      subroutine get_cod(cod)
      implicit none

! * Argument list

      integer*4     cod                 !Control code

! * Locals
      character*20  ans                 !Input answer

      cod = 99

      write(*,*) ' 0=Input Only : 1=Input&Output : 2=Output Only'
      write(*,*) 'Enter input/output control code: <cr>(default)' 
      read(*,'(A)') ans
      if (ans(1:1).ne.' ') then
         call ctoi(ans(1:2),cod)
         if ( cod .lt. 0 .or. cod .gt. 2 ) then
            write(*,*) 'Invalid control code. Will use default'
         endif
      endif

      return
      end

      subroutine get_value(ivar,ival,ans,isatd,err)
      implicit none

! * Argument List
      character*64  ivar              !Variable name
      character*80  ival              !Variable value - char string
      character*80  ans               !New value

      logical*4     err               !Err flag - true invalid data
      logical*4     isatd             !Can input be an atd driver

! * Locals

      character*80  answ              !Answer variable
      integer*4     type              !Input type of existing value
      integer*4     i                 !Integer value of input
      integer*4     ist               !IOSTAT flag

      real*4        x                 !Real value of input

! * Externals
      integer*4     lrbl              !Returns index of first blank from left
      integer*4     lran              !Returns index of first nonblank  from lt
      integer*4     rlan              !Returns index of first nonblank from rt

      ans = ' '
      err = .false.
      if ( isatd ) then
         write(*,20) ivar(:lrbl(ivar)),ival(lran(ival):rlan(ival))
      else
         write(*,10) ivar(:lrbl(ivar)),ival(lran(ival):rlan(ival))
      endif

      read(*,'(a)',IOSTAT=ist) ans
      if ( index(ivar,'naptdmd') .le. 0 ) then !dont do type get for chars
         if ( ans(1:1) .ne. ' ' .and. ist .eq. 0 ) then
            call lower(ans,80)
            call gettypeval(ivar,ans,x,type,err)
         else
            answ = ival
            call lower(answ,80)
            call gettypeval(ivar,answ,x,type,err)
         endif
      else
         type = 5
      endif

      if (  err .and.  isatd ) err = .false. !don't blow up for atds
      if ( err .or. type .lt. 2 .and. type .ne. -99 ) then
         if ( type .lt. 2 .and. type .ne. -99 ) then
            write(*,*) 'Unable to determine variable type'
         endif
         if ( err ) then
            write(*,*) 'Invalid input for this variable type'
         endif
         write(*,*) 'Hit return to continue'
         read(*,'(a)') answ
      endif
      return
 10   format(' Enter value for ',a,' <cr>= ',a,' (default)')
 20   format(' Enter value or driver for ',a,' <cr>= ',a,' (default)')
      end


      subroutine list_var(irow,var,itype)
      implicit none

! * Argument List
      character*64  var             !Output variable

      integer*4     irow            !Height of current display
      integer*4     itype           !Type of variable 
                                    !1=ic/in 2=ic/out 3=task 4=plot

! * Locals
      character*132 filename        !Complete file name
      character*64  vars(1000)      !variable array
      character*64  tvar            !temp variable 
      character*64  label           !Label for top
      character*10  types           !Type string
      character*1   ctype           !Type string

      integer*4     i,j,k           !Counters
      integer*4     nv              !Number of valid variables read in
      integer*4     nl              !Number of displayed lines
      integer*4     imx             !Length of longest variable name
      integer*4     ist             !IO status flag
      integer*4     col             !Number of columns to display

      integer*4     lu21 /21/       !Logical unit for variables.dat file

      logical*4     fexist          !File exists flag
      logical*4     cont            !Continue flag
! * Externals
      integer*4     lrbl            !Returns index of first blank from left
      integer*4     lran            !Returns index of first non-blank
      integer*4     rlan            !Returns index of last  non-blank

      include "flt_plot.inc"

      var = ' ' 

      call pathfile(filename,fpath,'variables.dat')

      inquire(FILE=filename,EXIST=fexist)

      if ( .not. fexist ) then !File does not exist
         write(*,*) 'File: '//filename(:lrbl(filename))
         write(*,*) 'Does not exist.'
         return
      endif

      open(UNIT=lu21,FILE=filename,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*) 'Error opening file: '//filename(:lrbl(filename))
         write(*,*) 'Unable to produce variable list'
         return
      endif


      write(ctype,'(i1)') itype

      if ( itype .eq. 1 ) then
         label = 'IC input Variables'
      elseif( itype .eq. 2 ) then
         label = 'IC Output Variables'
      elseif( itype .eq. 3 ) then
         label = 'Task 3/5 Variables'
      elseif( itype .eq. 4 ) then
         label = 'Plot Variables'
      endif


      nv = 0
      imx = 0

      read(lu21,10,IOSTAT=ist) types,tvar
      do while ( ist .eq. 0 .and. nv .lt. 1000 ) 
         k = index(types,ctype)
         if ( k .gt. 0 ) then    !This variable is of desired type
            nv = nv + 1
            vars(nv) = tvar(lran(tvar):) !remove leading spaces
            i = lrbl(vars(nv))
            if ( i .gt. imx ) imx = i
         endif
         read(lu21,10,IOSTAT=ist) types,tvar
      enddo

      close(lu21)

      cont = .true.

      if ( imx .le. 10 ) then
         col = 4
      elseif ( imx .le. 20 ) then
         col = 3
      elseif ( imx .le. 30 ) then
         col = 2
      else
         col = 1
      endif

      if ( nv .lt. 1 ) return

      j = 1
      do while ( cont )
         write(*,*) '     '//label(:rlan(label))
         write(*,*) ' '
         if ( j .gt. nv/col ) j = 1
         i = 1
         do while ( j .le. nv/col .and. nl .le. irow - 6 )
            if ( col .eq. 4 ) then
               write(*,14) (i,vars(i),i=j*4-3,j*4)
            elseif ( col .eq. 3 ) then
               write(*,13) (i,vars(i),i=j*3-2,j*3)
            elseif ( col .eq. 2 ) then
               write(*,12) (i,vars(i),i=j*2-1,j*2)
            else
               write(*,11)  j,vars(j)
            endif
            j = j + 1
            nl = nl + 1   !incr line count
         enddo

         if ( mod(nv,col) .gt. 0 .or. nv .lt. col ) then !write the remainer
            if ( col .eq. 4 ) then
               write(*,14) (j,vars(j),j=i,nv)
            elseif ( col .eq. 3 ) then
               write(*,13) (j,vars(j),j=i,nv)
            elseif ( col .eq. 2 ) then
               write(*,12) (j,vars(j),j=i,nv)
            else
               write(*,11) (j,vars(j),j=i,nv)
            endif
            nl = nl + 1   !incr line count
         endif

         write(*,*) ' Enter Variable # or +/= Next page  '// & 
                                      'or -/_ Prev page'
         read(*,20,IOSTAT=ist) tvar

         if ( ist .ne. 0 ) return

         if ( tvar(1:1) .eq. ' ') return

         if ( index(tvar,'+') .gt. 0 .or. index(tvar,'=') .gt. 0 ) then
            nl = 0
         elseif(index(tvar,'-') .gt. 0 .or. index(tvar,'_') .gt. 0) then
            j = j - 2*(irow-6)
            nl = 0
            if ( j .lt. 1 ) j = 1
         else  !Assume a number
            read(tvar,*,IOSTAT=ist) k
            if ( ist .ne. 0 .or. k .gt. nv .or. k .lt. 1 ) then
               write(*,*) 'Error reading input'
               write(*,*) 'Try again '
            else
               var = vars(k)
               return
            endif
         endif
      enddo


      return
 10   format(a10,a)
 11   format(6x,i3,'-',a)
 12   format(2(2x,i3,'-',a30))
 13   format(3(2x,i3,'-',a20))
 14   format(4(2x,i3,'-',a10))
 20   format(a)
      end

      subroutine write_var(var,itype)
      implicit none

! * Argument List
      character*64  var             !Output variable

      integer*4     itype           !Type of variable 
                                    !1=ic/in 2=ic/out 3=task 4=plot

! * Locals
      character*256 message         !Message
      character*132 filename        !Complete file name
      character*64  vars(1000)      !variable array
      character*64  tvar            !temp variable 
      character*64  label           !Label for top
      character*10  types           !Type string
      character*1   ctype           !Type string

      integer*4     i,j,k           !Counters
      integer*4     ist             !IO status flag

      integer*4     lu21 /21/       !Logical unit for variables.dat file
      integer*4     lu22 /22/       !Logical unit for variables.dat.old file

      logical*4     fexist          !File exists flag
      logical*4     fnd             !Variable found flag

! * Externals
      integer*4     lrbl            !Returns index of first blank from left
      integer*4     lran            !Returns index of first non-blank
      integer*4     rlan            !Returns index of last non-blank

      include "flt_plot.inc"

      call pathfile(filename,fpath,'variables.dat')

! * Verify varaibles.dat file exists
      inquire(FILE=filename,EXIST=fexist)

      if ( .not. fexist ) then !File does not exist
         write(*,*) 'File: '//filename(:lrbl(filename))
         write(*,*) 'Does not exist. Unable to add variable'
         return
      endif

! * Make back up copy of variables.dat to variables.dat.old
      i = lrbl(filename)
      call rename_file(filename(:i),filename(:i)//'.old',fnd)
 
      inquire(FILE=filename(:lrbl(filename))//'.old',EXIST=fexist)

      if ( .not. fexist .or. fnd ) then !File does not exist
         write(*,*) 'Unable to make copy of variables.dat'
         write(*,*) 'File: '//filename(:i)//'.old'
         write(*,*) 'Does not exist. Unable to add variable'
         return
      endif

! * Open both files
      open(UNIT=lu21,FILE=filename,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*) 'Error opening file: '//filename(:lrbl(filename))
         write(*,*) 'Unable to write variable to list'
         call rename_file(filename(:i)//'.old',filename(:i),fnd)
         return
      endif

      open(UNIT=lu22,FILE=filename(:lrbl(filename))//'.old',IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*) 'Error opening file: '//filename(:lrbl(filename))
         write(*,*) 'Unable to write variable to list'
         call rename_file(filename(:i)//'.old',filename(:i),fnd)
		 close(lu21)
         return
      endif

      write(ctype,'(i1)',IOSTAT=ist) itype

	  if ( ist .ne. 0 ) then
         write(*,*) 'Error writing variable type'
         write(*,*) 'Unable to write variable to list'
         call rename_file(filename(:i)//'.old',filename(:i),fnd)
		 close(lu21)
		 close(lu22)
         return
	  endif		

! * Check to see if variable already exists
      fnd = .false.
      read(lu22,10,IOSTAT=ist) types,tvar
      do while ( ist .eq. 0 .and. .not. fnd ) 
         if ( tvar(lran(tvar):rlan(tvar)) .eq. var(:lrbl(var)) ) then
            fnd = .true.
         else
            write(lu21,10,IOSTAT=ist) types,tvar
         endif
         read(lu22,10,IOSTAT=ist) types,tvar
      enddo

      if ( fnd ) then   !variable already exists in file
         k = index(types,ctype)
         if ( k .eq. 0 ) then   !this type not defined
            if ( types(itype:itype) .eq. ' ' ) then
               types(itype:itype) = ctype
            else
               i = 1
               do while ( types(i:i) .ne. ' ' .and. i .lt. 10 )
                  i = i + 1
               enddo
               types(i:i) = ctype
            endif
         endif
         write(lu21,10,IOSTAT=ist) types,tvar  !Write this line
         read(lu22,10,IOSTAT=ist) types,tvar
         do while ( ist .eq. 0 .and. .not. fnd )  !Write rest of file
            write(lu21,10,IOSTAT=ist) types,tvar
            read(lu22,10,IOSTAT=ist) types,tvar
         enddo
      else  !this variable not found rest of file already written
         types = ' '
         types(itype:itype) = ctype
         write(lu21,10,IOSTAT=ist) types,var
      endif

      close(lu21)
      close(lu22)


      return
 10   format(a10,a)

      end



      subroutine mod_task3(fattest,numt,testname,testnum,irow, & 
                         nt3,t3_var,t3_val)
      implicit none

      character*64  t3_var(100)          !Variables for task 3
      character*40  testname(1000)       !Testnames
      character*80  t3_val(100)          !Variables for task 3

      integer*4     testnum(1000)        !Test numbers
      integer*4     irow                !Number of rows on screen
      integer*4     nt3                 !Number of task 3 variables
      integer*4     fattest             !test number
      integer*4     numt                !Number of define tests

! * Locals
      character*132 oldt                !old title
      character*132 oldc                !old comment
      character*64  tivar               !Temp input variable name
      character*40  name                !temp input name
      character*40  ttestname           !temp storage for test name
      character*80  ans                 !answer string

      integer*4     itype               !Type of test input name=1 num=0
      integer*4     i,j,k,l             !Counters
      integer*4     imx                 !Max length of variables
      integer*4     ist                 !IO status flag         
      integer*4     col                 !Number of columns displayed
      integer*4     ierr                !Error flag
      integer*4     ierr2               !Error flag
      integer*4     inum1               !Start of range of IC's to modify
      integer*4     inum2               !End of range of IC's to modify
      integer*4     lu18  /18/          !Logical unit for testdef.tdf.old
      integer*4     fininrt             !Real time error flag

      logical*4     terr                !Error flag
      logical*4     cont                !continue loop
      logical*4     change              !Data changed update before returing
      logical*4     isatd  /.false./    !Is input atd for gat_value call

! * Externals (defined in flt_read_vars.inc lrbl rlan lran)


      include "flt_plot.inc"
      include "flt_read_vars.inc"

! * Get max variable length

      change = .false.

      imx = 0
      do i=1, nt3
         k = lrbl(t3_var(i))
         if ( k .gt. imx ) imx = k
      enddo

      j  = 1
      cont = .true.
      do while ( cont )
         write(*,*) ' '
         write(*,30)'     Task 3 ',fattest,ftestname
         write(*,*) '    ',title(:rlan(title))
         write(*,*) '    ',comment(:rlan(comment))
         write(*,*) ' '
         j = 1
         i = 0
         do while ( j .le. nt3 )
            write(*,20)  j,t3_var(j)(:imx), & 
                         t3_val(j)(lran(t3_val(j)):rlan(t3_val(j)))
            j = j + 1
         enddo

         write(*,*) ' '
         write(*,*) ' Enter Condition #-## or (A)dd or (D)elete #-##'
         write(*,*) ' (C)opy/Replace from other test (+) Go to Task 5'

         read(*,10,IOSTAT=ist) ans

         if ( ist .ne. 0 .or. ans(1:1) .eq. ' ' ) then
            if ( change ) then
               ans = ' '
            else
               return
            endif
         endif

         call lower(ans,20)

         if ( index(ans,'a') .gt. 0 ) then ! Add condition
            write(*,*) 'Enter variable name or (L)ist to see all '// & 
                        'variables previously used'
            read(*,10,IOSTAT=ist) tivar
            call lower(tivar,64)

            if ( tivar(1:1) .eq. 'l' .and. lrbl(tivar) .eq. 1 ) then
               call list_var(irow,tivar,3)
            endif

            if ( tivar(1:1) .ne. ' ' ) then
               terr = .false.
               do i = 1,nt3
                  if ( tivar(:lrbl(tivar)) .eq. & 
                       t3_var(i)(:lrbl(t3_var(i))) ) terr = .true.
               enddo
               if ( terr ) then
                  write(*,*) 'Variable already exists.'// & 
                          '  Will not add it'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,10) tivar
               else
                  nt3 = nt3 + 1
                  t3_var(nt3) = tivar
                  t3_val(nt3) = 'N/A'
                  call get_value(t3_var(nt3),t3_val(nt3),ans,isatd,terr)
                  if ( .not. terr ) then
                     if ( ans(1:1) .ne. ' ' ) then
                        t3_val(nt3) = ans
                        change = .true.
                        call write_var(tivar,3) !Write variables.dat file
                     else
                        nt3  = nt3 - 1
                     endif
                  else
                     nt3 = nt3 - 1
                  endif
               endif
               do i=1, nt3
                  k = lrbl(t3_var(i))
                  if ( k .gt. imx ) imx = k
               enddo
            endif !input variable

         elseif( index(ans,'d') .gt. 0 ) then !Delete Condition
            i=index(ans,'-')
            ierr  = 0 
            ierr2 = 0
            if ( i .gt. 1 ) then
               read(ans(2:i-1),*,IOSTAT=ierr) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans(2:),*,IOSTAT=ierr) inum1
               inum2 = inum1
            endif
            if ( ierr .ne. 0 .or. ierr2 .ne. 0 ) then
               write(*,*) 'Enter condition number to delete'
               read(*,10,IOSTAT=ist) ans
               read(ans,*,IOSTAT=ierr) inum1
               if ( ist .ne. 0 .or. ierr .ne. 0 ) then
                  write(*,*) 'Invalid input'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,10) tivar
               else
                  ierr2 = 0
                  inum2 = inum1
               endif
            endif
            if ( ierr .eq. 0 .and. ierr2 .eq. 0 ) then
               if ( inum1 .gt. inum2 & 
                    .or. inum1 .lt. 1 .or. inum1 .gt. nt3 & 
                    .or. inum2 .lt. 1 .or. inum2 .gt. nt3 ) then
                  write(*,*) 'Invalid index. '
                  write(*,*) 'Hit <CR> to continue.'
                  read(*,10) tivar
               else
                  k = inum2 - inum1 + 1 !number of variables to delete
                  do i=inum1,nt3-k
                     t3_var(i) = t3_var(i+k)
                     t3_val(i) = t3_val(i+k)
                  enddo
                  nt3 = nt3 - k
                  change = .true.
               endif
            endif
         elseif ( index(ans,'c') .gt. 0 ) then !Copy from other test
            write(*,*) ' Enter Test Name or Number to COPY : <CR> = MENU'
            read(*,10,IOSTAT=ist) name
            call findname(name,i,itype,testname,testnum,numt)
            if ( itype .lt. 2 ) then
               ttestname = ftestname
               ftestname = name         
               oldt      = title
               oldc      = comment
               include "flt_read.inc" !read new data from ftestname.tdf
               do i=1,ntask3
                  t3_var(i) = t3var(i)
                  t3_val(i) = t3val(i)
               enddo
               nt3 = ntask3
               change = .true.
               ftestname = ttestname !restore values to current test
               title     = oldt
               comment   = oldc
               do i=1, nt3           !Update imx variable to new values
                  k = lrbl(t3_var(i))
                  if ( k .gt. imx ) imx = k
               enddo
            else
               write(*,*) 'Test ',name(:lrbl(name)),' not found'
               write(*,*) 'No changes made'
            endif

         elseif ( ans(1:1) .eq. '0'  .or. ans(1:1) .eq. ' ' .or. & 
                 index(ans,'+') .gt. 0 .or. & 
                 index(ans,'=') .gt. 0) then !exit
            if ( change ) then !Rewrite test definition file
               write(*,*) 'Updating test definition file'
               filename = ftestname(:lrbl(ftestname))//'.tdf'
               call pathfile(testfile,fpath,filename(:lrbl(filename)))
			   i = lrbl(testfile)
			   call rename_file(testfile(:i),testfile(:i)//'.old',terr)

! *          Open .tdf file to write
               open(lu19,FILE=testfile,IOSTAT=istatus)
               if ( istatus .ne. 0 .or. terr ) then
                  write(*,*)  'UNABLE TO OPEN '// & 
                       testfile(:lrbl(testfile))
                  write(*,*) 'No changes made'
                  call rename_file(testfile(:i)//'.old',testfile(:i),terr)
                  return
               endif

! *          Open .tdf.old file to read
               open(lu18,FILE=testfile(:lrbl(testfile)) & 
                              //'.old',IOSTAT=i)
               if ( i .ne. 0 ) then
                  write(*,*) 'UNABLE TO OPEN '// & 
                       testfile(:lrbl(testfile))//'.old'
                  write(*,*) 'No changes made'
                  call rename_file(testfile(:i)//'.old',testfile(:i),terr)
                 return
               endif

               imx = 0
               do i=1,nt3   !update the max char length for output
                  j = lrbl(t3_var(i))
                  if ( j .gt. imx ) imx = j
               enddo
               i = 0
               k = 0
               l = 0
               do while ( ( i .eq. 0 .or. k .eq. 0 .or. l .eq. 0 ) & 
                    .and. istatus .eq. 0 ) 
                  read(lu18,10,IOSTAT=istatus) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'start')
                  k = index(lowline,'task')
                  l = index(lowline,'3')
                  write(lu19,10) line(:rlan(line)) !Echo data
               enddo
               do i=1,nt3 !Write new values read in from other test
                  write(lu19,50) t3_var(i)(:imx), & 
                                 t3_val(i)(:rlan(t3_val(i)))
               enddo
               i=0
               do while ( i .eq. 0 .and. istatus .eq. 0 )
                  read(lu18,10,IOSTAT=istatus) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'end') !read to end of task 3
               enddo
               write(lu19,10) line(:rlan(line)) !Write to end of file
               read(lu18,10,IOSTAT=istatus) line
               do while ( istatus .eq. 0 )
                  write(lu19,10) line(:rlan(line)) !Echo data 
                  read(lu18,10,IOSTAT=istatus) line
               enddo
               close(lu19)      !close testdef.tdf
               close(lu18)      !close testdef.tdf.old
! *   Re-read updated test definition file
               include "flt_read.inc" 
               write(*,*) 'Test definition file:',testfile(:rlan(testfile))
               write(*,*) 'Written to and re-read.'
            endif
            cont = .false.   !exit loop
            if ( index(ans,'+') .gt. 0 .or. & 
                 index(ans,'=') .gt. 0 ) then ! goto task 5
               if ( .not. change ) then
                  include "flt_read.inc"  !Read task 5 variables
               endif
                  call mod_task5(fattest,numt,testname,testnum,irow, & 
                       ncond,ntask5,t5var,t5val,t5source,t5sync,t5bias, & 
                       convar,conval,con,conop)
               return
            endif
         else !Input must be a number
            i=index(ans,'-')
            ierr  = 0 
            ierr2 = 0
            if ( i .gt. 1 ) then   !extract either 1 or a range 
               read(ans(:i-1),*,IOSTAT=ierr) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans,*,IOSTAT=ierr) inum1
               inum2 = inum1
            endif
            if ( ierr .eq. 0 .and. ierr2 .eq. 0 ) then
               if ( inum1 .gt. inum2 & 
                    .or. inum1 .lt. 1 .or. inum1 .gt. nt3 & 
                    .or. inum2 .lt. 1 .or. inum2 .gt. nt3 ) then
                  write(*,*) 'Invalid index. '
                  write(*,*) 'Hit <CR> to continue.'
                  read(*,10) tivar
               else
                  do i=inum1,inum2
                     call get_value(t3_var(i),t3_val(i),ans,isatd,terr)
                     if ( .not. terr ) then
                        if ( ans(1:1) .ne. ' ' ) then
                           t3_val(i) = ans
                           change = .true.
                        endif
                     endif
                  enddo
               endif
            endif
         endif
      enddo


 10   format(a)
 20   format(5x,i2,2x,a,' = ',a)
 30   format(a,1x,I7,2x,a)
 50   format(5x,a,' = ',a)

      return
      end



      subroutine mod_task5(fattest,numt,testname,testnum,irow, & 
                           n_con,nt5,t5_var,t5_val,t5_sor,t5_syn,t5_bia, & 
                           c_var,c_val,c_con,c_op)
      implicit none

      character*64  c_var(2,30)         !Variable for compare in conditionals
      character*80  c_val(2,30)         !value to compared coditional to
      character*64  t5_syn(30,15)       !Variable for t5 sync 
      character*64  t5_var(30,15)       !Variable to be set in task 5
      character*80  t5_val(30,15)       !Value to set t5var to - raw ascii
      character*8   t5_sor(30,15)       !Source of atd data ie .acd .atd .sim
      character*2   c_con(2,30)         !Condition Operator as in file
      character*40  testname(1000)       !Testnames

      real*4        t5_bia(30,15)       !Task 5 bias term

      integer*4     n_con               !Number of task5 conditions
      integer*4     c_op(30)            !operator between 1st & 2nd cond 
      integer*4     nt5(30)             !# of drivers per task 5 condition
      integer*4     testnum(1000)        !Test numbers
      integer*4     irow                !Number of rows on screen
      integer*4     fattest             !test number
      integer*4     numt                !Number of define tests

! * Locals
      character*132 oldt                !old title
      character*132 oldc                !old comment
      character*80  cval                !value string
      character*64  cvar                !variable string
      character*64  cblank               !blank string
      character*64  tivar               !Temp input variable name
      character*40  name                !temp input name
      character*40  ttestname           !temp storage for test name
      character*80  ans                 !answer string
      character*3   anor(3) /'   ','AND','OR '/
      character*2   logic(6) /'=','<','>','<=','>=','<>'/

      integer*4     dc                  !Define condition index
      integer*4     cv                  !Condition vairable index
      integer*4     itype               !Type of test input name=1 num=0
      integer*4     i,j,k,l             !Counters
      integer*4     imr                 !Max length of variables
      integer*4     iml                 !Max length of variables
      integer*4     icr                 !Max length of variables
      integer*4     icl                 !Max length of variables
      integer*4     ist                 !IO status flag         
      integer*4     col                 !Number of columns displayed
      integer*4     ierr                !Error flag
      integer*4     ierr2               !Error flag
      integer*4     ierr3               !Error flag
      integer*4     inum                !Start of range of IC's to modify
      integer*4     inum2               !End of range of IC's to modify
      integer*4     inum3               !End of range of IC's to modify
      integer*4     lu18  /18/          !Logical unit for testdef.tdf.old
      integer*4     fininrt             !Real time error flag

      logical*4     terr                !Error flag
      logical*4     ferr                !Error flag
      logical*4     cont                !continue loop
      logical*4     cont2               !continue loop
      logical*4     change              !Data changed update before returing
      logical*4     new                 !New input
      logical*4     isatd /.true./      !Input to get_value can be atd

      real*4        x                   !Temp x variable

! * Externals (defined in flt_read_vars.inc lrbl rlan lran)


      include "flt_plot.inc"
      include "flt_read_vars.inc"

! * Get max variable length

      change = .false.
      cval   = 'VALUE'
      cvar   = 'VARIABLE'
      cblank  = ' '


      imr = 8
      icr = 8
      iml = 8
      icl = 8
      do i=1, n_con
         k = lrbl(c_var(1,i))
         l = rlan(c_val(1,i))
         if ( k .gt. icr ) icr = k
         if ( l .gt. icl ) icl = l
         if ( c_op(i) .gt. 0 ) then
            k = lrbl(c_var(2,i))
            l = rlan(c_val(2,i))
            if ( k .gt. icr ) icr = k
            if ( l .gt. icl ) icl = l
         endif
         do j=1,nt5(i)
            k = lrbl(t5_var(i,j))
            l = rlan(t5_val(i,j))
             if ( k .gt. imr ) imr = k
             if ( l .gt. iml ) iml = l
         enddo
      enddo

      dc = 1
      cv = 1
      cont = .true.
      do while ( cont )
         write(*,*) ' '
         write(*,70)'     Task 5 ',fattest,ftestname
         write(*,*) '    ',title(:rlan(title))
         write(*,*) '    ',comment(:rlan(comment))
         write(*,*) ' '

         nl = 1
         do while ( dc .le. n_con .and. nl .lt. irow - 6 )
            if ( cv .eq. 1 ) then  !Write condition header
               write(*,*) ' '
               if ( c_op(dc) .gt. 0 ) then !two defining conditions
                   write(*,30) dc,c_var(1,dc)(:icr),c_con(1,dc), & 
                       c_val(1,dc)(:icl),anor(c_op(dc)+1), & 
                       c_var(2,dc)(:icr),c_con(2,dc),c_val(2,dc)(:icl)
               else !Only one defining condition
                  write(*,30) dc,c_var(1,dc)(:icr),c_con(1,dc), & 
                       c_val(1,dc)(:icl)
               endif
               write(*,40) cvar(:imr),cval(:icl)
               nl = nl + 3
            endif !IF First of condition
            if ( cv .le. nt5(dc) ) then
               call gettypeval(t5_var(dc,cv),t5_val(dc,cv),x,k,terr)

               if ( terr .and. ( k .ge. 2 .or. k .eq. -99)) then !atd driver
                  if ( t5_bia(dc,cv) .ne. 0.0 ) then
                     write(*,41) dc,cv,t5_var(dc,cv)(:imr), & 
                          t5_val(dc,cv)(:iml),t5_sor(dc,cv), & 
                          t5_syn(dc,cv)(:lrbl(t5_syn(dc,cv))), & 
                          t5_bia(dc,cv)
                  else
                     write(*,41) dc,cv,t5_var(dc,cv)(:imr), & 
                          t5_val(dc,cv)(:iml),t5_sor(dc,cv), & 
                          t5_syn(dc,cv)(:lrbl(t5_syn(dc,cv)))
                  endif
               else
                  if ( t5_bia(dc,cv) .ne. 0.0 ) then
                     write(*,41) dc,cv,t5_var(dc,cv)(:imr), & 
                          t5_val(dc,cv)(:iml),cblank(:8), & 
                          t5_syn(dc,cv)(:lrbl(t5_syn(dc,cv))), & 
                          t5_bia(dc,cv)
                  else
                     write(*,41) dc,cv,t5_var(dc,cv)(:imr), & 
                          t5_val(dc,cv)(:iml),cblank(:8), & 
                          t5_syn(dc,cv)(:lrbl(t5_syn(dc,cv)))
                  endif

               endif
               nl = nl + 1
            endif

            if ( cv .eq. nt5(dc) .and. dc .lt. n_con ) then
               if ( nt5(dc+1) + nl .lt. irow - 6) then
                  dc = dc + 1
                  cv = 0
               else
                  write(*,*) 'Display More.  '// & 
                             'Will scroll screen. (Y/n)'
                  read(*,10,IOSTAT=ist) ans
                  if ( ist .ne. 0 ) then
                     ans = 'y'
                  endif
                  call lower(ans,20)
                  if ( index(ans,'n') .gt. 0 ) then
                     nl = irow
                  else
                     dc = dc + 1
                     cv = 0
                     nl = 1
                  endif
               endif
            elseif ( cv .ge. nt5(dc) ) then
               cv = 0
               dc = dc + 1
            endif
            cv = cv + 1
            if ( cv .le. nt5(dc) .and. nl .ge. irow -6 ) then
               nl = nl - 1
            endif
         enddo

         write(*,*) ' '
         write(*,*) ' Enter Condition # [(,.)#] (C)opy  (D)elete #[,#-#]'
         write(*,*) ' (R)eview  (H)elp (+=)goto task 3'


         read(*,10,IOSTAT=ist) ans

         if ( ist .ne. 0 .or. ans(1:1) .eq. ' ' ) then
            if ( change ) then
               ans = ' '
            else
               return
            endif
         endif

         call lower(ans,20)

         if ( index(ans,'r') .gt. 0 ) then ! Review
            cv = 1
            dc = 1

         elseif( index(ans,'d') .gt. 0 ) then !Delete Condition
            ierr  = 0 
            ierr2 = 0
            ierr3 = 0
            if ( rlan(ans) .le. index(ans,'d') ) then
               write(*,*) 'Enter condition number to delete #[,#-#]'
               read(*,10,IOSTAT=ist) ans
               if ( ist .ne. 0 ) then
                  ans = ' '
                  ierr = 1
               endif
            endif

            i=index(ans,'-')
            k=index(ans,',') + index(ans,'.')
            l = 0
            if ( k .eq. 0 ) then !No sub condition specified
               read(ans(index(ans,'d')+1:),*,IOSTAT=ierr) inum  !Define #
               inum2 = 1
               inum3 = 0
               if ( ierr .eq. 0 ) inum3 = nt5(inum)
               l = 1
            else  ! condition #,# specified
               read(ans(2:k-1),*,IOSTAT=ierr) inum  !Define #
               if ( inum .gt. n_con ) inum = n_con
               if ( inum .lt. 1     ) inum = 1
               if ( i .gt. 1 ) then
                  read(ans(k+1:i-1),*,IOSTAT=ierr2) inum2
                  read(ans(i+1:),*,IOSTAT=ierr3) inum3
                  if ( inum3 .lt. inum2 ) inum3 = inum2
               else
                  read(ans(k+1:),*,IOSTAT=ierr2) inum2
                  inum3 = inum2
               endif
               if ( inum3 .gt. nt5(inum) ) inum3 = nt5(inum)
               if ( inum2 .gt. nt5(inum) ) inum2 = nt5(inum)
            endif
            if ( ierr .ne. 0 .or. ierr2 .ne. 0 .or. ierr3 .ne. 0 ) then
               write(*,*) 'Invalid input'
               write (*,*) 'Hit <CR> to continue.'
               read (*,10) tivar
            else
               k = inum3 - inum2 + 1 !number of variables to delete
               do i=inum2,nt5(inum)-k
                  t5_var(inum,i) = t5_var(inum,i+k)
                  t5_val(inum,i) = t5_val(inum,i+k)
                  t5_sor(inum,i) = t5_sor(inum,i+k)
                  t5_syn(inum,i) = t5_syn(inum,i+k)
               enddo
               nt5(inum) = nt5(inum) - k
               if ( nt5(inum) .eq. 0 .and. l .eq. 1 ) then !condition deleted
                  do i=inum,n_con-1
                     c_val(1,i) = c_val(1,i+1)
                     c_var(1,i) = c_var(1,i+1)
                     c_con(1,i) = c_con(1,i+1)
                     c_val(2,i) = c_val(2,i+1)
                     c_var(2,i) = c_var(2,i+1)
                     c_con(2,i) = c_con(2,i+1)
                     c_op(i)    = c_op(i+1)
                     do j= 1,nt5(i+1)
                        t5_var(i,j) = t5_var(i+1,j)
                        t5_val(i,j) = t5_val(i+1,j)
                        t5_sor(i,j) = t5_sor(i+1,j)
                        t5_syn(i,j) = t5_syn(i+1,j)
                     enddo
                     nt5(i) = nt5(i+1)
                  enddo
                  n_con = n_con - 1
               endif
               change = .true.
            endif
            cv = 1
            dc = 1
         elseif ( index(ans,'c') .gt. 0 ) then !Copy from other test
            cv = 1
            dc = 1
            write(*,*) ' Enter Test Name or Number to COPY : <CR> = MENU'
            read(*,10,IOSTAT=ist) name
            call findname(name,i,itype,testname,testnum,numt)
            if ( itype .lt. 2 ) then
               ttestname = ftestname
               ftestname = name         
               oldt      = title
               oldc      = comment
               include "flt_read.inc" !read new data from ftestname.tdf
               if ( fininrt .ne. 3 ) then
                  imr = 8
                  icr = 8
                  n_con = ncond
                  do i=1,ncond
                     c_val(1,i) = conval(1,i)
                     c_var(1,i) = convar(1,i)
                     c_con(1,i) = con(1,i)
                     c_val(2,i) = conval(2,i)
                     c_var(2,i) = convar(2,i)
                     c_con(2,i) = con(2,i)
                     c_op(i)    = conop(i)
                     k = lrbl(c_var(1,i))
                     l = lrbl(c_val(1,i))
                     if ( k .gt. icr ) icr = k
                     if ( l .gt. icl ) icl = l
                     if ( c_op(i) .gt. 0 ) then
                        k = lrbl(c_var(2,i))
                        l = rlan(c_val(2,i))
                        if ( k .gt. icr ) icr = k
                        if ( l .gt. icl ) icl = l
                     endif

                     do j=1,ntask5(i)
                        t5_var(i,j) = t5var(i,j)
                        t5_val(i,j) = t5val(i,j)
                        t5_sor(i,j) = t5source(i,j)
                        t5_syn(i,j) = t5sync(i,j)
                        k = lrbl(t5_var(i,j))
                        l = rlan(t5_val(i,j))
                        if ( k .gt. imr ) imr = k
                        if ( l .gt. iml ) iml = l
                     enddo
                     nt5(i) = ntask5(i)
                  enddo
                  change = .true.
               endif
               ftestname = ttestname !restore values to current test
               title     = oldt
               comment   = oldc
            else
               write(*,*) 'Test ',name(:lrbl(name)),' not found'
               write(*,*) 'No changes made'
            endif

         elseif ( ans(1:1) .eq. '0'  .or. ans(1:1) .eq. ' ' .or. & 
                 index(ans,'=') .gt. 0 .or. & 
                 index(ans,'+') .gt. 0 ) then !exit
            if ( change ) then !Rewrite test definition file
               write(*,*) 'Updating test definition file'
               filename = ftestname(:lrbl(ftestname))//'.tdf'
               call pathfile(testfile,fpath,filename(:lrbl(filename)))
				i = lrbl(testfile)
			   call rename_file(testfile(:i),testfile(:i)//'.old',ferr)

! *          Open .tdf file to write
               open(lu19,FILE=testfile,IOSTAT=istatus)
               if ( istatus .ne. 0 ) then
                  write(*,*)  'UNABLE TO OPEN '// & 
                       testfile(:lrbl(testfile))
                  write(*,*) 'No changes made'
	    		  call rename_file(testfile(:i)//'.old',testfile(:i),ferr)
                  return
               endif

! *          Open .tdf.old file to read
               open(lu18,FILE=testfile(:lrbl(testfile))//'.old',IOSTAT=i)
               if ( i .ne. 0 ) then
                  write(*,*) 'UNABLE TO OPEN '// & 
                       testfile(:lrbl(testfile))//'.old'
                  write(*,*) 'No changes made'
	    		  call rename_file(testfile(:i)//'.old',testfile(:i),ferr)
                  return
               endif

! *          Update character lengths               
               imr = 8
               icr = 8
               iml = 8
               icl = 8
               do i=1, n_con
                  k = lrbl(c_var(1,i))
                  l = rlan(c_val(1,i))
                  if ( k .gt. icr ) icr = k
                  if ( l .gt. icl ) icl = l
                  if ( c_op(i) .gt. 0 ) then
                     k = lrbl(c_var(2,i))
                     l = rlan(c_val(2,i))
                     if ( k .gt. icr ) icr = k
                     if ( l .gt. icl ) icl = l
                  endif
                  do j=1,nt5(i)
                     k = lrbl(t5_var(i,j))
                     l = rlan(t5_val(i,j))
                     if ( k .gt. imr ) imr = k
                     if ( l .gt. iml ) iml = l
                  enddo
               enddo


               i = 0
               k = 0
               l = 0
! *          Read and write file down to start task 5 line
               do while ( ( i .eq. 0 .or. k .eq. 0 .or. l .eq. 0 ) & 
                    .and. istatus .eq. 0 ) 
                  read(lu18,10,IOSTAT=ist) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'start')
                  k = index(lowline,'task')
                  l = index(lowline,'5')
                  if ( ist .eq. 0) write(lu19,10) line(:rlan(line)) !Echo data
               enddo

! *          Write new data for task 5
               do i=1,n_con
                  if ( c_op(i) .gt. 0 ) then  !more than one define
                     write(lu19,60) c_var(1,i)(:icr),c_con(1,i), & 
                       c_val(1,i)(:icl),anor(c_op(i)+1), & 
                       c_var(2,i)(:icr),c_con(2,i),c_val(2,i)(:icl)
                  else !Only one define
                     write(lu19,60) c_var(1,i)(:icr),c_con(1,i), & 
                       c_val(1,i)(:icl)
                  endif
                  do j=1,nt5(i)
                     write(line,65) t5_var(i,j)(:imr),t5_val(i,j)(:iml)
                     call gettypeval(t5_var(i,j),t5_val(i,j),x,k,terr)
                     if ( terr .and. (k .ge. 2 .or. k .eq. -99)) then !atd
                        line = line(:rlan(line))//' Source = '// & 
                             t5_sor(i,j)(:lrbl(t5_sor(i,j)))
                     endif
                     if ( t5_syn(i,j)(1:1) .ne. ' ' ) then
                        line = line(:rlan(line))//' Sync = '// & 
                             t5_syn(i,j)(:lrbl(t5_syn(i,j)))
                     endif

                     if ( t5_bia(i,j) .ne. 0.0 ) then
                        write(tivar,*) t5_bia(i,j)
                        tivar = tivar(lran(tivar):rlan(tivar))
                        line = line(:rlan(line))//' Bias = '// & 
                             tivar(:lrbl(tivar))
                     endif

                     write(lu19,10) line(:rlan(line))
 65                  format(6x,a,' = ',a,1x)
                  enddo
               enddo
               i = 0
               ist = 0
! *          Read and discard the old task 5 information
               do while ( i .eq. 0 .and. ist .eq. 0 )
                  read(lu18,10,IOSTAT=istatus) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'end') !read to end of task 5
               enddo
! *          Read and write the remainder of the file
               write(lu19,10) line(:rlan(line)) !Write to end of file
               read(lu18,10,IOSTAT=ist) line
               do while ( ist .eq. 0 )
                  write(lu19,10) line(:rlan(line)) !Echo data 
                  read(lu18,10,IOSTAT=ist) line
               enddo
               close(lu19)      !close testdef.tdf
               close(lu18)      !close testdef.tdf.old

! *   Re-read updated test definition file
               include "flt_read.inc" 
               write(*,*) 'Test definition file:',testfile(:rlan(testfile))
               write(*,*) 'Written to and re-read.'
            endif
            cont = .false.  !exit loop
            if ( index(ans,'+') + index(ans,'=') .gt. 0 ) then
               if ( .not. change ) then
                  include "flt_read.inc"  !Read the task 3 variables
               endif
               call mod_task3(fattest,numt,testname,testnum,irow, & 
                    ntask3,t3var,t3val)
               return
            endif

         else !Input must be a number
            cv = 1
            i=index(ans,',') + index(ans,'.')
            ierr  = 0 
            ierr2 = 0
            if ( i .gt. 1 ) then   !#,#
               read(ans(:i-1),*,IOSTAT=ierr) inum
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans,*,IOSTAT=ierr) inum
               inum2 = 99
            endif
            if ( ierr .eq. 0 .and. ierr2 .eq. 0 ) then
               if ( inum .le. 0 .or. inum .gt. n_con + 1 .or.    & !invalid
                    ( inum .gt. n_con .and. inum2 .ne. 99)  & !can't add define
                    .or. inum2 .le. 0 .or. & 
                    (inum2 .gt. ndimt5 .and. inum2 .ne. 99 ) ) then
                  write(*,*) 'Invalid index. '
                  write(*,*) 'Hit <CR> to continue.'
                  read(*,10) tivar

               else
                  new = .false.
                  if ( inum2 .eq. 99 ) then !Edit define line
                     if ( inum .gt. n_con ) new = .true.
                     cont2 = .true.
                     j = 1
                     do while ( j .le. 2 .and. cont2 )
                        write(*,*) 'Enter variable name or '// & 
                             '(L)ist to see all '// & 
                             'variables previously used'
                        if ( .not. new ) then
                           write(*,*) 'Hit <CR> for current = ', & 
                                c_var(j,inum)(:lrbl(c_var(j,inum)))
                        endif

                        read(*,10,IOSTAT=ist) tivar
                        call lower(tivar,64)
                        if ( tivar(1:1) .eq. 'l' & 
                             .and. lrbl(tivar) .eq. 1 ) then
                           call list_var(irow,tivar,3)
                        endif

                        if ( tivar(1:1) .ne. ' '  ) then
                           if ( j .eq. 1 .and. new ) then
                              n_con = n_con + 1
                              inum = n_con
                              c_op(inum)    = 0
                              nt5(inum)     = 0
                           endif
                           if ( new ) then
                              c_con(j,inum) = '= '
                              c_val(j,inum) = 'N/A'
                           else
                              if ( c_var(j,inum)(:lrbl(c_var(j,inum))) & 
                                   .ne. tivar(:lrbl(tivar)) ) then
                                 change = .true.
                                 c_val(j,inum) = 'N/A'
                              endif
                           endif
                           c_var(j,inum) = tivar
                        endif

                        write(*,*) 'Choose operator 1=EQ '// & 
                             '2=LT 3=GT 4=LE 5=GE 6=NE'
                        write(*,*) 'Hit <CR> for default: "', & 
                                    c_con(j,inum),'"'

                        read(*,'(i1)',IOSTAT=ist) i
                        if ( ist .eq. 0 .and. i .le. 6 & 
                                .and. i .ge. 1 ) then
                           if ( .not. new ) then
                              if (  c_con(j,inum) .ne. logic(i)) & 
                                   change = .true.
                           endif
                           c_con(j,inum) = logic(i)
                        endif
                        isatd = .false.
                        call get_value(c_var(j,inum),c_val(j,inum), & 
                                       ans,isatd,terr)
                        if ( .not. terr ) then
                           if ( ans(1:1) .ne. ' ' ) then
                              c_val(j,inum) = ans
                              change = .true.
                              call write_var(c_var(j,inum),3)
                           else
                              if ( new ) n_con = n_con - 1
                           endif
                        else
                           cont2 = .false.
                           if ( new ) n_con = n_con - 1
                        endif
                        if ( j .eq. 1 ) then
                           if (  c_op(inum) .eq. 0 ) then
                              write(*,*) 'Do you want a second '// & 
                                   'parameter for this define (y,N)'
                              read(*,10,IOSTAT=ist) ans
                              call lower(ans,20)
                              if ( ist .ne. 0 .or. & 
                                   index(ans,'y') .eq. 0 ) then
                                 cont2 = .false.
                              else
                                 c_op(inum) = 1
                              endif
                           endif

                           if ( c_op(inum) .gt. 0 ) then
                              write(*,*) 'Input operator'// & 
                                ' 1=AND 2=OR  3=Delete <CR>=', & 
                                    anor(c_op(inum)+1)
                              read(*,'(i1)',IOSTAT=ist) i
                              if ( ist .ne. 0 .or. i .gt. 2) then
                                 c_op(inum) = 0
                                 c_val(2,inum) = ' '
                                 c_var(2,inum) = ' '
                                 cont2 = .false.
                              elseif ( i .eq. 2 ) then    
                                 c_op(inum) = 2
                              elseif ( i .eq. 1 ) then
                                 c_op(inum) = 1
                              endif
                              change = .true.
                           endif
                        endif !if j eq 1
                        j = j + 1
                     enddo
                     dc = inum
                  endif  !edit define 

                  if ( inum2 .eq. 99 ) then
                     write(*,*) 'Do you want to edit sub conditions (y/N)'
                     read(*,10,IOSTAT=ist) ans
                     call lower(ans,20)
                     if ( ist .eq. 0 .and. & 
                          index(ans,'y') .gt. 0 ) then
                        inum2 = 1
                     endif
                  endif

!
!   Edit sub condition
                  if ( inum2 .ne. 99) then !edit sub condition
                     if ( inum2 .gt. nt5(inum) ) then
                        new   = .true.
                     endif
                     cont2 = .true.
                     do while ( cont2 )
                        write(*,*) 'Enter variable name or '// & 
                             '(L)ist to see all '// & 
                             'variables previously used'
                        if ( .not. new ) then
                           write(*,*) 'Hit <CR> for default = ', & 
                           t5_var(inum,inum2)(:lrbl(t5_var(inum,inum2)))
                        endif

                        read(*,10,IOSTAT=ist) tivar
                        call lower(tivar,64)
                        if ( tivar(1:2) .eq. 'l ' & 
                             .and. lrbl(tivar) .eq. 1 ) then
                           call list_var(irow,tivar,3)
                        endif
                        if ( tivar(1:1) .ne. ' ' .and. new ) then
                           inum2 = nt5(inum) + 1
                           nt5(inum) = inum2
                           t5_var(inum,inum2) = & 
                                   tivar(lran(tivar):rlan(tivar))
                           t5_val(inum,inum2) = 'N/A'
                           t5_sor(inum,inum2) = 'acd'
                           t5_syn(inum,inum2) = ' '
                           t5_bia(inum,inum2) = 0.0
                        elseif ( tivar(1:1) .ne. ' ' ) then
                           if ( t5_var(inum,inum2) & 
                               (:lrbl(t5_var(inum,inum2))) .ne. & 
                                tivar(lran(tivar):rlan(tivar)) ) then
                              t5_var(inum,inum2) = & 
                                   tivar(lran(tivar):rlan(tivar))
                              change = .true.
                           endif
                        endif

                        isatd = .true.
                        call get_value(t5_var(inum,inum2), & 
                             t5_val(inum,inum2),ans,isatd,terr)
                        if ( .not. terr ) then
                           if ( ans(1:1) .ne. ' ' ) then
                              t5_val(inum,inum2) = ans
                              change = .true.
                              call write_var(t5_var(inum,inum2),3)
                           else
                              if ( new ) nt5(inum) = nt5(inum) - 1
                           endif
                        else
                           cont2 = .false.
                           if ( new ) nt5(inum) = nt5(inum) - 1
                        endif

                        if ( cont2 ) then  !input valid
                           call gettypeval(t5_var(inum,inum2), & 
                                t5_val(inum,inum2),x,i,err)
                           if(err .and. (i .ge. 2 .or. i .eq.-99)) then
                              write(*,*) 'Input source file '// & 
                                   '1=atd 2=acd 3=pom or xxx'
                              write(*,*) 'Hit <CR> for default = ', & 
                                         t5_sor(inum,inum2)

                              read(*,10,IOSTAT=ist) ans
                              if ( ist .eq. 0 ) then
                                 if ( index(ans,'1') .gt. 0 ) then
                                    t5_sor(inum,inum2)='atd'
                                 elseif ( index(ans,'2') .gt. 0 ) then
                                    t5_sor(inum,inum2)='acd'
                                 elseif ( index(ans,'3') .gt. 0 ) then
                                    t5_sor(inum,inum2)='pom'
                                 elseif ( ans(1:1) .ne. ' ' ) then
                                    t5_sor(inum,inum2) = & 
                                         ans(lran(ans):rlan(ans))
                                 endif
                                 change = .true.
                              endif
                           endif !if atd driver


! *                     Deal with sync variable
                           write(*,*) 'Sync variable for '// & 
                                t5_var(inum,inum2)
                           write(*,*)'(A)dd (C)hange (D)elete Hit'// & 
                             ' <CR> for default = ', t5_syn(inum,inum2)

                           read(*,10,IOSTAT=ist) ans
                           call lower(ans,80)
                           if (ist .eq. 0 .and. ( & 
                                index(ans,'c') .gt. 0 .or. & 
                                index(ans,'a') .gt. 0 )  ) then
                              write(*,*) 'Input sync variable. '// & 
                                    'Note: can be any global variable'
                              read(*,10,IOSTAT=ist) ans
                              if ( ist .eq. 0 .and. ans .ne. ' ') then
                                 t5_syn(inum,inum2) = & 
                                      ans(lran(ans):rlan(ans))
                                 change = .true.
                              endif
                           elseif ( ist .eq. 0 .and. & 
                                   index(ans,'d') .gt.  0 ) then
                              t5_syn(inum,inum2) = ' '
                              change = .true.
                           endif

! *                     Deal with bias
                           write(*,*) 'Bias for '// & 
                                t5_var(inum,inum2)

                           write(*,*)'(C)hange (D)elete Hit'// & 
                             ' <CR> for default = ', t5_bia(inum,inum2)

                           read(*,10,IOSTAT=ist) ans
                           call lower(ans,80)
                           if (ist .eq. 0 .and. & 
                                index(ans,'c') .gt. 0 ) then
                              write(*,*) 'Input bias value '
                              read(*,10,IOSTAT=ist) ans
                              if ( ist .eq. 0 .and. ans .ne. ' ') then
                                 read(ans,*,IOSTAT=ist) x
                                 if ( ist .eq. 0 ) then
                                    t5_bia(inum,inum2) = x
                                    change = .true.
                                 endif
                              endif
                           elseif ( ist .eq. 0 .and. & 
                                   index(ans,'d') .gt.  0 ) then
                              t5_bia(inum,inum2) = 0.0
                              change = .true.
                           endif


                           if ( new ) then
                              write(*,*) 'Do you want to input'// & 
                                   ' another variable (y,N)?'
                              read(*,10,IOSTAT=ist) ans
                              call lower(ans,20)
                           else
                              ans = 'n'
                           endif
                           if ( ist .eq. 0 .and. & 
                                index(ans,'y') .gt. 0 ) then
                              cont2 = .true.
                              inum2 = inum2 + 1
                              if ( inum2 .gt. ndimt5 ) then
                                 write(*,*) 'Maximum number of '// & 
                                      'statements for contional'
                                 cont2 = .false.
                              endif
                           else
                              cont2 = .false.
                           endif
                        endif
                     enddo
                     dc = inum
                     cv = 1
                  endif         !If define edit
               endif    !Number valid as a condition
            endif       !Input valid as a number
         endif                  !Master command conditional
      enddo


 10   format(a)
 20   format(5x,i2,2x,a,' = ',a)
 30   format('Condition #',i2,2x,a,1x,a,1x,a,2x,a3,2x,a,1x,a,1x,a)
 40   format(11x,a,3x,a,'SOURCE         SYNC          BIAS')
 41   format(2x,i2,',',i2,4x,a,' = ',a,3x,a,3x,a,3x,f10.3)
 50   format(5x,a,' = ',a)
 60   format('   Define ',a,1x,a2,1x,a,2x,a3,2x,a,1x,a2,1x,a)
 70   format(a,1x,I7,2x,a)

      return
      end



      subroutine list_ic(irow,var,flg)

      implicit none

! * Argument List
      integer*4     irow            !Number of rows in display
      integer*4     flg             !Flag to return a var =1

      character*64  var             !Variable output

      logical*4     cont            !Continue flag
! * Locals 

      character*256 filename        !Complete file with path
      character*256 message         !Error message
      character*132 line            !Line to read from file
      character*64  vars(1000)       !Variables
      character*36  labs(1000)       !labels for variables
      character*36  tilab           !Input label
      character*20  ans             !Input answer

      integer*4     nv              !Number of variables
      integer*4     i,j,k,l         !Counters
      integer*4     fnum(1000)       !Ic order
      integer*4     ord(1000)        !Index in order
      integer*4     lu80 /80/       !Logical unit for flt_symbols.dat
      integer*4     lu81 /81/       !Logical unit for flt_symbols.dat.new
      integer*4     ist             !IOSTAT flag =0 for OK
      integer*4     is              !Integer index
      integer*4     ierr1           !Read error flag
      integer*4     ierr2           !Read error flag
      integer*4     inum1           !Index of input
      integer*4     inum2           !Index of input
      integer*4     imx             !Max length of vars
      integer*4     nl              !NUmber of lines displayed
      integer*4     nonum           !Number for vars w/o number

      logical*4     ch              !Temp changed flag
      logical*4     change          !Data changed now update file
      logical*4     ferr            !Error flag

! * Externals
      integer*4     rlan            !Returns index of most right char
      integer*4     lran            !Returns index of most left char

      include "flt_plot.inc"

      var = ' '

      call pathfile(filename,fpath,'flt_symbols.dat')
      open(lu80,FILE=filename,IOSTAT=ist)
      if ( ist .ne. 0 ) then
         write(*,*) 'Unable to open: ',filename
         write(*,*) 'Unable to display list of variables'
         return
      endif


      read(lu80,10,IOSTAT=ist) line
      nl = 1 
      nv = 0
      cont = .true.
      nonum = 0
      do while ( ist .eq. 0 .and. cont )      
         k = index(line,'|')
         if ( line(1:1) .ne. '#' .and. k .gt. 0 ) then   ! exclude comments
            nv = nv + 1
            read(line(k+1:),*,IOSTAT=ist) vars(nv)
            call lower(vars(nv),64)
            if ( ist .ne. 0 ) then
               message= 'Unable to read sim variable (second column)'
               call write_mess(message,line,nl,filename)
               close(lu80)
               return
            endif
            do i=1,2
               k = index(line(k+1:),'|') + k
            enddo
            l = index(line(k+1:),'|') + k
            read(line(k+1:l-1),*,IOSTAT=ist) fnum(nv) 
            if ( ist .ne. 0 .or. fnum(nv) .eq. 0 ) then ! order doesn't exist 
               fnum(nv) = nonum + 1000 ! set to end of list
               nonum = nonum + 1
            endif
            i = lran(line(l+1:))
            read(line(l+i:),10,IOSTAT=ist) labs(nv)
            if ( ist .ne. 0 ) then ! Error reading this line
               message='Unable to read Title for '//vars(nv)
               call write_mess(message,line,nl,filename)
               close(lu80)
               return
            endif
         endif  ! Is a comment line

         read(lu80,'(a)',IOSTAT=ist) line
         nl = nl + 1

      enddo

!      close(lu80)  ! close flt_symbols.dat    

! * Create ordered array
      ord(1) = 1
      imx =  rlan(vars(1))
      do j=2,nv
         k = 1
         ch = .false.
         do while ( k .le. j-1 .and. .not. ch )
            if ( fnum(j) .lt. fnum(ord(k)) ) then !new min
               do l = j,k+1,-1
                  ord(l) = ord(l-1)
               enddo
               ord(k) = j
               ch = .true. 
            endif
            k = k + 1
         enddo
         if ( .not. ch ) ord(j) = j
         l = rlan(vars(j))
         if ( l .gt. imx ) imx = l
      enddo


      nl = 0
      cont = .true.
      j = 1
      do while ( cont )  
         write(*,*) ''
         write(*,*) '     VARIABLES DEFINE IN flt_symbols.dat'
         write(*,*) ' '
         write(*,*) '*= IC order not specified'

         nl = 0
         do while ( nl .lt. irow -8 ) 
            if ( fnum(ord(j)) .lt. 1000 ) then
               write(*,20) j,vars(ord(j))(:imx),labs(ord(j)) & 
                 (:rlan(labs(ord(j))))
            else
               write(*,21) j,vars(ord(j))(:imx),labs(ord(j)) & 
                 (:rlan(labs(ord(j))))
            endif
            nl = nl + 1
            j = j + 1


            if ( j .gt. nv ) then
               j = 1
               nl = irow
            endif

         enddo

         write(*,*) ''

         write(*,*) 'Input # or '// & 
                    '+= Down  -_ Up (L)abel (E)xit or <CR>  '
         write(*,*) '(M)ove #,# (from,to)'

         read(*,10,IOSTAT=ist) ans
         call lower(ans,20)

         if ( ist .ne. 0 ) then
            ans = 'e'
         endif

         if ( index(ans,'=') .gt. 0 .or. index(ans,'+') .gt. 0 ) then
            cont = .true.
         elseif ( index(ans,'e') .gt. 0 .or. ans(1:1) .eq. ' ' ) then
            if (change ) then
               rewind(lu80)
               call pathfile(filename,fpath,'flt_symbols.dat.new')
               open(lu81,FILE=filename,IOSTAT=ist)
               if ( ist .ne. 0 ) then
                  write(*,*) 'Unable to open: ',filename
                  write(*,*) 'Can not update flt_symbols.dat file'
                  close(lu80)
                  return
               endif


               read(lu80,10,IOSTAT=ist) line
               nl = 1 
               nv = 0
               do while ( ist .eq. 0 )      
                  k = index(line,'|')
                  if ( line(1:1) .ne. '#' .and. k .gt. 0 ) then ! exclude comments
                     nv = nv + 1
                     l = index(line(k+1:),'|') + k
                     line = line(:k)//' '//vars(nv)(:imx)//' '//line(l:)
                     do i=1,2
                        k = index(line(k+1:),'|') + k
                     enddo
                     l = index(line(k+1:),'|') + k
                     ans = ' '
                     if ( fnum(nv) .lt. 1000 ) then
                        write(ans,*) fnum(nv)
                        ans=ans(lran(ans):)
                     endif
                     line = line(:k)//' '//ans(:5)//line(l:)

                     l = index(line(k+1:),'|') + k
                     line = line(:l)//' '//labs(nv)(:rlan(labs(nv)))
                  endif         ! Is a comment line

                  write(lu81,10) line(:rlan(line))

                  read(lu80,10,IOSTAT=ist) line
                  nl = nl + 1

               enddo
               close(lu81)
               close(lu80)
               line=filename
               call pathfile(filename,fpath,'flt_symbols.dat')
			   call rename_file(line(:rlan(line)),filename(:rlan(filename)),ferr)
               if ( ferr ) then
                  write(*,*) 'Unable to rename: ',line(:rlan(line))
                  write(*,*) 'To new file name: ',filename(:rlan(filename))
               endif
             endif
            cont = .false.
         elseif( index(ans,'m') .gt. 0 ) then
            ierr1 = 0 
            ierr2 = 0
            if ( rlan(ans) .le. index(ans,'m') ) then
               write(*,*) 'Enter line to move #,# (from,to)'
               read(*,10,IOSTAT=ist) ans
               if ( ist .ne. 0 ) then
                  ans = ' '
                  ierr1 = 1
               endif
            endif

            i = index(ans,',')
            k = index(ans,'m')
            if ( i .gt. 1 ) then
               read(ans(k+1:i-1),*,IOSTAT=ierr1) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans(k+1:),*,IOSTAT=ierr1) inum1
               write(*,*) 'Enter line to move to'
               read(*,*,IOSTAT=ierr2) inum2
            endif
            if ( ierr1 .ne. 0 .or. ierr2 .ne. 0 .or.  & 
                 inum1 .lt. 1 .or. inum1 .gt. nv .or.  & 
                 inum2 .lt. 1 .or. inum2 .gt. nv .or. & 
                 fnum(ord(inum1)) .ge. 1000 .or. & 
                 fnum(ord(inum2)) .ge. 1000 ) then
               write(*,*) 'Invalid input'
               write (*,*) 'Hit <CR> to continue.'
               read (*,10) ans
            else
               change = .true.
               k = fnum(ord(inum2))
               if ( inum1 .gt. inum2) then
                  do i=inum2,inum1-1
                     fnum(ord(i)) = fnum(ord(i+1))
                  enddo
               else
                  do i=inum2,inum1+1,-1
                     fnum(ord(i)) = fnum(ord(i-1))
                  enddo
               endif
               fnum(ord(inum1)) = k
               ord(1) = 1
               do j=2,nv
                  k = 1
                  ch = .false.
                  do while ( k .le. j-1 .and. .not. ch )
                     if ( fnum(j) .lt. fnum(ord(k)) ) then !new min
                        do l = j,k+1,-1
                           ord(l) = ord(l-1)
                        enddo
                        ord(k) = j
                        ch = .true. 
                     endif
                     k = k + 1
                  enddo
                  if ( .not. ch ) ord(j) = j
               enddo
            endif

            j = 1
         elseif( ans(1:1) .eq. ' ' ) then
            cont = .true.
         elseif ( index(ans,'-') .gt. 0 .or. index(ans,'_') .gt. 0) then
            j = j - 2*(irow - 6)
            if ( j .lt. 1 ) j = 1
         else  !must be a number
            k = 0
            if ( index(ans,'l') .gt. 0 ) k = 1
            ierr1  = 0 
            read(ans,*,IOSTAT=ierr1) inum1

            if ( ierr1 .ne. 0 ) then
               write(*,*) 'Enter variable number'
               read(*,10,IOSTAT=ist) ans
               read(ans,*,IOSTAT=ierr1) inum1
               if ( ist .ne. 0 .or. ierr1 .ne. 0 ) then
                  write(*,*) 'Invalid input'
                  write (*,*) 'Hit <CR> to continue.'
                  read (*,10) ans
               endif
            endif
            if ( ierr1 .eq. 0 .and. flg .eq. 1 .and. k .eq. 0) then
               var = vars(ord(inum1))
               cont = .false.
            elseif ( ierr1 .eq. 0 ) then
               write(*,30) vars(ord(inum1))(:imx),labs(ord(inum1))
               write(*,*) 'Enter new label <CR> for default'
               write(*,*) 'Use ? to force line break '// & 
                          'and : to show scales'
               write(*,*) '234567890123456789012345| 36 char max'
               read(*,10,IOSTAT=ist) tilab
               if ( ist .eq. 0 .and. tilab(1:1) .ne. ' ') then
                  labs((ord(inum1))) = tilab
                  change = .true.
               endif
            endif
         endif
      enddo

      close(lu80)
      return
 10   format(a)
 20   format(3x,'(',i3,')',3x,a,2x,a)
 21   format(3x,'(',i3,')*',2x,a,2x,a)
 30   format(3x,'Variable:',1x,a,1x,'Label:',1x,a)
      end





      subroutine mod_sng(fattest,numt,testname,testnum,irow, & 
                  ncnt,var,ysh,ygn,xsh,xgn,ncond,ntask5,t5val)
      implicit none

! * Argument List      
      character*40  testname(1000)       !Testnames

      integer*4     testnum(1000)        !Test numbers
      integer*4     irow                !Number of rows on screen
      integer*4     fattest             !test number
      integer*4     numt                !Number of define tests

! * Locals

      logical*4     cont                !Main loop continue flag
      logical*4     cont2               !Secondary loop continue flag
      logical*4     change              !Data changed so rewrite tdf file
      logical*4     ferr                !Error flag
      logical*4     isload(4)           !Has data file been read once

      integer*4     i,j,k               !Counters
      integer*4     k1,k2,k3            !Temp interger indices
      integer*4     i1                  !Index one
      integer*4     i2                  !Index two
      integer*4     idx                 !Pointer into array
      integer*4     lmax                !Length of longest variable
      integer*4     lu18 /18/           !Logical unit for read file
      integer*4     ist                 !IOSTAT flag
      integer*4     ist2                !IOSTAT flag
      integer*4     cmd                 !Command input
      integer*4     nml(4)              !Number of variables in data files
      integer*4     fininrt             !Status flag from data read

      character*8   cfile(4)            !File types
      character*4   dfile(3)            !File types
      character*64  vari /'Variable                                '/
      character*64  varl(200,4)         !List of variables in acd atd pom files
      character*80  ans                 !Answer variable
      character*80  ans2                !Answer variable
      character*132 scrfile             !Scratch file

      real*4        treal               !temporary real variable
      real*4        dmn(200,4)          !Minimun value of data dummy argument
      real*4        dmx(200,4)          !Maximum value of data dummy argument

      include "flt_plot.inc"
      include "flt_read_vars.inc"

      cfile(1) = 'ACD File'
      cfile(2) = 'ATD File'
      cfile(3) = 'POM File'
      cfile(4) = 'Drivers'
      dfile(1) = '.acd'
      dfile(2) = '.atd'
      dfile(3) = '.pom'

      lmax = 8
      do i=1,4
         do j=1,ncnt(i)
            k = lrbl(var(i,j))
            if (k .gt. lmax ) lmax = k
         enddo
         isload(i) = .false.
         nml(i)    = 0
      enddo

      cont = .true.

      do while ( cont )

         write(*,*) ' '
         write(*,*) '    Shifts and gains for ',fattest,ftestname
         write(*,*) '    ',title(:rlan(title))
         write(*,*) '    ',comment(:rlan(comment))
         write(*,*) ' '

         do i =1,4 
            if ( ncnt(i) .gt. 0 ) then
               write(*,*) cfile(i)(:rlan(cfile(i)))// & 
                    ' Shift and Gains'
               write(*,20) vari(:lmax)
               do j=1,ncnt(i)
                  write(*,30) j,var(i,j)(:lmax),xsh(i,j),xgn(i,j), & 
                                              ysh(i,j),ygn(i,j)
               enddo
               write(*,*) ' '
            endif
         enddo
         write(*,*) ' '
         write(*,*) ' '

         do j=1,4 
            write(*,*) '(',j,') '//cfile(j)
         enddo
         write(*,*) 'Select file type to edit <CR> Return'

         read(*,11,IOSTAT=ist) cmd

         if ( ist .ne. 0 .or. cmd .gt. 4 .or. cmd .lt. 1 ) then
            cont = .false.
            if ( change ) then  !rewrite tdf file
               write(*,*) 'Updating test definition file'
               filename = ftestname(:lrbl(ftestname))//'.tdf'
               call pathfile(testfile,fpath, & 
                    filename(:lrbl(filename)))


               call pathfile(scrfile,fpath,'tdf_scratch')
               open(lu19,FILE=scrfile,IOSTAT=istatus)
               if ( istatus .ne. 0 ) then
                  write(*,*)  'UNABLE TO OPEN '// & 
                       scrfile(:lrbl(scrfile))
                  write(*,*) 'No changes made'
                  return
               endif	
               i = lrbl(testfile)
			   call rename_file(testfile(:i),testfile(:i)//'.old',ferr)
               open(lu18,FILE=testfile(:lrbl(testfile)) & 
                              //'.old',IOSTAT=i)
               if ( i .ne. 0 ) then
                  write(*,*) 'UNABLE TO OPEN '// & 
                       testfile(:lrbl(testfile))//'.old'
                  write(*,*) 'No changes made'
                  return
               endif

! * Start by stripping all shifts and gains from file
               do while ( ist .eq. 0 ) 
                  read(lu18,10,IOSTAT=ist) line
                  i  = 0
                  k  = 0
                  k1 = 0
                  k2 = 0
                  k3 = 0
                  if ( i .eq. 0 .and. ist .eq. 0 ) & 
                          write(lu19,10) line(:rlan(line)) !Echo data
                  do while ( ( i .eq. 0 .or. (k .eq. 0 .and. k1 .eq. 0 & 
                       .and. k2 .eq. 0 .and. k3) ) & 
                       .and. ist .eq. 0 ) 
                     write(lu19,10) line(:rlan(line)) !Echo data
                     read(lu18,10,IOSTAT=ist) line
                     lowline = line
                     call lower(lowline,132)
                     i  = index(lowline,'start')
                     k  = index(lowline,'atd')
                     k1 = index(lowline,'acd')
                     k2 = index(lowline,'pom')
                     k3 = index(lowline,'drive')
                  enddo
                  i = 0
                  do while ( ist .eq. 0 .and. i .eq. 0 )
                     read(lu18,10,IOSTAT=ist) line
                     lowline = line
                     call lower(lowline,132)
                     i  = index(lowline,'end')
                  enddo
               enddo

               close(lu18)
               close(lu19)

               open(lu18,FILE=scrfile,IOSTAT=ist)
               if ( ist .ne. 0 ) then
                  write(*,*)  'UNABLE TO OPEN '// & 
                       scrfile(:lrbl(scrfile))
                  write(*,*) 'No changes made'
				  i = lrbl(testfile)
				  call rename_file(testfile(:i)//'.old',testfile(:i),ferr)
                  return
               endif

               open(lu19,FILE=testfile,IOSTAT=ist)
               if ( ist .ne. 0 ) then
                  write(*,*)  'UNABLE TO OPEN '// & 
                       testfile(:lrbl(testfile))
                  write(*,*) 'No changes made'
				  i = lrbl(testfile)
				  call rename_file(testfile(:i)//'.old',testfile(:i),ferr)
                  return
               endif

               i = 0
               k = 0
               read(lu18,10,IOSTAT=ist) line
               do while ( ( i .eq. 0 .or. k .eq. 0 ) & 
                    .and. ist .eq. 0 ) 
                  write(lu19,10) line(:rlan(line)) !Echo data
                  read(lu18,10,IOSTAT=ist) line
                  lowline = line
                  call lower(lowline,132)
                  i  = index(lowline,'start')
                  k  = index(lowline,'plot')
               enddo

               do i=1,4
                  if ( ncnt(i) .gt. 0 ) then
                     write(lu19,*)' '
                     write(lu19,10) 'Start '//cfile(i)// & 
                          ' Shift and gains'
                     write(lu19,10) '# variable    Yshift   Ygain  '// & 
                          '  Xshift      Xgain'
                     do j=1,ncnt(i)
                        write(lu19,35) var(i,j),ysh(i,j),ygn(i,j), & 
                                                xsh(i,j),xgn(i,j)
                     enddo
                     write(lu19,10) 'End '//cfile(i)// & 
                          ' Shift and gains'
                     write(lu19,*)' '
                  endif
               enddo


               write(lu19,10) line(:rlan(line)) !Start plot
               read(lu18,10,IOSTAT=ist) line
               do while ( ist .eq. 0 )
                  write(lu19,10) line(:rlan(line)) !Write ic end to file
                  read(lu18,10,IOSTAT=ist) line
               enddo

               close(lu19)     
               close(lu18)     

! *   Re-read updated test definition file
               include "flt_read.inc" 
               write(*,*) 'Test definition file:',testfile(:rlan(testfile))
               write(*,*) 'Written to and re-read.'
            endif
         else
            if ( ncnt(cmd) .gt. 0 ) then
               write(*,*) 'Enter line number to modify - '// & 
                           '(A)dd (D)elete #-# <CR> Return'
               read(*,10,IOSTAT=ist) ans
               if ( ist .ne. 0 .or. ans .eq. ' ' ) then
                  ans = ' ' 
               else
                  call lower(ans,40)
               endif
            else
               ans = 'a'
            endif

            idx = 0
            if ( index(ans,'d') .gt. 0 ) then !Delete
               i=index(ans,'-')
               ist  = 0 
               ist2 = 0
               if ( i .gt. 1 ) then
                  read(ans(2:i-1),*,IOSTAT=ist) i1
                  read(ans(i+1:),*,IOSTAT=ist2) i2
               else
                  read(ans(2:),*,IOSTAT=ist) i1
                  i2 = i1
               endif
               if ( ist .ne. 0 .or. ist2 .ne. 0 ) then
                  write(*,*) 'Enter number to delete'
                  read(*,10,IOSTAT=ist) ans
                  read(ans,*,IOSTAT=ist2) i1
                  if ( ist .ne. 0 .or. ist2 .ne. 0 ) then
                     write(*,*) 'Invalid input'
                     write (*,*) 'Hit <CR> to continue.'
                     read (*,10,IOSTAT=ist) ans
                  else
                     i2 = i1
                  endif
               endif
               if ( ist .eq. 0 .and. ist2 .eq. 0 ) then
                  if ( i1 .gt. 0 .and. i1 .le. ncnt(cmd) .and. & 
                       i2 .gt. 0 .and. i2 .le. ncnt(cmd) ) then
                     k = i2 - i1 + 1 !number of variables to delete
                     do i=i1,ncnt(cmd)-k
                        var(cmd,i) = var(cmd,i+k)
                        xsh(cmd,i) = xsh(cmd,i+k)
                        xgn(cmd,i) = xgn(cmd,i+k)
                        ysh(cmd,i) = ysh(cmd,i+k)
                        ygn(cmd,i) = ygn(cmd,i+k)
                     enddo
                     ncnt(cmd) = ncnt(cmd) - k
                     change = .true.
                  else
                     write(*,*)'Invalid indices specified'
                     write (*,*) 'Hit <CR> to continue.'
                     read (*,10,IOSTAT=ist) ans
                  endif
               endif
            elseif ( index(ans,'a') .gt. 0 ) then
               if ( cmd .lt. 4 ) then
                  write(*,*) 'Enter a variable name or (l) to see all'// & 
                          ' vairables in '//cfile(cmd)
               else
                  write(*,*) 'Enter a variable name or (l) to see'// & 
                       ' the task 5 driver information'
               endif

               read(*,10,IOSTAT=ist) ans
               if ( ist .ne. 0 .or. ans .eq. ' ') then
               else
                  call lower(ans,40)
                  if ( ans(1:1) .eq. 'l' ) then
                     if ( cmd .eq. 4 .and. .not. isload(4)) then
                        do i=1,ncond
                           do j=1,ntask5(i)
                              read(t5val(i,j),*,IOSTAT=ist) treal
                              if ( ist .ne. 0 ) then !Must have text 
                                 ans=t5val(i,j)(lran(t5val(i,j)):)
                                 call lower(ans,80)
                                 k = index(ans,'t ') + & 
                                     index(ans,'true') + & 
                                     index(ans,'false') + & 
                                     index(ans,'f ') 
                                 if ( k .gt. 0 ) ist = 0
                              endif
                              if ( ist .ne. 0 ) then
                                 nml(cmd) = nml(cmd) + 1
                                 varl(nml(cmd),cmd) = ans(:lrbl(ans))
                              endif
                           enddo
                        enddo
                     else
                        if ( .not. isload(cmd) ) then
                           call pathfile(filename,fpath, & 
                             ftestname(:lrbl(ftestname))//dfile(cmd))
! *                    Get list of varialbles in .acd .atd .pom files
                           call flt_var_data(filename,varl(1,cmd), & 
                                nml(cmd),dmn(1,cmd),dmx(i,cmd),err)
                           if ( .not. err) isload(cmd) = .true.
                        endif
                     endif

                     if ( nml(cmd) .lt. 1 ) then
                        write(*,*) 'No data available'
                        ist  = 1
                     else
                        do i=1,nml(cmd)
                           write(*,40) i,varl(i,cmd)(lran(varl(i,cmd)):)
                        enddo
                        write(*,*) 'Enter variable number to use'
                        read(*,*,IOSTAT=ist) k
                        if ( ist .ne. 0 .or. k .lt. 1 & 
                                        .or. k .gt. nml(cmd)) then
                           ist = 1
                        else
                           ncnt(cmd) = ncnt(cmd) + 1
                           var(cmd,ncnt(cmd)) = & 
                                         varl(k,cmd)(lran(varl(k,cmd)):)
                           idx = ncnt(cmd)
                        endif
                     endif

                  else  !Input must be a variable Check to make sure in file
                     if ( .not. isload(cmd) ) then
                        call pathfile(filename,fpath, & 
                             ftestname(:lrbl(ftestname))//dfile(cmd))
! *   Get list of varialbles in .acd .atd .pom files
                        call flt_var_data(filename,varl(1,cmd), & 
                             nml(cmd),dmn(1,cmd),dmx(i,cmd),err)
                        if ( .not. err) isload(cmd) = .true.
                     endif
                     ans = ans(lran(ans):)
                     call lower(ans,80)
                     fnd = .false.
                     i = 0
                     do while ( i .le. nml(cmd) .and. .not. fnd)
                        if ( varl(i,cmd)(:lrbl(varl(i,cmd))) .eq. & 
                             ans(:lrbl(ans)) ) then
                           fnd = .true.
                           idx = i
                        endif
                        i = i + 1
                     enddo

                     if ( .not. fnd ) then
                        write(*,*)'Variable: '//ans(:lrbl(ans))
                        write(*,*)'Not found in '//cfile(cmd)
                        write(*,*)'Try again. Hit <CR> to Continue'
                        read(*,10,IOSTAT=ist) ans
                        ist = 1
                     else
                        ncnt(cmd) = ncnt(cmd) + 1 
                        var(cmd,ncnt(cmd)) = ans(:lrbl(ans))
                        idx = ncnt(cmd)
                     endif
                  endif
               endif
            elseif ( ans .ne. ' ') then  !must be a number
               read(ans,*,IOSTAT=ist) idx
               if ( ist .ne. 0 .or. idx .lt. 1 .or. & 
                                    idx .gt. nml(cmd))then
                  write(*,*)'Index is invalid try again.'
                  write(*,*)'Hit <CR> to Continue'
                  read(*,10,IOSTAT=ist) ans
                  idx = 0
               endif

            endif
            if ( idx .gt. 0 ) then  !prompt for sng information
               cont2 = .true.
               do while (cont2)
                  write(*,*)' '
                  write(*,*)' '
                  write(*,20) vari(:lmax)
                  write(*,30) idx,var(cmd,idx)(:lmax), & 
                     xsh(cmd,idx),xgn(cmd,idx),ysh(cmd,idx),ygn(cmd,idx)
                  write(*,*)' '
                  write(*,*)'Modify (A)ll X(G)ain  X(S)hift '// & 
                         'Ygai(N) Yshif(T) (R)eset <CR> No change/Exit'
                  read(*,10,IOSTAT=ist) ans
                  call lower(ans,80)
                  if ( ist .ne. 0 .or. ans .eq. ' ' ) then
                     cont2 = .false.
                  elseif ( index(ans,'r') .gt. 0 ) then !reset
                     xsh(cmd,idx) = 0.0
                     xgn(cmd,idx) = 1.0
                     ysh(cmd,idx) = 0.0
                     ygn(cmd,idx) = 1.0
                     change = .true.
                  endif

                  if ( cont2 .and.  & 
                          index(ans,'a') + index(ans,'g') .gt. 0) then
                     write(*,*)'Input X Gain for '//var(cmd,idx)// & 
                          '<CR> Current =',xgn(cmd,idx)
                     read(*,10,IOSTAT=ist) ans2
                     if ( ist .eq. 0 .and. ans2 .ne. ' ' ) then
                        read(ans2,*,IOSTAT=ist) treal
                        if ( ist .ne. 0 ) then
                           write(*,*)'Error reading value.'
                           write(*,*)'Try again. Hit <CR> to Continue'
                           read(*,10,IOSTAT=ist) ans
                        else
                           xgn(cmd,idx) = treal
                           change = .true.
                        endif
                     endif
                  endif
                  if ( cont2 .and.  & 
                          index(ans,'a') + index(ans,'s') .gt. 0) then
                     write(*,*)'Input X Shift for '//var(cmd,idx)// & 
                          '<CR> Current =',xsh(cmd,idx)
                     read(*,10,IOSTAT=ist) ans2
                     if ( ist .eq. 0 .and. ans2 .ne. ' ' ) then
                        read(ans2,*,IOSTAT=ist) treal
                        if ( ist .ne. 0 ) then
                           write(*,*)'Error reading value.'
                           write(*,*)'Try again. Hit <CR> to Continue'
                           read(*,10,IOSTAT=ist) ans
                        else
                           xsh(cmd,idx) = treal
                           change = .true.
                        endif
                     endif
                  endif
                  if ( cont2 .and.  & 
                          index(ans,'a') + index(ans,'n') .gt. 0) then
                     write(*,*)'Input Y Gain for '//var(cmd,idx)// & 
                          '<CR> Current =',ygn(cmd,idx)
                     read(*,10,IOSTAT=ist) ans2
                     if ( ist .eq. 0 .and. ans2 .ne. ' ' ) then
                        read(ans2,*,IOSTAT=ist) treal
                        if ( ist .ne. 0 ) then
                           write(*,*)'Error reading value.'
                           write(*,*)'Try again. Hit <CR> to Continue'
                           read(*,10,IOSTAT=ist) ans
                        else
                           ygn(cmd,idx) = treal
                           change = .true.
                        endif
                     endif
                  endif
                  if ( cont2 .and.  & 
                          index(ans,'a') + index(ans,'t') .gt. 0) then
                     write(*,*)'Input Y Shift for '//var(cmd,idx)// & 
                          '<CR> Current =',ysh(cmd,idx)
                     read(*,10,IOSTAT=ist) ans2
                     if ( ist .eq. 0 .and. ans2 .ne. ' ' ) then
                        read(ans2,*,IOSTAT=ist) treal
                        if ( ist .ne. 0 ) then
                           write(*,*)'Error reading value.'
                           write(*,*)'Try again. Hit <CR> to Continue'
                           read(*,10,IOSTAT=ist) ans
                        else
                           ysh(cmd,idx) = treal
                           change = .true.
                        endif
                     endif
                  endif

               enddo !cont2
            endif !idx >0 

         endif
      enddo

      return

 10   format(a)
 11   format(i1)
 20   format(2x,a,'    X Shift     X Gain      Y Shift     Y Gain')
 30   format(i1,1x,a,f10.2,1x,f10.2,3x,f10.2,1x,f10.2)
 35   format(a,f10.2,1x,f10.2,3x,f10.2,1x,f10.2)
 40   format(4x,'(',i3,')',3x,a)
      end



      subroutine read_index(numt,testname,testnum)
      implicit none

! * Arguments 
      integer*4     numt           !Number of tests
      integer*4     testnum(1000)   !Array of test numbers

      character*40  testname(1000)  !Array of test names

! * Locals
      character*256 message        !Message string
      character*132 filename       !Full file name 
      character*40  name           !temp name
      character*10  module /'read_index'/

      logical*4     exist          !File exists flag

      integer*4     i              !Counter
      integer*4     ist            !IO status
      integer*4     lu20  /20/     !Logical unit for test_index.dat

! * Externals
      integer*4     rlan            !Returns index of last non-blank
      integer*4     lran            !Returns index of first non-blank
      integer*4     lrbl            !Returns index of first blank from left

! * Get globals mainly fpath
      include "flt_plot.inc"

      numt = 0

      call pathfile(filename,fpath,'test_index.dat')

      inquire(FILE=filename,EXIST=exist)

      if ( .not. exist ) then !test_index.dat file does not exist
         write(*,*) 'File : '//filename(:lrbl(filename))
         write(*,*)'Does not exist.  Unable to determine tests.'
         return
      endif

      open(UNIT=lu20,FILE=filename,IOSTAT=ist)
      if ( ist .ne. 0 ) then !Unable to open test_index.dat file 
         write(*,*)'Unable to open file.  Can not determine test.'
         write(*,*)'File : '//filename(:lrbl(filename))
         return
      endif

      do i=1,1000
         testnum(i)  = 0
         testname(i) = ' '
      enddo

! * Read test_index.dat file
      do while ( ist .eq. 0 .and. numt .lt. 1000 )
         read(lu20,*,IOSTAT=ist) i,name

         if ( ist .eq. 0 ) then
            numt = numt + 1
            testname(numt) = name(lran(name):rlan(name))
            testnum(numt)  = i
         endif
      enddo

      close(lu20)  !close test_index.dat file for now
      return
      end

