!  ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : Boeing 717-200
!    JOB             : 8700
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : flt_modplot
!    DESCRIPTION     : modifies plot part of test definition files
!    PACKAGE         : flt
!    RATE            : offline
!    ORIGINATOR      : Flight Data Library
!    DATE            : 12/1/98
!    ENGINEER        : Mike Saladin
!    SYSTEM          : Unix

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 1998 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 251-0500  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!--> REVISION BEGIN
! $Id: flt_modplot.f,v 1.4 2000/03/13 21:44:41 saladinm Exp $
! $Log: flt_modplot.f,v $
! Revision 1.4  2000/03/13 21:44:41  saladinm
! DR/MACAR:     None
! Problem:      Added ylimit option to plotting routines and not supported
!               by the FLT utility.
! Conclusion:   True
! Resolution:   Added the ylimit option to this module so it can be modified
!               from the flt utility.
! Dependencies: flt_output.f,fat_readtest.f,flt_init_plot.inc,flt_read.inc
! Engineer:     Mike Saladin

! Revision 1.3  2000/02/14 16:03:51  saladinm
! DR/MACAR:     None
! Problem:      Unable to set title or comments and X axis scales not working.
! Conclusion:   Title/Comment not being written to .tdf file.  X axis reads
!               looking at wrong label and the change flag was not set.
! Resolution:   Added code to output title and comments to .tdf file.
!               Corrected labels and some indices and added change flag
!               for the X scales interface.
! Dependencies: None
! Engineer:     Mike Saladin

! Revision 1.2  1999/03/15 13:28:13  saladinm
! Update from 717.

! Revision 1.5  1999/03/11 14:19:01  saladinm
! Added checking for valid input of target slopes.

! Revision 1.4  1999/02/12 13:05:15  saladinm
! Fixed setting y/x targets if one already was set. Added checking if target
! set in a high variable before allow hilight to be set.

! Revision 1.3  1999/02/10 16:38:11  saladinm
!  Added slope option to x&y target analysis.

! Revision 1.2  1999/02/08 17:03:33  saladinm
! Added RCS revision control stuff.

!--> REVISION END
! *******************************************************************

      subroutine flt_modplot(fattest,numt,testname,testnum,irow)

      implicit none
      CHARACTER*80  RCSID & 
      /"$Id: flt_modplot.f,v 1.4 2000/03/13 21:44:41 saladinm Exp $"/

      character*40  testname(400)       !Testnames

      integer*4     testnum(400)        !Test numbers
      integer*4     irow                !Number of rows on screen
      integer*4     fattest             !test number
      integer*4     numt                !Number of define tests

! * Locals
      character*132 oldt                !old title
      character*132 oldc                !old comment
      character*132 ffile               !File
      character*20  cval                !value string
      character*64  cvar                !variable string
      character*64  acdvar(200)         !Acd variable list
      character*64  cblank              !blank string
      character*64  tivar               !Temp input variable name
      character*40  name                !temp input name
      character*40  ttestname           !temp storage for test name
      character*20  ans                 !answer string
      character*10  cmn                 !Char string of min
      character*10  cmx                 !Char string of max
      character*8   tsnp                !Temp snap 
      character*8   slope(3) /'Either','Positive','Negative'/

      integer*4     tmi                 !Temp minimum
      integer*4     tmx                 !Temp maximum
      integer*4     tgrd                !Temp number of grids
      integer*4     nacd                !Number of acd variables
      integer*4     dc                  !Define condition index
      integer*4     cv                  !Condition vairable index
      integer*4     itype               !Type of test input name=1 num=0
      integer*4     i,j,k,l,m,ik        !Counters
      integer*4     p,g                 !page index and grid number
      integer*4     imx                 !Max length of y variables
      integer*4     ml                  !Number of lines avail for plot info
      integer*4     idx                 !Total number of plot info lines disply
      integer*4     lx                  !Last x
      integer*4     npy                 !Number of y per a displayed
      integer*4     np                  !Number of pages available
      integer*4     nv                  !Number of grids per hardcopy page
      integer*4     ist                 !IO Status flag
      integer*4     ierr1               !Error flag
      integer*4     ierr2               !Error flag
      integer*4     inum1               !Start of range of IC's to modify
      integer*4     inum2               !End of range of IC's to modify
      integer*4     lu18  /18/          !Logical unit for testdef.tdf.old
      integer*4     fininrt             !Real time error flag
      integer*4     nx                  !Number of plot pages
      integer*4     ntot                !Total number of vars displayed
      integer*4     ymn                 !Max number of chars in min scales
      integer*4     ymx                 !Max number of chars in max scales
      integer*4     plt(6,6)            !Page maxtrix into yvar array
      integer*4     npage               !Number of current pages
      integer*4     newx                !New X index into xvar array
      integer*4     newy                !New Y index into yvar array
      integer*4     ix                  !Current x index
      integer*4     iy                  !Current y index

      logical*4     aerr                !Error flag reading acd file
      logical*4     terr                !Error flag
      logical*4     cont                !continue loop
      logical*4     cont2               !continue loop
      logical*4     change              !Data changed update before returing
      logical*4     new                 !New input
      logical*4     samex               !X changes
      logical*4     xinacd(6)           !is var in acd file
      logical*4     yinacd(36)          !is var in acd file
      logical*4     thil                !Temp hilite
      logical*4     tlim                !Temp ylimit
      logical*4     acdusd(200)         !Is acd variable plotted
      logical*4     t(26)               !Temp array used fo moves
      logical*4     newin               !New input flag
      logical*4     anly                !Loop control flag for analysis sec

      real*4        x                   !Temp x variable
      real*4        ttop                !Temp percent tolerance
      real*4        ttoa                !Temp absolute tolerance
      real*4        acdmn(200)          !Minimum value for acd variables
      real*4        acdmx(200)          !Maximum value for acd variables


! * Externals (defined in flt_read_vars.inc lrbl rlan lran)
      integer*4     toi                 !Get idx based on page number and grid
      integer*4     upx                 !Nearest above x for current idx
      logical*4     isx                 !Is index an x variable

      include "flt_plot.inc"
      include "flt_read_vars.inc"

! * Get max variable length

      change = .false.
      cblank  = ' '

! * Re-Read test definition file to gain access to plot variables
      include "flt_read.inc"

      imx = 8
      ymn = 3
      ymx = 3
      do i=1, ny
         k = lrbl(yvar(i))
         if ( k .gt. imx ) imx = k
         write(cmn,11) ymin(i)
         cmn = cmn(lran(cmn):)
         l = lrbl(cmn)
         if ( l .gt. ymn ) ymn = l
         write(cmn,11) ymax(i)
         cmn = cmn(lran(cmn):)
         l = lrbl(cmn)
         if ( l .gt. ymx ) ymx = l
      enddo
      do i=1, nplot
         k = lrbl(xvar(i))
         if ( k .gt. imx ) imx = k
         write(cmn,11) xmin(i)
         cmn = cmn(lran(cmn):)
         l = lrbl(cmn)
         if ( l .gt. ymn ) ymn = l
         write(cmn,11) xmax(i)
         cmn = cmn(lran(cmn):)
         l = lrbl(cmn)
         if ( l .gt. ymx ) ymx = l
      enddo
      np   = 6   !Number of plots pages
      nv   = 6   !Number of grids per page

      do i=1,np
         xinacd(i) = .false.
      enddo
      do i=1,np*nv
         yinacd(i) = .false.
      enddo

      call pathfile(ffile,fpath,ftestname(:lrbl(ftestname))//'.acd')

      call flt_var_data(ffile,acdvar,nacd,acdmn,acdmx,aerr)      


      call load_plt(plt,ntot,npage,ngrid,ny,ynplot,nplot,nv,np)

! * Check to see if plot variables in acd file
      if ( .not. aerr ) then
         call load_acdusd(acdusd,nacd,acdvar,yinacd,xinacd, & 
                             ny,yvar,nplot,xvar,nv,np)
      endif


      ml = irow - 10
      cont = .true.
      idx  = 1
      newx = 0

      do while ( cont )
         write(*,*) ' '
         write(*,*) '     PLOT SETUP FOR : ',ftestname(:rlan(ftestname)),fattest
         write(*,*) '             (T)ITLE: ',title(:rlan(title))
         write(*,*) '           C(O)MMENT: ',comment(:rlan(comment))
         write(*,20) recrate,type
         write(*,*) '  *=In ACD file'

! *    Display loop

         nl = 0
         do while ( nl .lt. ml )
            call get_gp(idx,nv,g,p)
            if ( isx(idx,nv) ) then    !this is an x variable
               write(*,'(2x,68("-"),2x)')
               nl = nl + 1
               if ( plt(p,1) .eq. 199 ) then
                  ix = newx
               else
                  ix = ynplot(plt(p,1)) !X var is same for all y on page
               endif
               write(cmn,11) xmin(ix)
               write(cmx,11) xmax(ix)
               cmx = cmx(lran(cmx):)
               cmn = cmn(lran(cmn):)
               if ( xinacd(ix) ) then
                  write(*,31) idx,xvar(ix)(:imx),cmn(:ymn),cmx(:ymx)
               else
                  write(*,30) idx,xvar(ix)(:imx),cmn(:ymn),cmx(:ymx)
               endif
            else    !Write y
               if ( plt(p,g) .eq. 99 ) then
                  write(*,41) idx,'  "     '
               elseif ( plt(p,g) .eq. 0 .or. plt(p,g) .eq. 199 ) then
                  write(*,41) idx,'   '
               else
                  write(cmn,11) ymin(plt(p,g))
                  write(cmx,11) ymax(plt(p,g))
                  cmx = cmx(lran(cmx):)
                  cmn = cmn(lran(cmn):)
                  if ( yinacd(plt(p,g)) ) then
                     write(line,42) idx,yvar(plt(p,g))(:imx), & 
                       cmn(:ymn),cmx(:ymx)
                  else
                     write(line,40) idx,yvar(plt(p,g))(:imx), & 
                       cmn(:ymn),cmx(:ymx)
                  endif
                  if ( dampvar .eq. plt(p,g) ) then
                     write(ans,13) damp_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Damp_St = '//ans
                  endif
                  if ( phivar .eq. plt(p,g) ) then
                     write(ans,13) phi_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Phi_St = '//ans
                  endif
                  if ( betavar .eq. plt(p,g) ) then
                     write(ans,13) beta_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Beta_St = '//ans
                  endif
                  if ( cfdvar .eq. plt(p,g) ) then
                     write(ans,13) cfd_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Cfd_St = '//ans
                  endif
                  if ( snap(plt(p,g))(1:1) .ne. ' ' ) then
                     line = line(:rlan(line))//' Snap = '//snap(plt(p,g))
                  endif
                  if ( hilite(plt(p,g)) ) then
                     line=line(:rlan(line))//' Hilite '
                  endif
                  if ( ylimit(plt(p,g)) ) then
                     line=line(:rlan(line))//' Ylimit '
                  endif
                  if ( powervar .eq. plt(p,g) ) & 
                            line=line(:rlan(line))// ' Power '
                  if ( plavar .eq. plt(p,g) ) & 
                            line=line(:rlan(line))// ' Pla '
                  do i=1,nyt
                     if ( ytarvar(i) .eq. plt(p,g) ) then
                        write(ans,13) ytarval(i)
                        ans = ans(lran(ans):)
                        line = line(:rlan(line))//' Ytarget = '//ans
                        if ( ytarm(i) .ne. 0  ) then
                           line = line(:rlan(line))//' Slope = '// & 
                                              slope(ytarm(i)+1)(:3)
                        endif
                     endif
                  enddo
                  do i=1,nxt
                     if ( xtarvar(i) .eq. plt(p,g)) then
                        write(ans,13) xtarval(i)
                        ans = ans(lran(ans):)
                        line = line(:rlan(line))//' Xtarget = '//ans
                        if ( xtarm(i) .ne. 0 ) then
                           line = line(:rlan(line))//' Slope = '// & 
                                              slope(xtarm(i)+1)(:3)
                        endif
                     endif
                  enddo
                  if ( tol_a(plt(p,g)) .ne. 0. ) then
                     write(ans,13) tol_a(plt(p,g))
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Tol_A = '//ans
                  endif
                  if ( tol_p(plt(p,g)) .ne. 0. ) then
                     write(ans,13) tol_p(plt(p,g))
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Tol_P = '//ans
                  endif
                  write(*,*) line(:rlan(line))
               endif
            endif
            nl = nl + 1
            idx = idx + 1

            if ( idx .gt. ntot .and. g .eq. nv & 
                      .and. plt(p+1,1) .ne. 199 )  then
               nl = ml
               write(*,'(2x,68("#"),2x)')
            endif
         enddo

! * Master menu

         write(*,*) ' '
         write(*,*) ' Enter item to alter: <cr>=done : '// & 
                '+= More  -_ Back (E)xpand # (D)elete #-#'
         write(*,*) '(C)opy (M)ove (From,To) (U)se all acd (A)cd unused'

         read(*,10,IOSTAT=ist) ans

         if ( ist .ne. 0 ) then
            if ( change ) then
               ans = ' '
            else
               return
            endif
         endif

         call lower(ans,20)

! * Command parsing area         

         if ( index(ans,'+') .gt. 0 .or. index(ans,'=') .gt. 0) then ! Move dow
            nl = 0
            if ( idx .gt. ntot ) idx = 1
            idx = upx(idx,nv)
         elseif( ans(1:1) .eq. '-' .or. index(ans,'_') .gt. 0) then
            nl  = 0
            idx = idx - 2*ml
            if ( idx .le. 1 ) then
               idx = 1
            endif
            idx = upx(idx,nv)
         elseif( index(ans,'s') .gt. 0 ) then !Change type to snapshot
            type = 'Snap'
            change = .true.
            idx = 1

         elseif( index(ans,'p') .gt. 0 ) then !Change type to plot
            type = 'Plot'
            change = .true.
            idx = 1

         elseif( index(ans,'r') .gt. 0 ) then !Change plot rate
            write(*,*)'Enter new recording rate in Hz <CR> for default'
            read(*,10,IOSTAT=ist) ans

            if ( ist .eq. 0 ) then
               read(ans,*,IOSTAT=ist) x
               if ( ist .eq. 0) then
                  recrate   = x
                  change = .true.
               else
                  write(*,*)'Error reading new rate.  Not changed.'
                  write(*,*) ' Hit <cr> to continue'
                  read(*,10,IOSTAT=ist) ans
               endif
            endif

            idx = 1

         elseif( index(ans,'t') .gt. 0 ) then !Edit title
            write(*,*) ' '
            write(*,*)'Enter new title (dd) to delete'// & 
                    '  <cr> for no change'
            read(*,10,IOSTAT=ist) oldt
            if ( ist .eq. 0 .and. oldt(1:1) .ne. ' ' ) then
               if ( oldt(1:2) .eq. 'dd' ) then
                  title = ' '
               else
                  title = oldt
               endif
               change = .true.
            endif
            idx = 1
         elseif( index(ans,'o') .gt. 0 ) then !Edit Comment
            write(*,*) ' '
            write(*,*)'Enter new comment  (dd) to delete'// & 
                    '  <cr> for no change'
            read(*,10,IOSTAT=ist) oldc
            if ( ist .eq. 0 .and. oldc(1:1) .ne. ' ' ) then
               if ( oldc(1:2) .eq. 'dd' ) then
                  comment = ' '
               else
                  comment = oldc
               endif
               change = .true.
            endif
            idx = 1
         elseif( index(ans,'a') .gt. 0 ) then !Show unused acd parameters
            k = 0
            do j=1,nacd
               if ( .not. acdusd(j) ) k = k + 1
            enddo

            nl = 0
            cont2 = .true.
            do while ( cont2 ) 
               write(*,*) ' '
               write(*,*) '     UNUSED VARS FROM: ',ftestname & 
                                          (:rlan(ftestname))//'.acd'
               write(*,*) '     NUMBER OF VARIABLES: ',nacd
               write(*,*) '         NUMBER NOT USED: ',k

               i = 1
               do while (  i .le. nacd )
                  if ( .not. acdusd(i)  ) then 
                     write(*,*) '     ',acdvar(i)(:lrbl(acdvar(i)))
                     nl = nl + 1
                  endif
                  i = i + 1

                  if ( nl .gt. irow - 8 ) then
                     write(*,*) ' Hit <cr> to continue'
                     read(*,10,IOSTAT=ist) ans
                     nl = 0
                  endif
               enddo

               write(*,*) 'Enter (R)eview or <cr> to exit'
               read(*,10,IOSTAT=ist) ans
               call lower(ans,20)

               if ( ist .eq. 0 .and. index(ans,'r') .gt. 0 ) then
                  cont2 = .true.
               else
                  cont2 = .false.
               endif

            enddo
            idx = 1
         elseif ( index(ans,'u') .gt. 0 .and. .not. aerr) then !use unused acds
            if ( nplot .eq. 0 ) then !No current x axis specified
               nplot = 1
               xvar(1) = acdvar(1)  !use first variable in acd file
               xmin(1) = acdmn(1)
               xmax(1) = acdmx(1)
               recrate = 0
               type = 'plot'
               k = 1
            else
               call get_gp(ntot,nv,g,p)
               if ( g .gt. 0 ) then
                  k = ynplot(plt(p,g))
               else
                  k = ynplot(plt(p-1,1))
               endif
            endif
            i = ny + 1
            j = 1
            do while ( i .le. nv*np .and. j .le. nacd )
               if ( .not. acdusd(j) ) then
                  acdusd(j) = .true.
                  yvar(i) = acdvar(j)
                  snap(i) = ' '
                  hilite(i) = .false.
                  ylimit(i) = .false.
                  ngrid(i)  = 1
                  tol_a(i)  = 0.
                  tol_p(i)  = 0.
                  ik=0
                  do l=1,nyt
                     if ( ytarvar(l) .eq. i ) then
                        do m=l,nyt-1
                           ytarvar(m) = ytarvar(m+1)
                           ytarval(m) = ytarval(m+1)
                           ytarm(m)   = ytarm(m+1)
                        enddo
                        ik = ik + 1
                     endif
                  enddo
                  nyt = nyt - ik 
                  ik = 0
                  do l=1,nxt
                     if ( xtarvar(j) .eq.  i ) then
                        do m=l,nxt-1
                           xtarvar(m) = xtarvar(m+1)
                           xtarval(m) = xtarval(m+1)
                           xtarm(m)   = xtarm(m+1)
                        enddo
                        ik = ik + 1
                     endif
                  enddo
                  nxt = nxt - ik 
                  if ( phivar   .eq. i) phivar  = 0
                  if ( betavar  .eq. i) betavar = 0
                  if ( dampvar  .eq. i) dampvar = 0
                  if ( cfdvar   .eq. i) cfdvar  = 0
                  if ( powervar .eq. i) powervar= 0
                  if ( plavar   .eq. i) plavar  = 0
                  call get_scale(acdmn(j),acdmx(j),ymin(i),ymax(i))
                  ynplot(i) = k
                  i = i + 1
               endif
               j = j + 1
            enddo
            ny = i - 1
            call load_plt(plt,ntot,npage,ngrid, & 
                          ny,ynplot,nplot,nv,np)
            call load_acdusd(acdusd,nacd,acdvar,yinacd,xinacd, & 
                             ny,yvar,nplot,xvar,nv,np)
            change = .true.
         elseif( index(ans,'e') .gt. 0 ) then !Expand variable
            idx = 1  !Redisplay full plot set upon exitting
            ierr1 = 0 
            if ( rlan(ans) .le. index(ans,'e') ) then
               write(*,*) 'Enter variable to expand'
               read(*,10,IOSTAT=ist) ans
               if ( ist .ne. 0 ) then
                  ans = ' '
                  ierr1 = 1
               endif
            endif

            k = index(ans,'e')
            read(ans(k+1:),*,IOSTAT=ierr1) inum1
            if ( ierr1 .eq. 0 ) then
               if ( inum1 .lt. 1 .or. inum1 .gt. ntot ) then
                  write(*,*) 'Invalid input'
                  write(*,*) 'Hit <CR> to continue.'
                  read (*,10) tivar
                  ierr1 = 1
               elseif ( isx(inum1,nv) ) then
                  write(*,*) 'X Axis may not be expanded'
                  write(*,*) 'Hit <CR> to continue.'
                  read (*,10) tivar
                  ierr1 = 1
               endif
            endif

            if ( ierr1 .eq. 0 ) then   !Number ok
               write(*,*) 'Enter total number of grids desired <cr> = 1'
               read(*,12,IOSTAT=ierr2) inum2

               if ( ierr2 .ne. 0 .or. inum2 .lt. 1 & 
                                 .or. inum2 .gt. nv ) then
                  inum2 = 1
               endif

               call get_gp(inum1,nv,g,p)
               if ( g + inum2 - 1 .gt. nv ) then
                  write(*,*) 'Unable to expand grid across a page'
                  write(*,*) 'Hit <CR> to continue.'
                  read (*,10) tivar
               elseif ( inum2 .ne. ngrid(plt(p,g)) ) then
                  ngrid(plt(p,g)) = inum2
                  change = .true.
                  call load_plt(plt,ntot,npage, & 
                       ngrid,ny,ynplot,nplot,nv,np)
                  idx = upx(inum1,nv)
               endif
            endif    !Is number valid


         elseif( index(ans,'d') .gt. 0 ) then !Delete variable
            ierr1 = 0 
            ierr2 = 0
            if ( rlan(ans) .le. index(ans,'d') ) then
               write(*,*) 'Enter variables to delete #[-#]'
               read(*,10,IOSTAT=ist) ans
               if ( ist .ne. 0 ) then
                  ans = ' '
                  ierr1 = 1
               endif
            endif

            i = index(ans,'-')
            k = index(ans,'d')
            if ( i .gt. 1 ) then
               read(ans(k+1:i-1),*,IOSTAT=ierr1) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans(k+1:),*,IOSTAT=ierr1) inum1
               inum2 = inum1
            endif
            if ( inum2 .gt. ntot ) inum2 = ntot
            if ( ierr1 .ne. 0 .or. ierr2 .ne. 0 ) then
               write(*,*) 'Invalid input'
               write (*,*) 'Hit <CR> to continue.'
               read (*,10) tivar
            else
               call get_gp(inum1,nv,g,p)
               call get_gp(inum2,nv,i,l)
               if ( l .gt. p ) then !delete crosses pages
                  do j=l,p+1,-1
                     if ( ynplot(plt(p,1)) .ne. ynplot(plt(j,1)) ) then
                        inum2 = toi(6,j-1,nv) !limit to end of page with same x
                     endif
                  enddo
               endif
               k = inum2 - inum1 + 1 !number of variables to delete
               i = inum1
               l = i
               do while ( i .le. inum2 ) 
                  call get_gp(l,nv,g,p)
                  if ( isx(i,nv) ) then !X axis page do not do anything
                     i = i + 1
                  elseif( plt(p,g) .eq. 99 ) then  !repeat only change ngrid
                     j = i - 1
                     do while ( j .gt. 2 ) 
                        call get_gp(j,nv,g,p)
                        if ( plt(p,g) .ne. 99 ) then
                           ngrid(plt(p,g)) = ngrid(plt(p,g)) - 1
                           j = 0
                        endif
                        j = j - 1
                     enddo
                     i = i + 1
                     l = l + 1
                  elseif( plt(p,g) .eq. 0 ) then !Nothing plotted here
                     i = i + 1
                     l = l + 1
                  else !Delete y variable
                     i = i + ngrid(plt(p,g))  !inc by number of grids deleted
                     do j=plt(p,g),ny-1
                        yvar(j) = yvar(j+1)
                        ymin(j) = ymin(j+1)
                        ymax(j) = ymax(j+1)
                        ngrid(j) = ngrid(j+1)
                        snap(j) = snap(j+1)
                        tol_a(j) = tol_a(j+1)
                        tol_p(j) = tol_p(j+1)
                        hilite(j) = hilite(j+1)
                        ylimit(j) = ylimit(j+1)
                        ynplot(j) = ynplot(j+1)
                     enddo

                     ny = ny - 1
                     ik=0
                     do j=1,nyt
                        if ( ytarvar(j) .eq. plt(p,g)  ) then
                           do m=j,nyt-1
                              ytarvar(m) = ytarvar(m+1)
                              ytarval(m) = ytarval(m+1)
                              ytarm(m)   = ytarm(m+1)
                           enddo
                           ik = ik + 1
                        endif
                     enddo
                     nyt = nyt - ik 
                     ik = 0
                     do j=1,nxt
                        if ( xtarvar(j) .eq.  plt(p,g) ) then
                           do m=j,nxt-1
                              xtarvar(m) = xtarvar(m+1)
                              xtarval(m) = xtarval(m+1)
                              xtarm(m)   = xtarm(m+1)
                           enddo
                           ik = ik + 1
                        endif
                     enddo
                     nxt = nxt - ik 
                     if ( phivar   .eq. plt(p,g)) phivar  = 0
                     if ( cfdvar   .eq. plt(p,g)) cfdvar  = 0
                     if ( betavar  .eq. plt(p,g)) betavar = 0
                     if ( dampvar  .eq. plt(p,g)) dampvar = 0
                     if ( powervar .eq. plt(p,g)) powervar = 0
                     if ( plavar   .eq. plt(p,g)) plavar  = 0
                  endif  !delete y
                  call load_plt(plt,ntot,npage, & 
                             ngrid,ny,ynplot,nplot,nv,np)
               enddo
               change = .true.
               if ( .not. aerr ) then
                  call load_acdusd(acdusd,nacd,acdvar,yinacd,xinacd, & 
                       ny,yvar,nplot,xvar,nv,np)
               endif

            endif
            idx = 1
         elseif ( index(ans,'c') .gt. 0 ) then !Copy from other test
            if ( rlan(ans) .gt. index(ans,'c') ) then !name specified
               i = index(ans,'c')
               read(ans(i+1:),10,IOSTAT=ist) name
               name=name(lran(name):)
            else
               write(*,*) ' Enter Test Name or Number to COPY :' & 
                    //' <CR> = MENU'
               read(*,10,IOSTAT=ist) name
            endif
            call findname(name,i,itype,testname,testnum,numt)
            if ( itype .lt. 2 ) then
               ttestname = ftestname
               ftestname = name         
               oldt      = title
               oldc      = comment
               include "flt_read.inc" !read new data from ftestname.tdf
               ftestname = ttestname !restore values to current test
               title     = oldt
               comment   = oldc
               if ( fininrt .ne. 3 ) then
                  imx = 8
                  do i=1, ny
                     k = lrbl(yvar(i))
                     if ( k .gt. imx ) imx = k
                     write(cmn,11) ymin(i)
                     cmn = cmn(lran(cmn):)
                     l = lrbl(cmn)
                     if ( l .gt. ymn ) ymn = l
                     write(cmn,11) ymax(i)
                     cmn = cmn(lran(cmn):)
                     l = lrbl(cmn)
                     if ( l .gt. ymx ) ymx = l
                  enddo
                  do i=1, nplot
                     k = lrbl(xvar(i))
                     if ( k .gt. imx ) imx = k
                     write(cmn,11) xmin(i)
                     cmn = cmn(lran(cmn):)
                     l = lrbl(cmn)
                     if ( l .gt. ymn ) ymn = l
                     write(cmn,11) xmax(i)
                     cmn = cmn(lran(cmn):)
                     l = lrbl(cmn)
                     if ( l .gt. ymx ) ymx = l
                  enddo
                  call load_plt(plt,ntot,npage, & 
                       ngrid,ny,ynplot,nplot,nv,np)
                  if ( .not. aerr ) then
                     call load_acdusd(acdusd,nacd,acdvar,yinacd,xinacd, & 
                          ny,yvar,nplot,xvar,nv,np)
                  endif
                  change = .true.
               else
                  write(*,*) 'Error reading other test.  Re-reading'// & 
                       'current test'
                  include "flt_read.inc"
               endif
            else
               write(*,*) 'Test ',name(:lrbl(name)),' not found'
               write(*,*) 'No changes made'
            endif
            idx = 1
         elseif ( index(ans,'m') .gt. 0 ) then !Move
            ierr1 = 0 
            ierr2 = 0
            if ( rlan(ans) .le. index(ans,'m') ) then
               write(*,*) 'Enter line to move #,# (from,to)'
               read(*,10,IOSTAT=ist) ans
               if ( ist .ne. 0 ) then
                  ans = ' '
                  ierr1 = 1
               endif
            endif

            i = index(ans,',')
            k = index(ans,'m')
            if ( i .gt. 1 ) then
               read(ans(k+1:i-1),*,IOSTAT=ierr1) inum1
               read(ans(i+1:),*,IOSTAT=ierr2) inum2
            else
               read(ans(k+1:),*,IOSTAT=ierr1) inum1
               write(*,*) 'Enter line to move to'
               read(*,*,IOSTAT=ierr2) inum2
            endif
            if ( ierr1 .ne. 0 .or. ierr2 .ne. 0 .or.  & 
                 inum1 .lt. 1 .or. inum1 .gt. ntot .or.  & 
                 inum2 .lt. 1 .or. inum2 .gt. ntot) then
               write(*,*) 'Invalid input'
               write (*,*) 'Hit <CR> to continue.'
               read (*,10) tivar
            else
               change = .true.
               call get_gp(inum1,nv,g,p)
               j = inum1
               inum1 = plt(p,g)  !Change inum1 to index into yvar array
               if ( inum1 .eq. 99 ) then !from is repeated grid find start
                  do while ( j .ge. 1 .and. inum1 .eq. 99 ) 
                     call get_gp(j,nv,g,p)
                     if ( plt(p,g) .ne. 99 .and. g .gt. 1) then
                        inum1 = plt(p,g)
                     endif
                     j = j - 1
                  enddo
               endif
               call get_gp(inum2,nv,g,p)
               j = inum2
               inum2 = plt(p,g)  !Change inum1 to index into yvar array
               if ( inum2 .eq. 99 ) then !from is repeated grid find start
                  do while ( j .ge. 1 .and. inum2 .eq. 99 ) 
                     call get_gp(j,nv,g,p)
                     if ( plt(p,g) .ne. 99 .and. g .gt. 1) then
                        inum2 = plt(p,g)
                     endif
                     j = j - 1
                  enddo
               endif
               tivar = yvar(inum1)
               tmi  = ymin(inum1)
               tmx  = ymax(inum1)
               tgrd = ngrid(inum1)
               tsnp = snap(inum1)
               thil = hilite(inum1)
               tlim = ylimit(inum1)
               ttoa = tol_a(inum1)
               ttop = tol_p(inum1)

               do i=1,26
                  t(i) = .false.
               enddo
               if ( dampvar .eq. inum1 ) t(1) = .true.
               if ( phivar  .eq. inum1 ) t(2) = .true.
               if ( betavar .eq. inum1 ) t(3) = .true.
               if ( cfdvar  .eq. inum1 ) t(4) = .true.
               if ( powervar.eq. inum1 )t(5) = .true.
               if ( plavar  .eq. inum1 )t(6) = .true.
               do j=1,nyt
                  if ( ytarvar(j) .eq. inum1 ) t(j+6) = .true.
               enddo
               do j=1,nxt
                  if ( xtarvar(j) .eq. inum1 ) t(j+16) = .true.
               enddo
               if ( inum1 .gt. inum2) then
                  do i=inum1,inum2+1,-1
                     yvar(i)   = yvar(i-1)
                     ymin(i)   = ymin(i-1)
                     ymax(i)   = ymax(i-1)
                     ngrid(i)  = ngrid(i-1)
                     snap(i)   = snap(i-1)
                     hilite(i) = hilite(i-1)
                     ylimit(i) = ylimit(i-1)
                     tol_a(i)  = tol_a(i-1)
                     tol_p(i)  = tol_p(i-1)
                     if ( dampvar .eq. i-1 ) dampvar = i
                     if ( phivar  .eq. i-1 ) phivar  = i
                     if ( betavar .eq. i-1 ) betavar = i
                     if ( cfdvar  .eq. i-1 ) cfdvar  = i
                     if ( powervar.eq. i-1 ) powervar= i
                     if ( plavar  .eq. i-1 ) plavar  = i
                     do j=1,nyt
                        if ( ytarvar(j) .eq. i-1 ) ytarvar(j) = i
                     enddo
                     do j=1,nxt
                        if ( xtarvar(j) .eq. i-1 ) xtarvar(j) = i
                     enddo
                  enddo
               else
                  do i=inum1,inum2-1
                     yvar(i)   = yvar(i+1)
                     ymin(i)   = ymin(i+1)
                     ymax(i)   = ymax(i+1)
                     ngrid(i)  = ngrid(i+1)
                     snap(i)   = snap(i+1)
                     hilite(i) = hilite(i+1)
                     ylimit(i) = ylimit(i+1)
                     tol_a(i)  = tol_a(i+1)
                     tol_p(i)  = tol_p(i+1)
                     if ( dampvar .eq. i+1 ) dampvar = i
                     if ( phivar  .eq. i+1 ) phivar  = i
                     if ( betavar .eq. i+1 ) betavar = i
                     if ( cfdvar  .eq. i+1 ) cfdvar  = i
                     if ( powervar.eq. i+1 ) powervar= i
                     if ( plavar  .eq. i+1 ) plavar  = i
                     do j=1,nyt
                        if ( ytarvar(j) .eq. i+1 ) ytarvar(j) = i
                     enddo
                     do j=1,nxt
                        if ( xtarvar(j) .eq. i+1 ) xtarvar(j) = i
                     enddo
                  enddo
               endif
               yvar(inum2) = tivar
               ymin(inum2) = tmi  
               ymax(inum2) = tmx   
               ngrid(inum2) = tgrd  
               snap(inum2) = tsnp  
               hilite(inum2) = thil  
               ylimit(inum2) = tlim  
               tol_a(inum2) = ttoa 
               tol_p(inum2) = ttop  
               if ( t(1) ) dampvar = inum2
               if ( t(2) ) phivar  = inum2
               if ( t(3) ) betavar = inum2
               if ( t(4) ) cfdvar  = inum2
               if ( t(5) ) powervar= inum2
               if ( t(6) ) plavar  = inum2
               do j=1,nyt
                  if ( t(j+6) ) ytarvar(j) = inum2
               enddo
               do j=1,nxt
                  if ( t(j+16) ) xtarvar(j) = inum2
               enddo
               call load_plt(plt,ntot,npage, & 
                       ngrid,ny,ynplot,nplot,nv,np)

               idx = 1
            endif               !if valid entry
         elseif ( ans(1:1) .eq. '0'  .or. ans(1:1) .eq. ' ') then !exit
            if ( change ) then !Rewrite test definition file
               write(*,*) 'Updating test definition file'
               filename = ftestname(:lrbl(ftestname))//'.tdf'
               call pathfile(testfile,fpath, & 
                    filename(:lrbl(filename)))
			   i = lrbl(testfile)
			   call rename_file(testfile(:i),testfile(:i)//'.old',terr)

! *          Open .tdf file to write
               open(lu19,FILE=testfile,IOSTAT=istatus)
               if ( istatus .ne. 0 ) then
                  write(*,*)  'UNABLE TO OPEN '//testfile(:i)
                  write(*,*) 'No changes made'
                  call rename_file(testfile(:i)//'.old',testfile(:i),terr)
                  return
               endif
! *          Open .tdf.old file to read
               open(lu18,FILE=testfile(:i)//'.old',IOSTAT=i)
               if ( i .ne. 0 ) then
                  write(*,*) 'UNABLE TO OPEN '//testfile(:i)//'.old'
                  write(*,*) 'No changes made'
                  return
               endif
! *          Update character lengths               
               imx = 8
               ymn = 3
               ymx = 3
               do i=1, ny
                  k = lrbl(yvar(i))
                  if ( k .gt. imx ) imx = k
                  write(cmn,11) ymin(i)
                  cmn = cmn(lran(cmn):)
                  l = lrbl(cmn)
                  if ( l .gt. ymn ) ymn = l
                  write(cmn,11) ymax(i)
                  cmn = cmn(lran(cmn):)
                  l = lrbl(cmn)
                  if ( l .gt. ymx ) ymx = l
               enddo
               do i=1, nplot
                  k = lrbl(xvar(i))
                  if ( k .gt. imx ) imx = k
                  write(cmn,11) xmin(i)
                  cmn = cmn(lran(cmn):)
                  l = lrbl(cmn)
                  if ( l .gt. ymn ) ymn = l
                  write(cmn,11) xmax(i)
                  cmn = cmn(lran(cmn):)
                  l = lrbl(cmn)
                  if ( l .gt. ymx ) ymx = l
               enddo


               i = 0 
               ist = 0
               do while ( i .eq. 0 .and. ist .eq. 0 ) 
                  read(lu18,10,IOSTAT=ist) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'title')
                  if ( ist .eq. 0 ) then
                     if ( i .eq. 0 ) then
                        write(lu19,10) line(:rlan(line)) !Echo data
                     else
                        write(lu19,10) 'Title   = '// & 
                             title(:rlan(title))
                     endif
                  endif
               enddo

               i   = 0 
               ist = 0
			   k   = 0
               do while ( i .eq. 0 .and. ist .eq. 0 .and. k .eq. 0 ) 
                  read(lu18,10,IOSTAT=ist) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'comment')
				  k = index(lowline,'start')
				  
                  if ( ist .eq. 0 ) then
                     if ( i .eq. 0 ) then
 						if ( k .ne. 0 ) then
							i = rlan(comment)
							if ( i .gt. 0 ) then
                               write(lu19,10) 'comment   = '// & 
                                    comment(:rlan(comment))
							   write(lu19,10) '#'
						    endif
						 endif
                         write(lu19,10) line(:rlan(line)) !Echo data
                     else
                        write(lu19,10) 'comment   = '// & 
                             comment(:rlan(comment))
                     endif
                  endif
               enddo

               i = 0
               k = 0
               istatus = 0
               do while ( ( i .eq. 0 .or. k .eq. 0 ) & 
                    .and. istatus .eq. 0 ) 
                  read(lu18,10,IOSTAT=ist) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'start')
                  k = index(lowline,'plot')
                  if ( ist .eq. 0) write(lu19,10) line(:rlan(line)) !Echo data
               enddo

! *          Write new data 
               lx = 0
               do i=1,ny
                  if ( lx .ne. ynplot(i) ) then !write x axis
                     k = ynplot(i)
                     lx = ynplot(i)
                     write(cmn,11) xmin(k)
                     write(cmx,11) xmax(k)
                     cmx = cmx(lran(cmx):)
                     cmn = cmn(lran(cmn):)
                     if ( k .eq. 1 ) then
                        write(line,60) xvar(k)(:imx),cmn(:ymn),cmx(:ymx)
                        call lower(type,8)
                        if ( index(type,'plot') .eq. 0 ) line = & 
                             line(:rlan(line))//' Type = '//type
                        if ( recrate .ne. 0 ) then
                           write(cmn,11) recrate
                           line = line(:rlan(line))//' Rate = '//cmn
                        endif
                        write(lu19,10) line(:rlan(line))
                     else
                        write(lu19,60) xvar(k)(:imx),cmn(:ymn),cmx(:ymx)
                     endif
                  endif  !if new x
                  write(cmn,11) ymin(i)
                  write(cmx,11) ymax(i)
                  cmx = cmx(lran(cmx):)
                  cmn = cmn(lran(cmn):)
                  write(line,61) yvar(i)(:imx), & 
                       cmn(:ymn),cmx(:ymx)
                  if ( ngrid(i) .gt. 1 ) then
                     write(ans,12) ngrid(i)
                     line = line(:rlan(line))//' Grids = '//ans
                  endif
                  if ( dampvar .eq. i ) then
                     write(ans,13) damp_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Damp_St = '//ans
                  endif
                  if ( phivar .eq. i ) then
                     write(ans,13) phi_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Phi_St = '//ans
                  endif
                  if ( betavar .eq. i ) then
                     write(ans,13) beta_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Beta_St = '//ans
                  endif
                  if ( cfdvar .eq. i ) then
                     write(ans,13) cfd_st
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Cfd_St = '//ans
                  endif
                  if ( snap(i)(1:1) .ne. ' ' ) then
                     line = line(:rlan(line))//' Snap = '//snap(i)
                  endif
                  if ( hilite(i) ) then
                     line=line(:rlan(line))//' Hilite '
                  endif
                  if ( ylimit(i) ) then
                     line=line(:rlan(line))//' Ylimit '
                  endif
                  if ( powervar .eq. i ) & 
                            line=line(:rlan(line))// ' Power '
                  if ( plavar .eq. i ) & 
                            line=line(:rlan(line))// ' Pla '
                  do j=1,nyt
                     if ( ytarvar(j) .eq.i ) then
                        write(ans,13) ytarval(j)
                        ans = ans(lran(ans):)
                        line = line(:rlan(line))//' Ytarget = '//ans
                        if ( ytarm(j) .ne. 0 ) then
                           write(ans,12) ytarm(j)
                           ans = ans(lran(ans):)
                           line = line(:rlan(line))//' Slope = '//ans
                        endif
                     endif
                  enddo
                  do j=1,nxt
                     if ( xtarvar(j) .eq. i ) then
                        write(ans,13) xtarval(j)
                        ans = ans(lran(ans):)
                        line = line(:rlan(line))//' Xtarget = '//ans
                        if ( xtarm(j) .ne. 0 ) then
                           write(ans,12) xtarm(j)
                           ans = ans(lran(ans):)
                           line = line(:rlan(line))//' Slope = '//ans
                        endif
                     endif
                  enddo
                  if ( tol_a(i) .ne. 0. ) then
                     write(ans,13) tol_a(i)
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Tol_A = '//ans
                  endif
                  if ( tol_p(i) .ne. 0. ) then
                     write(ans,13) tol_p(i)
                     ans = ans(lran(ans):)
                     line = line(:rlan(line))//' Tol_P = '//ans
                  endif
                  write(lu19,10) line(:rlan(line))
               enddo

! *          Read to end of old plot info
               i = 0
               ist = 0
               do while ( i .eq. 0 .and. ist .eq. 0 )
                  read(lu18,10,IOSTAT=istatus) line
                  lowline = line
                  call lower(lowline,132)
                  i = index(lowline,'end') !read to end of plot area
               enddo
! *          Write reat of test definition file
               write(lu19,10) line(:rlan(line)) !Write to end of file
               read(lu18,10,IOSTAT=ist) line
               do while ( ist .eq. 0 )
                  write(lu19,10) line(:rlan(line)) !Echo data 
                  read(lu18,10,IOSTAT=ist) line
               enddo
               close(lu19)      !close testdef.tdf
               close(lu18)      !close testdef.tdf.old
! *   Re-read updated test definition file
               include "flt_read.inc" 
               cont = .false.
               write(*,*) 'Test definition file:',testfile(:rlan(testfile))
               write(*,*) 'Written to and re-read.'
            endif
            return

! * Input must be a number 
         else    !Must be a number
            ierr1 = 0 

            read(ans,*,IOSTAT=ierr1) inum1

            if ( ierr1 .ne. 0 .or. inum1 .le. 0 ) then
               write(*,*) 'Invalid index. '
               write(*,*) 'Hit <cr> to continue.'
               read(*,10) tivar
               idx = 1
            else
               new = .false.
               call get_gp(inum1,nv,g,p)
               if ( inum1 .gt. ntot ) new = .true.
               ans = 'n'
               if ( isx(inum1,nv) ) then !moidfy x variable
                  write(*,*) 'You have chosen to change a'// & 
                       ' X axis variable'
                  samex = .false.
                  if ( new ) then
                     write(*,*) 'Do you want a new X?'// & 
                          ' (y,N)(N = use previous X)  '
                     samex = .true.
                     ix = nplot + 1
                  else
                     ix = ynplot(plt(p,1))
                     if ( p .ne. 1 ) then
                        if ( ynplot(plt(p,1)) .eq. & 
                             ynplot(plt(p-1,1)) ) then
                           write(*,*) 'This X variable is the same'// & 
                                ' as the page before.'
                           samex = .true.
                        elseif ( npage .gt. p ) then 
                           if ( ynplot(plt(p,1)) .eq. & 
                                ynplot(plt(p+1,1)) ) then
                              write(*,*) 'This X variable is the same'// & 
                                   ' as the NEXT page.'
                              samex = .true.
                           endif
                        endif
                        if ( samex ) then
                           write(*,*) 'Do you want to change all'// & 
                                ' pages that have this X? (y,N=change '// & 
                                'this page only)'
                        endif
                     endif
                  endif

                  if ( samex ) then 
                     read(*,10,iostat=ist) ans
                     if ( ist .ne. 0 .or. ans(1:1) .eq. ' ') ans='n'
                     call lower(ans,20)
                  endif
               else
                  if ( new ) then
                     iy = ny + 1
                  else
                     iy = plt(p,g)
                  endif
               endif


               if ( .not. new .or. .not. isx(inum1,nv) .or. & 
                    ( new .and. index(ans,'y') .gt. 0 )) then
                  write(*,*) ' '
                  write(*,*) 'Enter variable name or '// & 
                       '(L)ist to see all '// & 
                       'variables previously used'
                  if ( .not. new ) then
                     if ( isx(inum1,nv) ) then
                        write(*,*) 'Hit <cr> for default = ', & 
                             xvar(ix)(:lrbl(xvar(ix)))
                     else
                        write(*,*) 'Hit <cr> for default = ', & 
                             yvar(iy)(:lrbl(yvar(iy)))
                     endif
                  endif

                  read(*,10,iostat=ist) tivar
                  call lower(tivar,64)
                  if ( tivar(1:2) .eq. 'l ' & 
                       .and. lrbl(tivar) .eq. 1 ) then
                     call list_var(irow,tivar,4)
                  endif

                  if ( tivar(1:1) .ne. ' '  ) then
                     call write_var(tivar,4) !write variable to variables.dat
                     if ( new .and. isx(inum1,nv) ) then !new x
                        newx = 0
                        do i=1,nplot
                           if ( xvar(i)(:lrbl(xvar(i))) .eq. & 
                                tivar(:lrbl(tivar)) ) newx = i
                        enddo
                        if ( newx .eq. 0 ) then
                           nplot = nplot + 1
                           xvar(nplot) = tivar(:lrbl(tivar))
                           newx = nplot
                           change = .true.
                        endif
                        ix = newx
                        plt(p,1) = 199
                     elseif( new ) then !new y
                        newy = 0
                        do i=1,ny
                           if ( yvar(i)(:lrbl(yvar(i))) .eq. & 
                                tivar(:lrbl(tivar)) ) then
                              write(*,*) 'Note: new variable is '// & 
                                   'already plotted'
                           endif
                        enddo
                        ny = ny + 1
                        newy = ny
                        iy = newy
                        if ( newx .ne. 0 ) then !new x recently specified
                           ynplot(iy) = newx
                        elseif ( g .ne. 1 ) then !not 1st grid used 1st x
                           ynplot(iy) = ynplot(plt(p,1))
                        elseif( p .ne. 1 ) then !not 1st page use p-1 x
                           ynplot(iy) = ynplot(plt(p-1,1))
                        else
                           ynplot(iy) = 1 !g=1 p=1 so x = 1
                        endif
                        yvar(iy) = tivar(:lrbl(tivar))
                        plt(p,g) = iy
                        call load_plt(plt,ntot,npage,ngrid, & 
                                      ny,ynplot,nplot,nv,np)
                        change = .true.
                     elseif ( isx(inum1,nv) ) then !old x
                        newx = 0 !reset nexx parameter
                        if ( samex .and. index(ans,'n') .gt. 0 ) then 
! *   use input x for this page only - create new x
                           ix = 0
                           do i=1,nplot !if new var exists use location in arra
                              if ( xvar(i)(:lrbl(xvar(i))) .eq. & 
                                   tivar(:lrbl(tivar)) ) then
                                 ix = i
                              endif
                           enddo
                           if ( ix .eq. 0 ) then
                              nplot = nplot + 1
                              ix = nplot
                              xvar(ix) = tivar(:lrbl(tivar))
                           endif
                           do i=1,nv !update rest of page
                              if ( plt(p,i) .ne. 0 ) then
                                 ynplot(plt(p,i)) = ix
                              endif
                           enddo
                           change = .true.
                        else    !just change xvar name
                           ix = 0
                           do i=1,nplot !if new var exists use location in arra
                              if ( xvar(i)(:lrbl(xvar(i))) .eq. & 
                                   tivar(:lrbl(tivar)) ) then
                                 ix = i
                                 do j=1,nv
                                    ynplot(plt(p,j)) = ix
                                 enddo
                              endif
                           enddo
                           if ( ix .eq. 0 ) then
                              ix = ynplot(plt(p,1)) !x is from  g 1 of p
                              xvar(ix) = tivar(:lrbl(tivar))
                           endif
                        endif
                        change = .true.
                     else       ! old y
                        newx = 0
                        iy = plt(p,g)
                        yvar(iy) = tivar(:lrbl(tivar))
                     endif
                  endif
               else             !new x use old x
                  newx = ynplot(plt(p-1,1))
                  ix   = newx
                  plt(p,1) = 199
               endif

               if ( isx(inum1,nv) ) then !Xvariable
                  if ( new .and. index(ans,'y') .gt. 0 ) then !Set defaults 
                     xmin(ix) = 0.
                     xmax(ix) = 100.
                  endif
                  ans(1:1) = '1'
                  do while ( ans(1:1) .ne. ' ' ) 
                     write(cmn,11) xmin(ix)
                     write(cmx,11) xmax(ix)
                     write(*,50) 'X',xvar(ix)(:lrbl(xvar(ix))), & 
                          cmn(lran(cmn):),cmx(lran(cmx):)
                     write(*,*) '(S)cale  <CR> for defaults'
                     read(*,10,IOSTAT=ist) ans
                     if ( ist .ne. 0 ) then
                        ans = ' '
                     endif
                     call lower(ans,20)
                     if ( index(ans,'n') + index(ans,'s') .gt. 0 ) then
                        write(*,*) 'Input minimum: '
                        read(*,10,IOSTAT=ist) tivar
                        if ( ist .eq. 0 .and. tivar(1:1) .ne. ' ') then
                           read(tivar,*,IOSTAT=ist) x
                           if ( ist .eq. 0 ) then
                              xmin(ix) = x
                              change = .true.
                           endif
                        endif
                     endif
                     if ( index(ans,'x') + index(ans,'s') .gt. 0 ) then
                        write(*,*) 'Input maximum: '
                        read(*,10,IOSTAT=ist) tivar
                        if ( ist .eq. 0 .and. tivar(1:1) .ne. ' ') then
                           read(tivar,*,IOSTAT=ist) x
                           if ( ist .eq. 0 ) then
                              xmax(ix) = x
                              change = .true.
                           endif
                        endif
                     endif
                     if( xmax(ix) .le. xmin(ix) ) then
                        write(*,*) 'Maximum is not greater than'// & 
                             ' the minimum.  Please fix.'
                        ans = '1'
                     endif
                  enddo
               else             ! y variable to input for
                  if ( new ) then !Set defaults totally arbitrary
                     ymin(iy) = 0.
                     ymax(iy) = 100.
                     change = .true.
                  endif
                  ans(1:1) = '1'
                  do while ( ans(1:1) .ne. ' ' ) 
                     write(*,*) ' '
                     write(*,*) ' '
                     write(*,*) ' '
                     write(cmn,11) ymin(iy)
                     write(cmx,11) ymax(iy)
                     write(*,50) 'Y',yvar(iy)(:lrbl(yvar(iy))), & 
                          cmn(lran(cmn):),cmx(lran(cmx):)

                     if ( dampvar .eq. iy ) then
                        write(*,*) 'Damping Ratio Analysis'// & 
                             ' Variable.  Start time = ',damp_st
                     endif
                     if ( phivar .eq. iy ) then
                        write(*,*) 'Peak Analysis'// & 
                             ' Roll Variable.  Start time = ',phi_st
                     endif
                     if ( betavar .eq. iy ) then
                        write(*,*) 'Peak Analysis'// & 
                             ' Sideslip Variable.  Start time = ',beta_st
                     endif
                     if ( cfdvar .eq. iy ) then
                        write(*,*) 'Cfd Analysis'// & 
                             ' Variable.  Start time = ',cfd_st
                     endif
                     if ( snap(iy)(1:1) .ne. ' ' ) then
                        write(*,*) 'Set snap shots for: ',snap(iy)
                     endif
                     if ( hilite(iy) ) then
                        write(*,*) 'Highlighting engaged.'
                     endif
                     if ( ylimit(iy) ) then
                        write(*,*) 'Limiting of plot data to Y-Axis'// & 
                                   ' engaged'
                     endif
                     if ( powervar .eq. iy ) then
                        write(*,*) 'Acceleration Analysis'// & 
                             ' Power Variable'
                     endif
                     if ( plavar .eq. iy ) then
                        write(*,*) 'Acceleration Analysis'// & 
                             ' PLA Variable'
                     endif
                     do i=1,nyt
                        if ( ytarvar(i) .eq. iy ) then
                           if ( ytarm(i) .ne. 0 ) then
                              write(*,*) 'Y target at : ',ytarval(i), & 
                                  ' Slope = '//slope(ytarm(i)+1)
                           else
                              write(*,*) 'Y target at : ',ytarval(i)
                           endif
                        endif
                     enddo
                     do i=1,nxt
                        if ( xtarvar(i) .eq. iy ) then
                           if ( xtarm(i) .ne. 0 ) then
                              write(*,*) 'X target at : ',xtarval(i), & 
                                  ' Slope = '//slope(xtarm(i)+1)
                           else
                              write(*,*) 'X target at : ',xtarval(i)
                           endif
                        endif
                     enddo
                     if ( tol_a(iy) .ne. 0. ) then
                        write(*,*) 'Absolute Tolerance: ', & 
                             tol_a(iy)
                     endif
                     if ( tol_p(iy) .ne. 0. ) then
                        write(*,*) 'Percent Tolerance: ', & 
                             tol_p(iy)
                     endif
                     write(*,*) ' '
                     write(*,*) ' (S)cale (T)olerance (A)nalysis'

                     write(*,*) 'Select above options or '// & 
                          ' <CR> for defaults (no changes)'
                     read(*,10,IOSTAT=ist) ans
                     if ( ist .ne. 0 ) then
                        ans = ' '
                     endif
                     call lower(ans,20)

                     if ( index(ans,'n') + index(ans,'s') .gt. 0 ) then
                        write(*,*) 'Input minimum: '
                        read(*,10,IOSTAT=ist) tivar
                        if ( ist .eq. 0 .and. ans(1:1) .ne. ' ') then
                           read(tivar,*,IOSTAT=ist) x
                           if ( ist .eq. 0 ) then
                              ymin(iy) = x
                              change = .true.
                           endif
                        endif
                     endif
                     if(index(ans,'x') + index(ans,'s') .gt. 0) then
                        write(*,*) 'Input maximum: '
                        read(*,10,IOSTAT=ist) tivar
                        if ( ist .eq. 0 .and. ans(1:1) .ne. ' ') then
                           read(tivar,*,IOSTAT=ist) x
                           if ( ist .eq. 0 ) then
                              ymax(iy) = x
                              change = .true.
                           endif
                        endif
                     elseif( ymax(iy) .le. ymin(iy) ) then
                        write(*,*) 'Maximum is not greater than'// & 
                             ' the minimum.  Please fix.'
                        ans = '1'
                     elseif( index(ans,'t') .gt. 0 ) then !Tolerances
                        write(*,*) 'Tolerances should be set in the '// & 
                            'tolerances.dat file in the DATA dir.'
                        write(*,*) 'The tolernaces you specify will '// & 
                           'over write those values for this test only.'
                        write(*,*) ' '
                        write(*,*) 'Enter Absolute tolerance'
                        write(*,*) 'Hit <CR> for default= ',tol_a(iy)
                        read(*,10,IOSTAT=ist) tivar
                        if ( ist .eq. 0 .and. tivar(1:1) .ne. ' ' ) then
                           read(tivar,*,IOSTAT=ist) x
                           if ( ist .eq. 0 ) then
                              tol_a(iy) = x
                              change = .true.
                           endif
                        endif
                        write(*,*) 'Enter Percent tolerance'
                        write(*,*) 'Hit <CR> for default= ',tol_p(iy)
                        read(*,10,IOSTAT=ist) tivar
                        if ( ist .eq. 0 .and. tivar(1:1) .ne. ' ' ) then
                           read(tivar,*,IOSTAT=ist) x
                           if ( ist .eq. 0 ) then
                              tol_p(iy) = x
                              change = .true.
                           endif
                        endif
                     elseif ( index(ans,'a') .gt. 0 ) then
                        anly = .true.
                        write(*,*) ' '
                        write(*,*) ' (D)amp (P)eak (H)ighlight '// & 
                             '(X)target (Y)target (C)fd'// & 
                             ' (A)ccel (S)nap Y(L)imit'

                        write(*,*) 'Enter desired change or'// & 
                                ' <CR> for defaults'
                        read(*,10,IOSTAT=ist) ans
                        if ( ist .ne. 0 ) then
                           ans = ' '
                        endif
                        if ( ans .eq. ' ' ) anly = .false.
                        call lower(ans,20)
                        if ( index(ans,'l') .gt. 0 ) then
                           ylimit(iy) = .not. ylimit(iy)
                           change = .true.
                        elseif ( index(ans,'h') .gt. 0 ) then
                           if ( hilite(iy) ) then
                              hilite(iy) = .false.
                              change = .true.
                           else !Verify target set before desired hilite
                              thil = .false.
                              do i=1,nyt
                                 if ( ytarvar(i) .le. iy ) thil = .true.
                              enddo
                              do i=1,nxt
                                 if ( xtarvar(i) .le. iy ) thil = .true.
                              enddo
                              if ( thil ) then
                                 hilite(iy) = .true.
                                 change = .true.
                              else
                                 write(*,*) 'A target must be set in '// & 
                                    'a variable above this one '// & 
                                    'for the hilight to work'
                                 write(*,*) 'Hit <cr> to continue.'
                                 read(*,12,IOSTAT=ist) i
                              endif
                           endif

                        elseif ( index(ans,'s') .gt. 0 ) then
                           write(*,*) & 
                                'Snap shot (1)Acd (2)Pom (3)Both'
                           read(*,12,IOSTAT=ist) i
                           if ( ist .eq. 0 ) then
                              if ( i .eq. 1 ) then
                                 snap(iy)='Acd'
                              elseif ( i .eq. 2 ) then
                                 snap(iy)='Pom'
                              elseif ( i .eq. 3 ) then
                                 snap(iy)='Acd/Pom'
                              else
                                 snap(iy) = ' '
                              endif
                              change = .true.
                           endif
                        elseif ( index(ans,'d') .gt. 0 ) then
                           ans(1:1) = 'y'
                           if ( dampvar .eq. iy ) then
                              write(*,*) 'Keep this variable as '// & 
                                 'damping ratio analysis variable (Y/n)'
                              read(*,10,IOSTAT=ist) ans
                              if ( ist .ne. 0 .or. & 
                                   ans(1:1) .eq. ' ') then
                                 ans(1:1) = 'y'
                              endif
                              call lower(ans,20)
                           endif

                           if ( index(ans,'n') .gt. 0 ) then
                              if ( dampvar .eq. iy ) dampvar = 0
                              change = .true.
                           else
                              write(*,*) 'Enter start time for '// & 
                                   'damping ratio analysis:'
                              read(*,10,IOSTAT=ist) tivar
                              if ( ist .eq. 0 .and. & 
                                   tivar(1:1) .ne. ' ') then
                                 read(tivar,*,IOSTAT=ist) x
                                 if ( ist .eq. 0 ) then
                                    damp_st = x
                                    dampvar = iy
                                    change = .true.
                                 endif
                              endif
                           endif
                        elseif ( index(ans,'p') .gt. 0 ) then
                           ans(1:1) = 'y'
                           if ( phivar .eq. iy .or. & 
                                betavar .eq. iy ) then
                              write(*,*) 'Keep this variable as a '// & 
                                   'peak analysis variable (Y/n)'
                              read(*,10,IOSTAT=ist) ans
                              if ( ist .ne. 0 .or. & 
                                   ans(1:1) .eq. ' ') then
                                 ans(1:1) = 'y'
                              endif
                              call lower(ans,20)
                           endif

                           if ( index(ans,'n') .gt. 0 ) then
                              if ( phivar .eq. iy ) phivar = 0
                              if ( betavar .eq. iy ) betavar = 0
                              change = .true.
                           else
                              write(*,*)'Peak analysis (1)roll '// & 
                                   '(2)sideslip'
                              read(*,12,IOSTAT=ist) i
                              if ( ist .eq. 0 .and. i .ne. 0 ) then
                                 if ( i .eq. 1 .and. & 
                                      phivar .ne. iy ) then
                                    phivar = iy
                                    change = .true.
                                 elseif( i .eq. 2 .and. & 
                                         betavar .ne. iy) then
                                    betavar = iy
                                    change = .true.
                                 endif

                                 write(*,*) 'Enter start time for'// & 
                                      ' peak analysis:'
                                 read(*,10,IOSTAT=ist) tivar
                                 if ( ist .eq. 0 & 
                                      .and. tivar(1:1) .ne. ' ' ) then
                                    read(tivar,*,IOSTAT=ist) x
                                    if ( ist .eq. 0 ) then
                                       if ( i .eq. 1 ) then
                                          phi_st = x
                                       elseif( i .eq. 2) then
                                          beta_st = x
                                       endif
                                       change = .true.
                                    endif
                                 endif
                              endif
                           endif

                        elseif( index(ans,'a') .gt. 0 ) then
                           ans(1:1) = 'y'
                           if ( powervar .eq. iy .or. & 
                                plavar .eq. iy ) then
                              write(*,*) 'Keep this variable as an '// & 
                                   'accel analysis variable (Y/n)'
                              read(*,10,IOSTAT=ist) ans
                              if ( ist .ne. 0 .or. & 
                                   ans(1:1) .eq. ' ') then
                                 ans(1:1) = 'y'
                              endif
                              call lower(ans,20)
                           endif

                           if ( index(ans,'n') .gt. 0 ) then
                              if ( powervar .eq. iy ) powervar = 0
                              if ( plavar   .eq. iy ) plavar = 0
                              change = .true.
                           else
                              write(*,*)'Accel analysis (1)N1 '// & 
                                   '(2)PLA'
                              read(*,12,IOSTAT=ist) i
                              if ( ist .eq. 0 .and. i .ne. 0 ) then
                                 if ( i .eq. 1 .and. & 
                                      powervar .ne. iy) then
                                    powervar = iy
                                    change = .true.
                                 elseif( i .eq. 2 .and. & 
                                         plavar .ne. iy) then
                                    plavar   = iy
                                    change = .true.
                                 endif

                              endif
                           endif
                        elseif( index(ans,'x') .gt. 0 ) then
                           newin = .true.
                           do i=1,nxt
                              if ( xtarvar(i) .eq. iy ) then
                                 newin = .false.
                              endif
                           enddo
                           i = 1
                           do while ( i .le. nxt ) 
                              if ( xtarvar(i) .eq. iy ) then
                                 write(*,*) 'X target value = ', & 
                              xtarval(i),' Slope = ',slope(xtarm(i)+1)
                                 write(*,*) 'Enter New # (D)elete'// & 
                                      ' <CR> Default (A)dd (S)lope'
                                 read(*,10,IOSTAT=ist) tivar
                                 call lower(tivar,20)
                                 if ( ist .eq. 0 .and. & 
                                      tivar .ne. ' ') then
                                    if ( index(tivar,'d') & 
                                         .gt. 0 ) then
                                       xtarvar(i) = 0
                                       do j=i,nxt-1
                                          xtarval(j)=xtarval(j+1)
                                          xtarvar(j)=xtarvar(j+1)
                                          xtarm(j)  =xtarm(j+1)
                                       enddo
                                       nxt = nxt - 1
                                       change = .true.
                                    elseif( index(tivar,'a') & 
                                            .gt. 0 ) then
                                       i = nxt + 1 !exit loop
                                       newin = .true.
                                    elseif ( index(tivar,'s') & 
                                            .gt. 0 ) then
                                       write(*,*) 'Enter Slope '// & 
                                   ' 0=Either 1=Pos  2=Neg <CR>=Either'
                                       read(*,12,IOSTAT=ist) j
                                       if ( ist .ne. 0 .or. j .lt. 0 & 
                                         .or. j .gt. 2 ) j = 0
                                       xtarm(i) = j
                                       change = .true.
                                    else
                                       read(tivar,*,IOSTAT=ist) x
                                       if ( ist .eq. 0 ) then
                                          xtarval(i) = x
                                          change = .true.
                                       endif
                                       i = i + 1
                                    endif
                                 else
                                    i = i + 1
                                 endif
                              else
                                 i = i + 1
                              endif
                           enddo

                           if ( newin ) then
                              tivar(1:1) = '1'
                              ist = 0
                              do while (ist .eq. 0 .and. nxt .lt. 10 & 
                                   .and. tivar(1:1) .ne. ' ') 
                                 write(*,*) & 
                                       'Enter next X target value'
                                 read(*,10,IOSTAT=ist) tivar
                                 if ( ist .eq. 0 .and. & 
                                      tivar(1:1) .ne. ' ') then
                                    read(tivar,*,IOSTAT=ist) x
                                    if ( ist .eq. 0 ) then
                                       nxt = nxt + 1
                                       xtarval(nxt) = x
                                       xtarvar(nxt) = iy
                                       write(*,*) 'Enter Slope '// & 
                                   ' 0=Either 1=Pos  2=Neg <CR>=Either'
                                       read(*,12,IOSTAT=ist) j
                                       if ( ist .ne. 0 .or. j .lt. 0 & 
                                         .or. j .gt. 2 ) j = 0
                                       xtarm(i) = j
                                       change = .true.
                                    endif
                                 endif
                              enddo
                           endif
                        elseif( index(ans,'y') .gt. 0 ) then !Y target
                           newin = .true.
                           do i=1,nyt
                              if ( ytarvar(i) .eq. iy ) then
                                 newin = .false.
                              endif
                           enddo
                           i = 1
                           do while ( i .le. nyt ) 
                              if ( ytarvar(i) .eq. iy ) then
                                 write(*,*) 'Y target value = ', & 
                               ytarval(i),' Slope = ',slope(ytarm(i)+1)
                                 write(*,*) 'Enter New # (D)elete'// & 
                                      ' <CR> Default (A)dd (S)lope'
                                 read(*,10,IOSTAT=ist) tivar
                                 call lower(tivar,20)
                                 if ( ist .eq. 0 .and. & 
                                      tivar .ne. ' ') then
                                    if ( index(tivar,'d') & 
                                            .gt. 0 ) then
                                       ytarvar(i) = 0
                                       do j=i,nyt-1
                                          ytarval(j)=ytarval(j+1)
                                          ytarvar(j)=ytarvar(j+1)
                                       enddo
                                       nyt = nyt - 1
                                       change = .true.
                                    elseif( index(tivar,'a') & 
                                            .gt. 0 ) then
                                       i = nyt + 1 !exit loop
                                       newin = .true.
                                    elseif ( index(tivar,'s') & 
                                            .gt. 0 ) then
                                       write(*,*) 'Enter Slope '// & 
                                  ' 0=Either 1=Pos  2=Neg <CR>=Either'
                                       read(*,12,IOSTAT=ist) j
                                       if ( ist .ne. 0 .or. j .gt. 2 & 
                                         .or. j .lt. 0 ) j = 0
                                       ytarm(i) = j
                                       change = .true.
                                    else
                                       read(tivar,*,IOSTAT=ist) x
                                       if ( ist .eq. 0 ) then
                                          ytarval(i) = x
                                          change = .true.
                                       endif
                                       i = i + 1
                                    endif
                                 else
                                    i = i + 1
                                 endif
                              else
                                 i = i + 1
                              endif
                           enddo
                           if ( newin) then
                              tivar = '1'
                              ist = 0
                              do while (ist .eq. 0 .and. nyt .lt. 10 & 
                                   .and. tivar(1:1) .ne. ' ') 
                                 write(*,*) & 
                                      'Enter next Y target value'
                                 read(*,10,IOSTAT=ist) tivar
                                 if ( ist .eq. 0 .and. & 
                                      tivar(1:1) .ne. ' ') then
                                    read(tivar,*,IOSTAT=ist) x
                                    if ( ist .eq. 0 ) then
                                       nyt = nyt + 1
                                       ytarval(nyt) = x
                                       ytarvar(nyt) = iy
                                       write(*,*) 'Enter Slope '// & 
                                    ' 0=Either 1=Pos  2=Neg <CR>=Either'
                                       read(*,12,IOSTAT=ist) j
                                       if ( ist .ne. 0 .or. j .lt. 0 & 
                                          .or. j .gt. 2 ) j = 0
                                       ytarm(i) = j
                                       change = .true.
                                    endif
                                 endif
                              enddo
                           endif
                        elseif( index(ans,'c') .gt. 0 ) then !CFD
                           ans(1:1) = 'y'
                           if ( cfdvar .eq. iy ) then
                              write(*,*) 'Keep this variable as '// & 
                                   'CFD analysis variable (Y/n)'
                              read(*,10,IOSTAT=ist) ans
                              if ( ist .ne. 0 .or. & 
                                   ans(1:1) .eq. ' ') then
                                 ans(1:1) = 'y'
                              endif
                              call lower(ans,20)
                           endif

                           if ( index(ans,'n') .gt. 0 ) then
                              if ( cfdvar .eq. iy ) then
                                 cfdvar = 0
                                 change = .true.
                              endif
                           else
                              write(*,*) 'Enter start time for CFD'// & 
                                      ' analysis:'
                              read(*,10,IOSTAT=ist) tivar
                              if(ist .eq. 0 .and. & 
                                   tivar(1:1) .ne. ' ') then
                                 read(tivar,*,IOSTAT=ist) x
                                 if ( ist .eq. 0 ) then
                                    cfd_st = x
                                    cfdvar = iy
                                    change = .true.
                                 endif
                              endif
                           endif
                        endif   !Y parsing
                        if (anly ) ans='1'
                     endif
                  enddo         !y command llop
               endif            !Xy variable
               idx=1
               if ( .not. aerr ) then
                  call load_acdusd(acdusd,nacd,acdvar,yinacd,xinacd, & 
                       ny,yvar,nplot,xvar,nv,np)
               endif
            endif               !if x variable
         endif                  !master command parsing

      enddo !master loop


 10   format(a)
 11   format(f10.2)
 12   format(i1)
 13   format(f5.1)
 20   format(5x,'(R)ate : ',f6.2,4x,'Type [(P)lot/(S)nap]: ',a)
 30   format(1x,i2,1x,'X = ',a,1x,'MIN = ',a,' MAX = ',a)
 31   format(1x,i2,'*',' X = ',a,1x,'MIN = ',a,' MAX = ',a)
 40   format(i2,2x,' Y = ',a,1x,'MIN = ',a,' MAX = ',a)
 41   format(1x,i2,2x,' Y = ',a)
 42   format(i2,'*  Y = ',a,1x,'MIN = ',a,' MAX = ',a)
 43   format(1x,i2,'*  Y = ',a)
 50   format(1x,a1,' Variable: ',a,3x,'Mi(N) = ',a,' Ma(X) = ',a)
 60   format('X = ',a,1x,'Scale = ',a,' to ',a)
 61   format(3x,'Y = ',a,1x,'Scale = ',a,' to ',a)
      return
      end

      subroutine load_plt(plt,ntot, & 
                          npage,ngrid,ny,ynplot,nplot,nv,np)
      implicit none

! * Argument list

      integer*4       plt(6,6)    !Plt array to load
      integer*4       ntot        !Total x + y
      integer*4       npage       !Total number of pages

      integer*4       nv          !Number of grids peg page
      integer*4       np          !Number of page avail

      include "flt_plot.inc"
      include "flt_read_vars.inc"

! * Locals
      integer*4       i,k,j           !counter
      integer*4       lx          !Last x
      integer*4       nye         !Number of expanded y

      do i=1,np
         do j= 1,nv
            plt(i,j) = 0
         enddo
      enddo


      k  = 0
      lx = -99

      npage    = 0          ! Start with 1 page
      do j=1,ny
         if ( ynplot(j) .eq. lx ) then !Same x variable
            if ( k + ngrid(j) .gt. nv ) then ! page full 
               npage = npage + 1               
               plt(npage,1) = j
               k = ngrid(j)
            else
               plt(npage,k+1) = j
               k = k + ngrid(j)
            endif
         else                   ! New x means new page
            npage = npage + 1
            plt(npage,1) = j
            k = ngrid(j)
            lx = ynplot(j)
         endif
         if ( ngrid(j) .gt. 1 ) then !Fill
            do i=k-ngrid(j)+2,k
               plt(npage,i) = 99
            enddo
         endif
      enddo

      nye  = (npage - 1) * nv + k
      if ( nye .lt. 0 ) nye = 0
      ntot = npage + nye
      if ( ny .eq. 0 ) then
         if ( nplot .ne. 0 ) then
            ntot = 1
            plt(1,1) = 199
         endif
      endif

      return
      end

      subroutine load_acdusd(acdusd,nacd,acdvar,yinacd,xinacd, & 
                             ny,yvar,nplot,xvar,nv,np)
      implicit none

      character*64  acdvar(200)         !Acd variable list

      logical*4     acdusd(200)         !Is acd variable plotted
      logical*4     xinacd(6)           !Is x variable in acd
      logical*4     yinacd(36)          !Is y variable in acd

      integer*4     nacd                !Number of acd variables
      integer*4     nv                  !Number of grids per page
      integer*4     np                  !Number of total pages available

! * Remaining argument variables in following include file
      include "flt_plot.inc"
      include "flt_read_vars.inc"

! * Locals
      integer*4     i,j                 !Counters


      do i=1,np
         xinacd(i) = .false.
      enddo
      do i=1,np*nv
         yinacd(i) = .false.
      enddo
      do i=1,nacd
         acdusd(i) = .false.
         do j=1,nplot
            if ( xvar(j)(:lrbl(xvar(j))) .eq. & 
                 acdvar(i)(:lrbl(acdvar(i))) ) then
               xinacd(j) = .true.
               acdusd(i) = .true.
            endif
         enddo
         do j=1,ny
            if ( yvar(j)(:lrbl(yvar(j))) .eq. & 
                 acdvar(i)(:lrbl(acdvar(i))) ) then
               yinacd(j) = .true.
               acdusd(i) = .true.
            endif
         enddo
      enddo

      return
      end


      integer function toi(g,p,nv)
      implicit none

! * Argument  list
      integer*4    g         !Grid
      integer*4    p         !Page
      integer*4    nv        !Number of variables per page

      toi = (p-1) * nv + 1 + g

      return
      end

      integer function upx(idx,nv)
      implicit none

! * Argument  list
      integer*4    idx       !Index
      integer*4    nv        !Number of variables per page

      upx = ((idx-1)/(nv+1))*(nv+1) + 1

      return
      end


      logical function isx(idx,nv)
      implicit none

! * Argument  list
      integer*4    idx       !Index
      integer*4    nv        !Number of variables per page

      isx = ( mod(idx,nv+1) .eq. 1 .or. idx .eq. 1 )

      return
      end


      subroutine get_gp(idx,nv,g,p)      
      implicit none

! * Argument  list
      integer*4    g         !Grid
      integer*4    p         !Page

      integer*4    idx       !Index
      integer*4    nv        !Number of variables per page
! * Externals
      integer*4    upx       !return x for current page

      p = (idx-1)/(nv+1) + 1

      g = idx - upx(idx,nv)

      return 
      end

      subroutine get_scale(min,max,lower,upper)
      implicit none

      real*4      min              !input minimum
      real*4      max              !input maximum
      real*4      lower            !output min scale
      real*4      upper            !Ouput max scale

      integer*4   i                !counter
      integer*4   iscale           !index in to scales
      integer*4   ist              !IOSTAT flag
      integer*4   p                !Power

      real*4      delscl           !Delta between min and max scaled by 10^p
      real*4      delta            !Delta between min and max 
      real*4      admn             !Adjust minimum by 1%
      real*4      admx             !Adjust maximum by 1%

      logical     cont

      integer     nscale
      parameter(nscale=4)

      real scale(nscale) /1.,2.,4.,5./

      cont = .true.

      if ( max .le. min ) then
         cont = .false.
         upper = max
         lower = max - 10
      endif

      if ( cont ) then
         admn= 1.01
         admx = 0.99
         if ( min .lt. 0. ) admn = .99
         if ( max .lt. 0. ) admx = 1.01

         if ( max * admx .gt. min * admn) then
            min = admn * min
            max = admx * max
         endif

         delta = max - min

         p= alog10(delta)

         delscl = delta / 10.**p

         i = 1
         iscale = 1
         do while( i .le. nscale .and. scale(i) .lt. delscl )
            iscale = i 
            i = i + 1
         enddo

         if ( iscale .ne. 1 ) iscale = iscale + 1
         if ( iscale .eq. 5 ) then
            iscale = 1
            p = p + 1
         endif

         lower = aint( min/10.**p) * 10.**p
         upper = lower + scale(iscale)*10.**p

         do while ( lower .gt. min  )
            lower = lower - 10.**p
            upper = lower + scale(iscale)*10.**p
         enddo


         do while ( upper .lt. max ) 
            iscale = iscale + 1
            upper = lower + scale(iscale)*10.**p
         enddo

         if ( lower .gt. 0. .and. lower .lt. 10. & 
              .and. upper .lt. 10.) then
            lower = 0.
            upper = 10.
         endif

      endif

      return
      end


