!  ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : Generic
!    JOB             : All
!    DEPARTMENT      : 61 - Flight Dynamics
!    MODULE NAME     : flt_modfile
!    DESCRIPTION     : modifies autotest data files
!    PACKAGE         : flt
!    RATE            : offline
!    ORIGINATOR      : Flight Data Library
!    DATE            : 2/16/2000
!    ENGINEER        : Mike Saladin
!    SYSTEM          : Unix

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 2000 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 259-4000  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
!--> REVISION BEGIN
! $Id: flt_modfile.f,v 1.1 2000/03/13 21:42:30 saladinm Exp $
! $Log: flt_modfile.f,v $
! Revision 1.1  2000/03/13 21:42:30  saladinm
! Initial revision

!--> REVISION END
! *******************************************************************


      subroutine flt_modfile()

      implicit none

      CHARACTER*80  RCSID & 
      /"$Id: flt_modfile.f,v 1.1 2000/03/13 21:42:30 saladinm Exp $"/

! * Locals
      character*64 input        !Input Line

      integer*4    cmd          !command input
      integer*4    ist          !IO status
      integer*4    irow         !Number of rows in window

      logical*4    copy         !Copy from one file to another
      logical*4    delete       !Delete parameter from one file 
      logical*4    end          !Loop controler

! * Externals      

! *   Get current window size
      call flt_window(irow)

      end = .false.

      do while ( .not. end )
         write(*,*)' '
         write(*,*)'              Data Manipulation Menu'
         write(*,*)' '
         write(*,*)' 1.  Copy parameter(s) from one file to another'
         write(*,*)' 2.  Convert parameter(s) from standard format to'// & 
              ' XY format and/or filter data'
         write(*,*)' 3.  Delete parameter(s) from a file'
         write(*,*)' '
         write(*,*)' 4.  Change ICs in ACD file (new time)'
         write(*,*)' 5.  Exit'
         write(*,*)' '
         write(*,*)' '
         write(*,*)' Enter your choice->'
         read(*,10,IOSTAT=ist) cmd

         if ( ist .ne. 0 ) end = .true.

         if ( cmd .le. 0 .or. cmd .gt. 4 ) end = .true.


         if ( .not. end ) then 
            if ( cmd .eq. 1 ) then
               copy   = .true.
               delete = .false.
               call mod_data(copy,delete,irow)
            elseif ( cmd .eq. 2 ) then
               copy   = .false.
               delete = .false.
               call mod_data(copy,delete,irow)
            elseif ( cmd .eq. 3 ) then
               copy   = .false.
               delete = .true.
               call mod_data(copy,delete,irow)
            elseif ( cmd .eq. 4 ) then
               call mod_ictime(irow)
            endif !Master command sorter
         endif !IF not end
      enddo  !Master Loop

 10   format(i2)

      return
      end

! *************************************************************************

      subroutine mod_data(copy,delete,irow)

! *************************************************************************
!     This subroutine takes a parameter and copies it from one file 
!     (ACD,ATD,POM,SIM,MAN) to another file (ACD,ATD,POM)

!     The parameter copied will either be in the new grouped format or
!     in an XY format.  The new format can only be used if the X parameter
!     is absolutely identical between the parameter to be copied and the
!     the X parameter in the file it is being copied in to.

! *************************************************************************

      implicit none

      logical*4     copy            !Copy parameter from one file to another
      logical*4     delete          !Delete parameter from one file 
      integer*4     irow            !Number of rows on the screen

! * Locals
      integer*4     nout            !Dimension of output array
      parameter (nout = 300)

      character*256 message         !Message variable
      character*132 file            !Temp file name 
      character*132 filein          !Full path name of input file
      character*132 fileout         !Full path name of output file
      character*64  invar(42)       !array of variables from input file
      character*64  var(200)        !array of variables found
      character*64  copyv(42)       !array of variables to copy
      character*40  testname(1000)  !testnames
      character*40  name            !temp testname
      character*40  ans             !temp answer variable
      character*4   suf(5) /'.acd','.pom','.atd','.sim','.man'/

      real*4        min(200)       !Minimum of variable
      real*4        max(200)       !Maximum of variable

      integer*4     idx(40)        !index to correlate to fatdnum
      integer*4     dim(40)        !Number of data points per variable
      integer*4     xdx(40)        !Location of xpointer for the atdvar
      integer*4     ydx(40)        !Location of ypointer for the atdvar
      integer*4     psnap          !Location of fsnap


      integer*4     ptr            !Number of data points filled in outarr


      real*4        dt             !Delta time of data for filter
      real*4        outarr(100000) !Data storage array
      real*4        rate           !Filter rate
      real*4        sng(2,40)      !Y Shift and gains (1,#)=shift (2,#)=gain
      real*4        xsng(2,40)     !X Shift and gains (1,#)=shift (2,#)=gain
      real*4        xo(20000)      !X data from output file

      logical*4     isman          !Manual test flag
      logical*4     err            !error flag 
      logical*4     force(40)      !Force XY output format


      integer*4     testnum(1000)   !test numbers
      integer*4     i,j,k,l         !Counters
      integer*4     ist             !IO status
      integer*4     col             !Number of columns to display
      integer*4     cmd             !Command input               
      integer*4     imx             !Max length of variable name             
      integer*4     itype           !Type of input either a number or name
      integer*4     lu18  /18/      !Logical unit for output file         
      integer*4     ncopy           !Number of variables to copy
      integer*4     nl              !Number of lines displayed
      integer*4     np              !Number of points for filter
      integer*4     numt            !number of tests
      integer*4     num             !Test Number of found test
      integer*4     nvar            !number of variables in vars
      integer*4     type            !Type of test input name=1 num=0
      integer*4     xdim            !Num of points in X in output file

      logical*4     cont            !Master while loop continue
      logical*4     cont2           !Secondary while loop continue
      logical*4     found           !Variable found flag
      logical*4     insert          !Flag to insert data vs write all data   
      logical*4     isxy(40)        !Is output data in XY format
      logical*4     lexist          !File exists flag
      logical*4     list            !Show list
      logical*4     newfile         !Output file is a new file
      logical*4     repeat          !At least one of copy vars in output file
      logical*4     same            !Is X data in output file same as new data



! * Externals
      integer*4     rlan            !Returns index of last non-blank
      integer*4     lran            !Returns index of first non-blank
      integer*4     lrbl            !Returns index of first blank from left

! * Allow for global character strings ( fpath )
      include "flt_plot.inc"

      call read_index(numt,testname,testnum)

      do i=1,40
         sng(1,i)  = 0.0
         sng(2,i)  = 1.0
         xsng(1,i) = 0.0
         xsng(2,i) = 1.0
         idx(i)    = i
      enddo


! * Master do loop
      cont = .true.

      do while ( cont )
         ftestname = ' '
         write(*,*)'     Copy Parameter File to File'
         write(*,*)' '
         write(*,*)' Enter test name or number to work with:'
         read(*,10,IOSTAT=ist) name
         if ( name .eq. ' ' .or. ist .ne. 0 ) then
            cont = .false.
         else   
            call findname(name,num,itype,testname,testnum,numt)
            if ( itype .gt. 2 ) then ! test not found
               write(*,*) 'Test Not Found. '
            else
               ftestname = name(:lrbl(name))    !test found
            endif           
         endif

         cont2 = .true.
         list = .false.

         filein  = ' '
         fileout = ' '
         if ( ftestname .ne. ' ' ) then 

            do while (cont2 ) 
               if ( copy ) then
                  write(*,*)' Choose file type to copy from: '
               elseif ( delete ) then
                  write(*,*)' Choose file type to delete from: '
               else
                  write(*,*)' Choose file type to modify: '
               endif

               write(*,*)' '
               write(*,*)' 1.  ACD'
               write(*,*)' 2.  POM'
               write(*,*)' 3.  ATD'
               write(*,*)' 4.  SIM'
               write(*,*)' 5.  MAN'
               write(*,*)' 6.  Exit'
               write(*,*)' '
               read(*,20,IOSTAT=ist) cmd
               if ( cmd .lt. 1 .or. cmd .gt. 5 .or. ist .ne. 0 ) then
                  cont2 = .false.
               else
                  file   = ftestname(:lrbl(ftestname))//suf(cmd)
                  call pathfile(filein,fpath,file(:lrbl(file)))

                  inquire(FILE=filein,EXIST=lexist)

                  if ( .not. lexist ) then
                     write(*,*)'File does not exist: '// & 
                                          filein(:lrbl(filein))
                     write(*,*)'Try again.'
                  else

                     newfile = .false.
                     if ( copy ) then
                        write(*,*)' Choose file type to copy TO: '
                        write(*,*)' '
                        write(*,*)' 1.  ACD'
                        write(*,*)' 2.  POM'
                        write(*,*)' 3.  ATD'
                        write(*,*)' 4.  Exit'
                        write(*,*)' '
                        read(*,20,IOSTAT=ist) cmd
                        if ( cmd .lt. 1 .or. cmd .gt. 3 & 
                             .or. ist .ne. 0 ) then
                           cont2 = .false.
                        else
                           file = ftestname(:lrbl(ftestname))//suf(cmd)
                           call pathfile(fileout,fpath,file)

                           inquire(FILE=fileout,EXIST=lexist)
                           if ( .not. lexist ) then
                              write(*,*)' File does not exist: '// & 
                                   fileout(:lrbl(fileout))
                              write(*,*)' Will create this file'
                              newfile = .true.
                           endif
                           cont2 = .false.
                        endif
                     else
                        fileout=filein
                        cont2 = .false.
                     endif
                  endif
               endif
            enddo  !Cont2 do while
         endif !IF ftestname .ne. ' '

         ncopy = 0

         if ( filein .ne. ' ' .and. fileout .ne. ' ') then
            call flt_var_data(filein,var,nvar,min,max,err)

            cont2 = .true.

            do while ( cont2 ) 
               if ( .not. list ) then
                  write(*,*)' '
                  write(*,*)' Do you want to see a list of'// & 
                       ' available variables? (y/N)'
                  read(*,10,IOSTAT=ist) ans
                  call lower(ans,10)
                  if ( ist .eq. 0 .and. index(ans,'y') .gt. 0) then
                     list = .true.
                  endif
               endif
               if ( .not. list ) then
                  if ( copy ) then
                     write(*,*)' Input desired variable name to copy:'
                  elseif ( delete ) then
                     write(*,*)' Input desired variable name to delete:'
                  else
                     write(*,*)' Input variable to output in XY format:'
                  endif
                  read(*,10,IOSTAT=ist) name
                  call lower(name,80)
                  if ( ist .ne. 0 ) then
                     name = ' '
                  else          !variable input
                     found = .false.
                     i = 1
                     do while ( i .le. nvar .and. .not. found )
                        if ( var(i)(:lrbl(var(i))) .eq. & 
                             name(:lrbl(name)) ) then
                           found = .true.
                        endif
                        i = i + 1
                     enddo
                     if ( found ) then
                        ncopy = ncopy + 1
                        copyv(ncopy) = name(:lrbl(name))
                     else
                        name = ' '
                        write(*,*)' Variable not found: '// & 
                             name(:lrbl(name))
                        write(*,*)' In File: '//filein(:lrbl(filein))
                     endif
                  endif
               else             ! Pick from list
                  imx = 0

                  do i=1,nvar
                     k = lrbl(var(i))
                     if ( k .gt. imx ) imx = i
                  enddo


                  if ( imx .le. 10 ) then
                     col = 4
                  elseif ( imx .le. 20 ) then
                     col = 3
                  elseif ( imx .le. 30 ) then
                     col = 2
                  else
                     col = 1
                  endif

                  j = 1
                  cont = .true.
                  nl = 0
                  do while ( cont )
                     write(*,*) ' Variables in: '//filein(:lrbl(filein))
                     write(*,*) ' '
                     if ( j .gt. nvar/col ) j = 1
                     i = 1
                     do while ( j .le. nvar/col .and. nl .le. irow - 6 )
                        if ( col .eq. 4 ) then
                           write(*,14) (i,var(i),i=j*4-3,j*4)
                        elseif ( col .eq. 3 ) then
                           write(*,13) (i,var(i),i=j*3-2,j*3)
                        elseif ( col .eq. 2 ) then
                           write(*,12) (i,var(i),i=j*2-1,j*2)
                        else
                           write(*,11)  j,var(j)
                        endif
                        j = j + 1
                        nl = nl + 1 !incr line count
                     enddo

                     if ( mod(nvar,col) .gt. 0 .or. nvar .lt. col ) then !write the remainer
                        if ( col .eq. 4 ) then
                           write(*,14) (j,var(j),j=i,nvar)
                        elseif ( col .eq. 3 ) then
                           write(*,13) (j,var(j),j=i,nvar)
                        elseif ( col .eq. 2 ) then
                           write(*,12) (j,var(j),j=i,nvar)
                        else
                           write(*,11) (j,var(j),j=i,nvar)
                        endif
                        nl = nl + 1 !incr line count
                     endif

                     write(*,*) ' Enter Variable # or +/= Next page  '// & 
                          'or -/_ Prev page  Turn List (O)ff'
                     read(*,10,IOSTAT=ist) ans
                     call lower(ans,10)

                     if ( ans .eq. ' ' .or. ist .ne. 0 ) then
                        cont = .false.
                        name = ' '
                     endif

                     if ( index(ans,'+') .gt. 0 .or.  & 
                          index(ans,'=') .gt. 0 ) then
                        nl = 0
                     elseif(index(ans,'o') .gt. 0 ) then
                        list = .false.
                     elseif(index(ans,'-') .gt. 0 .or. & 
                             index(ans,'_') .gt. 0) then
                        j = j - 2*(irow-6)
                        nl = 0
                        if ( j .lt. 1 ) j = 1
                     else       !Assume a number
                        read(ans,*,IOSTAT=ist) k
                        if ( ist .ne. 0 .or. k .gt. nvar .or. & 
                             k .lt. 1 ) then
                           write(*,*) 'Error reading input'
                           write(*,*) 'Try again '
                        else
                           name = var(k)
                           ncopy = ncopy + 1
                           copyv(ncopy) = name(:lrbl(name))
                           cont = .false.
                        endif
                     endif
                  enddo

               endif   
               if ( ncopy .lt. 40 ) then
                  if ( copy ) then
                     write(*,*)' Do you want to force XY output? (y/N)'
                     read(*,10,IOSTAT=ist) ans
                     call lower(ans,80)
                     if ( ans .eq. ' ' .or. ist .ne. 0 & 
                          .or. index(ans,'n') .gt. 0) then
                        force(ncopy) = .false.
                     else
                        force(ncopy) = .true.
                     endif
                  elseif( delete ) then
                     force(ncopy) = .false.   
                  else
                     force(ncopy) = .true.
                  endif

                  write(*,*)' Do you want another variable (y/N)'
                  read(*,10,IOSTAT=ist) ans
                  call lower(ans,10)
                  if ( ans .eq. ' ' .or. ist .ne. 0 & 
                       .or. index(ans,'n') .gt. 0) then
                     cont2 = .false.
                  endif
               else
                  write(*,*)' Maximum number of variables selected'
                  write(*,*)' If more desired re-run.'
                  cont2 = .false.
               endif
            enddo  !do while cont2

            repeat = .false.
            if ( .not. newfile ) then  !Check to see if variable already exists
               call flt_var_data(fileout,var,nvar,min,max,err)

               do i=1,ncopy
                  j = 1
                  do while ( j .le. nvar )
                     if ( copyv(i)(:lrbl(copyv(i))) .eq. & 
                          var(j)(:lrbl(var(j))) ) then
                        write(*,*)' Selected variable: '// & 
                                    copyv(i)(:lrbl(copyv(i)))
                        if ( copy ) then
                           write(*,*)' Already exists in output file.'// & 
                                ' Do you want to replace it? (y/N)'
                        elseif ( delete ) then
                           write(*,*)' Are you sure that you want to '// & 
                                'permantly delete this variable? (y/N)'
                        else
                           write(*,*)' Are you sure that you want to '// & 
                                'permantly change the format? (y/N)'
                        endif
                        read(*,10,IOSTAT=ist) ans
                        call lower(ans,10)
                        if ( ans .eq. ' ' .or. ist .ne. 0 & 
                             .or. index(ans,'n') .gt. 0) then
                           ncopy = ncopy - 1
                           do k=i,ncopy       !remove unwanted variable
                              copyv(k) = copyv(k+1)
                              force(k) = force(k+1)
                           enddo
                        else  !Keep this variable and flag it as a replace
                           repeat = .true.
                        endif
                     endif
                     j = j + 1
                  enddo
               enddo
            endif




         endif                  !if filein and fileout != ' '

!   Output selected variables to selected file
         if ( ncopy .gt. 0 ) then 
            call get_date()

            if ( newfile ) then  !New Output file 
               open(lu18,FILE=fileout,STATUS='NEW',IOSTAT=ist)
               if ( ist .ne. 0  ) then
                  write(*,*)' Error opening output file: ',fileout
                  write(*,*)' Nothing done '
               else
                  write(lu18,10)'# This file was created by'// & 
                       ' flt_modfile'
                  write(lu18,10)'# By: '//username(:lrbl(username))// & 
                       ' On: '//chdate//' '//chtime
                  write(lu18,10)'# Data is from: '// & 
                       filein(:lrbl(filein))
                  write(lu18,10)'#'
                  write(lu18,10)'Start Data'
                  write(lu18,10)'End Data'

                  close (lu18)

               endif
               nvar = 0
            else

!              Read first two arrays from output file
               ptr = 1
               call flt_read_data(fileout,var,2,idx,xsng,sng,dim, & 
                               xdx,ydx,ptr,outarr,psnap,isman,err)

            endif

            err = .false.

            do i=1,ncopy        !Default the output format to XY
               isxy(i) = .true.
            enddo

!           Find out if output file has a grouped Y format
            if ( nvar .gt. 1 .and. xdx(1) .eq. xdx(2) .and. copy ) then
               xdim = dim(1)
               do i=1,xdim
                  xo(i) = outarr(xdx(1)+i-1)
               enddo

!              Read data from input file to copy to output file
               ptr = 1
               call flt_read_data(filein,copyv,ncopy,idx,xsng,sng,dim, & 
                               xdx,ydx,ptr,outarr,psnap,isman,err)

!              See which output variables have same x array as output file
               do i=1,ncopy
                  isxy(i) = .true.
                  if ( dim(i) .eq. xdim ) then !X arrays same size
                     same = .true.
                     do j=1,xdim
                        if (xo(j) .ne. outarr(xdx(i)+j-1)) same=.false.
                     enddo
                     if (same .and. .not. force(i)) isxy(i) = .false.
                  endif
               enddo

            elseif ( delete ) then
               repeat = .true.

               ptr = 1
               call flt_read_data(filein,copyv,ncopy,idx,xsng,sng,dim, & 
                    xdx,ydx,ptr,outarr,psnap,isman,err)

!              Set the dimension to zero so it won't be output               
               do i=1,ncopy
                  dim(i) = 0
               enddo
            elseif ( .not. copy ) then
!              Read data from input file to copy to output file
               repeat = .true.

               ptr = 1
               call flt_read_data(filein,copyv,ncopy,idx,xsng,sng,dim, & 
                    xdx,ydx,ptr,outarr,psnap,isman,err)

               do i=1,ncopy
                  write(*,*)' Do you want to filter the'// & 
                            ' output data?(y/N)'
                  read(*,10,IOSTAT=ist) ans
                  call lower(ans,10) 

                  if ( ist .eq. 0 .and. index(ans,'y') .gt. 0 ) then
                     write(*,*)' Variable:         '//copyv(i) & 
                          (:lrbl(copyv(i)))
                     write(*,*)' Number of Points: ',dim(i)
                     dt = outarr(xdx(i)+1)-outarr(xdx(i))
                     write(*,*)' Time step:        ',dt,' secs'
                     write(*,*)' Input desired rate in Hz (pts/sec)'
                     read(*,*,IOSTAT=ist) rate
                     if ( ist .eq. 0 ) then
                        if ( dt .ne. 0 ) then
                           dt = 1.0 / dt
                        else
                           dt = 1.0
                        endif
                        if ( rate .gt. 0.0 ) then
                           np = int( 0.5 + dt/rate)
                        else
                           np = 1
                        endif
                     else
                        np = 1
                     endif

!                    Filter data
                     if ( ptr + dim(i) .gt. 100000 ) then
                        write(*,*)' Unable to filter data. '
                        write(*,*)' Not enough room in the data array'
                        write(*,*)' Will output data unfiltered'
                     else
                        j = np  !get the first point
                        k = 0
                        do l=1,dim(i)
                           if ( j .ge. np ) then
                              k = k + 1
                              outarr(ptr+k-1) = outarr(xdx(i)+l-1)
                              outarr(ydx(i)+k-1) = outarr(ydx(i)+l-1)
                              j = 0
                           endif
                           j = j + 1
                        enddo
                        dim(i) = k        !Adjust dim of array
                        xdx(i) = ptr      !Adjust location of X in array
                        ptr    = ptr + k  !Adjust first vacant pt in outarr
                     endif
                  endif !Filter data
               enddo !Loop through outputs to filter


            else  !output file has no Y group or new file
!              Read data from input file to copy to output file
               ptr = 1
               call flt_read_data(filein,copyv,ncopy,idx,xsng,sng,dim, & 
                    xdx,ydx,ptr,outarr,psnap,isman,err)

!              Check to see if any variables have the same X
               if ( ncopy .gt. 1 ) then
                  i = 1
                  found = .false.
                  do while ( i .lt. ncopy .and. .not. found ) 
                     do k = i+1,ncopy
                        if ( dim(i) .eq. dim(k) ) then
                           same = .true.
                           do j=1,dim(i)
                              if (outarr(xdx(i)+j-1) .ne. & 
                                   outarr(xdx(k)+j-1)) same = .false.
                           enddo
                           if (same .and. .not. force(k)) then
                              isxy(i)=.false.
                              isxy(k)=.false.
                              found = .true.
                           endif
                        endif
                     enddo
                     i = i + 1
                  enddo

               endif

            endif               !Is data in Y grouped format

!           Write desired data to the file
            call rep_ins_data(fileout,copyv,ncopy,outarr,dim,xdx,ydx, & 
                              repeat,isxy,err)


         endif                  !If variable(s) selected


      enddo  !Master do loop


 10   format(a)
 11   format(6x,i3,'-',a)
 12   format(2(2x,i3,'-',a30))
 13   format(3(2x,i3,'-',a20))
 14   format(4(2x,i3,'-',a10))
 20   format(i5)
 30   format(i2,'/',i2,'/',i4,' At ',i2.2,':',i2.2,':',i2.2)

      return
      end




! ****************************************************************************

! This subroutine reads through a data file and removes repeat data and
! inserts other data at the proper place in the file.

! ****************************************************************************

      subroutine rep_ins_data(filein,var,nvar,datarr,dim,xdx,ydx, & 
                              repeat,isxy,err)

      implicit none

      integer*4     nvar        !Number of parameters to output
      integer*4     dim(40)     !Number of data points per variable
      integer*4     xdx(40)     !Location of xpointer for the atdvar
      integer*4     ydx(40)     !Location of ypointer for the atdvar

      character*132 filein      !Full path name of output file
      character*64  var(40)     !array of variables to output

      real*4        datarr(100000)!Output data

      logical*4     isxy(40)    !Output this parameter in XY format
      logical*4     repeat      !A variable already exists in output file
      logical*4     err         !err flag

!    Locals 
      integer*4     i,j,k,l     !Loop counters
      integer*4     ist         !Status flag
      integer*4     ist2        !Status flag
      integer*4     lu18 /18/   !Logical unit for output file
      integer*4     lu19 /19/   !Logical unit for temp output file
      integer*4     nl          !Number of lines read in
      integer*4     nv          !Number of data points
      integer*4     type        !Type of variable input 1=Y group 2=XY

      logical*4     fend        !File end flag
      logical*4     fnd         !Variable found flag
      logical*4     first       !First parameter flag
      logical*4     firstxy     !First XY parameter flag
      logical*4     rot(40)     !Variable has been written
      logical*4     start       !Start reading flag 

      character*132 blk /' '/   !Blank line
      character*132 line        !Input line read
      character*132 lline       !Input line lower cased
      character*132 message     !Output error message string
      character*132 tfile       !Temp file
      character*64  v1          !temp variable name from file
      character*64  v2          !temp variable name from file
      character*64  vt          !temp variable name from file

      real*4        dat(20000)  !Temp data array


! * Externals
      integer*4     rlan            !Returns index of last non-blank
      integer*4     lran            !Returns index of first non-blank
      integer*4     lrbl            !Returns index of first blank from left


      include "flt_plot.inc"



!     Open existing data file for reading
      open(lu18,FILE=filein,IOSTAT=ist)
      if ( ist .ne. 0  ) then
         write(*,*)' Error opening output file: ',filein
         write(*,*)' Nothing done '
         err = .true.
         return
      endif

!     Open temp data file to write data to
      i = lrbl(cpid)
      call pathfile(tfile,fpath,'temp_data_'//cpid(:i)//'.dat')
      open(lu19,FILE=tfile,IOSTAT=ist)
      if ( ist .ne. 0  ) then
         write(*,*)' Error opening output file: ',tfile
         write(*,*)' Nothing done '
         close(lu18)
         err = .true.
         return
      endif

!     Setup necessary flags      
      ist   = 0
      nl    = 0
      start = .true. 
      first = .true.
      firstxy = .true.
      type  = 0
      j     = 1
      fend = .false. 

      do i=1,40
         rot(i) = .false.
      enddo


      do while ( ist .eq. 0 .and. .not. fend .and. .not. err )
         read(lu18,10,IOSTAT=ist) line
!         write(*,*) line(:rlan(line))
         nl = nl + 1

         if ( ist .eq. 0 .and. line(1:1) .ne. '#' & 
                             .and. line .ne. blk ) then
            lline = line
            call lower(lline,132) ! make input line lower case

            if ( index(lline,'end') .gt. 0 .and. & 
                 index(lline,'data') .gt. 0 .and. & 
                 .not. start ) fend = .true.

!>          Read until "start data" is found
            if ( start ) then
               i = index(lline,'start')
               j = index(lline,'data')
               if ( i .gt. 0 .and. j .gt. 0 ) then !found start of data
                  start = .false.
                  write(lu19,10) '# Modified By: '//username// & 
                       ' On: '//chdate//chtime
                  write(lu19,10) line(:rlan(line))
               endif
            elseif( fend ) then
               type = 0

!              Write out remaining Y grouped vairables
               if ( first ) then !No Y group in file so write x first
                  i = 1
                  do while ( i .le. nvar .and. first )
                     if ( .not. isxy(i) .and. dim(i) .gt. 0 ) then
                        write(lu19,*,IOSTAT=ist2) 'ftsttime ',dim(i)
                        write(lu19,20,IOSTAT=ist2) & 
                             (datarr(l+xdx(i)-1),l=1,dim(i))
                        first = .false.
                     endif
                     i = i + 1
                  enddo
               endif

               do i = 1,nvar
                  if ( .not. isxy(i) .and. .not. rot(i) .and. & 
                       dim(i) .gt. 0) then
                     write(lu19,*,IOSTAT=ist2) var(i)(:lrbl(var(i)))
                     write(lu19,20,IOSTAT=ist2) & 
                             (datarr(l+ydx(i)-1),l=1,dim(i))
                     rot(i) = .true.
                  endif
               enddo

               do i = 1,nvar
                  if ( isxy(i) .and. dim(i) .gt. 0 ) then
!                   For now assume that x is time will need to fix this
                     write(lu19,*,IOSTAT=ist2) & 
                          'ftsttime  ',var(i)(:lrbl(var(i))),dim(i)
                     write(lu19,30,IOSTAT=ist2)  & 
                     (datarr(xdx(i)+k-1),datarr(ydx(i)+k-1),k=1,dim(i))
                     if ( ist2 .ne. 0 ) then
                        message='Error writing data for: '//var(i)
                        call write_mess(message,line,nl,filein)
                        err =  .true.
                     endif
                     rot(i) = .true.
                  endif
               enddo

               write(lu19,10) 'End Data'

!>          Looking for new variable 
            elseif ( type .eq. 0 ) then ! looking for new variable
               read(lline,*,IOSTAT=ist2) v1,v2,nv


!              Determine format of data
               if ( ist2 .eq. 0 ) then !No Error reading this format x y numpts
                  type = 2
               else !See if in format "y" or "x numpts"
                  if ( first ) then     ! First var has # after it
                     read(lline,*,IOSTAT=ist2) v2,nv
                  else
                     read(lline,*,IOSTAT=ist2) v2
                  endif

                  if ( ist2 .ne. 0 ) then  !error in data
                     message='UNABLE to read variable name'
                     call write_mess(message,line,nl,filein)
                     err = .true.
                     close(lu18)
                     close(lu19)
                     return
                  endif

                  type = 1

               endif

!              See if variable repeated
               fnd = .false.

               if ( repeat ) then
                  k = lrbl(v2)
                  vt = v2
                  call lower(vt,k)
                  i = 1
                  do while ( i .le. nvar .and. .not. fnd ) 
!debug                     write(*,*) var(i)(:lrbl(var(i))),' ',vt(:k)
                     if (var(i)(:lrbl(var(i))) .eq. vt(:k)) then
                        fnd = .true.
                        l = i
                     endif
                     i = i + 1
                  enddo
               endif

               if ( type .eq. 1 ) then
                  read(lu18,*,IOSTAT=ist2) (dat(i), i=1,nv)
                  if ( ist2 .gt. 0 ) then
                     message='Error reading data for: '//v2
                     call write_mess(message,line,nl,filein)
                     err =  .true.
                  endif
                  nl = nl + (nv-1)/6 + 1

                  if ( first ) then !always re-write this label
                     write(lu19,*,IOSTAT=ist2) v2(:k),nv
                     write(lu19,20,IOSTAT=ist2) (dat(i),i=1,nv)
                     first = .false.
                  else
                     if ( .not. fnd ) then         !rewrite this data
                        write(lu19,*,IOSTAT=ist2) v2(:k)
                        write(lu19,20,IOSTAT=ist2) (dat(i),i=1,nv)
                     elseif ( .not. isxy(l) .and. .not. rot(l) .and. & 
                             dim(l) .gt. 0 ) then !output new data
                        write(lu19,*,IOSTAT=ist2) v2(:k)
                        write(lu19,20,IOSTAT=ist2) & 
                             (datarr(i+ydx(l)-1),i=1,dim(l))
                        rot(l) = .true.
                     endif !Don't write this data
                  endif
                  if ( ist2 .gt. 0 ) then
                     message='Error writing data for: '//v2
                     call write_mess(message,line,nl,filein)
                     err =  .true.
                  endif
               else  !Type = 2

                  if ( firstxy ) then  !Write new grouped labels first
                     firstxy = .false.
                     if ( first ) then !No Y group in file so write x first
                        i = 1
                        do while ( i .le. nvar .and. first )
                           if ( .not. isxy(i) .and. dim(i) .gt. 0 ) then
                              write(lu19,*,IOSTAT=ist2) 'ftsttime ', & 
                                                         dim(i)
                              write(lu19,20,IOSTAT=ist2) & 
                                   (datarr(l+xdx(i)-1),l=1,dim(i))
                              first = .false.
                           endif
                           i = i + 1
                        enddo
                     endif
                     do i = 1,nvar
                        if ( .not. isxy(i) .and. .not. rot(i) .and. & 
                             dim(i) .gt. 0 ) then 
                           write(lu19,*,IOSTAT=ist2) var(i)(:lrbl(var(i)))
                           write(lu19,20,IOSTAT=ist2) & 
                             (datarr(l+ydx(i)-1),l=1,dim(i))
                           rot(i) = .true.
                        endif
                     enddo
                  endif

!                 if this variable to be replaced remove it else echo lines out
                  if ( .not. fnd ) & 
                       write(lu19,*,IOSTAT=ist2) line(:rlan(line))
                  do i=1,nv
                     nl = nl + 1
                     read(lu18,10,IOSTAT=ist2) line
                     if ( ist2 .ne. 0 ) then
                        message='Error reading data for: '//v2
                        call write_mess(message,line,nl,filein)
                        err =  .true.
                     endif

                     if ( .not. fnd ) & 
                          write(lu19,*,IOSTAT=ist2) line(:rlan(line))

                     if ( ist2 .ne. 0 ) then
                        message ='Error writing data for: '//v2
                        call write_mess(message,line,nl,filein)
                        err =  .true.
                     endif

                  enddo
               endif

               type = 0
            else   !Write line to temp file
               write(lu19,10,IOSTAT=ist2) line(:rlan(line))
               if ( ist2 .ne. 0 ) then
                  message='Error writing data for: '//line(:rlan(line))
                  call write_mess(message,line,nl,filein)
                  err =  .true.
               endif
            endif !If start

         else !Write comments/blank lines to temp file
            write(lu19,10,IOSTAT=ist2) line(:rlan(line))
            if ( ist2 .ne. 0 ) then
               message='Error writing data for: '//line(:rlan(line))
               call write_mess(message,line,nl,filein)
               err =  .true.
            endif
         endif !If comment

      enddo  !Master read loop

      close(lu18)
      close(lu19)

      if ( .not. err ) then
         k = lrbl(filein)

		 call rename_file(filein(:k),filein(:k)//'.old',err)
!		 if ( err ) then
!		    write(*,*) 'Unable to move file: '//filein(:k)
!			write(*,*) 'To destination file: '//filein(:k)//'.old'
!			write(*,*) 'To recover changes manually remove the file: '//filein(:k)
!			write(*,*) 'and rename this file to that name: '//tfile(:lrbl(tfile))
!		 else
			call rename_file(tfile(:lrbl(tfile)),filein(:k),err)
			if  ( err ) then
			   write(*,*) 'Unable to move file: '//tfile(:lrbl(tfile))
			   write(*,*) 'To destination file: '//filein(:k)
			   write(*,*) 'To recover changes manually move the file: '//tfile(:lrbl(tfile))
			   write(*,*) 'to one called: '//filein(:k)
			else
			   write(*,*) 'The following file has been updated: '//filein(:k)
		    endif
!		 endif
      endif



 10   format(A)
 20   format(6(G11.5,1x))
 30   format(G11.5,1X,G11.5)


      return
      end



! *************************************************************************

      subroutine mod_ictime(irow)

! *************************************************************************
!     This subroutine takes an ACD data file and re-creates the IC DATA
!     section at the top based on a specified time in the time based data.

!     The IC DATA can either be totally deleted and replaced or only defined
!     parameters can be updated.

! *************************************************************************

      implicit none

      integer*4     irow            !Number of rows on the screen

! * Locals

      character*256 message         !Message variable
      character*132 file            !Temp file name 
      character*132 filein          !Full path name of input file
      character*64  icvar(200)      !Variables to search for
      character*64  outvar(200)     !array of variables to output
      character*64  getvar(42)      !Array of variables to get from ACD file
      character*64  var(200)        !array of variables found
      character*40  testname(1000)  !testnames
      character*40  name            !temp testname
      character*40  ans             !temp answer variable

      real*4        min(200)        !Minimum of variable
      real*4        max(200)        !Maximum of variable
      real*4        time            !Time for new data

      integer*4     idx(40)         !index to correlate to fatdnum
      integer*4     dim(40)         !Number of data points per variable
      integer*4     xdx(40)         !Location of xpointer for the atdvar
      integer*4     ydx(40)         !Location of ypointer for the atdvar
      integer*4     psnap           !Location of fsnap




      real*4        icindata(200)  !Data from ic file
      real*4        icoutdata(200) !New data to output to ACD file
      real*4        outarr(100000) !Data storage array
      real*4        sng(2,40)      !Y Shift and gains (1,#)=shift (2,#)=gain
      real*4        xsng(2,40)     !X Shift and gains (1,#)=shift (2,#)=gain

      logical*4     isman          !Manual test flag
      logical*4     err            !error flag 

      integer*4     testnum(1000)   !test numbers
      integer*4     i,j,k,l         !Counters
      integer*4     ist             !IO status
      integer*4     cmd             !Command input               
      integer*4     itype           !Type of input either a number or name
      integer*4     ndx(200)        !Index array
      integer*4     nic             !Number of IC's
      integer*4     nget            !Number of vars to get from the data sec
      integer*4     nout            !Number of variables to output
      integer*4     numt            !number of tests
      integer*4     num             !Test Number of found test
      integer*4     nvar            !number of variables in vars
      integer*4     ptr            !Number of data points filled in outarr

      logical*4     cont            !Master while loop continue
      logical*4     cont2           !Secondary while loop continue
      logical*4     delete          !Delete variables not in data section
      logical*4     found           !Variable found flag
      logical*4     isacd(200)      !Variable exists in data section
      logical*4     replace         !Totally replace data in header


! * Externals
      integer*4     rlan            !Returns index of last non-blank
      integer*4     lran            !Returns index of first non-blank
      integer*4     lrbl            !Returns index of first blank from left

      real*4        findval         !Returns y data for a given X

! * Allow for global character strings ( fpath )
      include "flt_plot.inc"

      call read_index(numt,testname,testnum)


      do i=1,40
         sng(1,i)  = 0.0
         sng(2,i)  = 1.0
         xsng(1,i) = 0.0
         xsng(2,i) = 1.0
         idx(i)    = i
      enddo


! * Master do loop
      cont = .true.

      do while ( cont )
         ftestname = ' '
         cont2 = .true.
         write(*,*)' '
         write(*,*)' '
         write(*,*)' '
         write(*,*)' '
         write(*,*)'     Update ICs in ACD File'
         write(*,*)' '
         write(*,*)' Enter test name or number to work with:'
         read(*,10,IOSTAT=ist) name
         if ( name .eq. ' ' .or. ist .ne. 0 ) then
            return  
         else   
            call findname(name,num,itype,testname,testnum,numt)
            if ( itype .gt. 2 ) then ! test not found
               write(*,*) 'Test Not Found. '
               cont2 = .false.
            else
               ftestname = name(:lrbl(name))    !test found
            endif           
         endif


         filein  = ' '

         replace = .false.
         delete  = .false.

         do while ( cont2 )

            write(*,*)' '
            write(*,*)'     Options'
            write(*,*)' '
            if ( replace ) then
               write(*,*)' 1:  IC Data (Replace/Update)'// & 
                               '             : Replace All'
            else
               write(*,*)' 1:  IC Data (Replace/Update)'// & 
                               '             : Update Values'
            endif

            if ( delete ) then
               write(*,*)' 2:  IC variables not found '// & 
                               '(Delete/Keep) : Delete'
            else
               write(*,*)' 2:  IC variables not found '// & 
                               '(Delete/Keep) : Keep'
            endif

            write(*,*)' '
            write(*,*) 'Enter choice (RTN to Cont)-> '
            read (*,20,IOSTAT=ist) cmd

            if ( ist .ne. 0 .or. cmd .gt. 2 .or. cmd .lt. 1) then
               cont2 = .false.
               cmd   = 99
            endif

            if ( cmd .eq. 1 ) then
               replace = .not. replace
            elseif ( cmd .eq. 2 .and. .not. replace ) then
               delete = .not. delete
            endif
         enddo


         write(*,*)' Enter time for IC point: '
         read(*,*,IOSTAT=ist) time
         if ( ist .ne. 0 ) time = -1.0

         do i=1,200
            isacd(i) = .false.
         enddo

         file = ftestname(:lrbl(ftestname))//'.acd'
         call pathfile(filein,fpath,file(:lrbl(file)))

!        Read existing IC Data from acd file
         write(*,*)' Reading existing IC Data'
         call flt_read_ic_all(filein,nic,icvar,icindata,err)

!        Read list of variables from data portion of ACD file
         write(*,*)' Reading list of variables in ACD file'
         call flt_var_data(filein,var,nvar,min,max,err)

         i = 1
         do while ( i .le. nvar ) 
            if ( var(i)(:8) .eq. 'ftsttime' ) then
               do j=i,nvar-1
                  var(j) = var(j+1)
               enddo
               nvar = nvar - 1
            endif
            i = i + 1
         enddo

         write(*,*)' Compiling list of variables to output.'
         if ( delete .and. replace ) then  !Don't keep any information use all
            do i=1,nvar                    !vars from data section
               outvar(i) = var(i)
               isacd(i)  = .true.
            enddo
            nout = nvar
         elseif ( .not. delete .and. .not. replace ) then !only use existing 
            do i=1,nic                                    !ic vars
               outvar(i)     = icvar(i)
               icoutdata(i)  = icindata(i)

               j = 1 
               found = .false.
               do while ( j .le. nvar .and. .not. found ) 
                  if ( icvar(i)(:lrbl(icvar(i)))  .eq. & 
                         var(j)(:lrbl(var(j))) ) then
                     isacd(i) = .true.
                     found = .true.
                  endif
                  j = j + 1
               enddo
            enddo
            nout = nic
         elseif ( delete ) then !Start with existing ICs and delete one's not found
            nout = 0
            do i=1,nic
               j = 1 
               found = .false.
               do while ( j .le. nvar .and. .not. found ) 
                  if ( icvar(i)(:lrbl(icvar(i)))  .eq. & 
                         var(j)(:lrbl(var(j))) ) then
                     nout = nout + 1
                     outvar(nout) = icvar(i)
                     isacd(nout)  = .true.
                     found = .true.
                  endif
                  j = j + 1
               enddo
            enddo
         else  ! replace and not delete
            do i=1,nvar                    !vars from data section
               outvar(i) = var(i)
               isacd(i)  = .true.
            enddo
            nout = nvar
            do i=1,nic
               j = 1 
               found = .false.
               do while ( j .le. nvar .and. .not. found ) 
                  if ( icvar(i)(:lrbl(icvar(i)))  .eq. & 
                         var(j)(:lrbl(var(j))) ) then
                     found = .true.
                  endif
                  j = j + 1
               enddo

               if ( .not. found ) then
                  nout = nout + 1
                  outvar(nout) = icvar(i)
                  icoutdata(nout) = icindata(i)
               endif
            enddo

         endif


!     Get actual array data from ACD file
         write(*,*)' Getting new values from acd file'
         i = 1
         nget = 0
         do while ( i .le. nout )
            if ( isacd(i) ) then
               nget = nget + 1
               getvar(nget) = outvar(i)
               ndx(nget)    = i
            endif

!           Store data in output data array
            if ( nget .ge. 40 ) then
               ptr = 1
               call flt_read_data(filein,getvar,nget,idx,xsng,sng,dim, & 
                               xdx,ydx,ptr,outarr,psnap,isman,err)
               do j=1,nget
                  icoutdata(ndx(j)) = findval(time,dim(j), & 
                       xdx(j),ydx(j),outvar(ndx(j)),outarr)
               enddo
               nget = 0
            endif
            i = i + 1
         enddo

!        Store data in output data array
         if ( nget .ne. 0 ) then
            ptr = 1
            call flt_read_data(filein,getvar,nget,idx,xsng,sng,dim, & 
                 xdx,ydx,ptr,outarr,psnap,isman,err)
            do j=1,nget
               icoutdata(ndx(j)) = findval(time,dim(j), & 
                    xdx(j),ydx(j),outvar(ndx(j)),outarr)
            enddo
         endif


!        Write IC Data to ACD file
         write(*,*) ' Writing data to ACD file'
         call write_ics_all(filein,outvar,icoutdata,nout,time,err)
         if ( .not. err ) then
            write(*,*)' New IC Data successfully written to file:'
            write(*,*) filein(:lrbl(filein))
         endif

      enddo
      return

 10   format (A)
 20   format (i2)

      end



      real function findval(time,dim,xdx,ydx,var,arr)

      implicit none

      real         time           !Time to find in outarr
      real         arr(100000)    !Data storage array

      character*64 var

      integer      dim            !Number of data points in for this var
      integer      xdx            !Index to first X value in outarr
      integer      ydx            !Index to first y value in outarr

!     Locals

      logical      fnd            !Found

      integer      i              !Loop counter
      integer      id             !Index

      real         d1             !Delta time one
      real         d2             !Delta time two


      fnd = .false.
      i   = 0

      do while ( .not. fnd .and. i .lt. dim )
         if ( arr(xdx+i) .le. time .and. arr(xdx+i+1) .ge. time ) then
            d1 = abs(arr(xdx+i)-time)
            d2 = abs(arr(xdx+i+1)-time)
            if ( d1 .lt. d2 ) then
               id = i
            else
               id = i + 1
            endif
            fnd = .true.
         endif
         i = i + 1
      enddo

      if ( .not. fnd ) then
         write(*,*)' Unable to properly locate ',time
         write(*,*)' In the independent array for ',var
         write(*,*)' Using the first point instead'
         id = 0
      endif

      findval = arr(ydx + id)

      return
      end

