! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *
! 
!            F L I G H T S A F E T Y   I N T E R N A T I O N A L

!    SIMULATOR       : Boeing 717-200
!    JOB             : 8700          
!    DEPARTMENT      : 61 - Flight Dynamics 
!    MODULE NAME     : FLT_PLT
!    DESCRIPTION     : Auto Test plot program.
!    PACKAGE         : autotest
!    RATE            : offline
!    ORIGINATOR      : Flight Data Library
!    DATE            : 1/18/95
!    ENGINEER        : Mike Saladin
!                    : Valere Demeter
!    SYSTEM          : Unix

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!    Copyright 1995 FlightSafety International

!    The information contained herein is the property of
!    FLIGHTSAFETY INTERNATIONAL Simulation Systems Division
!    and shall not be copied, in part or in whole, or disclosed
!    to others in any manner without the express written
!    authorization of the FLIGHTSAFETY INTERNATIONAL Simulation
!    Systems Division.

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

!           F L I G H T S A F E T Y   I N T E R N A T I O N A L
!               Simulation Systems Division
!               2700 North Hemlock Circle
!               Broken Arrow, Oklahoma 74012
!               (918) 251-0500  Fax: (918) 251-5597

! ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** *

! ****************************************************************************
      program flt
      implicit none

!--> REVISION BEGIN

!                            Revision History

! 

!--> REVISION END

      CHARACTER*80  RCSID & 
      /"$Id: flt_main.f,v 2.5 2000/03/16 15:15:58 leongw Exp leongw $"/

      include "flt_plot.inc"

! * Locals

      real*4        sng(100,4)    !Shifts and gains
                                  !1=xsh 2=ysh 3=xgn 4=ygn

      integer*4     numvar                 !Number of variables
      integer*4     cmd                    !input command
      integer*4     cmd2                   !input command
      integer*4     cmd3                   !input command
      integer*4     selection              !selection variable in include file
      integer*4     ist                    !status flag

      character*1   ans                    !input answer
      character*132 answ                   !input answer
      character*80  command
      character*80  dpath                  !data path
      character*80  path                   !original path
      character*64  var(100)               !Variables in file

      logical*4    fexist                 !file exists
      logical*4    cnt                    !continue loop flag
      logical*4    err                    !continue loop flag
      logical*4    ftgplot                !test guide plot flag

! * Externals
      integer*4     rlan                  !returns index of last nonblank
      integer*4     lrbl
      character*80  getcwd                !function to find cwd


!     Load process id and user name into flt_plot.fi common labels
      call get_process()

!########  Hard code path variable for now
!	fpath = 'G:\autotest\data\rac'
	fpath='\\Jpats-server\jpats3\autotest\data'


      cmd = 1
      cnt = .true.
      do while ( cmd .gt. 0 .and. cmd .lt. 6 .and. cnt ) 

         write (*,*) '     FLT PROGRAM: MAIN MENU           '
         write (*,*) ' '
         write (*,*) '     Working path:',path(:rlan(path))
         write (*,*) '     Data path:   ',fpath(:rlan(fpath))
         write (*,*) ' '
         write (*,*) ' 1.  Autotest Test Setup:       modtest  '
         write (*,*) ' 2.  Autotest DATA Files:       modfile  '
         write (*,*) ' 3.  Autotest Test Guide Plot:  tgplot   '
         write (*,*) ' 4.  Autotest Test Guide Print: tgprint  '
         write (*,*) ' 5.  More Programs                       '
         write (*,*) ' 6.  Exit                                '
         write (*,*) ' '
         read (*,'(i2)',IOSTAT=ist) cmd

         if ( ist .ne. 0 ) then
            cnt = .false.
            cmd = 99
         endif

         if     ( cmd .eq. 1 ) then
            call flt_modtest
         elseif ( cmd .eq. 2 ) then
            call flt_modfile
         elseif ( cmd .eq. 3 ) then
            call tgplot
         elseif ( cmd .eq. 4 ) then
            call tgprint
         elseif ( cmd .eq. 5 ) then
            cmd2 = 1
            do while ( cmd2 .gt. 0 .and. cmd2 .lt. 14 ) 
               write (*,*) ' '
               write (*,*) ' '
               write (*,*) '     FLT PROGRAM: MORE MENU           '
               write (*,*) ' '
               write (*,*) '     Working path:',path(:rlan(path))
               write (*,*) '     Data path:   ',fpath(:rlan(fpath))
               write (*,*) ' '
               write (*,*) ' 1.  Autotest Data Converters            '
               write (*,*) ' 2.  Flight Test Data Converter: reduction'
               write (*,*) ' 3.  Aero Data Converter:        '// & 
                                 'boeing_con_aero'
               write (*,*) ' 4.  Performance Calculation:    utility '
               write (*,*) ' 5.  Data Plotter:               lookplot'
               write (*,*) ' 6.  ACD Data Cross Plotter:     dataxplot'
               write (*,*) ' 7.  Calculator:                 calc    '
               write (*,*) ' 8.  Interpolator:               interp  '
               write (*,*) ' 9.  Ground Model Calc:          ground  '
               write (*,*) '10.  QTG & Subs. Data Covers     cover   '
			   write(*,*)  '11.  Make Electronic QTG         EQTG'
               write (*,*) '12.  DPD Aero Data Converter:    '// & 
                                 'dpd_con_aero'
               write (*,*) '13.  Make test definition file   '// & 
                                 'con_testdef'
               write (*,*) '14.  While Waiting:              masterm '
               write (*,*) '15.  Exit                                '
               write (*,*) ' '
               read (*,'(i2)',IOSTAT=ist) cmd2
               if ( ist .ne. 0 ) then
                  cmd2 = 99
               endif

               if     ( cmd2 .eq. 2) then
                  call flt_reduction
               elseif ( cmd2 .eq. 3) then
!                  call flt_boeing_con_aero(path,fpath)
               elseif ( cmd2 .eq. 4) then
!                  call utility
               elseif ( cmd2 .eq. 5) then
!                  call flt_lookplot(path,fpath)
               elseif ( cmd2 .eq. 6) then
!                  call flt_dataxplot          
               elseif ( cmd2 .eq. 7) then
!                  call calc
               elseif ( cmd2 .eq. 8) then
!                  call interp
               elseif ( cmd2 .eq. 9 ) then
!                  call flt_ground
               elseif ( cmd2 .eq. 10) then
	               call flt_cover()
              elseif ( cmd2 .eq. 11 ) then
	               call flt_eqtg()
              elseif ( cmd2 .eq. 12) then
!                  call flt_dpd_con_aero(path,fpath)
               elseif ( cmd2 .eq. 13) then
!                  call flt_con_testdef()
               elseif ( cmd2 .eq. 14) then
!                  call mastermind
               elseif ( cmd2 .eq. 1 ) then
                  cmd3 = 1
                  do while ( cmd3 .gt. 0 .and. cmd3 .lt. 9 ) 
                     write (*,*) ' '
                     write (*,*) ' '
                     write (*,*) '     FLT PROGRAM: AUTOTEST CONV      '
                     write (*,*) ' '
                     write (*,*) '     Working path:',path(:rlan(path))
                     write (*,*) '     Data path:   ',fpath(:rlan(fpath))
                     write (*,*) ' '
                     write (*,*) ' 1.  ftdrvr CCC --> unix             '
                     write (*,*) ' 2.  ftplot CCC --> unix             '
                     write (*,*) ' 3.  ftinit CCC --> unix             '
                     write (*,*) ' 4.  Old acd    --> new acd          '
                     write (*,*) ' 5.  Old atd    --> new atd          '
                     write (*,*) ' 6.  Sim        --> Acd              '
                     write (*,*) ' 7.  Old sim    --> New sim (acd type)'
                     write (*,*) ' 8.  Old DATA   --> New DATA         '
                     write (*,*) ' 9.  Exit                            '
                     write (*,*) ' '

                     read (*,'(i2)',IOSTAT=ist) cmd3
                     if ( ist .ne. 0 ) then
                        cmd3 = 99
                     endif

                     if ( cmd3 .eq. 1 ) then
                        call filechk('ftdrvr',ans)
!                        if (ans.eq.'Y') call conv_ftdrvr
                     elseif ( cmd3 .eq. 2) then
                        call filechk('ftplot',ans)
                        if (ans.eq.'Y') then
!                           call conv_ftplot !conv ccc to unix:old format
!                           call flt_ftplot_conv !conv old to new format
                        endif
                     elseif ( cmd3 .eq. 3) then
!                        call filechk('ftinit',ans)
                        if (ans.eq.'Y') then
!                           call conv_ftinit !conv ccc to unix:old format
!                           call flt_ftinit_conv !conv old to new format
                        endif
                     elseif ( cmd3 .eq. 4) then
                        write(*,*)'Not supported yet'
!                        call conv_acd
                     elseif ( cmd3 .eq. 5) then
!                        call conv_atd
                     elseif ( cmd3 .eq. 6) then
                        write(*,*)'NEW formats are the same'
!                        call sim_to_acd(dpath)
                     elseif ( cmd3 .eq. 7) then
                        write(*,*)'NEW formats are the same'
!                        call sim_to_sim(dpath)
                     elseif ( cmd3 .eq. 8 ) then
                        write(*,*) 'Enter full name of file to convert'
                        read(*,'(a)',IOSTAT=ist) ftestname
                        if ( ist .eq. 0 .and. & 
                             ftestname(1:1) .ne. ' ') then
!                           call flt_con_data(answ(1:6),var,sng, & 
!                                                numvar,err,1)
                        endif
                     endif      !cmd3 if statement
                  enddo         !Data converter section cmd3
               endif            !cmd2 If statement
            enddo               !cmd2 loop
         endif                  !cmd if statement
      enddo                     !master cmd loop

      stop
      end



! file check subroutine

      subroutine filechk(infile,ans)
      implicit none

      character*14 dfile
      character*8  infile
      character*1  ans
      logical*4    lexist

      ans = 'Y'
      dfile(1:6)=infile(1:6)
      dfile(7:10)='.ccc'
      inquire(file=dfile(1:10),exist=lexist)
      if (.not.lexist) then
         write (*,*) ' '
         write (*,*) ' ',dfile(1:10),' does not exist.  This file is'
         write (*,*) ' required as the input file to start the'
         write (*,*) ' conversion.'
         write (*,*) ' '
         write (*,*) ' Hit any key to return to previous menu.'
         write (*,*) ' '
         read (*,'(a)') ans
         ans = 'N'
         return
      endif

      dfile(7:10)='.dat'
      inquire(file=dfile(1:10),exist=lexist)
      if (lexist) then
         write (*,*) ' '
         write (*,*) ' ',dfile(1:10),' exists --- this program will'
         write (*,*) ' delete this file and create a new one.'
         write (*,*) ' '
         write (*,*) ' Do you want to continue (y/n)?'
         read (*,'(a)') ans
         call upper(ans,1)
      endif

      return
      end


