! *****************************************************************************
! 
! This include file loads the global ic and plot arrays to be used in the 
! output routine to make hardcopies of the data.  It is used by both the
! fat_readtest.f in the autotest program  and in flt_tgplot.f in the flt 
! program.  Using the include file allows for upgrades to this section to be
! made in one place.

! *****************************************************************************
! * Read icmap.dat file to map ic input variables to IC output variables
      call read_icmap(ic_set,ic_out,numic,err)
      if ( err ) then
         message='Icmap.dat file does not exist.'
         call ftn_logmsg_err("fat_readtest",message)
      endif           


! * Extract airport and run way variables
      i = 1
      do while ( i .le. nic ) 
         if ( index(icvar(i),'naptdmd') .gt. 0 .or. & 
              index(icvar(i),'nrwydmd') .gt. 0  ) then

            if (index(icvar(i),'naptdmd') .gt. 0 ) then
               call upper(icval(i), 4)
               cair = icval(i)(:4)
               fairdmd = airport
            else
               call upper(icval(i), 4)
               crun = icval(i)(:4)
               frundmd = runway
            endif   
            do j=i,nic-1
               icvar(j) = icvar(j+1)
               icval(j) = icval(j+1)
               icout(j) = icout(j+1)
            enddo
            nic = nic - 1
         else 
            i = i + 1
         endif
      enddo


!>    Get sms address for ic variables set in 113 task 2

      ficinnum = 0
      ficotnum = 0
      do i=1,nic
         if ( (icout(i) .eq. 0 .or. icout(i) .eq. 1) .and. & 
                index(icval(i),'null' ) .eq. 0 ) then !Input 
            ficinnum = ficinnum + 1
            ficinop(ficinnum)  = icout(i)
            ficinvar(ficinnum) = icvar(i)(:lrbl(icvar(i)))
            call gettypeval(icvar(i),icval(i),ficinval(ficinnum), & 
                           fictype(ficinnum),terr)

            if ( terr .or. fictype(ficinnum) .le. 0 ) then ! Error reading this line
               err = .true.
               if ( terr ) then
                  message='Unable to read IC value for '//icvar(i)// & 
                       'from file: '//testfile(:lrbl(testfile))
                  call ftn_logmsg_err("fat_readtest",message)
               else
                  message='Unable to determine IC variable type for '// & 
                       icvar(i)(:lrbl(icvar(i)))
                  if (fcpmess) call ftn_logmsg_err("fat_readtest",message)
               endif
            endif

         endif

         if ( icout(i) .eq. 1 .or. icout(i) .eq. 2 ) then  !output
            ficotnum = ficotnum + 1

! *        Map input ic's to out variables defined in icmap.dat
            k = 1
            ch = .false.
            do while ( k .le. numic .and. .not. ch )
               if ( icvar(i)(:lrbl(icvar(i))) .eq. & 
                   ic_set(k)(:lrbl(ic_set(k)))) then
                  ch = .true.
                  ficoutvar(ficotnum) = ic_out(k)
               endif
               k = k + 1
            enddo
            if ( .not.  ch ) then !IC in var not mapped to a different out var
               ficoutvar(ficotnum) = icvar(i) !add variable to output list
            endif

!           Get the variable type

            call gettype(ficoutvar(ficotnum),ficoutype(ficotnum),terr)

            if ( terr ) then ! Error reading this line
               err = .true.
               message='Unable to determine IC variable type for '// & 
                       icvar(i)(:lrbl(icvar(i)))
               if (fcpmess) call ftn_logmsg_err("fat_readtest",message)
            endif

         endif
      enddo



      fyvarnum = ny
      fxvarnum = nplot
      frecnumb = fyvarnum + fxvarnum + 1  !Total # variables = #y + #x + time
      frecrate = recrate                  !defaults to 200 ie. every frame

      tminx = 100.
      frecvar(1)  = 'ftsttime'

      snapsim = .false. 


! * Set up snap shot flags
      if ( index(type,'snap') .gt. 0 ) then  !all plot types are snap shot
         fsnaplot = .true.
         do i=1,fyvarnum
            fsnappom(i) = .true.
            fsnapacd(i) = .true.
         enddo
      else
         fsnaplot = .false.
         do i=1,fyvarnum
            fsnappom(i) = .false. 
            fsnapacd(i) = .false.

            if ( index(snap(i),'pom') .gt. 0 )  fsnappom(i) = .true.
            if ( index(snap(i),'acd') .gt. 0 )  fsnapacd(i) = .true.
         enddo
      endif

      do i=1,fxvarnum
         frecvar(i+1)   = xvar(i)
         fxname(i)    = xvar(i)  ! Save name to lookup from other data
         fxscale(1,i) = xmin(i)
         fxscale(2,i) = xmax(i)  
         if ( frecvar(i+1)(:lrbl(frecvar(i+1))) .eq. 'ftsttime' ) then
           if ( xmin(i) .lt. tminx ) tminx = xmin(i)
        endif
      enddo

      frecstart = tminx
      if ( frecstart .ge. 100. ) frecstart = 0.0

      do i=1,fyvarnum 
         frecvar(i+fxvarnum+1)  = yvar(i)
         fyname(i)              = yvar(i)
         fymaptox(i)            = ynplot(i)    !For each y which x
         fyscale(1,i)           = ymin(i)
         fyscale(2,i)           = ymax(i)
         fnumgrid(i)            = ngrid(i)
         ftola(i)               = tol_a(i)
         ftolp(i)               = tol_p(i)
         fhilite(i)             = hilite(i)
         fylimit(i)             = ylimit(i)
         if ( index(snap(i),'acd') .gt. 0 ) fsnapacd(i) = .true.
         if ( index(snap(i),'pom') .gt. 0 ) fsnappom(i) = .true.
      enddo 

! * Special plot analysis variables
      fnytar = nyt
      do i=1,nyt      !Y targets
         fytarval(i) = ytarval(i)
         fytarvar(i) = ytarvar(i)
         fytarm(i)   = ytarm(i)
      enddo
      fnxtar = nxt
      do i=1,nxt      !X targets
         fxtarval(i) = xtarval(i)
         fxtarvar(i) = xtarvar(i)
         fxtarm(i)   = xtarm(i)
      enddo

      fdampst = damp_st
      fbetast = beta_st
      fphist  = phi_st 
      fdampvar = dampvar
      fbetavar = betavar
      fphivar  = phivar

	fcfdvar   = cfdvar
	fcfdst    = cfd_st

      fpowervar = powervar 
      fplavar   = plavar



!>    Check for repeated variables for recording and only record one
      do i=1,frecnumb-1
         do is=i+1,frecnumb
            if ( frecvar(i)(:lrbl(frecvar(i))) .eq.  & 
                 frecvar(is)(:lrbl(frecvar(is))) ) then ! variable is repeated
!>             remove duplicate and re-pack array
               do ie=is,frecnumb-1
                  frecvar(ie) = frecvar(ie+1) 
               enddo
               frecnumb = frecnumb - 1  !reduce # of variables by one removed
            endif
         enddo
      enddo


!>##  Put ACD and POM shift and gain data into global storage

!       facdnum = ncnt(1)

      do j=1,frecnumb
         fxsng(1,1,j) = 0.0
         fxsng(1,2,j) = 1.0
         fysng(1,1,j) = 0.0
         fysng(1,2,j) = 1.0
         fxsng(2,1,j) = 0.0
         fxsng(2,2,j) = 1.0
         fysng(2,1,j) = 0.0
         fysng(2,2,j) = 1.0

         do i=1,ncnt(1)   ! Search acd shifts and gains for plots
            if ( var(1,i)(:lrbl(var(1,i))) .eq. & 
                 frecvar(j)(:lrbl(frecvar(j))) ) then
               fxsng(1,1,j) = xsh(1,i)
               fxsng(1,2,j) = xgn(1,i)
               fysng(1,1,j) = ysh(1,i)
               fysng(1,2,j) = ygn(1,i)
            endif
         enddo
         do i=1,ncnt(3)  ! Search pom shifts and gains for plots
            if ( var(3,i)(:lrbl(var(3,i))) .eq. & 
                 frecvar(j)(:lrbl(frecvar(j))) ) then
               fxsng(2,1,j) = xsh(3,i)
               fxsng(2,2,j) = xgn(3,i)
               fysng(2,1,j) = ysh(3,i)
               fysng(2,2,j) = ygn(3,i)
            endif
         enddo
      enddo

!###########################################################

! * Get output labels for plot variables
      call get_labels(frecvar,frecnumb,ndimrec,freclab, & 
                      icorder,60,1,fcpmess,err)


! * Get output labels and output order for IC variables
      call get_labels(ficoutvar,ficotnum,ndimic,ficlab, & 
                      ficord,ndimic,2,fcpmess,err)


!#######################################################################

! * Check for fsnapv flag
      do i =1,ncond
         do is=1,ntask5(i)
            if ( t5var(i,is)(:lrbl(t5var(i,is))) .eq. 'fsnapv' ) then
               snapsim = .true.
            endif
         enddo
      enddo


! * Add fsnap variable to recording list if fsnapv set in task 5
      if ( snapsim ) then
         frecnumb = frecnumb + 1
         frecvar(frecnumb) = 'fsnap'
      endif

      do i=1,frecnumb  
         call gettype(frecvar(i),frectype(i),terr)
         if ( terr ) then
            err = .true.
            message='Unable to determine record variable type for '// & 
                       xvar(i)(:lrbl(xvar(i)))
            if ( fcpmess ) call ftn_logmsg_err("fat_readtest",message)
         endif     
      enddo





