!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y   I N T E R N A T I O N A L        *
!                                                                   *
!      Simulator         :   
!      Job number        :  
!      Department        :  61 - Flight                             *
!      Module name       :  flt_eqtg                                *
!      Module description:  Create Electronic QTG 
!      Rate              :  n/a                                     *
!      Issue             :  n/a                                     *
!      Originator        :  Mike Saladin                            *
!      Date              :  3/31/00                             *
!      Engineer          :                                          *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!     The information contained herein is the property of           *
!     FlightSafety International Simulation Systems Division        *
!     and shall not be copied, in part or in whole, or disclosed    *
!     to others in any manner without the express written           *
!     authorization of the FlightSafety International Simulation    *
!     Systems Division.                                             *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!                                                                   *
!        F L I G H T S A F E T Y  I N T E R N A T I O N A L         *
!            Simulation Systems Division                            *
!            2700  North Hemlock Circle                             *
!            Broken Arrow, Oklahoma  74012                          *
!            (918) 251-0500    Fax: (918) 251-5597                  *
!                                                                   *
!  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **  **
!--> REVISION BEGIN

!                            Revision History

! ***************************************************************************
      subroutine flt_eqtg ()
      implicit none


! * Locals
	character*132	dir(10)				!Directories
	character*132	dpath				!Path to master EQTG directory
	character*132	epath				!Path to master EQTG directory
	character*132	pdfdir				!Path to distiller output directory
	character*132	psdir				!Path to distiller input directory
	character*132	temp1 
	character*132	tfiles(10)			!Text files for master html
	character*132	hyplink(100)		!Hyper link names
	character*40	ctnum				!test number in characters
	character*80	infile
	character*132	outfile
	character*40	name				!temp test name
	character*40	testname(1000)		!testnames
	character*3		opt(2)				!Option string

	integer*4		ftpage(500,5)		!Page data 1=sec 2=test 3=# text 
										!          4=No pages 5=start
	integer*4		icnt				!Number of data points in ftpage
	integer*4		cmd					!Command
	integer*4		sect
	integer*4		dnum				!NUmber of directories
	integer*4		et					!test number end
	integer*4		fattest				!Fattest number
	integer*4		fininrt             !Error flag for flt_read.inc
	integer*4		ierr				!iostat error
	integer*4		ist					!IOSTAT flag
	integer*4		i,j,k				!counter
	integer*4		nline				!line pointer
	integer*4		lu60  /60/			!text file lu
	integer*4		lu61  /61/			!front.txt file
	integer*4		nhl					!Number of hyperlinks
	integer*4		num					!Found test number
	integer*4		numt				!number of tests
	integer*4		tnum				!Temp test number
	integer*4		testnum(1000)		!test numbers
	integer*4		itype				!Type of input
	
    logical*4       batch               !batch flag
	logical*4       create(2)           !Create options flags
	logical*4		display				!display plot/txt
	logical*4		do_all				!Create whole EQTG vs just HTML files
	logical*4       ferr                !Error flag
	logical*4		force(500)          !Force array - not use here in call to read_ftpages
	logical*4		hardcopy			!display plot/txt
	logical*4		isindex				!Is file to create an index file
	logical*4       isok                !Directory created OK
	logical*4       last                !Last file flag for batch
	logical*4		isplot(500)			!Test has plot defined flag
	logical*4		prompt /.false./	!Prompt flag for call to ftpages

! * Include files

	include "flt_plot.inc"
	include "flt_read_vars.inc"

	call read_index(numt,testname,testnum)

	call get_directories(dir,dnum)
	write(*,*) ' Select directory to produce EQTG in'
	write(*,*) '    If desired directory does not exist create one in the '
	write(*,*) '    EQTG directory in '//fpath(:lrbl(fpath))
	write(*,*) ' '
	do i=1,dnum
		write(*,20) i,dir(i)(:lrbl(dir(i)))
	enddo
	write(*,20) dnum+1,'Input New Directory'
	write(*,20) dnum+2,'Continue'

	read (*,'(i2)',IOSTAT=ist) cmd
	if ( ist .ne. 0 .or. cmd .gt. dnum+1 .or. cmd .lt. 1) then
		return
	endif


!   This is the directory for the master html file
	if ( cmd .eq. dnum+1 ) then
		write(*,*) 'Input new directory name: '
		read(*,*,IOSTAT=ist) temp1
		if( ist .ne. 0 .or. temp1 .eq. ' ' ) then
			write(*,*) 'Error reading directory name '
			return
		endif
		temp1 = temp1(lran(temp1):rlan(temp1))
	else
		temp1 = dir(cmd)
	endif
	call pathfile(epath,fpath,'eqtg\'//temp1(:lrbl(temp1)))
	call is_dir(epath,fexist)

	if ( .not. fexist ) then
		call make_dir(epath,isok)
		if ( isok) then
			write(*,*) 'Unable to create directory to store EQTG data'
			write(*,*)  epath(:lrbl(epath))
			write(*,*) ' '
			write(*,*) 'Exiting - nothing done'
			return
		endif
	endif

	call pathfile(dpath,epath,'data')

!   This is the directory to store everything but the master html file
	call is_dir(dpath,fexist)

	if ( .not. fexist ) then
		call make_dir(dpath,isok)
		if ( isok ) then
			write(*,*) 'Unable to create directory to store EQTG data'
			write(*,*)  dpath(:lrbl(dpath))
			write(*,*) ' '
			write(*,*) 'Exiting - nothing done'
			return
		endif
	endif


	write(*,*) 'Do you want to create whole EQTG (Y,n)'
	write(*,*) 'Selecting "NO" will just recreate HTML files'
	read(*,10,IOSTAT=ist) temp1

	call lower(temp1,10)
	if ( index(temp1,'n') .gt. 0  .and. ist .eq. 0 ) then
		do_all = .false.
	else
		do_all = .true.
	endif


!   Read all of the test numbers for the test guide  test number = ftpages(i,2)

	call read_ftpages(ftpage,icnt,force,ferr)


!	Determine if plot page exists for this test
	do i=2,icnt
		tnum = ftpage(i,2)
		call itoc(tnum,ftestname)
		call findname(ftestname,tnum,itype, & 
							testname,testnum,numt)
		if ( itype .gt. 2 ) then ! test not found
			write(*,*) 'Test Not Found in test_index.dat ',tnum
			return
		endif           
	!   Read .tdf file to see if a plot page should exist	
		include "flt_read.inc"
				
		if ( ny .lt. 1 ) then
			isplot(i) = .false.
		else
			isplot(i) = .true.
		endif
	enddo



	if ( do_all ) then
	!   Verify Postscript in and pdf out directories exist

		call pathfile(pdfdir,fpath,'distiller\out')
		call pathfile(psdir,fpath,'distiller\in')

		inquire (FILE=psdir,EXIST=fexist)
		if ( .not. fexist ) then
			write(*,*) 'Directory: '//psdir(:lrbl(psdir))
			write(*,*) 'Does not exist.'
			write(*,*) 'This means the ADOBE distiller is not set up'
			write(*,*) 'Create the directory '//fpath(:lrbl(fpath))//'\distiller'
			write(*,*) 'You need to configure the ADOBE Distiller to watch '
			write(*,*) 'this directory'
			write(*,*) 'Exiting - nothing done'
			return
		endif

		inquire (FILE=pdfdir,EXIST=fexist)
		if ( .not. fexist ) then
			write(*,*) 'Directory: '//pdfdir(:lrbl(pdfdir))
			write(*,*) 'Does not exist.'
			write(*,*) 'This means the ADOBE distiller is not set up'
			write(*,*) 'Create the directory '//fpath(:lrbl(fpath))//'\distiller'
			write(*,*) 'You need to configure the ADOBE Distiller to watch '
			write(*,*) 'this directory'
			write(*,*) 'Exiting - nothing done'
			return
		endif


		opt(1) = 'No '
		opt(2) = 'No '
		create(1) = .false.
		create(2) = .false.

		do while ( cmd .ge. 1 .and. cmd .le. 2 )
			write(*,*) ' '
			write(*,*) '     Options for EQTG creation '
			write(*,*) ' '
			write(*,*) ' 1.  Re-Create Text Pages:  '//opt(1)
			write(*,*) ' 2.  Re-Create Plot Pages:  '//opt(2)
			write(*,*) ' 3.  Exit'
			read (*,'(i2)',IOSTAT=ist) cmd
			if ( ist .ne. 0 ) then
				cmd = 0
			endif	

			if ( cmd .eq. 1 .or. cmd .eq. 2 ) then
				create(cmd) = .not. create(cmd)
				if (  create(cmd) ) then
					opt(cmd) = 'Yes'
				else
					opt(cmd) = 'No'
				endif
			endif

		enddo

	!   Recreate files
		if ( create(1) .or. create(2) ) then
			do i=1,icnt                   
				tnum = ftpage(i,2)      
				call itoc(tnum,ftestname)
				call findname(ftestname,tnum,itype, & 
							testname,testnum,numt)
				if ( itype .gt. 2 ) then ! test not found
				   write(*,*) 'Test Not Found in test_index.dat ',tnum
				   return
				endif           
				batch = .false.
				last  = .true.
				display = .false.
				hardcopy = .false.
				if ( create(1) ) then
					call flt_print (ftestname,tnum,batch,last,display,hardcopy)
				endif

				if ( create(2) ) then
					display = .false.
					hardcopy = .false.
					write(*,*) 'Creating plot for test ',tnum
					call flt_plottest(tnum,display,hardcopy,.false., & 
						.true.,.false.,.true.,.false.,1,.false.)
				endif
			enddo
		endif


	!   Copy all of the txt_####.ps and plot_####.ps files to the distiller/in directory

		write(*,*)'Copying text and plot postscript files to the distiller directory.'
		write(*,*)'This may take a couple of minutes.'

		do i=1,icnt                   
			tnum = ftpage(i,2)      

			call itoc(tnum,ctnum) 
			et = lrbl(ctnum)

			call pathfile(infile,fpath,'txt_'//ctnum(:et)//'.ps')
			call pathfile(outfile,psdir,'txt_'//ctnum(:et)//'.ps')

			inquire(FILE=infile,EXIST=fexist)
			if ( .not. fexist ) then
				write(*,*) 'ERROR - File does not exist'
				write(*,*) infile
				write(*,*) 'Please create and retry'
				return
			endif

			call copy_file(infile,outfile,err)
			if ( err ) then
				write(*,*) 'ERROR - Unable to copy file: '//infile(:lrbl(infile))
				write(*,*) 'To file: '//outfile(:lrbl(outfile))
				write(*,*) 'Unable to continue'
				return
			endif

			call itoc(tnum,ftestname)
			call findname(ftestname,tnum,itype, & 
							testname,testnum,numt)
			if ( itype .gt. 2 ) then ! test not found
				write(*,*) 'Test Not Found in test_index.dat ',tnum
				return
			endif     
			      
			if ( isplot(i) ) then
				call pathfile(infile,fpath,'plot_'//ctnum(:et)//'.ps')
				call pathfile(outfile,psdir,'plot_'//ctnum(:et)//'.ps')

				inquire(FILE=infile,EXIST=fexist)
				if ( .not. fexist ) then
					write(*,*) 'ERROR - File does not exist'
					write(*,*) infile
					write(*,*) 'Please create and retry'
					return
				endif
				call copy_file(infile,outfile,err)
				if ( err ) then
					write(*,*) 'ERROR - Unable to copy file: '//infile(:lrbl(infile))
					write(*,*) 'To file: '//outfile(:lrbl(outfile))
					write(*,*) 'Unable to continue'
					return
				endif
			endif
		enddo
	
	endif  !if do_all


	write(*,*) 'Creating Master Frame HTML file'
	call pathfile(temp1,epath,'qtg.htm')
	call html_frame(temp1,err)

	if (err) return


	write(*,*) 'Creating text HTML file'
	tfiles(1)  = 'front.txt'
	tfiles(2)  = 'back.txt'
	do i=3,10
		tfiles(i) = ' '
	enddo

	tnum = 2

	cmd = 1

	do while ( cmd .ne. 0 ) 
		write(*,*)' '
		write(*,*)' '
		write(*,*)'    Files to include in Master File'
		write(*,*)' '
		do i=1,tnum
			write(*,20) i,tfiles(i)(:lrbl(tfiles(i)))
		enddo	
		write(*,*)' '
	
		write(*,*)'(R)eplace  (D)elete  (I)nsert  (A)dd  '
		read(*,10,IOSTAT=ist) name
		call lower(name,4)

		num = 0
		if ( ist .ne. 0 .or. name .eq. ' ' ) then
			cmd = 0  !exit
		elseif ( index(name,'a') .ne. 0 .and. ist .eq. 0 ) then
			num = tnum + 1
			tnum = tnum + 1
		elseif ( index(name,'i') .ne. 0 .and. ist .eq. 0 ) then
			write(*,*) 'Enter number to insert before '
			read(*,'(i1)',IOSTAT=ist) dnum
			if ( ist .eq. 0 .and. dnum .gt. 0 .and. dnum .le. tnum) then
				num = dnum
				do i=tnum,num,-1
					tfiles(i+1) = tfiles(i)
				enddo
				tnum = tnum + 1
			endif
		elseif ( index(name,'d') .ne. 0 .and. ist .eq. 0 ) then
			write(*,*) 'Enter number of file to delete '
			read(*,'(i1)',IOSTAT=ist) dnum
			if ( ist .eq. 0 .and. dnum .gt. 0 .and. dnum .le. tnum) then
				do i=dnum,tnum-1
					tfiles(i) = tfiles(i+1)
				enddo
				tnum = tnum - 1
			else
				write(*,*)'Invalid input - Try Again'
			endif
		elseif ( index(name,'r') .ne. 0 .and. ist .eq. 0 ) then
			write(*,*) 'Enter number of file to replace '
			read(*,'(i1)',IOSTAT=ist) dnum
			if ( ist .eq. 0 .and. dnum .gt. 0 .and. dnum .le. tnum) then
				tfiles(dnum) = ' '
				num = dnum
			else
				write(*,*)'Invalid input - Try Again'
			endif
		endif

		if ( num .ne. 0 ) then

			write(*,*)' Input text file name (DATA Directory assumed):'
			read(*,10,IOSTAT=ist) temp1

			if ( ist .ne. 0 ) then
				write(*,*) 'Error inputing new file name'
			else
				tfiles(num) = temp1(:lrbl(temp1))
			endif

			do i = 1,tnum
				call pathfile(temp1,fpath,tfiles(i))
				inquire(FILE=temp1,EXIST=fexist)
				if ( tfiles(i) .eq. ' ' .or. .not. fexist) then 
					if ( .not. fexist ) then
						write(*,*) 'File does not exist :'//tfiles(i)(:lrbl(tfiles(i)))
						write(*,*) 'Removing from the list'
					endif
					do j=1,tnum-1
						tfiles(i) = tfiles(i+1)
					enddo
					tnum = tnum - 1
				endif
			enddo
		endif
	enddo


!	Open text HTML file and write Header information

	call pathfile(temp1,dpath,'qtg_text.htm')
	inquire(FILE=temp1,EXIST=fexist)
	if ( fexist ) then
		call del_file(temp1)
	endif

	open(UNIT=lu60,FILE=temp1,IOSTAT=ist)
	if( ist .ne. 0 ) then
		write(*,*) 'Error opening file: '//temp1(:lrbl(temp1))
		write(*,*) 'Exiting'
		return
	endif

	isindex = .false.
	call html_head(lu60,isindex)
	nhl = 0  !Reset number of hyperlinks to 0

	do i=1,tnum
		call pathfile(temp1,fpath,tfiles(i))
		call write_html(lu60,temp1,hyplink,nhl,ftpage,icnt,isplot,err)
		if ( err ) then
			close(lu60)
			write(*,*)'Error writing qtg_text.htm file'
			write(*,*)'The file being read was: ',temp1(:lrbl(temp1))
			return
		endif
	enddo	

! 	write(lu60,10) '</pre>'
	write(lu60,10) '</body>'
	write(lu60,10) '</html>'

	close(lu60)

!   Write the Index HTML file

	call pathfile(temp1,dpath,'qtg_index.htm')
	inquire(FILE=temp1,EXIST=fexist)
	if ( fexist ) then
		call del_file(temp1)
	endif

	open(UNIT=lu60,FILE=temp1,IOSTAT=ist)
	if( ist .ne. 0 ) then
		write(*,*) 'Error opening file: '//temp1(:lrbl(temp1))
		write(*,*) 'Exiting'
		return
	endif

	isindex = .true.	
	call html_head(lu60,isindex)
	call html_index(lu60,hyplink,nhl,ftpage,icnt,testname,&
					testnum,numt,isplot,err)

	if ( err ) then
		write(*,*)'Error creating file',temp1(:lrbl(temp1))
		return
	endif
	
	if ( do_all ) then
		write(*,*)'Getting ready to copy plot and text PDF files to file data directory'
		write(*,*)' '
		write(*,*)'IMPORTANT ------------'
		write(*,*)'Please start the ADOBE distiller and verify it is watching'
		write(*,*) fpath(:lrbl(fpath))//'\distiller'
		write(*,*)' '
		write(*,*)'Once set up it should start converting files '
		write(*,*)'Please wait until it finishes and Hit Return when done '
		read(*,10) temp1

		write(*,*)'Moving all PDF files to the data directory.'

		do i=1,icnt                   
			tnum = ftpage(i,2)      

			call itoc(tnum,ctnum) 
			et = lrbl(ctnum)

			call pathfile(infile,pdfdir,'txt_'//ctnum(:et)//'.pdf')
			call pathfile(outfile,dpath,'txt_'//ctnum(:et)//'.pdf')

			inquire(FILE=infile,EXIST=fexist)
			if ( .not. fexist ) then
				write(*,*) 'ERROR - File does not exist'
				write(*,*) infile(:lrbl(infile))
				return
			endif

			call rename_file(infile,outfile,err)
			if ( err ) then
				write(*,*) 'ERROR - Unable to move file: '//infile(:lrbl(infile))
				write(*,*) 'To file: '//outfile(:lrbl(outfile))
				write(*,*) 'Unable to continue'
				return
			endif


			if ( isplot(i) ) then
				call pathfile(infile,pdfdir,'plot_'//ctnum(:et)//'.pdf')
				call pathfile(outfile,dpath,'plot_'//ctnum(:et)//'.pdf')

	!		inquire(FILE=infile,EXIST=fexist)
	!		if ( .not. fexist ) then
	!			write(*,*) 'ERROR - File does not exist'
	!			write(*,*) infile
	!			return
	!		endif
				call rename_file(infile,outfile,err)
				if ( err ) then
					write(*,*) 'ERROR - Unable to move file: '//infile(:lrbl(infile))
					write(*,*) 'To file: '//outfile(:lrbl(outfile))
					write(*,*) 'Unable to continue'
					return
				endif
			endif
		enddo
	
	endif

		
	return		
10	format(A)
20	format(T5,I1,'.  ',A)
	end


	subroutine write_html(luid,infile,hyplink,hl,ftpage,icnt,isplot,error)

	implicit none

	integer*4      hl              !Number of hyper links
	integer*4      luid            !Open output file logical unit
	integer*4      ftpage(500,5)   !Page data 1=sec 2=test 3=# text 
                                   !          4=No pages 5=start
	integer*4      icnt            !Number of data points in ftpage

	character*132  infile          !Input file name
	character*132  hyplink(100)    !Hyper link title

	logical*4      isplot(500)		!Test has a plot
	logical*4      error           !Error writing file


!	locals

	integer*4      ierr         !IOSTAT code
	integer*4      lu62 /62/    !Input file logical unit
	integer*4      i,j,ia,i1,i2,i3,i4,i5,i6,i7,i8,i9,i0 !counters
	integer*4      tnum         !Test number

	character*528  ctext        !Buffer to read data from file
	character*528  temp1        !Buffer to read data from file
	character*40   chl          !Temp char string of hyper link number
	character*40   name         !File name of pdf file
	character      pm  /z'b1'/  !plus minus symbol

	logical*4      fnd          !Found test number in ftpages.dat

!	Externals
	integer*4     lrbl          !returns index of first blank 
	integer*4     rlan          !returns index of last  blank 
	integer*4     lran          !returns index of first nonblank 


	include "flt_plot.inc"

	error = .false.

	open(UNIT=lu62,FILE=infile,IOSTAT=ierr)

	if ( ierr .ne. 0 ) then
		write(*,*)' ERROR - opening file ',infile(:lrbl(infile))
		error = .true.
		return
	endif




	read(lu62,10,IOSTAT=ierr) ctext  !read line from text file
	temp1 = ctext
	call lower(temp1,132)

	do while ( ierr .eq. 0 )

!        replace ~ with current test number

         i = index(ctext,'~') !search for ~ replace with testnum
         if ( i .gt. 0 ) ctext = ctext(:i-1)//' '//ctext(i+1:)
         i  = 1
         i1 = 1
         i2 = 1
         i3 = 0 
         i4 = 0
         do while ( i .gt. 0 )  !multiple times 
            i = index(ctext,'+/-') !search for +/- and replace with single char
            if (i .gt. 0) ctext = ctext(:i-1)//pm//ctext(i+3:)
         enddo

!         do while ( i1 .gt. 0 ) 
!            i1 = index(ctext(i3+1:),'(') !search for ( and add a back slash ps
!            if (i1 .gt. 0) then
!               ctext = ctext(:i1+i3-1)//'\'//ctext(i1+i3:)
!               i3 = i1 + i3  + 1
!            endif
!         enddo

!         do while ( i2 .gt. 0 )
!            i2 = index(ctext(i4+1:),')') !search for ) and add a back slash ps
!            if (i2 .gt. 0) then
!               ctext = ctext(:i2+i4-1)//'\'//ctext(i2+i4:)
!               i4 = i2 + i4 + 1
!            endif
!         enddo

         i1 = index(ctext,'TEST:')
         i2 = index(ctext,':')
         i3 = index(ctext,'Page:')
         i4 = index(ctext,'.pg')
         i5 = index(ctext,'@')     !12 pt Bold, Centered and underlined
         i6 = index(ctext,'^')     !10 pt Centered
         i7 = index(ctext,'?')     !12 pt Bold and Centered
         i8 = index(ctext,'`')     !10 pt Bold 
         i9 = index(ctext,'<')     !<> left and right justify
         i0 = index(ctext,'>')     ! "  
		 ia = index(temp1,'>hl<')  !Hyperlink

         if ( i9 .ne. 0 .and. i9 + 1 .ne. i0  .and. ia .eq. 0 ) then
            if ( i2 + 1 .ne. i9 ) i9 = 0   !not <> or :< so reset i9 to zero
            i0 = 0   !not <> so reset i0 to zero
         endif

!         if (i1 .gt. 0 .and. .not. tgtext) then 
!            if ( slot .eq. 0 ) then !create a title
!               ctext = ctext(i1+5:)
!               title = ctext
!               write(lu65,10) & 
!               '/TITLE ('//ctext(:rlan(ctext))//') def do_title do_sim'
! 12            format(A,I2,A)
!            endif
!            nline = nline - 1
!        elseif (i5 .gt. 0) then
		if ( i5 .gt. 0 ) then
			ctext(i5:i5)=' '    ! replace the @
			write(luid,20) 'title_u',ctext(lran(ctext):rlan(ctext))
		elseif (i6 .gt. 0) then
            ctext(i6:i6)=' '    ! replace the ^
			write(luid,20) 'center',ctext(lran(ctext):rlan(ctext))
		elseif (i7 .gt. 0) then
			ctext(i7:i7)=' '    ! replace the ?
			write(luid,20) 'title',ctext(lran(ctext):rlan(ctext))
		elseif (i8 .gt. 0) then
			ctext(i8:i8)=' '    ! replace the `
			write(luid,20) 'bold',ctext(lran(ctext):rlan(ctext))
		elseif ( ia .ne. 0 ) then
			ctext= ctext(:ia-1)//ctext(ia+4:)
			hl = hl + 1
			hyplink(hl) = ctext
			call itoc(hl,chl) 
			i = lrbl(chl)
			write(luid,10) '<A NAME="'//chl(:i)//'"></A>'

		elseif (i9 .gt. 0 .and. i0 .gt. 0) then !left and right justified
			ctext(i9:i0)='  '    ! replace the <>
			write(luid,30) 'c10',ctext(:rlan(ctext))
		elseif (i3 .gt. 0 ) then  ! page number no longer used
			 i = 0
		elseif (i2 .gt. 0) then   ! bolded title  : not used for text files
			if ( i9 .gt. 0) then
				if ( i9 .gt. 0 ) ctext(i9:i9) = ' ' !remove <
			endif
			call pad_spaces(ctext)
			write(luid,30) 'c10',ctext(:rlan(ctext))
		elseif(i4 .gt. 0 ) then !New page handle below but don't print .pg
			 i = 0 
		else
!			if ( ctext .eq. ' ' ) ctext = '&nbsp;'
!         See if test number in first column
			read(ctext,*,IOSTAT=ierr) tnum
			call pad_spaces(ctext)
			fnd = .false.
			if ( ierr .eq. 0 ) then
				i = 1
				do while ( i .le. icnt .and. .not. fnd ) 
					if ( ftpage(i,2) .eq. tnum .and. isplot(i) ) then !Test Number found in ftpages
						fnd = .true.
						call itoc(tnum,chl)
						name = 'plot_'//chl(:lrbl(chl))//'.pdf'
						write(luid,40) name(:lrbl(name)),ctext(:rlan(ctext))
					endif
					i = i + 1
				enddo
			endif

			if ( .not. fnd ) then
				write(luid,30) 'c10',ctext(:rlan(ctext))
			endif
		endif
		read(lu62,10,IOSTAT=ierr) ctext  !read line from text file
		if ( ierr .eq. 0 ) then
			temp1 = ctext
			call lower(temp1,132)
			i = index(temp1,'end')
			j = index(temp1,'text')
			if ( i .gt. 0 .and. j .gt. 0 .and. j .gt. i ) ierr=1
		endif


	enddo

	close(lu62)


	return
10	format(A)
!20	format('<p class=',a,'><span >',a,'</span></p>')
!30	format('<p class=',a,'><span >&nbsp;',a,'</span></p>')
!40	format('<p class=c10><span ><a href="',a,'">',a,'</a></span></p>')
20	format('<p class=',a,'>',a,'</p>')
30	format('<p class=',a,'>',a,'</p>')
40	format('<p class=c10><a href="',a,'">',a,'</a></p>')
	end

 
	subroutine html_head(luid,isindex)

	implicit none

	integer*4   luid    !Logical id to write to

	logical*4   isindex !Is index file

	write(luid,10) '<html>'

	write(luid,10) '<head>'
	write(luid,10) '<meta http-equiv="Content-Language" content="en-us">'
	write(luid,10) '<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">'
	write(luid,10) '<title>QUALIFICATION TEST GUIDE</title>'
	write(luid,10) '<style>'
	write(luid,10) '<!--'
	write(luid,10) '.Heading1    { font-family: Arial; font-size: 12pt; font-weight: bold ; '
    write(luid,10) '             line-height: 100%; margin-top: 20; margin-bottom: 10 }'
	write(luid,10) '.Results     { font-family: Arial; font-size: 10pt; '
    write(luid,10) '             line-height: 100%; margin-top: 0; margin-bottom: 0 }'
	write(luid,10) '.Heading2    { font-family: Arial; font-size: 10pt; '
    write(luid,10) '             line-height: 100%; margin-top: 0; margin-bottom: 10 }'
	write(luid,10) '.title       { font-family: Courier; font-size: 12pt; font-weight: bold ; '
	write(luid,10) '             text-align: Center; '
    write(luid,10) '             margin-top: 0; margin-bottom: 0;line-height: 100% }'
	write(luid,10) '.bigbold     { font-family: Courier; font-size: 12pt; font-weight: bold ; '
    write(luid,10) '             margin-top: 0; margin-bottom: 0;line-height: 100% }'
	write(luid,10) '.title_u     { font-family: Courier; font-size: 12pt; font-weight: bold ; '
	write(luid,10) '             text-align: Center; text-decoration: underline; '
    write(luid,10) '             margin-top: 0; margin-bottom: 0;line-height: 100% }'
	write(luid,10) '.bold        { font-family: Courier; font-size: 10pt; font-weight: bold; margin-left: 20; '
    write(luid,10) '             margin-top: 0; margin-bottom: 0;line-height: 100% }'
	write(luid,10) '.c10         { font-family: Courier; font-size: 10pt; margin-left: 20; '
    write(luid,10) '             margin-top: 0; margin-bottom: 0;line-height: 100% }'
 	write(luid,10) '.center      { font-family: Courier; font-size: 10pt; font-weight: bold; '
	write(luid,10) '             text-align: Center; '
    write(luid,10) '             margin-top: 0; margin-bottom: 0;line-height: 100% }'
	write(luid,10) '-->'
	write(luid,10) '</style>'

	if ( isindex ) then
		write(luid,10) '<script language="JavaScript1.2">'
		write(luid,10) '<!--'
		write(luid,10) 'var head="display:''''"'

		write(luid,10) 'function change(){'
		write(luid,10) '   if(!document.all)'
		write(luid,10) '      return'
		write(luid,10) '   if (event.srcElement.id=="foldheader") {'
		write(luid,10) '      var srcIndex = event.srcElement.sourceIndex'
		write(luid,10) '      var nested = document.all[srcIndex+1]'
		write(luid,10) '      if (nested.style.display=="none") {'
		write(luid,10) '         nested.style.display='''''

		write(luid,10) '      }'
		write(luid,10) '      else {'
		write(luid,10) '         nested.style.display="none"'

		write(luid,10) '      }'
		write(luid,10) '   }'
		write(luid,10) ' }'

		write(luid,10) 'document.onclick=change'

		write(luid,10) '//-->'
		write(luid,10) '</script>'
	endif
	write(luid,10) '<base target="main">'
	write(luid,10) '</head>'
	write(luid,10) '<body>'
	
!	if ( .not. isindex ) write(luid,10) '<pre>'

	return
10	format(a)
	end


	subroutine html_frame(infile,error)

	implicit none

	character*(*)   infile    !Input file name

	logical*4       error     !Error flag

!	Locals

	integer*4       ist       !IOSTAT output flag
	integer*4       lu63 /63/ !Logical unit for writing

	logical*4       fexist    !File exists flag


	error = .false.
	inquire(FILE=infile,EXIST=fexist)

	if ( fexist ) then 
		call del_file(infile)
	endif

	open(UNIT=lu63,FILE=infile,IOSTAT=ist)
	if ( ist .ne. 0 ) then
		write(*,*)'Error trying to open file: ',infile
		error = .true.
		return
	endif


	write(lu63,10) '<html>'

	write(lu63,10) '<head>'
	write(lu63,10) '<title>QTG Frame</title>'
	write(lu63,10) '</head>'

	write(lu63,10) '<frameset cols="296,*">'
  	write(lu63,10) '<frame name="contents" target="main" src="data/qtg_index.htm" scrolling="auto" marginwidth="0" marginheight="16">'
  	write(lu63,10) '<frame name="main" src="data/qtg_text.htm" target="main">'
  	write(lu63,10) '<noframes>'
  	write(lu63,10) '<body>'

  	write(lu63,10) '<p>This page uses frames, but your browser does not support them.</p>'

  	write(lu63,10) '</body>'
  	write(lu63,10) '</noframes>'
	write(lu63,10) '</frameset>'

	write(lu63,10) '</html>'


	close(lu63)

	return
10	format(a)
	end




	subroutine html_index(luid,hyplink,hl,ftpage,icnt,testname,&
	                      testnum,numt,isplot,error)

	implicit none

	integer*4      hl              !Number of hyper links
	integer*4      luid            !Open output file logical unit
	integer*4      ftpage(500,5)   !Page data 1=sec 2=test 3=# text 
                                   !          4=No pages 5=start
	integer*4      icnt            !Number of data points in ftpage
	integer*4      numt            !Number of found tests
	integer*4      testnum(1000)   !test numbers


	character*132  hyplink(100)    !Hyper link title
	character*40   testname(1000)  !testnames

	logical*4      isplot(500)		!Test has plot information
	logical*4      error           !Error writing file


!	locals

	integer*4      hnum         !Number of hyper links written
	integer*4      ierr         !IOSTAT code
	integer*4      i,j,k        !counters
	integer*4      isect        !Current Section
	integer*4      tnum         !Test number

	character*132  ctext        !Buffer to read data from file
	character*132  temp1        !Buffer to read data from file
	character*40   chl          !Temp char string of hyper link number
	character*40   name         !File name of pdf file
	character*40   title        !Test title from TDF file
	character      pm  /z'b1'/  !plus minus symbol

	logical*4      fnd          !Found test number in ftpages.dat

!	Externals
	integer*4     lrbl          !returns index of first blank 
	integer*4     rlan          !returns index of last  blank 
	integer*4     lran          !returns index of first nonblank 


	i = 1
	fnd = .false.

!   Write Default Link to Text File
	write(luid,10) 'qtg_text.htm','QTG TEXT'
	
	do while ( i .le. hl .and. .not. fnd )
		temp1 = hyplink(i)
		call lower(temp1,132)
		j = index(temp1,'table')
		k = index(temp1,'content')
		if ( j .gt. 0 .and. k .gt. 0 ) fnd = .true.
		call itoc(i,chl)
		write(luid,10) 'qtg_text.htm#'//chl(:lrbl(chl)),hyplink(i)(:rlan(hyplink(i)))
		i = i + 1
	enddo

	hnum = i

	isect = -99
	do i=1,icnt
		if ( isect .ne. ftpage(i,1) ) then !Write Section Header
			isect = ftpage(i,1)
			call itoc(isect,chl)
			if ( isect .ne. 1 ) write(luid,62)

			write(luid,20) chl(:lrbl(chl))
			write(luid,21)
		endif
		call itoc(ftpage(i,2),chl)
		j = lrbl(chl)
		name = chl
		call findname(name,tnum,k,testname,testnum,numt)
		if ( k .gt. 2 ) then ! test not found
			write(*,*) 'Test Not Found In test_index.dat. ',name
        else
			call get_title(name,title)
			write(luid,60) ftpage(i,2),title(:rlan(title))
			write(luid,61)
			write(luid,30) chl(:j)   !text hyper link
			if ( isplot(i) ) write(luid,40) chl(:j)   !Plot Hyper link
			write(luid,50)           !Comment Hyper Link
			write(luid,62)
		endif
	enddo
	write(luid,62) !End of list

	if ( hnum .le. hl ) then
		i = hnum
		do while ( i .le. hl )
			call itoc(i,chl)
			write(luid,10) 'qtg_text.htm#'//chl(:lrbl(chl)),hyplink(i)(:rlan(hyplink(i)))
			i = i + 1
		enddo
	endif


	write(luid,*) '</body>'
	write(luid,*) '</html>'


	close(luid)


	return

10	format('<h1 class="Heading1"><a href="',a,'">',a,'</a></h1>')
20	format('<li id="foldheader" class="Heading1">Section ',a,'</li>')
21  format('<ul id="foldinglist" style="display:none" style=&{head};>')
30	format('  <li><a href="txt_',a,'.pdf">Text</a></li>')
40	format('  <li><a href="plot_',a,'.pdf">Plot</a></li>')
50	format('  <li><a href="comment.hml">Comment</a></li>')
60	format('  <li id="foldheader" class="Heading2">',i7,6x,a,'</li>')
61	format('  <ul id="foldinglist" class="Results"  style="display:none" style=&{head};>')
62  format('  </ul>')

	end


	subroutine pad_spaces(line)
	
	implicit none

	character*(*)	line			!Input line

!	Locals
	
	integer*4		i 				!Loop Counter            
	integer*4		ln				!Start of first non blank
	integer*4       ld              !Dimension of text string

	character*6     sp /'&nbsp;'/	!Space character

!	External
	integer*4		lran			!Returns first non blank from left


	ln = lran(line)
	ld = len(line)

	if ( ln .eq. 0 .or. ln-1 .eq. ld ) then     !Line is empty
		line = sp
	elseif( ln .gt. 1 ) then	!Line has leading spaces
		do i=ln-1,1,-1
			line = line(:i-1)//sp//line(i+1:) !Insert space character
		enddo
	endif

	return

	end

