      subroutine flt_cover()
      implicit none

!--> REVISION BEGIN

!                            Revision History

! $Id: flt_cover.f,v 1.4 1998/09/08 20:43:35 vdemeter Exp $
! $Log: flt_cover.f,v $
!

!--> REVISION END

	CHARACTER*80  RCSID & 
	/"$Id: flt_cover.f,v 1.4 1998/09/08 20:43:35 vdemeter Exp $"/

	integer*4    i,j,k                  !pointer/counter
	integer*4    ic                     !Length of title
	integer*4    ifin,ifout             !last char
	integer*4    ist                    !Status flag
	integer*4    lu50   /50/            !Unit for tg_cover.ps file
	integer*4    lu51   /51/            !Unit for output file
	integer*4    vol                    !current volume count
	integer*4    voltg                  !tg volume count
	integer*4    volsub                 !sub volume count
	integer*4    npr                    !Number of prints

	character*132 line                  !Line for reading .ps file
	character*80 dpath                  !data path
	character*80 filein                 !input file name
	character*80 fileout                !output file name
	character*24 ctitle                 !cover title
	character*13 volume                 !cover volume
	character*1  cj,cvol,cpr            !character strings

!*     Externals
      integer*4     lrbl                   !first space char
      integer*4     lran           !Index of first character from left 
      integer*4     rlan           !Index of last character on line  
      integer*4     ftn_getcfg     !Get something from sim.cfg

	include "flt_plot.inc"

      jobcode = ' '
!      i = ftn_getcfg('autotest_job_number',line)
      if ( i .eq. 0 ) then
         i = lran(line)
         jobcode = line(i:i+15)
      endif

	write (*,*) ' '
	write (*,*) ' '
	write (*,*) '  Qualification Test Guide &'
	write (*,*) ' Substantiation Cover Program'
	write (*,*) ' '

	voltg = 6
	do while ( voltg .gt. 5 .or. voltg .le. 0 ) 
		write (*,*) ' Enter the number of Test Guide volumes:'
		read (*,'(i4)',IOSTAT=ist) voltg
		if (voltg .le. 0 .or. ist .ne. 0 ) return
		if (voltg.gt.5) then
			write (*,*) ' MAXIMUM OF 5 VOLUMES.'
			write(*,*) ' Try Again - Enter Zero (0) to Exit'
		endif
	enddo

	volsub = 6
	do while ( volsub .gt. 5 )
		write (*,*) ' Enter the number of Substantiation volumes:'
		read (*,'(i4)',IOSTAT=ist) volsub
		if (volsub .le. 0) voltg = 1
		if (volsub .gt. 5) then
			write (*,*) ' MAXIMUM OF 5 VOLUMES.'
			write(*,*) ' Try Again'
		endif
	enddo


	npr = 1
	call pathfile(filein,fpath,'tg_cover.ps')
	ifin = lrbl(filein)

	write(*,*) 'filein:',filein

	open(UNIT=lu50,FILE=filein,IOSTAT=ist)
	if ( ist .ne. 0 ) then
	   write(*,*)' Unable to open file: '//filein(:ifin)
	   write(*,*)' Nothing printed'
	   return
	endif



	do i=1,2      !1=QTG, 2=Substantation
		if (i.eq.1) then
			ctitle='QUALIFICATION TEST GUIDE'
			vol = voltg
		else
			ctitle='SUBSTANTIATION DATA'
			vol = volsub
		endif
		ic = rlan(ctitle)

        do j=1,vol

			rewind(lu50)

			call itoc(npr,cpr)
			call pathfile(fileout,fpath,'print_cover_'//cpr//'.ps')
			ifout = lrbl(fileout)

			open(UNIT=lu51,FILE=fileout,IOSTAT=ist)
			if ( ist .ne. 0 ) then
				write(*,*)' Unable to open file: '//fileout(:ifout)
				write(*,*)' Nothing printed'
				return
			endif

			write (*,*) ' Printing '//ctitle(:ic)//' cover and spine.'
            write (*,*) ' Volume ',j,' of ',vol
			write (*,*) ' '

		    if (vol.eq.1) then
	          volume='             '
			else
				call itoc(j,cj)
				call itoc(vol,cvol)
		        volume='Volume '//cj//' of '//cvol
		    endif
			ist = 0
			do while ( ist .eq. 0 ) 
				read(lu50,10,IOSTAT=ist) line
				if ( ist .eq. 0 ) then
					k = index(line,'JOB_TITLE^')
					if ( k .gt. 0 ) then
						line = line(1:k-1)//ctitle(:ic)//line(k+10:)
					endif	
					k = index(line,'JOB_VOL^')
					if ( k .gt. 0 ) then
						line = line(1:k-1)//volume//line(k+8:)
					endif	


                 if ( jobcode .ne. ' ' ) then
                     k = index(line,'/JOBNO')
                     if ( k .gt. 0 ) then
                        line = '/JOBNO ('//jobcode(:lrbl(jobcode))//') def'
                     endif
                  endif
					write(lu51,10,IOSTAT=k) line

					if ( k .gt. 0 ) then
						write(*,*) 'Error writing to file: '//fileout(:ifout)
						write(*,*) 'Nothing printed'
						close(lu50)
						close(lu51)
						return
					endif
					ist = ist + k
				endif
			enddo
			close(lu51)


			call print_file(fileout)
			call del_file(fileout)
			npr = npr + 1
			

		enddo
	enddo
	
	close(lu50)

	write (*,*) ' '
	write (*,*) ' '
	write (*,*) '  Qualification Test Guide &'
	write (*,*) ' Substantation Cover Complete'
	write (*,*) ' '
	write (*,*) ' Copy covers onto 11x11 inch paper at 119%'
	write (*,*) ' enlargement.  Copy spines onto 11x11 inch'
	write (*,*) ' paper at 100%.'
	write (*,*) ' '
	write (*,*) ' '
	write (*,*) ' '
	
	

10  format(a)

	return
	end


