-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Force_Types;

package roll_drive is

   type Instance is private;

    procedure follow_roll
        (bank_cmd         :in     Angle_Types.degrees;
         bank             :in     Angle_Types.degrees;
         Q_Bar            :in     Force_Types.Pounds_per_Sq_Feet;
         K_Roll           :in     Float;
         Dt               :in     Float;
         An_Instance      :in out Instance);

    function Aileron
          (An_Instance :in Instance) return Angle_Types.Degrees;

    procedure zero_roll_drive(An_Instance   :in out Instance);

private
    type Instance is
        record
            The_Aileron     : Angle_Types.Degrees := 0.0;
            Error           : Float    := 0.0;
            Error_L         : float    := 0.0;
        end record;

end Roll_drive;


