-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
package body Roll_drive is
    procedure follow_roll
        (bank_cmd         :in     Angle_Types.degrees;
         bank             :in     Angle_Types.degrees;
         Q_Bar            :in     Force_Types.Pounds_per_Sq_Feet;
         K_Roll           :in     Float;
         Dt               :in     Float;
         An_Instance      :in out Instance) is
       Error_L2    : Float := 0.0;
       P_Err       : Float := 0.0;
       P_Errd      : Float := 0.0;
       Pdot_Errdot : Float := 0.0;
       Da_Dot      : Float := 0.0;
       D_Da        : Float := 0.0;
    begin
       Error_L2 := An_Instance.Error_L;
       An_Instance.Error_L := An_Instance.Error;
       An_Instance.Error := 0.0175 * (Bank_Cmd - Bank);
       P_Err := (An_Instance.Error - An_Instance.Error_L)/Dt + 1.43 * An_Instance.Error_L * K_Roll;
       P_Errd := (An_Instance.Error - 2.0 * An_Instance.Error_L + Error_L2)/(Dt * Dt);
       Pdot_Errdot := 9.0 * K_Roll * (9.0 * K_Roll * P_Err + 2.0 * P_Errd);
       Da_Dot := - Pdot_Errdot/(0.0034 * Float'Max(15.0,Q_Bar));
       Da_Dot := Float'Max(-200.0,Float'Min(200.0,Da_dot));
       D_Da := Da_Dot * Dt;
       if ( D_Da > 0.0 and An_Instance.The_Aileron >= 11.25) or
              (D_Da < 0.0 and An_Instance.The_Aileron <= -20.5) then
          D_Da := 0.0;
       else
          An_Instance.The_Aileron := An_Instance.The_Aileron + D_Da;
       end if;
    end follow_roll;

    function aileron(An_Instance :in Instance) return Angle_Types.Degrees is
    begin
        return An_Instance.The_Aileron;
    end aileron;


    procedure zero_roll_drive(An_Instance   :in out Instance) is
    begin
       An_Instance.The_aileron := 0.0;
       An_Instance.Error   := 0.0;
       An_Instance.Error_L := 0.0;
    end Zero_roll_Drive;

end Roll_drive;
