-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Length_Types;
with Force_Types;
with Mass_Types;

package pitch_drive is

   type Instance is private;

   procedure follow_pitch
        (pitch_cmnd                :in     Angle_Types.degrees;
         ac_pitch                  :in     Angle_Types.degrees;
         Ac_Roll                   :in     Angle_Types.Degrees;
         Q_bar                     :in     Force_Types.Pounds_per_Sq_Feet;
         Nz                        :in     Float;
         K_Pitch                   :in     Float;
         Dt                        :in     Float;
         An_Instance               :in out Instance);

   procedure Follow_Cas
        (Q_bar                     :in     Force_Types.Pounds_per_Sq_Feet;
         vkcas                     :in     Length_Types.knots;
         V_Cmnd                    :in     Length_Types.knots;
         K_Pitch                   :in     Float;
         ac_pitch                  :in     Angle_Types.degrees;
         Dt                        :in     Float;
         An_Instance               :in out Instance);
   procedure follow_groundspeed
        (V_Cmnd                    :in     Length_Types.knots;
         vkcas                     :in     Length_Types.knots;
         K_Pitch                   :in     Float;
         Dt                        :in     Float;
         An_Instance               :in out Instance);

    procedure Assign_Position (Elevator    :in     Angle_Types.Degrees;
                               An_Instance :in out Instance);

    function elevator(An_Instance :in Instance) return Angle_Types.Degrees;
    function fx_drive(An_Instance :in Instance) return Force_Types.lbf;
    procedure zero_pitch_drive(An_Instance   :in out Instance);
    procedure zero_fx_driver(An_Instance   :in out Instance);

private
    type Instance is
        record
           The_Elevator           : Angle_Types.Degrees := 0.0;
           V_Err                  : Float := 0.0;
           V_Err_l                : Float := 0.0;
           Error                  : Float := 0.0;
           Error_l                : Float := 0.0;
           the_cmd                : Float := 0.0;
           Gcmd                   : Float := 0.0;
           Fx_Driver              : Float := 0.0;
        end record;

end Pitch_drive;












