-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Pitch_Drive;
with Coordinate_Types;
with Lat_Long_Types;
with JPATS_Auto_Test_Types;

package JPATS_Auto_Test is

    function Yaw_Rate return float;
    function Roll_Rate return float;
    function Pitch_Rate return float;
    function Roll_Angle return float;
    function Pitch_Angle return float;
    function heading return float;
    function AoA return float;
    function beta return float;
    function Cas return float;
    function Altitude return float;
    function Cg return Coordinate_Types.Reference_System;
    function GW return float;
    function OAT return float;
    function Inertia return Coordinate_Types.Inertia_Axis;
    function Nw_Steering return Boolean;
    function Nwa return Float;
    function L_Brake_Press return Float;
    function r_Brake_Press return Float;

    function Stick_Lat_Pos return float;
    function Stick_Long_Pos return float;
    function Pedal_Pos return float;
    function Lat_stk_Force return float;
    function Long_Stk_Force return float;
    function Pedal_Force return float;

    function L_Ail_pos return float;
    function R_Ail_Pos return float;
    function Elev_pos return float;
    function Rud_pos return float;
    function Ail_trim return float;
    function Ele_Tab_pos return Float;
    function Ele_Tab_Mode return Integer;
    function Rud_Tab_pos return float;
    function Rud_Tab_Mode return Integer;
    function Flap_Pos return float;
    function Sb_Pos return float;
    function LG_Pos return boolean;
    function At_phase return integer;
    function Roll_Mode return Integer;
    function yaw_Mode return Integer;
    function pitch_Mode return Integer;
    function On return Boolean;
    function Gear return Float;
    function Test_Number return Integer;
    function sb_switch return boolean;
    function Qnh return Float;
    function field_Temp return Float;
    function ship_Number return Integer;
    function field_alt return Float;
    function fx_driver return Float;
    function wind_vel return Float;
    function wind_dir return Float;
    function Latitude return Float;
    function Longitude return Float;
    function rcr return float;
    function Ground_Reset return Boolean;
    function Chocked return Boolean;
    function Emer_Gear return Boolean;
    function Num_Pil return Integer;
    function Fuel return Float;
    function Manual_Test return Boolean;
    function Seat_Position return Float;
    function Seat_frequency return Integer;
    function debug1 return Float;
    function debug2 return Float;
end JPATS_Auto_Test;












