-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with JPATS_Auto_test.Container;
with JPATS_Auto_test.IOS_Interface;

package body JPATS_Auto_test is

  function Yaw_Rate return Float is
  begin
    return Container.This_Subsystem.Yaw_Rate;
  end Yaw_Rate;

  function Roll_Rate return Float is
  begin
    return Container.This_Subsystem.Roll_Rate;
  end Roll_Rate;

  function Pitch_Rate return Float is
  begin
    return Container.This_Subsystem.Pitch_Rate;
  end Pitch_Rate;

  function Roll_Angle return Float is
  begin
    return Container.This_Subsystem.Roll_Angle;
  end Roll_Angle;

  function Pitch_Angle return Float is
  begin
    return Container.This_Subsystem.Pitch_Angle;
  end Pitch_Angle;

  function Heading return Float is
  begin
    return Container.This_Subsystem.Heading;
  end Heading;

  function AoA return Float is
  begin
    return Container.This_Subsystem.Aoa;
  end Aoa;

  function Beta return Float is
  begin
    return Container.This_Subsystem.Beta;
  end Beta;

  function Cas return Float is
  begin
    return Container.This_Subsystem.Cas;
  end Cas;

  function Altitude return Float is
  begin
    return Container.This_Subsystem.Altitude;
  end Altitude;

  function L_Brake_Press return Float is
  begin
    return Container.This_Subsystem.L_Brake_Press;
  end L_Brake_Press;

  function R_Brake_Press return Float is
  begin
    return Container.This_Subsystem.R_Brake_Press;
  end R_Brake_Press;

  function Cg return Coordinate_Types.Reference_System is
  begin
    return Container.This_Subsystem.Cg;
  end Cg;

  function GW return Float is
  begin
    return Container.This_Subsystem.Gw;
  end Gw;

  function OAT return Float is
  begin
    return Container.This_Subsystem.Oat;
  end Oat;

  function Inertia return Coordinate_Types.Inertia_Axis is
  begin
    return Container.This_Subsystem.Inertia;
  end Inertia;

  function Stick_Lat_Pos return Float is
  begin
    return Container.This_Subsystem.Stick_Lat_Pos;
  end Stick_Lat_Pos;

  function Stick_Long_Pos return Float is
  begin
    return Container.This_Subsystem.Stick_Long_Pos;
  end Stick_Long_Pos;

  function Pedal_Pos return Float is
  begin
    return Container.This_Subsystem.Pedal_Pos;
  end Pedal_Pos;

  function Lat_Stk_Force return Float is
  begin
    return Container.This_Subsystem.Lat_Force;
  end Lat_Stk_Force;

  function Long_Stk_Force return Float is
  begin
    return Container.This_Subsystem.Long_Force;
  end Long_Stk_Force;

  function Pedal_Force return Float is
  begin
    return Container.This_Subsystem.Pedal_Force;
  end Pedal_Force;

  function L_Ail_Pos return Float is
  begin
    return Container.This_Subsystem.Left_Ail;
  end L_Ail_Pos;

  function R_Ail_Pos return Float is
  begin
    return Container.This_Subsystem.Right_Ail;
  end R_Ail_Pos;

  function Elev_Pos return Float is
  begin
    return Container.This_Subsystem.Elev;
  end Elev_Pos;

  function Rud_Pos return Float is
  begin
    return Container.This_Subsystem.Rudder;
  end Rud_Pos;

  function Ail_Trim return Float is
  begin
    return Container.This_Subsystem.Aileron_Trim;
  end Ail_Trim;

  function Ele_Tab_Pos return Float is
  begin
    return Container.This_Subsystem.Ele_Tab_Pos;
  end Ele_Tab_Pos;

  function Ele_Tab_Mode return Integer is
  begin
    return Container.This_Subsystem.Ele_Tab_Mode;
  end Ele_Tab_Mode;

  function Rud_Tab_Pos return Float is
  begin
    return Container.This_Subsystem.Rud_Tab_Pos;
  end Rud_Tab_Pos;

  function Rud_Tab_Mode return Integer is
  begin
    return Container.This_Subsystem.Rud_Tab_Mode;
  end Rud_Tab_Mode;

  function Flap_Pos return Float is
  begin
    return Container.This_Subsystem.Flap_Pos;
  end Flap_Pos;

  function Sb_Pos return Float is
  begin
    return Container.This_Subsystem.Sb_Pos;
  end Sb_Pos;

  function LG_Pos return Boolean is
  begin
    return Container.This_Subsystem.Gear_Handle;
  end Lg_Pos;

  function Gear return Float is
  begin
    return Container.This_Subsystem.Lg_Pos;
  end Gear;

  function At_Phase return Integer is
  begin
    return JPATS_Auto_test.IOS_Interface.This_Ios_Interface.Test_Phase;
  end At_Phase;

  function Roll_Mode return Integer is
  begin
    return
      Container.This_Subsystem.Roll_Mode;
  end Roll_Mode;

  function Pitch_Mode return Integer is
  begin
    return
      Container.This_Subsystem.Pitch_Mode;
  end Pitch_Mode;

  function Yaw_Mode return Integer is
  begin
    return
      Container.This_Subsystem.Yaw_Mode;
  end Yaw_Mode;

  function On return Boolean is
  begin
    return
      JPATS_Auto_test.IOS_Interface.This_Ios_Interface.At_On;
  end On;

  function Test_Number return Integer is
  begin
    return
      Container.This_Subsystem.Test_Number;
  end Test_Number;

  function SB_Switch return Boolean is
  begin
    return Container.This_Subsystem.Speedbrake_Sw;
  end Sb_Switch;

  function Chocked return Boolean is
  begin
    return Container.This_Subsystem.Chocked;
  end Chocked;

  function Qnh return Float is
  begin
    return
      Container.This_Subsystem.Qnh;
  end Qnh;

  function Field_Temp return Float is
  begin
    return
      Container.This_Subsystem.Field_Temp;
  end Field_Temp;

  function Field_Alt return Float is
  begin
    return
      Container.This_Subsystem.Field_Alt;
  end Field_Alt;

  function Wind_Vel return Float is
  begin
    return
      Container.This_Subsystem.Wind_Vel;
  end Wind_Vel;

  function Wind_Dir return Float is
  begin
    return
      Container.This_Subsystem.Wind_Dir;
  end Wind_Dir;

  function Ship_Number return Integer is
  begin
    return
      Container.This_Subsystem.Ship_Num;
  end Ship_Number;

  function Fx_Driver return Float is
  begin
    return
      Pitch_Drive.Fx_Drive(Container.This_Subsystem.The_Pitch_Drive);
  end Fx_Driver;

  function Ground_Reset return Boolean is
  begin
    return
      Container.This_Subsystem.Ground_Reset;
  end Ground_Reset;

  function Nw_Steering return Boolean is
  begin
    return
      Container.This_Subsystem.Nw_Steering;
  end Nw_Steering;

  function Nwa return Float is
  begin
     return
       Container.This_Subsystem.Nwa;
  end Nwa;

  function Emer_Gear return Boolean is
  begin
    return
      Container.This_Subsystem.Emer_Gear;
  end Emer_Gear;

  function Latitude return Float is
  begin
    return
      Container.This_Subsystem.Latitude;
  end Latitude;

  function Longitude return Float is
  begin
    return
      Container.This_Subsystem.Longitude;
  end Longitude;

  function Rcr return Float is
  begin
    return
      Container.This_Subsystem.Rcr;
  end Rcr;

  function Fuel return Float is
  begin
    return
      Container.This_Subsystem.Fuel;
  end Fuel;

  function Num_Pil return Integer is
  begin
    return
      Container.This_Subsystem.Num_Pil;
  end Num_Pil;

  function Manual_Test return Boolean is
  begin
    return
      Container.This_Subsystem.Manual_Test;
  end Manual_Test;

  function Seat_Position return Float is
  begin
     return
       Container.This_Subsystem.Seat_Position;
  end Seat_Position;

  function Seat_frequency return Integer is
  begin
     return
      Container.This_Subsystem.Seat_Frequency;
  end Seat_Frequency;

  function Debug1 return Float is
  begin
    return
      Container.This_Subsystem.Debug1;
  end Debug1;

  function Debug2 return Float is
  begin
    return
      Container.This_Subsystem.Debug2;
  end Debug2;

end JPATS_Auto_test;
