-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Yogesh Tupe
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Subsystem_Scheduler;
with Ada.Streams;

package JPATS_Auto_Test.Scheduler is


   type Instance is
      new Subsystem_Scheduler.Instance
     with null record;


   type Handle is
      access all Instance'Class;

   -- Initialize defines non-real-time initializations run each time the
   -- simulation is started

   procedure Initialize
     (An_Instance : in out Instance);

   -- Update defines normal realtime behavior of the subsystem

   procedure Update
     (An_Instance : in out Instance;
       dt : in Float);

   -- Update_In_Freeze defines behavior of subsystem during Total Freeze

   procedure Update_In_Freeze
     (An_Instance : in out Instance);


   -------------------------------------------------------------------------------
   -- Routine to save a snapshot of the instance to the given stream.
   --
   -- Note that the predefined attributes 'Write and 'Output can be used on any
   -- object to store its value in the given stream.
   -------------------------------------------------------------------------------
   procedure Save
     ( An_Instance : in out Instance;
       To_Stream   : access Ada.Streams.Root_Stream_Type'Class);

   procedure Restore
     ( An_Instance : in out Instance;
       From_Stream : access Ada.Streams.Root_Stream_Type'Class);

   function Snapshot_Size (An_Instance : Instance) return Natural;


end JPATS_Auto_Test.Scheduler;
