-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--|
with JPATS_IOS_Interface;

package body JPATS_Auto_test.IOS_Interface is

  procedure At_On(PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.At_On := Jpats_Ios_Interface.Convert_To_Bool(PData);
  end At_On;

  procedure Trim_Bypass(PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Trim_Bypass  := Jpats_Ios_Interface.Convert_To_Bool(PData);
  end Trim_Bypass;

  procedure Manual_Test (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Manual_Test :=  Jpats_Ios_Interface.Convert_To_Bool(PData);
  end Manual_Test;

  procedure Test_Abort (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Test_Abort :=  Jpats_Ios_Interface.Convert_To_Bool(PData);
  end Test_Abort;

  procedure Batch (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Batch :=  Jpats_Ios_Interface.Convert_To_Integer(PData);
  end Batch;

  procedure Batchtime (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Batchtime :=  Jpats_Ios_Interface.Convert_To_Float(PData);
  end Batchtime;

  procedure Cancel (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Cancel :=  Jpats_Ios_Interface.Convert_To_Bool(PData);
  end Cancel;

  procedure Test_Id(PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Test_Id := Jpats_Ios_Interface.Convert_To_Integer(PData);
  end Test_Id;

  procedure Fatrun(PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Fatrun := Jpats_Ios_Interface.Convert_To_Integer(PData);
  end Fatrun;

  procedure Fatbfile(PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Fatbfile := Jpats_Ios_Interface.Convert_To_Integer(PData);
  end Fatbfile;

  procedure Register_IOS_Variables is
  begin
    JPATS_IOS_Interface.Register
      ( Name        => "fatstat",
        Variable   => This_Ios_Interface.Test_Phase'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "testactive",
        Variable   => This_Ios_Interface.At_On'Address,
        Set_Routine => At_On'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fatman",
        Variable   => This_Ios_Interface.Manual_Test'Address,
        Set_Routine => Manual_Test'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fatforce",
        Variable   => This_Ios_Interface.Trim_Bypass'Address,
        Set_Routine => Trim_Bypass'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fattime",
        Variable   => This_Ios_Interface.Test_Time'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fatcancel",
        Variable   => This_Ios_Interface.Test_Abort'Address,
        Set_Routine => Test_Abort'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fatbatch",
        Variable   => This_Ios_Interface.Batch'Address,
        Set_Routine => Batch'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "batchtime",
        Variable   => This_Ios_Interface.Batchtime'Address,
        Set_Routine => Batchtime'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fatbcancel",
        Variable   => This_Ios_Interface.Cancel'Address,
        Set_Routine => Cancel'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fattest",
        Variable   => This_Ios_Interface.Test_Id'Address,
        Set_Routine => Test_Id'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fatrun",
        Variable   => This_Ios_Interface.Fatrun'Address,
        Set_Routine => Fatrun'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "fatbfile",
        Variable   => This_Ios_Interface.Fatbfile'Address,
        Set_Routine => Fatbfile'Access
        );
  end Register_Ios_Variables;

end JPATS_Auto_test.IOS_Interface;


