-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
------------------------------------------------------------------------------
with Pitch_Drive;
with Roll_Drive;
with Yaw_Drive;


private package JPATS_Auto_test.Container is

    type Instance is
        record
           Gw                  : Float := 0.0;
           Cg                  : Coordinate_Types.Reference_System
                                                      := (0.0,0.0,0.0);
           Altitude            : Float := 0.0;
           Oat                 : Float := 518.0;
           Inertia             : Coordinate_Types.Inertia_Axis
                                        := (1000.0,1000.0,1000.0,100.0);
           Flap_Handle         : Integer := 0;
           Gear_Handle         : Boolean := False;
           Speedbrake_Sw       : Boolean := False;
           Tad_On              : Boolean := True;
           Pmu_On              : Boolean := True;
           Roc                 : Float := 0.0;
           Eng_Torque          : Float := 0.0;
           Nx                  : Float := 0.0;
           Ny                  : Float := 0.0;
           Nz                  : Float := 0.0;
           Roll_Rate           : Float := 0.0;
           Pitch_Rate          : Float := 0.0;
           Yaw_Rate            : Float := 0.0;
           Sb_Pos              : Float := 0.0;
           Flap_Pos            : Float := 0.0;
           LG_Pos              : Float := 0.0;
           Aoa                 : Float := 0.0;
           Beta                : Float := 0.0;
           Cas                 : Float := 0.0;
           Roll_Angle          : Float := 0.0;
           Pitch_Angle         : Float := 0.0;
           Heading             : Float := 0.0;
           Left_Ail            : Float := 0.0;
           Right_Ail           : Float := 0.0;
           Elev                : Float := 0.0;
           Rudder              : Float := 0.0;
           Stick_Lat_Pos       : Float := 0.0;
           Stick_Long_Pos      : Float := 0.0;
           Pedal_Pos           : Float := 0.0;
           Lat_Force           : Float := 0.0;
           Long_Force          : Float := 0.0;
           Pedal_Force         : Float := 0.0;
           Roll_Mode           : Integer := 0;
           Pitch_Mode          : Integer := 0;
           Yaw_Mode            : Integer := 0;
           Speed_Mode          : Integer := 0;
           Rud_Tab_Mode        : Integer := 0;
           Ele_Tab_Mode        : Integer := 0;
           Ele_Tab_Pos         : Float := 0.0;
           Rud_Tab_Pos         : Float := 0.0;
           Aileron_Trim        : Float := 0.0;
           Test_Phase          : Integer := 0;
           Test_Number         : Integer := 0;
           Pla                 : Float   := 0.0;
           Pla_Mode            : Integer := 0;
           Fn                  : Float := 0.0;
           Field_Temp          : Float := 59.0;
           Qnh                 : Float := 29.92;
           Ship_Num            : Integer := 5;
           Test_Type           : Integer := 0;
           Field_Alt           : Float := 0.0;
           Debug1              : Float := 0.0;
           Debug2              : Float := 0.0;
           The_Pitch_Drive     : Pitch_Drive.Instance;
           The_Roll_Drive      : Roll_Drive.Instance;
           The_Yaw_Drive       : Yaw_Drive.Instance;
           Ground_Reset        : Boolean := False;
           Chocked             : Boolean := False;
           Nw_Steering         : Boolean := False;
           Nwa                 : Float   := 0.0;
           L_Brake_Press       : Float   := 0.0;
           R_Brake_Press       : Float   := 0.0;
           Emer_Gear           : Boolean := False;
           Wind_Vel            : Float   := 0.0;
           Wind_Dir            : Float   := 0.0;
           Latitude            : Float   := 0.0;
           Longitude           : Float   := 0.0;
           Rcr                 : Float   := 23.0;
           Fuel                : Float   := 1000.0;
           Num_Pil             : Integer := 1;
           Manual_Test         : Boolean := False;
           Seat_Position       : Float   := 0.0;
           Seat_Frequency      : Integer := 1;
        end record;

        This_Subsystem : Instance;

end JPATS_Auto_test.Container;
