-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;

package Winds is

   type Instance is private;

    procedure Change_velocity
     (Delta_Velocity      :in out float;
      Final_Velocity      :in     Float;
      An_Instance         :in out Instance);

    procedure Change_altitude
     (Delta_Altitude      :in out float;
      Final_Altitude      :in     Float;
      An_Instance         :in out Instance);

    procedure Change_direction
     (Delta_Direction      :in out float;
      Final_Direction      :in     Float;
      An_Instance          :in out Instance);

    function Velocity (An_Instance : in Instance) return Length_Types.Knots;
    function altitude (An_Instance : in Instance) return Length_Types.feet;
    function direction (An_Instance : in Instance) return angle_Types.degrees;

    procedure store_Direction (Direction    :in      Angle_Types.degrees;
                               An_Instance  :in out Instance);

    procedure store_velocity (velocity      :in     length_Types.knots;
                              An_Instance   :in out Instance);

    procedure store_altitude (altitude      :in     length_Types.knots;
                              An_Instance   :in out Instance);

private
   type Instance is
      record
         The_Wind_Altitude        : Length_Types.Feet   := 0.0;
         The_Wind_Direction       : Angle_Types.degrees := 0.0;
         The_Wind_Velocity        : Length_Types.Knots  := 0.0;
      end record;

end Winds;





