-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;
with Ada.Numerics;

package body Winds is

    procedure Change_velocity
      (Delta_Velocity      :in out float;
       Final_Velocity      :in     Float;
       An_Instance         :in out Instance) is
    begin
      An_Instance.The_Wind_Velocity := An_Instance.The_Wind_Velocity + Delta_Velocity/450.0;
      if abs(An_Instance.The_Wind_Velocity - Final_Velocity) < abs(Delta_Velocity)/450.0 then
         Delta_Velocity := 0.0;
         An_Instance.The_Wind_Velocity := final_Velocity;
      end if;
    end Change_Velocity;

    procedure Change_altitude
     (Delta_Altitude      :in out float;
      Final_Altitude      :in     Float;
      An_Instance         :in out Instance) is
    begin
      An_Instance.The_Wind_Altitude := An_Instance.The_Wind_Altitude + Delta_Altitude/450.0;
      if abs(An_Instance.The_Wind_Altitude - Final_Altitude) < abs(Delta_Altitude)/450.0 then
         Delta_Altitude := 0.0;
         An_Instance.The_Wind_Altitude := Final_Altitude;
      end if;
    end Change_Altitude;

    procedure Change_direction
     (Delta_Direction      :in out float;
      Final_Direction      :in     Float;
      An_Instance          :in out Instance) is

       Corrected_Final_Direction : Float := Final_Direction;
    begin

       An_Instance.The_Wind_Direction := An_Instance.The_Wind_Direction + Delta_Direction/450.0;

       if Corrected_Final_Direction < 0.0 then
          Corrected_Final_Direction  := Corrected_Final_Direction  + 360.0;
       elsif Corrected_Final_Direction  > 360.0 then
          Corrected_Final_Direction  := Corrected_Final_Direction  - 360.0;
       end if;

       if abs(An_Instance.The_Wind_Direction - Corrected_Final_Direction) < abs(Delta_Direction)/450.0 then
          Delta_Direction := 0.0;
          An_Instance.The_Wind_Direction := Corrected_Final_Direction + 0.2; -- to give 0 wind instead of 360
       end if;

       if An_Instance.The_Wind_Direction < 0.0 then
          An_Instance.The_Wind_Direction := An_Instance.The_Wind_Direction + 360.0;
       elsif An_Instance.The_Wind_Direction > 360.0 then
          An_Instance.The_Wind_Direction := An_Instance.The_Wind_Direction - 360.0;
       end if;


    end Change_Direction;

    function Velocity (An_Instance : in Instance) return Length_Types.Knots is
    begin
       return An_Instance.The_Wind_Velocity;
    end Velocity;

    function Altitude (An_Instance : in Instance) return Length_Types.feet is
    begin
       return An_Instance.The_Wind_Altitude;
    end Altitude;

    function Direction (An_Instance : in Instance) return angle_Types.degrees is
    begin
       return An_Instance.The_Wind_Direction;
    end Direction;

    procedure store_Direction (Direction    :in      Angle_Types.degrees;
                               An_Instance  :in out Instance) is
    begin
          An_Instance.The_Wind_direction  := direction;
    end Store_direction;

    procedure store_velocity (velocity     :in     length_Types.knots;
                              An_Instance  :in out Instance) is
     begin
          An_Instance.The_Wind_velocity  := velocity;
     end Store_velocity;

     procedure store_altitude (altitude     :in     length_Types.knots;
                               An_Instance  :in out Instance) is
     begin
          An_Instance.The_Wind_altitude  := altitude;
     end Store_altitude;

end Winds;









