-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Ada.Numerics.Float_Random;                use Ada.Numerics.Float_Random;

package Wind_Gust is

   type Instance is private;

   procedure Calc_Gust_Properties (Basic_Gust_Dir  :in     Angle_Types.Degrees;
                                   Max_Dir_Var     :in     Angle_Types.Degrees;
                                   Max_Gust_Vel    :in     Length_Types.Knots;
                                   Dt              :in     Float;
                                   An_Instance     :in out Instance);

   procedure Calc_Gust_increase(An_Instance  :in out Instance);

   procedure Calc_Steady_Gust(Dt            :in     Float;
                              An_Instance   :in out Instance);

   procedure Calc_Gust_Decay (An_Instance  :in out Instance);

   procedure Calc_Dead_time(Dt           :in     Float;
                            An_Instance  :in out Instance);

   function  Phase(An_Instance : in Instance)return Integer;
   function  velocity(An_Instance : in Instance)return Length_Types.Knots;
   function  direction(An_Instance : in Instance)return Length_Types.Knots;

   procedure Save_Random_State(An_Instance :in out Instance);
   procedure Restore_Random_State(An_Instance :in out Instance);

private
   type Instance is
      record
         Max_Gust_Vel        : Length_Types.knots := 0.0;
         Gust_Dir            : Angle_Types.degrees := 0.0;
         Gust_Velocity       : Length_Types.knots := 0.0;
         Rise_Time           : Float := 1.0;
         Steady_Time         : Float := 0.0;
         Decay_Time          : Float := 1.0;
         Dead_Time           : Float := 0.0;
         Gust_Time           : Float := 0.0;
         Gust_Phase          : Integer := 0;
         Up_Delta            : Float   := 0.0;
         Down_Delta          : Float   := 0.0;
         -- random state variable
         The_State           : State;
      end record;

end Wind_Gust;


