-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;


package body Wind_Gust is
   G_Gust : Generator;

   procedure Calc_Gust_properties (Basic_Gust_Dir  :in     Angle_Types.Degrees;
                                   Max_Dir_Var     :in     Angle_Types.Degrees;
                                   Max_Gust_Vel    :in     Length_Types.Knots;
                                   Dt              :in     Float;
                                   An_Instance     :in out Instance) is

      Temp : Float := 0.0;
      Delta_Dir : Float := 0.0;
   begin
      Reset (G_gust);
      Temp := Random(G_Gust);
      Delta_Dir := (temp - 0.5) * 2.0 * Max_Dir_Var;
      An_Instance.Gust_Dir := Basic_Gust_Dir + Delta_Dir;
      Temp := Random(G_Gust);
      An_Instance.Max_Gust_Vel := (1.0 + Temp) * 0.5 * Max_gust_Vel;
      Temp := Random(G_Gust);
      An_Instance.rise_Time := Temp * 9.0 + 1.0;
      Temp := Random(G_Gust);
      An_Instance.steady_Time := Temp * 10.0;
      Temp := Random(G_Gust);
      An_Instance.decay_Time := Temp * 9.0 + 1.0;
      An_Instance.Dead_Time := Random(G_Gust) * 5.0;
      An_Instance.Up_delta := An_Instance.Max_Gust_Vel/An_Instance.Rise_Time * Dt;
      An_Instance.Down_Delta := An_Instance.Max_Gust_Vel/An_Instance.Decay_Time * Dt;
      An_Instance.Gust_Phase := 1;
   end Calc_Gust_properties;

   procedure Calc_Gust_increase(An_Instance  :in out Instance) is
   begin
      An_Instance.Gust_Velocity := An_Instance.Gust_Velocity + An_Instance.Up_Delta;
      if An_Instance.Gust_Velocity >= An_Instance.Max_Gust_Vel then
         An_Instance.Gust_Phase := 2;
      end if;
   end Calc_Gust_Increase;

   procedure Calc_Steady_Gust(Dt           :in     Float;
                              An_Instance  :in out Instance) is
   begin
      An_Instance.Gust_Time := An_Instance.Gust_Time + Dt;
      if An_Instance.Gust_Time > An_Instance.Steady_Time then
         An_Instance.Gust_Time := 0.0;
         An_Instance.Gust_Phase := 3;
      end if;
   end Calc_Steady_Gust;

   procedure Calc_Gust_Decay (An_Instance  :in out Instance) is
   begin
      An_Instance.Gust_Velocity := An_Instance.Gust_Velocity - An_Instance.down_Delta;
      if An_Instance.Gust_Velocity <= 0.0 then
         An_Instance.Gust_Velocity := 0.0;
         An_Instance.Gust_Phase := 4;
      end if;
   end Calc_Gust_Decay;

   procedure Calc_Dead_time(Dt           :in     Float;
                            An_Instance  :in out Instance) is
   begin
      An_Instance.Gust_Time := An_Instance.Gust_Time + Dt;
      if An_Instance.Gust_Time > An_Instance.Dead_time then
         An_Instance.Gust_Time := 0.0;
         An_Instance.Gust_Phase := 0;
      end if;
   end Calc_Dead_time;

   function Phase(An_Instance : in Instance)return Integer is
   begin
      return An_Instance.Gust_Phase;
   end Phase;

   function velocity(An_Instance : in Instance)return Length_Types.knots is
   begin
      return An_Instance.Gust_velocity;
   end velocity;

   function direction(An_Instance : in Instance)return Length_Types.knots is
   begin
      return An_Instance.Gust_dir;
   end direction;

   procedure Save_Random_State(An_Instance :in out Instance) is
   begin
      Save  (Gen        => G_Gust,
             To_State   => An_Instance.The_State);
   end Save_Random_State;

   procedure Restore_Random_State(An_Instance :in out Instance) is
   begin
      Reset (Gen        => G_Gust,
             From_State => An_Instance.The_State);

   end Restore_Random_State;

end Wind_Gust;
