-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Asep Rahmat
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;
with Ada.Numerics.Float_Random;          use Ada.Numerics.Float_Random;


package Turbulence is

   type Instance is private;

    procedure Set_Turbulence_Matrix(An_Instance :in out Instance);

   procedure Set_Turb_Intens
     (Turb_Level      :in     Float;
      An_Instance     :in out Instance);

   procedure Set_Turbulence_Scale_Length (Altitude     :in     Length_Types.Feet;
                                          An_Instance  :in out Instance);

   procedure Set_RMS_Intensity (Altitude    :in     Length_Types.Feet;
                                Dt          :in     Float;
                                An_Instance :in out Instance);

   procedure Set_ref_Speed (Tas           :in     Length_Types.Feet_per_Sec;
                            An_Instance   :in out Instance);

   function Get_Total_Turbulence_Intensity (An_Instance :in Instance) return Float;

   procedure Set_Turbulence_State_Vector
     (Dt             :in     Float;
      An_Instance    :in out Instance);

   procedure Calc_Linear_vel
     (Altitude       :in     Length_Types.Feet;
      An_Instance    :in out Instance);

   procedure Calc_Linear_decay(An_Instance :in out Instance);

   function turb_velocity
     (An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure calc_rotation
     (X_Cg           :in     Length_Types.Feet;
      Dt             :in     Float;
      An_Instance    :in out Instance);

   procedure reinitialize(An_Instance  :in out Instance);

   procedure Calc_Rotation_decay(An_Instance :in out Instance);

   function Turbulence_rotation
     (An_Instance :in Instance) return Coordinate_Types.Attitude;
   -- special routine for save and restore the random state variables
   procedure Save_Random_State(An_Instance :in out Instance);
   procedure Restore_Random_State(An_Instance :in out Instance);

private
   type Instance is
      record
         The_Turbulence_Matrix            : Coordinate_Types.Array_Type(1..10) :=
                                        (0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0);
         the_last_pass_matrix             : Float := 0.0;
         The_Rough_Air_Intensity          : Float := 0.0;
         The_Total_Turbulence_Intensity   : Float := 0.0;
         The_Turbulence_Scale_Length      : Float := 1000.0;
         The_RMS_Intensity                : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         the_fwd_speed                    : Length_Types.Feet_per_Sec := 0.0;
         The_Turbulence_State_Vector      : Coordinate_Types.Array_Type(1..11) :=
                                        (0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0);
         The_Vel                          : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         The_XNP                          : Float := 0.0;
         The_XINTQ                        : Float := 0.0;
         The_XNQ                          : Float := 0.0;
         The_XINTR                        : Float := 0.0;
         The_XNR                          : Float := 0.0;
         The_Turb_Ang_Rate                : Coordinate_Types.Attitude := (0.0,0.0,0.0);
         -- state of random generator
         The_State                        : State;
      end record;

end Turbulence;
