-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Coordinate_Types;
with Length_Types;

package NASA_Microburst_Model is

   type Instance is
      record
         Init_x_Vel : Length_Types.Feet_per_Sec :=   -5.0;
         Init_y_Vel : Length_Types.Feet_per_Sec :=  -15.0;
         A_x_Center                 : Coordinate_Types.Array_Type(1..5); --Feet
         A_y_Center                 : Coordinate_Types.Array_Type(1..5); --Feet
         A_Radius                   : Coordinate_Types.Array_Type(1..5); --Feet
         An_Altitude                : Coordinate_Types.Array_Type(1..5); --Feet
         A_Flow_Velocity            : Coordinate_Types.Array_Type(1..5); --Feet
         x_Fact      : Coordinate_Types.Array_Type(1..5); --Feet
         y_Fact      : Coordinate_Types.Array_Type(1..5); --Feet
      end record;

   Model_Array : constant array (1..5) of Instance :=
     ( 1 => -- Kennedy 1975 11011 approach model.  (FS # 11)
       ( Init_x_Vel =>   -5.0,
         Init_y_Vel =>  -15.0,

         A_x_Center                 => ( 5000.0,    0.0,    0.0,    0.0,    0.0), --Feet
         A_y_Center                 => (  400.0,    0.0,    0.0,    0.0,    0.0), --Feet
         A_Radius                   => ( 1200.0, 1000.0, 1000.0, 1000.0, 1000.0), --Feet
         An_Altitude                => (  720.0, 1000.0, 1000.0, 1000.0, 1000.0), --Feet

         A_Flow_Velocity            => (   10.0,    0.0,    0.0,    0.0,    0.0), --Feet
         x_Fact                     => (    0.5,    0.0,    0.0,    0.0,    0.0), --Feet
         y_fact                     => (    0.0,    0.0,    0.0,    0.0,    0.0) --Feet
         ),

       2 => -- New Orleans Takeoff.  (FS # 12)
       ( Init_x_Vel =>  -10.0,
         Init_y_Vel =>    0.0,

         A_x_Center                 => (-3800.0,    0.0,    0.0,    0.0,    0.0), --Feet
         A_y_Center                 => (  800.0,    0.0,    0.0,    0.0,    0.0), --Feet
         A_Radius                   => ( 2000.0, 1000.0, 1000.0, 1000.0, 1000.0), --Feet
         An_Altitude                => ( 2000.0, 1000.0, 1000.0, 1000.0, 1000.0), --Feet

         A_Flow_Velocity            => (   25.0,    0.0,    0.0,    0.0,    0.0), --Feet
         x_fact                     => (    0.6,    0.0,    0.0,    0.0,    0.0), --Feet
         y_fact                     => (    0.6,    0.0,    0.0,    0.0,    0.0) --Feet
         ),

       3 => -- Headwind and crosswind approach  (FS # 13)
       ( Init_x_Vel =>  -10.0,
         Init_y_Vel =>  -10.0,

         A_x_Center                 => ( 4000.0,    0.0,    0.0,    0.0,    0.0), --Feet
         A_y_Center                 => ( 1800.0,    0.0,    0.0,    0.0,    0.0), --Feet
         A_Radius                   => ( 1250.0, 1000.0, 1000.0, 1000.0, 1000.0), --Feet
         An_Altitude                => ( 1250.0, 1000.0, 1000.0, 1000.0, 1000.0), --Feet

         A_Flow_Velocity            => (   12.5,    0.0,    0.0,    0.0,    0.0), --Feet
         x_fact                     => (    0.0,    0.0,    0.0,    0.0,    0.0), --Feet
         y_fact                     => (    0.9,    0.0,    0.0,    0.0,    0.0) --Feet
         ),

       4 => -- Denver 1984 and Tuscon 1977 Takeoff.  (FS # 14)
       ( Init_x_Vel =>    0.0,
         Init_y_Vel =>    0.0,

         A_x_Center                 => (-3700.0,  -3700.0,    0.0,    0.0,    0.0), --Feet
         A_y_Center                 => (  800.0,    200.0,    0.0,    0.0,    0.0), --Feet
         A_Radius                   => ( 2700.0,    700.0, 1000.0, 1000.0, 1000.0), --Feet
         An_Altitude                => ( 1000.0,    300.0, 1000.0, 1000.0, 1000.0), --Feet

         A_Flow_Velocity            => (   13.0,   -5.0,    0.0,    0.0,    0.0), --Feet
         x_fact                     => (    0.0,    0.0,    0.0,    0.0,    0.0), --Feet
         y_fact                     => (    0.0,    0.0,    0.0,    0.0,    0.0)  --Feet
         ),

     5 => -- Jaws course AB Approach.  (FS # 15)
     ( Init_x_Vel =>    3.0,
       Init_y_Vel =>   -7.0,

       A_x_Center                 => ( 8000.0,  7000.0,  5750.0, -1500.0,    0.0), --Feet
       A_y_Center                 => ( -200.0,  -200.0,   900.0,  400.0,    0.0), --Feet
       A_Radius                   => ( 1400.0,   800.0,  1750.0, 1150.0, 1000.0), --Feet
       An_Altitude                => ( 2000.0,  2000.0,  2000.0, 1700.0, 1000.0), --Feet

       A_Flow_Velocity            => (   10.0,   14.0,   19.2,   19.2,    0.0), --Feet
       x_fact                     => (   -0.6,    0.7,    0.1,   -0.8,    0.0), --Feet
       y_fact                     => (    0.0,    0.0,    0.0,    0.0,    0.0)  --Feet
       )
     );


end NASA_Microburst_Model;


