-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Coordinate_Types;
with Length_Types;
with Nasa_Microburst_Model;


package NASA_Microburst is
   type Instance is private;

   procedure calc_Vel
     (x_to_td            :in     Length_Types.Feet;
      y_to_td            :in     Length_Types.Feet;
      Mb_Model           :in     Nasa_Microburst_Model.Instance;
      Alt                :in     Length_Types.Feet;
      An_Instance        :in out Instance);

   procedure Fade_In
     (washin        : in Float;
      An_Instance   :in out Instance);

   procedure init_Vel
     (Vel            :in     Coordinate_Types.Cartesian; --| Feet
      An_Instance    :in out Instance);

   function Velocity(An_Instance :in Instance) return Coordinate_Types.Cartesian;

private
   type Instance is
      record
         The_mb_Velocity : Coordinate_Types.Cartesian :=(0.0,0.0,0.0);
      end record;
end NASA_Microburst;

