-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Lat_Long_Types;
with Length_Types;
with Temperature_Types;


package Microburst is
   type Instance is private;

   procedure calc_Dist_to_td
     (Lat            :in     Lat_Long_Types.Latitude_Degrees;
      Long           :in     Lat_Long_Types.Longitude_Degrees;
      Thresh_Lat     :in     Lat_Long_Types.Latitude_Degrees;
      Thresh_Long    :in     Lat_Long_Types.Longitude_Degrees;
      Thresh_Hdg     :in     Angle_Types.Radians;
      An_Instance    :in out Instance);

   procedure Assign_Dist_To_Td
     (x_To_Td      :in     Length_Types.Feet;
      Y_To_Td      :in     Length_Types.Feet;
      An_Instance  :in out Instance);

   function Get_X_to_TD (An_Instance : in Instance) return Length_Types.Feet ;

   function Get_y_To_td (An_Instance : in Instance) return Length_Types.Feet;

   procedure Set_Vel_Ea
     (Thresh_Hdg       :in     Angle_Types.Radians;
      Mb_Vel           :in     Coordinate_Types.Cartesian;
      mb_Intens        :in     Float;
      An_Instance      :in out Instance);

   procedure Assign_Vel_Ea(Mb_Vel_Ea   :in     Coordinate_Types.Cartesian;
                           An_Instance :in out Instance);

   function Vel_Ea (An_Instance : in Instance) return Coordinate_Types.Cartesian;

   procedure Assign_Mb_Roll_Mom
     (Mb_Roll_Mom   :in     Float;
      An_Instance   :in out Instance);

   function Get_Mb_Roll_Mom (An_Instance :in Instance) return Float;

private
   type Instance is
      record
         The_north_wind        : Length_Types.Feet_per_Sec := 0.0;
         The_east_wind         : Length_Types.Feet_per_Sec := 0.0;
         The_Vert_Wind         : Length_Types.Feet_per_Sec := 0.0;
         The_Mb_Roll_Moment    : Float := 0.0;
         The_x_Distance        : Length_Types.Feet := 0.0;
         The_y_Distance        : Length_Types.Feet := 0.0;
         The_Velocity          : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
      end record;
end Microburst;
