-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;
with Limit_G;

package body Microburst is

   procedure calc_Dist_to_Td
     (Lat            :in     Lat_Long_Types.Latitude_Degrees;
      Long           :in     Lat_Long_Types.Longitude_Degrees;
      Thresh_Lat     :in     Lat_Long_Types.Latitude_Degrees;
      Thresh_Long    :in     Lat_Long_Types.Longitude_Degrees;
      Thresh_Hdg     :in     Angle_Types.Radians;
      An_Instance    :in out Instance) is

      cos_hdg          : Float := 0.0;
      sin_hdg          : Float   := 0.0;

      N_of_thresh      : Length_Types.Feet        := 0.0;
      E_of_thresh      : Length_Types.Feet        := 0.0;
   begin

      cos_hdg := Cos(Thresh_Hdg);
      sin_hdg := Sin(Thresh_Hdg);

      N_of_thresh := Float((Lat - Thresh_lat) * 364566.0);
      E_of_thresh := Float((Long - Thresh_Long) * 364566.0) * Cos(Float(Lat/57.3));

      An_Instance.The_x_Distance := - N_of_thresh * cos_Hdg - E_of_thresh * sin_hdg;
      An_Instance.The_y_Distance := N_of_thresh * sin_Hdg - E_of_thresh * cos_hdg;
   end calc_Dist_to_Td;

  procedure Assign_Dist_To_Td
     (x_To_Td      :in     Length_Types.Feet;
      Y_To_Td      :in     Length_Types.Feet;
      An_Instance  :in out Instance) is
   begin
      An_Instance.The_x_Distance := X_To_TD;
      An_Instance.The_y_Distance := y_To_td;
   end Assign_Dist_to_Td;

   function Get_x_To_Td (An_Instance : in Instance) return Length_Types.Feet is
   begin
      return An_Instance.The_x_Distance;
   end Get_x_to_Td;

   function Get_y_To_Td (An_Instance : in Instance) return Length_Types.Feet is
   begin
      return An_Instance.The_y_Distance;
   end Get_y_To_td;

   procedure Set_Vel_Ea
     (Thresh_Hdg     :in     Angle_Types.Radians;
      Mb_Vel         :in     Coordinate_Types.Cartesian;
      mb_Intens      :in     Float;
      An_Instance    :in out Instance) is

      x_Vel : Length_Types.Feet_per_Sec := 0.0;
      y_Vel : Length_Types.Feet_per_Sec := 0.0;
      z_Vel : Length_Types.Feet_per_Sec := 0.0;

      cos_hdg : Float := 0.0;
      sin_hdg   : Float := 0.0;
   begin

      cos_hdg   := Cos(Thresh_Hdg);
      sin_hdg   := Sin(Thresh_Hdg);

      x_vel := Mb_Vel.x * mb_intens;
      y_vel := Mb_Vel.y * mb_intens;
      z_vel := Mb_Vel.z * mb_intens;

      An_Instance.the_north_wind := -X_Vel * Cos_Hdg + Y_Vel * Sin_Hdg ;
      An_Instance.The_east_wind  := -X_Vel * sin_Hdg - Y_Vel * cos_Hdg ;
      An_Instance.the_vert_wind  := Z_Vel;

      An_Instance.The_Velocity   := (X_Vel  , Y_Vel , Z_Vel);
   end Set_Vel_Ea;

   procedure Assign_Vel_Ea(Mb_Vel_Ea    :in     Coordinate_Types.Cartesian;
                           An_Instance  :in out Instance) is
   begin
      An_Instance.the_north_wind := Mb_Vel_Ea.X ;
      An_Instance.The_east_wind  := Mb_Vel_Ea.Y ;
      An_Instance.the_vert_wind  := Mb_Vel_Ea.Z ;
   end Assign_Vel_Ea;

   function Vel_Ea (An_Instance : in Instance) return Coordinate_Types.Cartesian is
   begin
      return (An_Instance.The_North_Wind, An_Instance.The_East_Wind, An_Instance.The_Vert_Wind);
   end Vel_Ea;

   procedure Assign_Mb_Roll_Mom
     (Mb_Roll_Mom   :in     Float;
      An_Instance   :in out Instance) is
   begin
      An_Instance.The_Mb_Roll_Moment  := mb_Roll_Mom;
   end Assign_Mb_Roll_Mom;

   function Get_Mb_Roll_Mom (An_Instance :in Instance) return Float is
   begin
      return An_Instance.The_Mb_Roll_Moment;
   end Get_Mb_Roll_Mom;

 end Microburst;

