-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Length_Types;
with Mass_Types;
with Normalized_Types;
with Temperature_Types;


package JPATS_Atmosphere is

    --| Microburst

    function Mb_Roll_Moment return Float;

    --| Turbulence
    function rotational_turbulence return Coordinate_Types.Attitude;
    function Get_Total_Turbulence_Intensity return Float;

    --| Winds

    function Surface_Wind_Velocity return Length_Types.knots;
    function Surface_Wind_Direction return Angle_Types.degrees;
    function Wind_Aloft_Velocity return Length_Types.knots;
    function Wind_Aloft_Direction return Angle_Types.degrees;
    function Aircraft_Wind_Velocity return Length_Types.knots;
    function Aircraft_Wind_Direction return Angle_Types.degrees;
    function North_Wind return Length_Types.Feet_Per_Sec;
    function east_Wind return Length_Types.Feet_Per_Sec;
    function vertical_Wind return Length_Types.Feet_Per_Sec;

 --   Ice
    function Aoa_vane_Ice return float;
    function Primary_Pitot_Ice return float;
    function Standby_Pitot_Ice return float;
    function wb_ice return Float;

 --   Free_air
    function Temperature return Temperature_Types.Rankine;
    function Density  return Mass_Types.Slugs_per_Cubic_Feet;
    function Pressure_Ratio return Normalized_Types.Normalize;
    function Pressure return Force_Types.Pounds_Per_Sq_feet;
    function Pressure_hg return Force_Types.Inches_of_Hg;
    function Temperature_ratio return Normalized_Types.Normalize;
    function Sl_Pressure return Force_Types.Inches_of_Hg;
    function roc_cor return Float;
    function Midair return Boolean;
    function Flat_Tire return Boolean;
    function Shaker_Malf return Boolean;
    function Field_Temperature return Temperature_Types.Rankine;
    function Field_Pressure return Float;
    function Ios_Surface_Wind_Dir return Float;
    function Ios_Surface_Wind_Vel return Float;

    function Debug1 return Float;
    function Debug2 return Float;
    function Debug3 return Float;
    function Debug4 return Float;
    function Debug5 return Float;
    function Debug6 return Float;


  end JPATS_Atmosphere;
