-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with JPATS_Atmosphere.Container;

with DFW_Microburst;
with Free_Air;
with Microburst;
with NASA_Microburst;
with Turbulence;
with Wind_Gust;
with Winds;
with Aircraft_Ice;

package body JPATS_Atmosphere is
   cnt_nasa : Microburst.Instance renames Container.This_Subsystem.The_Microburst;
   Cnt_Dfw : Dfw_Microburst.instance renames Container.This_Subsystem.The_DFW_Microburst;

 --| Microburst
   function mb_Roll_Moment return Float is
   begin
      return DFW_Microburst.Get_Mb_Roll_Mom(cnt_dfw);
   end Mb_Roll_Moment;

 --| Turbulence

   function rotational_Turbulence return Coordinate_Types.Attitude is
   begin
      return Turbulence.turbulence_rotation(Container.This_Subsystem.The_Turbulence);
   end rotational_turbulence;

   function Get_Total_Turbulence_Intensity return Float is
   begin
      return Turbulence.Get_Total_Turbulence_Intensity(Container.This_Subsystem.The_Turbulence);
   end Get_Total_Turbulence_Intensity;

   --| Winds

   function Surface_Wind_Velocity return Length_Types.knots is
   begin
      return Winds.Velocity(Container.This_Subsystem.The_Surface_Wind);
   end Surface_Wind_Velocity;

   function Surface_Wind_Direction return Angle_Types.degrees is
   begin
      return Winds.Direction(Container.This_Subsystem.The_Surface_Wind);
   end Surface_Wind_Direction;

   function Wind_Aloft_Velocity return Length_Types.knots is
   begin
      return Winds.Velocity(Container.This_Subsystem.The_cruise_Wind);
   end Wind_Aloft_Velocity;

   function Wind_Aloft_Direction return Angle_Types.degrees is
   begin
      return Winds.Direction(Container.This_Subsystem.The_cruise_Wind);
   end Wind_Aloft_Direction;

   function Aircraft_Wind_Velocity return Length_Types.knots is
   begin
      return Winds.Velocity(Container.This_Subsystem.The_aircraft_Wind);
   end Aircraft_Wind_Velocity;

   function Aircraft_Wind_Direction return Angle_Types.degrees is
   begin
      return Winds.Direction(Container.This_Subsystem.The_aircraft_Wind);
   end Aircraft_Wind_Direction;

   function north_Wind return Length_Types.Feet_Per_sec is
   begin
      return Container.This_Subsystem.The_north_Wind;
   end north_Wind;

     function east_Wind return Length_Types.Feet_Per_sec is
   begin
      return Container.This_Subsystem.The_east_Wind;
   end east_Wind;

   function vertical_Wind return Length_Types.Feet_Per_sec is
   begin
      return Container.This_Subsystem.The_vertical_Wind;
   end vertical_Wind;

-- free air
   function Temperature return Temperature_Types.Rankine is
      begin
      return Free_Air.oat(Container.This_Subsystem.The_Free_air);
   end Temperature;

   function Density return Mass_Types.Slugs_per_Cubic_Feet is
      begin
        return Free_Air.density(Container.This_Subsystem.The_Free_air);
   end Density;

   function Pressure_ratio return Normalized_Types.Normalize is
      begin
        return Free_Air.Pressure_Ratio(Container.This_Subsystem.The_Free_air);
      end Pressure_ratio;

   function Pressure_hg return Force_Types.Inches_of_Hg is
   begin
      return Free_Air.Pressure_hg(Container.This_Subsystem.The_Free_air);
   end Pressure_hg;

   function Pressure return Force_Types.Pounds_Per_Sq_feet is
   begin
      return Free_Air.Pressure(Container.This_Subsystem.The_Free_air);
   end Pressure;

    function Sl_Pressure return Force_Types.Inches_of_Hg is
   begin
      return Free_Air.Sl_Pressure(Container.This_Subsystem.The_Free_air);
   end Sl_Pressure;

   function temperature_ratio return Normalized_Types.Normalize is
      begin
        return Free_Air.temp_Ratio(Container.This_Subsystem.The_Free_air);
      end temperature_ratio;

   function roc_cor return Float is
   begin
      return Container.This_Subsystem.Roc_Correction;
   end Roc_Cor;

-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   function Aoa_Vane_Ice return Float is
   begin
      return  Aircraft_Ice.aoa_probe_ice(Container.This_Subsystem.The_Aircraft_ice);
   end Aoa_Vane_Ice;

   function Primary_Pitot_Ice return Float is
   begin
      return Aircraft_Ice.Primary_Pitot_ice(Container.This_Subsystem.The_Aircraft_ice);
   end Primary_Pitot_Ice;

   function standby_Pitot_Ice return Float is
   begin
      return Aircraft_Ice.Secondary_Pitot_ice(Container.This_Subsystem.The_Aircraft_ice);
   end Standby_Pitot_Ice;

   function WB_ice return Float is
   begin
      return aircraft_Ice.wing_body_plus_ice(Container.This_Subsystem.The_Aircraft_ice);
   end wb_ice;

   function Flat_tire return Boolean is
   begin
      return Container.This_Ios_interface.Flat_tire;
   end Flat_tire;

   function midair return Boolean is
   begin
      return Container.This_Ios_interface.midair;
   end midair;

  function Shaker_malf return Boolean is
   begin
      return Container.This_Ios_interface.Shaker_malf;
   end Shaker_malf;

  function Field_Temperature return Temperature_Types.Rankine is
  begin
     return Container.This_Subsystem.Field_Temp;
  end Field_Temperature;

  function Field_Pressure return Float is
  begin
     return Container.This_Subsystem.Ios_Qnh;
  end Field_Pressure;

  function Ios_Surface_Wind_Dir return Float is
  begin
      return Winds.Direction(Container.This_Subsystem.The_Target_Surface_Wind);
  end Ios_Surface_Wind_Dir;

  function Ios_Surface_Wind_Vel return Float is
  begin
      return Winds.Velocity(Container.This_Subsystem.The_Target_Surface_Wind);
  end Ios_Surface_Wind_Vel;

  function Debug1 return Float is
  begin
     return Container.This_Subsystem.Debug1;
  end Debug1;

  function Debug2 return Float is
  begin
     return Container.This_Subsystem.Debug2;
  end Debug2;

  function Debug3 return Float is
  begin
     return Container.This_Subsystem.Debug3;
  end Debug3;

  function Debug4 return Float is
  begin
     return Container.This_Subsystem.Debug4;
  end Debug4;

  function Debug5 return Float is
  begin
     return Container.This_Subsystem.Debug5;
  end Debug5;

  function Debug6 return Float is
  begin
     return Container.This_Subsystem.Debug6;
  end Debug6;

end JPATS_Atmosphere;
