-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with JPATS_Atmosphere.Container;
with JPATS_Atmosphere.Microburst_Controller;
with Scheduler_Collection;

package body JPATS_Atmosphere.Microburst_Scheduler is

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      -- call appropriate Controller methods
      Microburst_Controller.Initialize;
      -- Note that you can refer to another package in the same package
      -- hierarchy by its simple name, omitting the prefix.  We can say
      -- Controller.Initialize rather than JPATS_Foo.Controller.Initialize
      -- (Does not apply to the with clause, where the full name must be
      -- provided.)

      --Controller.<init method>;

   end Initialize;

   procedure Update (An_Instance   : in out Instance;
                     Dt            : in     Float) is
   begin
      Microburst_Controller.Update (Dt => Dt);
   end Update;

   procedure Update_In_Freeze
     (An_Instance : in out Instance) is
   begin
      -- This procedure defines behavior during total freeze
      -- for example
      -- will call the Scheduler's Update procedure with a 0 time step
      -- while the default
           null;
      -- will do nothing during total freeze
   end Update_In_Freeze;

   -------------------------------------------------------------------------------
   -- Routine to save a snapshot of the instance to the given stream.
   --
   -- Note that the predefined attributes 'Write and 'Output can be used on any
   -- object to save its value to the given stream. This routine should be
   -- written so that data is written to the stream in the same order that it will
   -- be read back.
   -------------------------------------------------------------------------------
   procedure Save
     ( An_Instance : in out Instance;
       To_Stream   : access Ada.Streams.Root_Stream_Type'Class)
   is
   begin
   --      JPATS_Atmosphere.Container.Instance'Write
   --        ( To_Stream,
   --           JPATS_Atmosphere.Container.This_Subsystem);
      null;
   end Save;

   -------------------------------------------------------------------------------
   -- Routine to retrieve a snapshot of the instance from the given stream.
   --
   -- Note that the predefined attributes 'Read and 'Input can be used on any
   -- object to retrieve its value in the given stream. This routine should be
   -- written so that data is read from the stream in the same order it was placed
   -- into the stream.
   -------------------------------------------------------------------------------
   procedure Restore
     ( An_Instance : in out Instance;
       From_Stream : access Ada.Streams.Root_Stream_Type'Class )
   is

   begin
   --       JPATS_Atmosphere.Container.Instance'Read
   --         ( From_Stream,
   --          Jpats_Atmosphere.Container.This_Subsystem);
      null;
   end Restore;

   -------------------------------------------------------------------------------
   -- Returns the maximum amount of *bytes* that a snapshot takes up. This is
   -- used by Create_Streams to help size some interneral buffers.
   --
   -- By default, this will return the size of Instance in bytes (not counting the
   -- Save_Stream and Restore_Stream fields below). But you can override this to
   -- return a different value. You should do this if you wrote a custom Save
   -- routine which writes out data that is not contained directly in your
   -- instance (ie: in an object pointed to by your instance, or in a package body
   -- somewhere).
   -------------------------------------------------------------------------------
   function Snapshot_Size (An_Instance : Instance) return Natural is
   begin
      return JPATS_Atmosphere.Container.This_Subsystem'Size;
   end Snapshot_Size;


   -- Declare an instance of this scheduler to be added to the collection.

   This_Scheduler : aliased Instance;

begin

   -- Note that the string argument is no longer required.  The name of the
   -- scheduler is extracted from the tag.

   Scheduler_Collection.Register
     (This_Scheduler'Access);

end JPATS_Atmosphere.Microburst_Scheduler;

