-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with JPATS_IOS_Interface;

package JPATS_Atmosphere.IOS_Interface is

    --| MICROBURST
    procedure Mb_Pos (PData : JPATS_IOS_Interface.Set_Value);
    procedure Mb_Model (PData : JPATS_IOS_Interface.Set_Value);
    procedure Mb_Intens (PData : JPATS_IOS_Interface.Set_Value);
    procedure Mb_Active  (PData : JPATS_IOS_Interface.Set_Value);

    --| TURBULENCE
    procedure Turb_Intens (PData : JPATS_IOS_Interface.Set_Value);
    procedure Turb_Active (PData : JPATS_IOS_Interface.Set_Value);

    --| WIND SHEAR
    procedure Ws_Model (PData : JPATS_IOS_Interface.Set_Value);
    procedure Ws_Intens (PData : JPATS_IOS_Interface.Set_Value);
    procedure Ws_Active (PData : JPATS_IOS_Interface.Set_Value);

    --| SURFACE WINDS
    procedure Surf_Wind_Vel (PData : JPATS_IOS_Interface.Set_Value);
    procedure Surf_Wind_Dir  (PData : JPATS_IOS_Interface.Set_Value);
    procedure Surf_Wind_Agl (PData : JPATS_IOS_Interface.Set_Value);

    --| CRUISE WINDS
    procedure Cruise_Wind_Vel (PData : JPATS_IOS_Interface.Set_Value);
    procedure Cruise_Wind_Dir (PData : JPATS_IOS_Interface.Set_Value);
    procedure Cruise_Wind_Alt (PData : JPATS_IOS_Interface.Set_Value);

    --| CROSS WINDS
    procedure X_Wind_Vel (PData : JPATS_IOS_Interface.Set_Value);
    procedure X_Wind_Active (PData : JPATS_IOS_Interface.Set_Value);

    --| WIND GUST
    procedure Gust_Vel_In (PData : JPATS_IOS_Interface.Set_Value);
    procedure Gust_Vel (PData : JPATS_IOS_Interface.Set_Value);
    procedure Gust_Var (PData : JPATS_IOS_Interface.Set_Value);
    --| FIELD
    procedure Field_Press (PData : JPATS_IOS_Interface.Set_Value);
    procedure Field_Temp (PData : JPATS_IOS_Interface.Set_Value);
    procedure qnh (PData : JPATS_IOS_Interface.Set_Value);

    --| aircraft body
    procedure midair(PData : JPATS_IOS_Interface.Set_Value);
    procedure Flat_tire(PData : JPATS_IOS_Interface.Set_Value);
    procedure Shaker_malf(PData : JPATS_IOS_Interface.Set_Value);

    --| Ice
    procedure Ice_Time(PData : JPATS_IOS_Interface.Set_Value);
    procedure Ice_Qty(PData : JPATS_IOS_Interface.Set_Value);
    procedure env_change(PData : JPATS_IOS_Interface.Set_Value);

end JPATS_Atmosphere.IOS_Interface;
