-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Jpats_atmosphere.Container;
with Jpats_Ios_Interface;

package body JPATS_Atmosphere.IOS_Interface is
   package JII renames Jpats_Ios_Interface;
   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
--|
    procedure Mb_Pos(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Mb_Pos := JII.Convert_To_integer(PData);
    end Mb_Pos;

    procedure Mb_Model(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Mb_Model := JII.Convert_To_integer(PData);
    end Mb_Model;

    procedure Mb_Intens(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Mb_Intens  := JII.Convert_To_Integer(PData);
    end Mb_Intens;

    procedure Mb_Active (PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Mb_Active :=  JII.Convert_To_Bool(PData);
    end Mb_Active;

    --| TURBULENCE
    procedure Turb_Intens(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Turb_Intens  := JII.Convert_To_Integer(PData);
    end Turb_Intens;

    procedure Turb_Active (PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Turb_Active :=  JII.Convert_To_Bool(PData);
    end Turb_Active;

    --| WIND SHEAR
    procedure WS_Model(PData : JPATS_IOS_Interface.Set_Value)is
    begin
       IOS.WS_Model := JII.Convert_To_integer(PData);
    end WS_Model;

    procedure WS_Intens(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.WS_Intens := JII.Convert_To_Integer(PData);
    end WS_Intens;

    procedure WS_Active (PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.WS_Active :=  JII.Convert_To_Bool(PData);
    end WS_Active;

    --| SURFACE WINDS
    procedure Surf_Wind_Vel(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Surf_Wind_Vel   := JII.Convert_To_float(PData);
    end Surf_Wind_Vel;

    procedure Surf_Wind_Dir(PData : JPATS_IOS_Interface.Set_Value)  is
    begin
       IOS.Surf_Wind_Dir  := JII.Convert_To_float(PData);
    end Surf_Wind_Dir;

    procedure Surf_Wind_Agl(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       Ios.Surf_Wind_Agl := JII.Convert_To_float(PData);
    end Surf_Wind_agl;

    --| CRUISE WINDS
    procedure Cruise_Wind_Vel (PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Cruise_Wind_Vel := JII.Convert_To_float(PData);
    end Cruise_Wind_Vel;

    procedure Cruise_Wind_Dir(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Cruise_Wind_Dir  := JII.Convert_To_float(PData);
    end Cruise_Wind_Dir;

    procedure Cruise_Wind_Alt(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Cruise_Wind_Alt  := JII.Convert_To_float(PData);
    end Cruise_Wind_Alt;

    --| CROSS WINDS
    procedure X_Wind_Vel(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.X_Wind_Vel       := JII.Convert_To_float(PData);
    end X_Wind_Vel;

    procedure X_Wind_Active(PData : JPATS_IOS_Interface.Set_Value)  is
    begin
       IOS.X_Wind_Active :=  JII.Convert_To_Bool(PData);
    end X_Wind_Active;

    --| WIND GUST
    procedure Gust_Vel_In(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Gust_Vel_In := JII.Convert_To_float(PData);
    end Gust_Vel_In;

    procedure Gust_Vel(PData : JPATS_IOS_Interface.Set_Value)is
    begin
       IOS.Gust_Vel := JII.Convert_To_float(PData);
    end Gust_Vel;

    procedure Gust_Var(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.Gust_Var := JII.Convert_To_float(PData);
    end Gust_Var;

    --| FIELD
    procedure Field_Press (PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.The_Field_Pressure   := JII.Convert_To_float(PData);
    end Field_Press;

    procedure Field_Temp(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.The_Field_Temp  := JII.Convert_To_float(PData);
    end Field_Temp;

      procedure qnh(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       IOS.The_qnh  := JII.Convert_To_float(PData);
    end qnh;

     procedure Flat_tire(PData : JPATS_IOS_Interface.Set_Value)  is
    begin
       IOS.Flat_tire :=  JII.Convert_To_Bool(PData);
    end Flat_tire;

    procedure midair(PData : JPATS_IOS_Interface.Set_Value)  is
    begin
       IOS.midair :=  JII.Convert_To_Bool(PData);
    end midair;

    procedure Shaker_malf(PData : JPATS_IOS_Interface.Set_Value)  is
    begin
       IOS.Shaker_malf :=  JII.Convert_To_Bool(PData);
    end Shaker_malf;

    --| Ice
    procedure Ice_Time(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       Ios.Ice_Time := JII.Convert_To_Integer(PData);
    end Ice_Time;

    procedure Ice_Qty(PData : JPATS_IOS_Interface.Set_Value) is
    begin
       Ios.Ice_Quantity := JII.Convert_To_Integer(PData);
    end Ice_Qty;

     procedure env_change(PData : JPATS_IOS_Interface.Set_Value)  is
    begin
       IOS.env_change :=  JII.Convert_To_Bool(PData);
    end env_change;

end JPATS_Atmosphere.IOS_Interface;
