-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
--
with Jpats_atmosphere.Container;
with Jpats_Ios_Interface;
with Jpats_atmosphere.Ios_Interface;

separate (Jpats_atmosphere.Free_Air_Controller)

  procedure Register_Ios_Variables is

  begin

    JPATS_IOS_Interface.Register
      ( Name        => "Microburst Position",
        Variable    => Container.This_Ios_Interface.Mb_pos'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Mb_pos'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Microburst Model",
        Variable    => Container.This_Ios_Interface.Mb_model'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Mb_model'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Microburst Active",
        Variable   => Container.This_Ios_Interface.Mb_active'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Mb_active'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Microburst Intensity",
        Variable    => Container.This_Ios_Interface.Mb_intens'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Mb_intens'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Turbulence Active",
        Variable   => Container.This_Ios_Interface.Turb_active'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Turb_active'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Turbulence Intensity",
        Variable   => Container.This_Ios_Interface.Turb_intens'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Turb_intens'Access
        );

     Jpats_Ios_Interface.Register
      ( Name        => "Wind Shear Model",
        Variable   => Container.This_Ios_Interface.WS_model'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.WS_model'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Wind Shear Active",
        Variable   => Container.This_Ios_Interface.WS_active'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.WS_active'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Wind Shear Intensity",
        Variable   => Container.This_Ios_Interface.WS_intens'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.WS_intens'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Surface Wind Speed",
        Variable   => Container.This_Ios_Interface.Surf_Wind_vel'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Surf_Wind_vel'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Surface Wind Direction",
        Variable   => Container.This_Ios_Interface.Surf_Wind_dir'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Surf_Wind_dir'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Surface Wind Altitude AGL",
        Variable   => Container.This_Ios_Interface.Surf_Wind_AGL'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Surf_Wind_AGL'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Cruise Wind Speed",
        Variable   => Container.This_Ios_Interface.Cruise_Wind_vel'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Cruise_Wind_vel'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Cruise Wind Direction",
        Variable   => Container.This_Ios_Interface.Cruise_Wind_dir'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Cruise_Wind_dir'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Cruise Wind Altitude",
        Variable   => Container.This_Ios_Interface.Cruise_Wind_Alt'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Cruise_Wind_alt'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Cross Wind Speed",
        Variable   => Container.This_Ios_Interface.X_Wind_vel'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.X_Wind_vel'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Cross Wind Active",
        Variable   => Container.This_Ios_Interface.X_wind_active'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.X_wind_active'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "gust Variance",
        Variable   => Container.This_Ios_Interface.Gust_var'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Gust_var'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Gust Speed",
        Variable   => Container.This_Ios_Interface.Gust_Vel_In'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Gust_Vel_In'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Gust Speed Out",
        Variable   => Container.This_Ios_Interface.gust_vel'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.gust_vel'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Field_pressure",
        Variable   => Container.This_Ios_Interface.The_Field_pressure'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Field_press'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Field Temperature",
        Variable   => Container.This_Ios_Interface.The_Field_temp'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Field_temp'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "sl pressure",
        Variable   => Container.This_Ios_Interface.The_qnh'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.qnh'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Wind Speed",
        Variable   => Container.This_Ios_Interface.Wind_speed'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "wind Direction",
        Variable   => Container.This_Ios_Interface.wind_dir'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "Vertical Wind",
        Variable   => Container.This_Ios_Interface.Vert_wind'Address
        );

    -- three malfunctions stuck here for convenience
    Jpats_Ios_Interface.Register
      ( Name        => "MFFC01",
        Variable   => Container.This_Ios_Interface.midair'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.midair'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "MFLG06",
        Variable   => Container.This_Ios_Interface.Flat_tire'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Flat_tire'Access
        );

    -- ice

    Jpats_Ios_Interface.Register
      ( Name        => "ice quantity",
        Variable   => Container.This_Ios_Interface.Ice_Quantity'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Ice_Qty'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "ice time",
        Variable   => Container.This_Ios_Interface.Ice_Time'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.Ice_Time'Access
        );

     Jpats_Ios_Interface.Register
      ( Name        => "env_change",
        Variable   => Container.This_Ios_Interface.env_change'Address,
        Set_Routine => Jpats_Atmosphere.Ios_Interface.env_change'Access
        );

    Jpats_Ios_Interface.Register
      ( Name        => "mb in progress",
        Variable   => Container.This_Ios_Interface.mb_in_progress'Address
        );

    Jpats_Ios_Interface.Register
      ( Name        => "ws in progress",
        Variable   => Container.This_Ios_Interface.ws_in_progress'Address
        );

  end Register_Ios_Variables;
