-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Aircraft_Ice;
with DFW_Microburst;
with Free_Air;
with Microburst;
with NASA_Microburst;
with Turbulence;
with Wind_Gust;
with Winds;

private package JPATS_Atmosphere.Container is


   type Instance is
      record
         -- aircraft ice --
         The_Aircraft_Ice            : Aircraft_Ice.Instance;
         -- free air --
         The_Free_Air                : Free_Air.Instance;
         Env_Change_Freeair          : Boolean := False;
         Change_complete             : Boolean := True;
         Roc_Correction              : Float := 1.0;

         Field_Temp                  : Temperature_Types.Rankine:= 518.67;
         Field_Alt                   : Length_Types.Feet;
         Old_Field_Alt               : Float := 0.0;
         Old_Field_Temp              : Float := 518.669;
         Press_Change                : Boolean := False;
         Temp_Change                 : Boolean := False;
         Field_Change                : Boolean := False;
         SL_Temp                     : Temperature_Types.Rankine;
         Old_Sl_Temp                 : Float := 518.669;
         Delt_Sl_Temp                : Float := 0.0;
         Ios_Qnh                     : Float := 29.92;
         Qnh                         : Float := 29.92;
         Old_Qnh                     : Float := 29.92;
         Delt_qnh                    : Float := 0.0;
         Count                       : Integer := 0;
         At_Temp                     : Boolean := False;
         Norm_Temp                   : Float   := 59.0;


         -- microburst --
         The_Microburst              : Microburst.Instance;
         The_NASA_Microburst         : NASA_Microburst.Instance;
         The_DFW_Microburst          : DFW_Microburst.Instance;
         Mb_In_Progress              : Boolean := False;
         Wash_In                     : Boolean := False;
         Wash_out                    : boolean := false;
         Fadein                      : Float := 0.0;
         Fadeout                     : float := 1.0;
         Old_Mb_Model                : integer := 0;
         Mb_Velocity                 : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         Mb_Roll_Mom                 : Float := 0.0;
         Mb_Intens                   : Float := 0.0;

         -- windshear --
         Hat                         : Length_Types.Feet := 0.0;
         Model                       : Integer := 0;
         in_Progress                 : Boolean := False;
         Distance                    : Length_Types.Feet := 0.0;
         End_Dist                    : Length_Types.feet := 0.0;
         Fs_Tune                     : Float := 1.0;
         Fade                        : Float := 1.0;

         -- windgust/turbulence --
         The_Turbulence              : Turbulence.Instance;
         The_Wind_Gust               : Wind_Gust.Instance;
         Ios_Gust_Vel                : length_Types.Knots  := 0.0;
         Ios_Gust_var                : Angle_Types.Degrees := 0.0;


         -- steady winds/ x winds override --
         The_Surface_Wind            : Winds.Instance;
         The_Target_Surface_Wind     : Winds.Instance;
         The_Target_X_Surface_Wind   : Winds.Instance;
         The_delta_Surface_Wind      : Winds.Instance;
         The_Cruise_Wind             : Winds.Instance;
         The_Target_Cruise_Wind      : Winds.Instance;
         The_Target_X_Cruise_Wind    : Winds.Instance;
         The_delta_Cruise_Wind       : Winds.Instance;
         The_aircraft_Wind           : Winds.Instance;
         Wind_Change                 : Boolean := False;
         X_Wind_Change               : Boolean := False;
         Was_Active                  : Boolean := False;

         Env_Change_Winds            : Boolean := False;

         The_Vertical_Wind           : Length_Types.Feet_Per_Sec := 0.0;
         The_North_Wind              : Length_Types.Feet_Per_Sec := 0.0;
         The_east_Wind               : Length_Types.Feet_Per_Sec := 0.0;

         --icing
         Ice_Time                    : Integer := 0;
         Ice_Quantity                : Integer := 0;

         -- others --
         Debug1                      : Float := 0.0;
         Debug2                      : Float := 0.0;
         Debug3                      : Float := 0.0;
         Debug4                      : Float := 0.0;
         Debug5                      : Float := 0.0;
         Debug6                      : Float := 0.0;
      end record;
   This_Subsystem : Instance;

   type IOS_Interface_Instance is
      record

         MB_Pos                      : Integer := 0;
         MB_Model                    : Integer := 0;
         MB_Intens                   : Integer := 0;
         MB_Active                   : Boolean := false;
         Mb_In_Progress              : Boolean := False;

         Turb_Intens                 : Integer := 0;
         Turb_Active                 : Boolean := false;

         WS_Model                    : Integer := 0;
         WS_Intens                   : Integer := 0;
         WS_Active                   : Boolean := False;
         Ws_In_Progress              : Boolean := False;

         Surf_Wind_Vel               : Length_Types.Knots := 0.0;
         Surf_Wind_Dir               : Angle_Types.Degrees := 0.0;
         Surf_Wind_AGL               : Length_Types.Feet := 0.0;

         Cruise_Wind_Vel             : Length_Types.Knots := 0.0;
         Cruise_Wind_Dir             : Angle_Types.Degrees := 0.0;
         Cruise_Wind_Alt             : Length_Types.Feet := 30000.0;

         X_Wind_Vel                  : Length_Types.Knots := 0.0;
         X_Wind_Active               : Boolean := false;

         Gust_Vel_In                 : Length_Types.Knots := 0.0;
         Gust_Vel                    : Length_Types.Knots := 0.0;
         Gust_Var                    : Angle_Types.Degrees := 0.0;

         The_Field_Pressure          : Force_Types.Inches_of_Hg := 29.92;
         The_Qnh                     : Force_Types.Inches_of_Hg := 29.92;
         The_Field_Temp              : Temperature_Types.Fahrenheit := 59.0;

         Wind_Speed                  : Length_Types.Knots := 0.0;
         Wind_Dir                    : Angle_Types.Degrees := 0.0;
         Vert_Wind                   : Length_Types.Feet_Per_sec := 0.0;
-- 3 malfunctions stuck here for convenience
         Midair                      : Boolean := false;
         Flat_Tire                   : Boolean := false;
         Shaker_Malf                 : Boolean := false;

         Ice_Time                    : Integer := 0;
         Ice_Quantity                : Integer := 0;

         Env_Change                  : Boolean := False;

      end record;

   This_IOS_Interface : IOS_Interface_Instance;


end JPATS_Atmosphere.Container;
