-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Force_types;
with Length_Types;
with Mass_types;
with Normalized_Types;
with Temperature_Types;

package Free_Air is
   type Instance is private;

   procedure Assign_oat(Oat          :in     Temperature_Types.Rankine;
                        An_Instance  :in out Instance);

   function oat(An_Instance : in Instance)
                        return Temperature_Types.Rankine;

   procedure Assign_Temp_Ratio
     (Temp_Ratio     :in     Normalized_Types.Normalize;
      An_Instance    :in out Instance);

   function Temp_Ratio (An_Instance : in Instance) return Normalized_Types.Normalize;

   procedure Assign_SL_Pressure
     (SL_Press_Hg :in     Force_Types.Inches_of_Hg;
      An_Instance :in out Instance);

   function SL_Pressure (An_Instance : in Instance) return Force_Types.Inches_of_Hg;

   procedure Assign_Pressure
     (Press_Hg         :in     Force_Types.Inches_of_Hg;
      An_Instance      :in out Instance);

   function Pressure (An_Instance : in Instance) return Force_Types.Pounds_Per_Sq_feet;
   function Pressure_Hg (An_Instance : in Instance) return Force_Types.Inches_of_Hg;
   procedure Assign_Pressure_Ratio
          (Press_Ratio     :in     Normalized_Types.Normalize;
           An_Instance     :in out Instance);

   function Pressure_Ratio (An_Instance : in Instance)
                        return Normalized_Types.Normalize;

   procedure Assign_Density
     (Dens   :in     Mass_Types.Slugs_per_Cubic_Feet;
      An_Instance       :in out Instance);

   function Density (An_Instance : in Instance)
                return Mass_Types.Slugs_per_Cubic_Feet;

   procedure Assign_Std_Day (Std_Day         :in     Boolean;
                             An_Instance     :in out Instance);

   function Std_Day (An_Instance : in Instance) return Boolean;

   procedure Assign_density_Ratio
          (dens_Ratio      :in     Normalized_Types.Normalize;
           An_Instance     :in out Instance);

   function density_Ratio (An_Instance : in Instance)
     return Normalized_Types.Normalize;

private
   type Instance is
      record
         The_Dens          : Mass_Types.Slugs_per_Cubic_Feet := 0.0023769;
         The_dens_Ratio    : Normalized_Types.Normalize := 1.0;
         The_Press         : Force_Types.Pounds_per_Sq_Feet := 2116.22;
         The_Press_Ratio   : Normalized_Types.Normalize := 1.0;
         The_oat           : Temperature_Types.Rankine := 518.69;
         The_Temp_Ratio    : Normalized_Types.Normalize := 1.0;
         The_Press_hg      : Force_Types.Inches_of_Hg := 29.92;
         The_SL_Press_Hg   : Force_Types.Inches_of_Hg := 29.92;
         The_SL_Temp       : Temperature_Types.Rankine := 518.69;
         The_SL_Air_Dens   : Mass_Types.Slugs_per_Cubic_Feet := 0.0023769;
         The_Std_Day       : Boolean := true;
       end record;
end Free_Air;

