-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;

package body Free_Air is

   procedure Assign_oat(Oat         :in     Temperature_Types.Rankine;
                        An_Instance :in out Instance) is
   begin
      An_Instance.The_oat := oat;
   end Assign_oat;

   function oat (An_Instance : in Instance) return Temperature_Types.Rankine is
   begin
      return An_Instance.The_oat;
   end oat;

   procedure Assign_Temp_Ratio
     (Temp_Ratio     :in     Normalized_Types.Normalize;
      An_Instance    :in out Instance) is
   begin
      An_Instance.The_Temp_Ratio := Temp_Ratio;
      end Assign_Temp_Ratio;

   function Temp_Ratio (An_Instance : in Instance) return Normalized_Types.Normalize is
   begin
      return An_Instance.The_Temp_Ratio;
      end Temp_Ratio;

   procedure Assign_SL_Pressure
     (Sl_Press_Hg  :in     Force_Types.Inches_of_Hg;
      An_Instance  :in out Instance) is
   begin
      An_Instance.The_Sl_Press_Hg := Sl_Press_Hg;
   end Assign_Sl_Pressure;

   function SL_Pressure (An_Instance : in Instance)
     return Force_Types.Inches_of_Hg is
   begin
      return An_Instance.The_Sl_Press_Hg;
   end Sl_Pressure;

   procedure Assign_Pressure
     (Press_Hg         :in     Force_Types.Inches_of_Hg;
      An_Instance      :in out Instance) is
   begin
      An_Instance.The_Press_hg := Press_Hg;
      An_Instance.The_Press := Press_Hg * 70.73;
   end Assign_Pressure;

   function Pressure(An_Instance : in Instance)
     return Force_Types.Pounds_Per_Sq_feet is
      begin
         return An_Instance.The_Press;
      end Pressure;

    function Pressure_hg(An_Instance : in Instance)
     return Force_Types.Inches_of_Hg is
      begin
         return An_Instance.The_Press_hg;
      end Pressure_hg;

   procedure Assign_Pressure_Ratio
          (Press_Ratio     :in     Normalized_Types.Normalize;
           An_Instance     :in out Instance) is
   begin
      An_Instance.The_Press_Ratio := Press_Ratio;
   end Assign_Pressure_Ratio;

   function Pressure_Ratio (An_Instance : in Instance)
     return Normalized_Types.Normalize is
   begin
      return An_Instance.The_Press_Ratio;
   end Pressure_Ratio;

   procedure Assign_Density
     (Dens              :in     Mass_Types.Slugs_per_Cubic_Feet;
      An_Instance       :in out Instance)is
   begin
      An_Instance.The_Dens := Dens;
   end Assign_Density;

   function Density (An_Instance : in Instance)
     return Mass_Types.Slugs_per_Cubic_Feet is
   begin
      return An_Instance.The_Dens;
   end Density;


   procedure Assign_Std_Day (Std_Day         :in     Boolean;
                             An_Instance     :in out Instance)is
   begin
      An_Instance.The_Std_day := Std_Day;
      end Assign_Std_Day;

   function Std_Day (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.The_Std_Day;
   end Std_Day;

   procedure Assign_density_Ratio
          (dens_Ratio :in     Normalized_Types.Normalize;
           An_Instance     :in out Instance) is
   begin
      An_Instance.The_Dens_Ratio := Dens_Ratio;
   end Assign_Density_Ratio;

   function density_Ratio (An_Instance : in Instance)
     return Normalized_Types.Normalize is
   begin
      return An_Instance.The_Dens_Ratio;
   end Density_Ratio;

end Free_Air;
