-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Lat_Long_Types;
with Length_Types;
with Temperature_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;

package DFW_Microburst is
   package It renames Interpolation_Table;

   type Instance is private;

   procedure Calc_distance_to_mb_center
     (x_to_td                :in     Length_Types.Feet;
      y_to_td                :in     Length_Types.Feet;
      MB_loc_x               :in     Length_Types.Feet;
      MB_loc_y               :in     Length_Types.Feet;
      An_Instance            :in out Instance);

   function Get_x_to_MB_cntr(An_Instance :in Instance) return Length_Types.Feet;

   function Get_y_to_MB_cntr(An_Instance :in Instance) return Length_Types.Feet;

   function Radial_Distance (An_Instance :in Instance) return Length_Types.Feet;

   procedure init_penetration_dist
     (penetration_dist  :in     Length_Types.Feet;
      An_Instance       :in out Instance);

   function penetration (An_Instance :in Instance) return Length_Types.Feet;

    procedure calc_mb_wind_Vel
      (Alt                        :in     Length_Types.Feet;
      DFW_MB_Vel_Sect_T           :in out IT.Singly_Indexed.Instance;
      DFW_MB_Hor_Sect_1_T         :in out IT.Doubly_Indexed.Instance;
      DFW_MB_Hor_Sect_2_T         :in out IT.Doubly_Indexed.Instance;
      DFW_MB_Vert_Sect_1_T        :in out IT.Doubly_Indexed.Instance;
      DFW_MB_Vert_Sect_2_T        :in out IT.Doubly_Indexed.Instance;
      DFW_MB_Scnd_Wind_Dir_T      :in out IT.Doubly_Indexed.Instance;
      DFW_MB_Basic_Wind_Dir_1_T   :in out IT.Singly_Indexed.Instance;
      DFW_MB_Basic_Wind_Dir_2_T   :in out IT.Singly_Indexed.Instance;
      DFW_MB_Dir_Sect_T           :in out IT.Singly_Indexed.Instance;
      An_Instance                 :in out Instance);

   function mb_vel(An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Set_Mb_Roll_Mom
     (Roll_Moment :in out IT.Singly_Indexed.Instance;
      An_Instance                                :in out Instance);

   procedure Assign_Roll_Mom
     (cr_due_to_Mb :in     Float;
      An_Instance                                          :in out Instance);

   function Get_Mb_Roll_Mom (An_Instance :in Instance) return Float;

private
   type Instance is
      record
         the_hdg_to_mb_cntr          : Angle_Types.Radians := 0.0;
         the_penetration_dist        : Length_Types.Feet := 0.0;
         The_x_to_MB_cntr            : Length_Types.Feet := 10000.0;
         The_y_to_MB_cntr            : Length_Types.Feet := 10000.0;
         The_Mb_Velocity        : Coordinate_types.Cartesian := (0.0,0.0,0.0);
         The_Radial_Distance         : Length_Types.Feet := 0.0;
         The_Roll_Moment             : Float := 0.0;
      end record;
end DFW_Microburst;




