-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package Aircraft_Ice is

   type Instance is private;

   function Primary_Pitot_Ice
     (An_Instance : in Instance)
     return Float;

   function Secondary_Pitot_Ice
     (An_Instance : in Instance)
     return Float;

   function Aoa_Probe_Ice
     (An_Instance : in Instance)
     return Float;

   function Wing_Body_Plus_Ice
     (An_Instance : in Instance)
     return Float;

   procedure Initialize
     (An_Instance : in out Instance);

   procedure Update
     (An_Instance               : in out Instance;
      Iconst                    : in     Float;
      Icing                     : in     Boolean;
      Cold                      : in     Boolean;
      Wing_Body_Rate            : in     Float;
      Probe_Rate                : in     Float;
      Pct_Demanded              : in     Float;
      Pirmary_Pitot_Heater_On   : in     Boolean;
      Secondary_Pitot_Heater_On : in     Boolean;
      Aoa_Probe_Heater_On       : in     Boolean);

private

   type Instance is
      record
         Primary_Pitot_Ice   : Float;
         Secondary_Pitot_Ice : Float;
         Aoa_Probe_Ice       : Float;
         Wing_Body_Plus_Ice  : Float;
      end record;

end Aircraft_Ice;
