-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package body Aircraft_Ice is

   -------------------
   -- Aoa_Probe_Ice --
   -------------------

   function Aoa_Probe_Ice
     (An_Instance : in Instance)
      return Float
   is
   begin
      return An_Instance.Aoa_Probe_Ice;
   end Aoa_Probe_Ice;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Primary_Pitot_Ice   := 0.0;
      An_Instance.Secondary_Pitot_Ice := 0.0;
      An_Instance.Aoa_Probe_Ice       := 0.0;
      An_Instance.Wing_Body_Plus_Ice  := 0.0;
   end Initialize;

   -----------------------
   -- Primary_Pitot_Ice --
   -----------------------

   function Primary_Pitot_Ice
     (An_Instance : in Instance)
      return Float
   is
   begin
      return An_Instance.Primary_Pitot_Ice;
   end Primary_Pitot_Ice;

   -------------------------
   -- Secondary_Pitot_Ice --
   -------------------------

   function Secondary_Pitot_Ice
     (An_Instance : in Instance)
      return Float
   is
   begin
      return An_Instance.Secondary_Pitot_Ice;
   end Secondary_Pitot_Ice;

   ------------
   -- Update --
   ------------

   procedure Update
     (An_Instance               : in out Instance;
      Iconst                    : in     Float;
      Icing                     : in     Boolean;
      Cold                      : in     Boolean;
      Wing_Body_Rate            : in     Float;
      Probe_Rate                : in     Float;
      Pct_Demanded              : in     Float;
      Pirmary_Pitot_Heater_On   : in     Boolean;
      Secondary_Pitot_Heater_On : in     Boolean;
      Aoa_Probe_Heater_On       : in     Boolean)
   is

      Pri_Pitot_Ice : Float renames An_Instance.Primary_Pitot_Ice;
      Sec_Pitot_Ice : Float renames An_Instance.Secondary_Pitot_Ice;
      Aoa_Pitot_Ice : Float renames An_Instance.Aoa_Probe_Ice;
      Wing_Body_Ice : Float renames An_Instance.Wing_Body_Plus_Ice;

      Icing_Corrected : Boolean;

   begin

      Icing_Corrected := Icing or (Pct_Demanded = 0.0 and Wing_Body_Ice > 0.0);

      if Pirmary_Pitot_Heater_On then
         Pri_Pitot_Ice := Float'Max(0.0, Pri_Pitot_Ice-Iconst*0.033334);
      elsif Icing_Corrected then
         if Pri_Pitot_Ice < Pct_Demanded then
            Pri_Pitot_Ice := Float'Min (Pct_Demanded, Pri_Pitot_Ice+Probe_Rate);
         elsif Pri_Pitot_Ice > Pct_Demanded then
            Pri_Pitot_Ice := Float'Max (Pct_Demanded, Pri_Pitot_Ice-Iconst*0.33334);
         end if;
      elsif Cold then
         null; --Pri_Pitot_Ice := Float'Min (1.0, Float'Max(0.0, Pri_Pitot_Ice));
      else
         Pri_Pitot_Ice := Float'Max(0.0, Pri_Pitot_Ice-Iconst*0.033334);
      end if;


      if Secondary_Pitot_Heater_On then
         Sec_Pitot_Ice := Float'Max(0.0, Sec_Pitot_Ice-Iconst*0.033334);
      elsif Icing_Corrected then
         if Sec_Pitot_Ice < Pct_Demanded then
            Sec_Pitot_Ice := Float'Min (Pct_Demanded, Sec_Pitot_Ice+Probe_Rate);
         elsif Sec_Pitot_Ice > Pct_Demanded then
            Sec_Pitot_Ice := Float'Max (Pct_Demanded, Sec_Pitot_Ice-Iconst*0.033334);
         end if;
      elsif Cold then
         null; --Sec_Pitot_Ice := Float'Min (1.0, Float'Max(0.0, Sec_Pitot_Ice));
      else
         Sec_Pitot_Ice := Float'Max(0.0, Sec_Pitot_Ice-Iconst*0.033334);
      end if;


      if Aoa_Probe_Heater_On then
         Aoa_Pitot_Ice := Float'Max(0.0, Aoa_Pitot_Ice-Iconst*0.033334);
      elsif Icing_Corrected then
         if Aoa_Pitot_Ice < Pct_Demanded then
            Aoa_Pitot_Ice := Float'Min (Pct_Demanded, Aoa_Pitot_Ice+Probe_Rate);
         elsif Aoa_Pitot_Ice > Pct_Demanded then
            Aoa_Pitot_Ice := Float'Max (Pct_Demanded, Aoa_Pitot_Ice-Iconst*0.03334);
         end if;
      elsif Cold then
         null; --Aoa_Pitot_Ice := Float'Min (1.0, Float'Max(0.0, Aoa_Pitot_Ice));
      else
         Aoa_Pitot_Ice := Float'Max(0.0, Aoa_Pitot_Ice-Iconst*0.033334);
      end if;


      if Icing_Corrected then
         if Wing_Body_Ice < Pct_Demanded then
            Wing_Body_Ice := Float'Min(Pct_Demanded, Wing_Body_Ice+Wing_Body_Rate);
         elsif Wing_Body_Ice > Pct_Demanded then
            Wing_Body_Ice := Float'Max(Pct_Demanded, Wing_Body_Ice-Iconst*0.05);
         end if;
      elsif Cold then
         null; --Wing_Body_Ice := Float'Min(1.0, Float'Max(0.0, Wing_Body_Ice));
      else
         Wing_Body_Ice := Float'Max(0.0, Wing_Body_Ice-Iconst*0.05);
      end if;

   end Update;

   ------------------------
   -- Wing_Body_Plus_Ice --
   ------------------------

   function Wing_Body_Plus_Ice
     (An_Instance : in Instance)
      return Float
   is
   begin
      return An_Instance.Wing_Body_Plus_Ice;
   end Wing_Body_Plus_Ice;

end Aircraft_Ice;

