-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Length_Types;
with Normalized_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;
with Interpolation_Table.Multiply_Indexed;

package Wing_Body_Plus is
   package It renames Interpolation_Table;

   type Instance is private;

   procedure assign_ice_Weight
     (ice_wt        :in     Float;
      An_Instance   :in out Instance);

   function Get_Weight_Ice(An_Instance :in Instance) return float;

   procedure Calc_Lift_Coef
     (Aoa_Rate            :in     Angle_Types.Degrees_per_Sec;
      AOA                 :in     Angle_Types.Degrees;
      Flap_Pos            :in     Angle_Types.Degrees;
      Gear_Pos            :in     Float;
      Mach                :in     Length_Types.Mach;
      ND_Pitch_Rate       :in     Float;
      Beta                :in     Angle_Types.Degrees;
      SB_Pos              :in     Normalized_Types.Normalize;
      Ct                  :in     Float;
      Tas                 :in     Length_Types.Feet_per_Sec;
      Ice_Fac             :in     Float;
      HAG                 :in     Length_Types.Feet;
      KCLDYN_t            :in out IT.Singly_Indexed.Instance;
      DCLWBB_t            :in out IT.Doubly_Indexed.Instance;
      FCLTA_t             :in out IT.Doubly_Indexed.Instance;
      FCLTB_t             :in out IT.Doubly_Indexed.Instance;
      KCLTA_t             :in out IT.Doubly_Indexed.Instance;
      KCLTB_t             :in out IT.Doubly_Indexed.Instance;
      DCLWBLA_t           :in out IT.Doubly_Indexed.Instance;
      DCLWBSA_t           :in out IT.Doubly_Indexed.Instance;
      CLWBQ_t             :in out IT.Singly_Indexed.Instance;
      CLWBA_t             :in out IT.Multiply_Indexed.Instance;
      FCLWBGA_t           :in out IT.Doubly_Indexed.Instance;
      KCLWBGH_t           :in out IT.Doubly_Indexed.Instance;
      FCLWBICE_t          :in out IT.Doubly_Indexed.Instance;
      FCLWBGT_T           :in out IT.Doubly_Indexed.Instance;
      Test_Flag           :in     Boolean;
      An_Instance         :in out Instance);

   procedure Calc_Drag_Coef
     (SB_Drag_Var        :in     Float;
      AOA                :in     Angle_Types.Degrees;
      Flap_Pos           :in     Angle_Types.Degrees;
      Gear_Pos           :in     Float;
      Mach               :in     Length_Types.Mach;
      Beta               :in     Angle_Types.Degrees;
      SB_Pos             :in     Normalized_Types.Normalize;
      Ct                 :in     Float;
      Ice_Fac            :in     Float;
      HAG                :in     Length_Types.Feet;
      DCDWBB_t           :in out IT.Doubly_Indexed.Instance;
      FCDTA_t            :in out IT.Doubly_Indexed.Instance;
      FCDTB_t            :in out IT.Doubly_Indexed.Instance;
      KCDTA_t            :in out IT.Doubly_Indexed.Instance;
      KCDTB_t            :in out IT.Doubly_Indexed.Instance;
      DCDWBLA_t          :in out IT.Doubly_Indexed.Instance;
      DCDWBSA_t          :in out IT.Doubly_Indexed.Instance;
      CDWBA_t            :in out IT.Multiply_Indexed.Instance;
      FCDWBICE_t         :in out IT.Doubly_Indexed.Instance;
      Test_Flag          :in    Boolean;
      An_Instance        :in out Instance);

   procedure Calc_Pitch_Moment_Coef
     (AOA             :in     Angle_Types.Degrees;
      Flap_Pos        :in     Angle_Types.Degrees;
      Gear_Pos        :in     Float;
      Mach            :in     Length_Types.Mach;
      ND_Pitch_Rate   :in     Float;
      Beta            :in     Angle_Types.Degrees;
      SB_Pos          :in     Normalized_Types.Normalize;
      Ct              :in     Float;
      DCMWBB_t        :in out IT.Doubly_Indexed.Instance;
      FCMTA_t         :in out IT.Doubly_Indexed.Instance;
      FCMTB_t         :in out IT.Doubly_Indexed.Instance;
      KCMTA_t         :in out IT.Doubly_Indexed.Instance;
      KCMTB_t         :in out IT.Doubly_Indexed.Instance;
      DCMWBLB_t       :in out IT.Doubly_Indexed.Instance;
      DCMWBSA_t       :in out IT.Doubly_Indexed.Instance;
      CMWBQ_t         :in out IT.Singly_Indexed.Instance;
      CMWBA_t         :in out IT.Multiply_Indexed.Instance;
      Test_Flag       :in    Boolean;
      An_Instance     :in out Instance);

   procedure Calc_Sideforce_Coef
     (AOA            :in     Angle_Types.Degrees;
      Flap_Pos       :in     Angle_Types.Degrees;
      Gear_Pos       :in     Float;
      ND_Roll_Rate   :in     Float;
      Beta           :in     Angle_Types.Degrees;
      Ct             :in     Float;
      CYWBA_t        :in out IT.Doubly_Indexed.Instance;
      FCYTA_t        :in out IT.Doubly_Indexed.Instance;
      FCYTB_t        :in out IT.Doubly_Indexed.Instance;
      KCYTA_t        :in out IT.Doubly_Indexed.Instance;
      KCYTB_t        :in out IT.Doubly_Indexed.Instance;
      CYWBP_t        :in out IT.Doubly_Indexed.Instance;
      DCYWBLB_t      :in out IT.Doubly_Indexed.Instance;
      FCYWBB_t       :in out IT.Doubly_Indexed.Instance;
      KCYWBA_t       :in out IT.Doubly_Indexed.Instance;
      Test_Flag      :in    Boolean;
      An_Instance    :in out Instance) ;

   procedure Calc_Roll_Moment_coef
     (AOA           :in     Angle_Types.Degrees;
      Flap_Pos      :in     Angle_Types.Degrees;
      ND_Roll_Rate  :in     Float;
      ND_Yaw_Rate   :in     Float;
      Yaw_Rate      :in     Angle_Types.Radians_per_Sec;
      Beta          :in     Angle_Types.Degrees;
      Ct            :in     Float;
      Asym_Flap_Pos :in     Normalized_Types.Normalize;
      HAG           :in     Length_Types.Feet;
      CRWBA_t       :in out IT.Doubly_Indexed.Instance;
      FCRTA_t       :in out IT.Doubly_Indexed.Instance;
      FCRTB_t       :in out IT.Doubly_Indexed.Instance;
      KCRTA_t       :in out IT.Doubly_Indexed.Instance;
      KCRTB_t       :in out IT.Doubly_Indexed.Instance;
      KCRWBA_t      :in out IT.Doubly_Indexed.Instance;
      KCRWBAL_T     :in out IT.Doubly_Indexed.Instance;
      FCRWBB_t      :in out IT.Doubly_Indexed.Instance;
      CRWBP_t       :in out IT.Doubly_Indexed.Instance;
      CRWBPL_T      :in out IT.Doubly_Indexed.Instance;
      CRWBR_t       :in out IT.Doubly_Indexed.Instance;
      FCRWBGB_t     :in out IT.Doubly_Indexed.Instance;
      Test_Flag     :in    Boolean;
      An_Instance   :in out Instance);

   procedure Calc_Yaw_Moment_Coef
     (AOA             :in     Angle_Types.Degrees;
      Flap_Pos        :in     Angle_Types.Degrees;
      Gear_Pos        :in     Float;
      ND_Roll_Rate    :in     Float;
      ND_Yaw_Rate     :in     Float;
      Beta            :in     Angle_Types.Degrees;
      Ct              :in     Float;
      Cn_Gear         :in     Float;
      Asym_Gear_Pos   :in     Normalized_Types.Normalize;
      Cn_Pd_Flap      :in     Float;
      Asym_Flap_Pos   :in     Normalized_Types.Normalize;
      CNWBA_t         :in out IT.Doubly_Indexed.Instance;
      FCNTA_t         :in out IT.Doubly_Indexed.Instance;
      FCNTB_t         :in out IT.Doubly_Indexed.Instance;
      KCNTA_t         :in out IT.Doubly_Indexed.Instance;
      KCNTB_t         :in out IT.Doubly_Indexed.Instance;
      KCNWBA_t        :in out IT.Doubly_Indexed.Instance;
      FCNWBB_t        :in out IT.Doubly_Indexed.Instance;
      DCNWBLB_t       :in out IT.Doubly_Indexed.Instance;
      CNWBR_t         :in out IT.Doubly_Indexed.Instance;
      CNWBP_t         :in out IT.Doubly_Indexed.Instance;
      CNWBPL_T        :in out IT.Doubly_Indexed.Instance;
      Test_Flag       :in     Boolean;
      An_Instance     :in out Instance);

   procedure Calc_Moment_Arm
      (X_CG           :in     Length_Types.Feet;
       Y_CG           :in     Length_Types.Feet;
       Z_CG           :in     Length_Types.Feet;
       An_Instance    :in out Instance);

   function Get_Moment_Arm (An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Calc_Force
     (Q             :in     Force_Types.Pounds_per_Sq_Feet;
      AOA           :in     Angle_Types.Degrees;
      Test_Flag     :in     Boolean;
      An_Instance   :in out Instance);

   function Get_Force(An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Calc_Moment
     (Q              :in     Force_Types.Pounds_per_Sq_Feet;
      AOA            :in     Angle_Types.Degrees;
      turb_Moment    :in     coordinate_Types.Attitude;
      Test_Flag      :in     Boolean;
      An_Instance    :in out Instance);

   function Get_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian;

   procedure Calc_Crash_Nose_Impact
     (Descent_rate     :in     Length_Types.Feet_per_Sec;
      Pitch_Rate       :in     Angle_Types.Radians_per_Sec;
      Left_LG_FS       :in     Length_Types.Feet;
      Nose_LG_FS       :in     Length_Types.Feet;
      An_Instance      :in out Instance);

   function Get_Crash_Nose_Impact (An_Instance :in Instance) return Boolean;

   procedure Calc_Crash_Wingtip_Impact
     (Y_CG               :in     Length_Types.Feet;
      X_CG               :in     Length_Types.Feet;
      Z_CG               :in     Length_Types.Feet;
      Quaternion_L       :in     Coordinate_Types.Cartesian;
      Quaternion_M       :in     Coordinate_Types.Cartesian;
      Quaternion_N       :in     Coordinate_Types.Cartesian;
      HAG                :in     Length_Types.Feet;
      Roll_Rate          :in     Angle_Types.Radians_Per_Sec;
      X_Vel              :in     Length_Types.Feet_Per_Sec;
      An_Instance        :in out Instance);

   function Get_Crash_Wingtip_Impact (An_Instance :in Instance) return Boolean;

   procedure Calc_Crash_Tail_Impact
     (Pitch_Angle       :in     Angle_Types.Degrees;
      Y_CG              :in     Length_Types.Feet;
      X_CG              :in     Length_Types.Feet;
      Z_CG              :in     Length_Types.Feet;
      Quaternion_L      :in     Coordinate_Types.Cartesian;
      Quaternion_M      :in     Coordinate_Types.Cartesian;
      Quaternion_N      :in     Coordinate_Types.Cartesian;
      Weight_On_Wheels  :in     Boolean;
      HAG               :in     Length_Types.Feet;
      An_Instance       :in out Instance);

   function Get_Crash_Tail_Impact (An_Instance :in Instance) return Boolean;

  private
    type Instance is record
      The_Area                         : Length_Types.Sq_Feet := 175.3 ;
      The_Crash_Nose_Impact            : Boolean := False;
      The_Crash_Tail_Impact            : Boolean := False;
      The_Crash_Wingtip_Impact         : Boolean := False;
      The_Drag_Coefficient             : Float := 0.2 ;
      The_Force                        : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
      The_Lift_Coefficient             : Float := 0.0;
      The_MAC                          : Length_Types.Feet := 5.413;
      The_Moment                       : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
      The_Moment_Arm                   : Coordinate_Types.Cartesian:= (15.0,0.0,0.0);
      Cm                               : Float := 0.0;
      Cr                               : Float := 0.0;
      Cy                               : Float := 0.0;
      The_Span                         : Length_Types.Feet := 33.42;
      The_Weight_Ice                   : Float := 0.0;
      Cn                               : Float := 0.0;
      Kcr_Limited                      : Boolean := False;
      Kcl_Hag                          : Float := 0.0;
   end record;
end Wing_Body_Plus;


