-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This section describes the vertical tail flowfield created by the wing-body-prop.
--| The flowfield is characterized by a sidewash angle and a dynamic pressure ratio.
--| The sidewash angle is a function of angles of attack and sideslip, flap angle,
--| thrust coefficient, aileron deflection, and roll rate.  The dynamic pressure
--| ratio is a function of angles of attack and sideslip, flap deflection and thrust
--| coefficient.

--| The convection lags for sidewash and for the thrust-induced alteration in dynamic
--| pressure ratio are modeled. These equations are similar to the sidewash and dynamic
--| pressure ratio lags in the horizontal tail flowfield model.


with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Length_Types;
with Mass_Types;
with Interpolation_Table.Singly_Indexed;
with Interpolation_Table.Doubly_Indexed;

package  Vertical_Tail is
   package It renames Interpolation_Table;

   type Instance is private;

   procedure Calc_Moment_Arm
      (X_Cg          :in     Length_Types.Feet;
      Y_CG           :in     Length_Types.Feet;
      Z_CG           :in     Length_Types.Feet;
      An_Instance    :in out Instance);

   procedure Calc_Sidewash_Angle
     (K_Sidewash              :in     Float;
      AOA                     :in     Angle_Types.Degrees;
      Beta                    :in     Angle_Types.Degrees;
      Flap_Position           :in     Angle_Types.Degrees;
      Sb_Pos                  :in     Float;
      Ct                      :in     Float;
      x_V_B                   :in     Length_Types.Feet_per_Sec;
      x_Moment_Arm_Wb         :in     Length_Types.Feet;
      Avg_Ail                 :in     Angle_Types.Degrees;
      Nd_Roll_Rate            :in     Float;
      FSVB_t                  :in out IT.Doubly_Indexed.Instance;
      KSVA_t                  :in out IT.Doubly_Indexed.Instance;
      SVA_t                   :in out IT.Doubly_Indexed.Instance;
      KSVT_t                  :in out IT.Doubly_Indexed.Instance;
      FSVTB_t                 :in out IT.Doubly_Indexed.Instance;
      FSVTA_t                 :in out IT.Doubly_Indexed.Instance;
      FSVAB_t                 :in out IT.Singly_Indexed.Instance;
      FSVAA_t                 :in out IT.Singly_Indexed.Instance;
      DSVSA_t                 :in out IT.Singly_Indexed.Instance;
      Dt                      :in     Float;
      Test_Flag               :in     Boolean;
      An_Instance             :in out Instance);

   function Get_Dynamic_Sidewash_Angle (An_Instance :in Instance) return Angle_Types.Degrees;

   function Get_Static_Sidewash_Angle (An_Instance :in Instance) return Angle_Types.Degrees;

   procedure Compute_Dynamic_Pressure_Ratio
     (AOA                :in     Angle_Types.Degrees;
      Beta               :in     Angle_Types.Degrees;
      Flap_Position      :in     Angle_Types.Degrees;
      Ct                 :in     Float;
      prop_x_dist        :in     Length_Types.Feet;
      x_V_B              :in     Length_Types.Feet_per_Sec;
      NVA_t              :in out IT.Doubly_Indexed.Instance;
      KNVB_t             :in out IT.Doubly_Indexed.Instance;
      FNVTA_t            :in out IT.Doubly_Indexed.Instance;
      FNVTB_t            :in out IT.Doubly_Indexed.Instance;
      KNVT_t             :in out IT.Doubly_Indexed.Instance;
      Ct_Unl             :in     Float;
      Dt                 :in     Float;
      An_Instance        :in out Instance);

   function Get_Dynamic_Pressure_Ratio (An_Instance :in Instance) return Float;

   function Get_Unlagged_Thrust_Induced (An_Instance :in Instance) return Float;

   function Get_Convection_Lag_Thrust_Induced (An_Instance :in Instance) return Float;

   procedure Calc_Attributes
          (Tas          :in     Length_Types.Feet_per_Sec;
           AOA          :in     Angle_Types.Degrees;
           Beta         :in     Angle_Types.Degrees;
           Roll_Rate    :in     Angle_Types.Radians_per_Sec;
           Pitch_Rate   :in     Angle_Types.Radians_per_Sec;
           Yaw_Rate     :in     Angle_Types.Radians_per_Sec;
           Dens         :in     Mass_Types.Slugs_per_Cubic_Feet;
           V_B          :in     Coordinate_Types.Cartesian;
           Ct           :in     Float;
           Ct_lim       :in     Float;
           Q_Eng        :in     Float;
           Hat          :in     Float;
           Test_Flag    :in     Boolean;
           Dt           :in     Float;
           An_Instance  :in out Instance);

   function Get_Local_AOA (An_Instance :in Instance) return Angle_Types.Degrees;

   function Get_Local_Q (An_Instance :in Instance) return Force_Types.Pounds_per_Sq_Feet;

   procedure Calc_Coefficient
     (lagged_eff_rud_pos  :in     Angle_Types.Degrees;
      Cn                  :in     Float;
      CLV_t               :in out IT.Doubly_Indexed.Instance;
      CDV_t               :in out IT.Doubly_Indexed.Instance;
      CMVP_t              :in out IT.Singly_Indexed.Instance;
      Test_Flag           :in     Boolean;
      An_Instance         :in out Instance);

   function Get_Yaw_Moment_Coefficient_wrt_Rudder_Position(An_Instance :in Instance) return Float;

   procedure Calc_Force(AOA          :in     Angle_Types.Degrees;
                       An_Instance   :in out Instance);

   function Get_Force(An_Instance :in Instance) return Coordinate_Types.Cartesian ;

   procedure Calc_Moment(Test_Flag   :in Boolean;
                         An_Instance :in out Instance);

   function Get_Moment (An_Instance :in Instance) return Coordinate_Types.Cartesian;

private
   type Instance is
      record
         The_Area                              : Length_Types.Sq_Feet := 18.95;
         The_Chord                             : Length_Types.Feet := 3.66;
         The_x_Moment_Arm                      : Length_Types.Feet:= 25.0;
         The_y_Moment_Arm                      : Length_Types.Feet:= 0.0;
         The_z_Moment_Arm                      : Length_Types.Feet:= 0.0;
         The_Dynamic_Sidewash_Angle            : Angle_Types.Degrees:= 0.0;
         The_Static_Sidewash_Angle             : Angle_Types.Degrees:= 0.0;
         The_Last_Pass_unlagged_q_component    : Float := 0.0;
         The_unlagged_q_component              : Float := 0.0;
         The_Convection_Lag_Thrust_Induced     : Float := 0.0;
         The_Dynamic_Pressure_Ratio            : Float := 0.0;
         AOA                                   : Angle_Types.Degrees := 0.0;
         The_Q                                 : Force_Types.Pounds_per_Sq_Feet := 0.0;
         The_Lift                              : Float := 0.0;
         The_Drag                              : Float := 0.0;
         The_Yaw_Moment                        : Float := 0.0;
         The_Cn_wrt_Rudder_Position            : Float := -0.0012;
         Old_torque_lag                        : Float := 0.0;
         old_st_Sidewash                       : Angle_Types.Degrees:= 0.0;
         The_Force                             : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         The_Moment                            : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
      end record;
end Vertical_Tail;
