-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landman
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--| This package computes the tire velocities in body and earth axis systems.
--| Also computed is an earth projection axis which neglects the vertical and is
--| independant of heading
--|
-------------------------------------------------------------------------------
--|

with Angle_Types;
with Coordinate_Types;
with Length_Types;

package Tire_Velocity is

   type Instance is private;

   procedure Calc_Vertical_V_B
     (ext_tire_x_to_cg         :in     Length_Types.Feet;
      ext_tire_y_to_cg         :in     Length_Types.Feet;
      A_z_Inertial_V_B         :in     Length_Types.Feet_per_Sec;
      A_Roll_Rate              :in     Angle_Types.Radians_per_Sec;
      A_Pitch_Rate             :in     Angle_Types.Radians_per_Sec;
      An_Instance              :in out Instance);

   function Get_Vertical_V_B (An_Instance :in Instance)
            return Length_Types.Feet_per_Sec;

   procedure Calc_Tire_U_B
     (tire_y_to_cg         :in     Length_Types.Feet;
      tire_z_to_cg         :in     Length_Types.Feet;
      long_comp_rate       :in     Length_Types.Feet_per_Sec;
      A_x_Inertial_V_B     :in     Length_Types.Feet_per_Sec;
      A_Yaw_Rate           :in     Angle_Types.Radians_per_Sec;
      A_Pitch_Rate         :in     Angle_Types.Radians_per_Sec;
      An_Instance          :in out Instance);


   function Get_Tire_U_B (An_Instance :in Instance)
                          return Length_Types.Feet_per_Sec;

   procedure Calc_Tire_V_B
     (tire_x_to_cg            :in     Length_Types.Feet;
      tire_z_to_cg            :in     Length_Types.Feet;
      A_y_Inertial_V_B        :in     Length_Types.Feet_per_Sec;
      A_Yaw_Rate              :in     Angle_Types.Radians_per_Sec;
      A_Roll_Rate             :in     Angle_Types.Radians_per_Sec;
      An_Instance             :in out Instance);

   function Get_Tire_V_B (An_Instance :in Instance)
                            return Length_Types.Feet_per_Sec;

   procedure Calc_Tire_W_B (L_3         :in     Float;
                            M_3         :in     Float;
                            N_3         :in     Float;
                            An_Instance :in out Instance);

   function Get_Tire_W_B (An_Instance :in Instance)
      return Length_Types.Feet_per_Sec;

   procedure Calc_Tire_Vel_Ep (L_1            :in     Float;
                               M_1            :in     Float;
                               N_1            :in     Float;
                               L_2            :in     Float;
                               M_2            :in     Float;
                               N_2            :in     Float;
                               Nwa            :in     Angle_Types.Degrees;
                               Below_Breakout :in     Boolean;
                               An_Instance    :in out Instance);

   function Get_Tire_Vel_Ep (An_Instance :in Instance)
                       return Coordinate_Types.Cartesian;
   function Get_Wheel_Speed (An_Instance :in Instance)
                       return Angle_Types.Rpm;
   procedure Set_Wheel_Speed (An_Instance :in out Instance; Wheel_Speed :in Angle_Types.Rpm);
   
private
   type Instance is
      record
         The_Vert_Vel                 : Length_Types.Feet_per_Sec := 0.0;
         The_Tire_x_Velocity          : Length_Types.Feet_per_Sec := 0.0;
         The_Tire_y_Velocity          : Length_Types.Feet_per_Sec := 0.0;
         The_Tire_z_Velocity          : Length_Types.Feet_per_Sec := 0.0;
         The_Tire_Vel_Ep              : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
         Wheel_Speed                  : Angle_Types.Rpm := Angle_Types.Rpm(0.0);	 
      end record;

end Tire_Velocity;

